/*
 * Decompiled with CFR 0.152.
 */
package com.slg.j2me.lib.gui.layout;

import com.slg.j2me.lib.gfx.BaseScreen;
import com.slg.j2me.lib.gfx.ClipRect;
import com.slg.j2me.lib.gfx.ImageSequence;
import com.slg.j2me.lib.gui.BitmapFont;
import com.slg.j2me.lib.gui.control.GuiContainer;
import com.slg.j2me.lib.gui.image.IconImage;
import com.slg.j2me.lib.gui.image.IconImageBorderDropShadow;
import com.slg.j2me.lib.gui.image.TextImage;
import com.slg.j2me.lib.gui.layout.ScreenLayout;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class TextLayout
extends ScreenLayout {
    public Vector controlList;
    public Vector vecNewLines = new Vector();
    public int iLayoutFlags = 0;
    public int iLineHeight = -1;
    boolean takeNewLine = false;
    public ClipRect rectDocument = new ClipRect(0, 0, 0, 0);
    public int iXScroll = 0;
    public int iYScroll = 0;
    public boolean initialised = true;
    public int fp_y = 0;
    ClipRect oldRect;
    ClipRect newRect = new ClipRect(0, 0, 0, 0);

    public TextLayout() {
        this.controlList = new Vector();
    }

    public void addControl(GuiContainer item) {
        this.controlList.addElement(item);
    }

    public void addImage(ImageSequence imgSeq, int frame) {
        if (imgSeq != null) {
            this.addControl(new IconImage(imgSeq, frame));
        }
    }

    public void addImageBorderDropShadow(ImageSequence imgSeq, int frame) {
        if (imgSeq != null) {
            this.addControl(new IconImageBorderDropShadow(imgSeq, frame));
        }
    }

    public void clearText() {
        this.takeNewLine = false;
        this.controlList.removeAllElements();
        this.vecNewLines.removeAllElements();
        this.rectDocument.h = 0;
        this.initialised = false;
    }

    public void open() {
        this.layout();
    }

    public void close() {
        this.clearText();
        System.out.println("Clearing text from textlayout");
    }

    public void setNewLine(int word) {
        this.vecNewLines.addElement(new Integer(word));
    }

    public boolean isNewLine(int word) {
        for (int i = 0; i < this.vecNewLines.size(); ++i) {
            Integer newlinepos = (Integer)this.vecNewLines.elementAt(i);
            if (newlinepos != word) continue;
            return true;
        }
        return false;
    }

    public void layout() {
        this.initialised = false;
        this.iXScroll = 0;
        this.iYScroll = 0;
        this.fp_y = 0;
        int iItems = this.controlList.size();
        for (int i = 0; i < iItems; ++i) {
            GuiContainer container = (GuiContainer)this.controlList.elementAt(i);
            container.initialise();
        }
        int x = 0;
        short y = 0;
        int word = 0;
        Vector<Integer> vecLineLength = new Vector<Integer>();
        Vector<Integer> vecWords = new Vector<Integer>();
        int maxLineWidth = 0;
        if ((this.iLayoutFlags & 0x80) != 0) {
            this.clipRect.w = (short)BaseScreen.displayWidth;
        }
        int line_height = 0;
        for (int i = 0; i < iItems; ++i) {
            GuiContainer control = (GuiContainer)this.controlList.elementAt(i);
            ClipRect itemRect = control.clipRect;
            if (word > 0 && x + itemRect.w > this.clipRect.w || this.isNewLine(i)) {
                y += this.iLineHeight == -1 ? line_height : this.iLineHeight;
                maxLineWidth = maxLineWidth > x ? maxLineWidth : x;
                vecLineLength.addElement(new Integer(x));
                vecWords.addElement(new Integer(word));
                x = 0;
                word = 0;
                line_height = 0;
            }
            line_height = line_height > itemRect.h ? line_height : (int)itemRect.h;
            itemRect.x0 = (short)x;
            itemRect.y0 = y;
            x += itemRect.w;
            ++word;
        }
        y += this.iLineHeight == -1 ? line_height : this.iLineHeight;
        maxLineWidth = maxLineWidth > x ? maxLineWidth : x;
        vecLineLength.addElement(new Integer(x));
        vecWords.addElement(new Integer(word));
        if ((this.iLayoutFlags & 0x80) != 0) {
            this.clipRect.w = (short)maxLineWidth;
        }
        short height = y;
        if (this.iLayoutFlags != 0) {
            int line = 0;
            int lines = vecLineLength.size();
            int words = (Integer)vecWords.elementAt(line);
            int width = (Integer)vecLineLength.elementAt(line);
            word = 0;
            y = 0;
            line_height = 0;
            for (int i = 0; i < iItems; ++i) {
                GuiContainer control = (GuiContainer)this.controlList.elementAt(i);
                ClipRect itemRect = control.clipRect;
                if (y != itemRect.y0 || this.isNewLine(i)) {
                    y = itemRect.y0;
                    word = 0;
                    width = (Integer)vecLineLength.elementAt(++line);
                    words = (Integer)vecWords.elementAt(line);
                    line_height = 0;
                }
                int n = line_height = line_height > itemRect.h ? line_height : (int)itemRect.h;
                if ((this.iLayoutFlags & 1) != 0) {
                    itemRect.x0 = (short)(itemRect.x0 + (this.clipRect.w - width) / 2);
                } else if ((this.iLayoutFlags & 4) != 0) {
                    itemRect.x0 = (this.iLayoutFlags & 0x14) != 0 ? (words > 1 ? (short)(itemRect.x0 + (this.clipRect.w - width) * word / (words - 1)) : (short)(itemRect.x0 + (this.clipRect.w - width) / 2)) : (short)(itemRect.x0 + (this.clipRect.w - width) * (word + 1) / (words + 2));
                } else if ((this.iLayoutFlags & 0x200) != 0) {
                    itemRect.x0 = (short)(itemRect.x0 + (this.clipRect.w - width));
                }
                if ((this.iLayoutFlags & 2) != 0) {
                    int h = (this.clipRect.h - height) / 2;
                    if (h > 0) {
                        itemRect.y0 = (short)(itemRect.y0 + h);
                    }
                } else if ((this.iLayoutFlags & 8) != 0) {
                    if ((this.iLayoutFlags & 0x28) != 0) {
                        if (lines > 1) {
                            itemRect.y0 = (short)(itemRect.y0 + (this.clipRect.h - height) * line / (lines - 1));
                        }
                    } else {
                        itemRect.y0 = (short)(itemRect.y0 + (this.clipRect.h - height) / 2);
                    }
                }
                if (this.iLineHeight != -1 && this.iLineHeight > itemRect.h) {
                    itemRect.y0 = (short)(itemRect.y0 + (this.iLineHeight - itemRect.h >> 1));
                }
                if (this.iLineHeight == -1 && line_height > itemRect.h) {
                    itemRect.y0 = (short)(itemRect.y0 + (line_height - itemRect.h >> 1));
                }
                ++word;
            }
        }
        this.rectDocument.x0 = 0;
        this.rectDocument.y0 = (short)((this.iLayoutFlags & 2) != 0 ? (this.clipRect.h - height) / 2 : 0);
        this.rectDocument.y0 = 0 > this.rectDocument.y0 ? (short)0 : this.rectDocument.y0;
        this.rectDocument.w = this.clipRect.w;
        this.rectDocument.h = height;
        if ((this.iLayoutFlags & 0x100) != 0) {
            this.clipRect.h = this.rectDocument.h;
        }
        this.initialised = true;
    }

    public void formatText(BitmapFont font, String text) {
        this.initialised = false;
        int wordstart = 0;
        int nextwordstart = 0;
        boolean layoutflags = false;
        while (nextwordstart < text.length()) {
            if (this.takeNewLine) {
                this.setNewLine(this.controlList.size());
                this.takeNewLine = false;
            }
            wordstart = nextwordstart;
            int nextspace = text.indexOf(32, wordstart) + 1;
            int nextnewline = text.indexOf(10, wordstart) + 1;
            if (nextspace > 0 && (nextspace < nextnewline || nextnewline == 0)) {
                nextwordstart = nextspace;
            } else if (nextnewline > 0) {
                nextwordstart = nextnewline;
                this.takeNewLine = true;
            } else {
                nextwordstart = text.length();
            }
            String word = text.substring(wordstart, nextwordstart);
            this.addControl(new TextImage(font, word));
        }
    }

    public void paint(Graphics g) {
        if (!this.initialised) {
            return;
        }
        BaseScreen.pushVisibleRect(this.clipRect);
        for (int i = 0; i < this.controlList.size(); ++i) {
            GuiContainer item = (GuiContainer)this.controlList.elementAt(i);
            if (item.clipRect.x0 + item.clipRect.w + this.iXScroll <= 0 || item.clipRect.x0 + this.iXScroll >= 0 + this.clipRect.w || item.clipRect.y0 + item.clipRect.h + this.iYScroll <= 0 || item.clipRect.y0 + this.iYScroll >= 0 + this.clipRect.h) continue;
            if (!this.initialised) break;
            this.oldRect = item.clipRect;
            this.newRect.x0 = (short)(this.clipRect.x0 + item.clipRect.x0 + this.iXScroll);
            this.newRect.y0 = (short)(this.clipRect.y0 + item.clipRect.y0 + this.iYScroll);
            this.newRect.w = (short)((this.newRect.x0 + item.clipRect.w < this.clipRect.x0 + this.clipRect.w ? this.newRect.x0 + item.clipRect.w : this.clipRect.x0 + this.clipRect.w) - this.newRect.x0);
            this.newRect.h = (short)((this.newRect.y0 + item.clipRect.h < this.clipRect.y0 + this.clipRect.h ? this.newRect.y0 + item.clipRect.h : this.clipRect.y0 + this.clipRect.h) - this.newRect.y0);
            item.clipRect = this.newRect;
            item.paint(g);
            item.clipRect = this.oldRect;
        }
        BaseScreen.popVisibleRect();
    }

    public void process() {
    }

    public boolean scroll(int fp_moveamount) {
        int fp_lastY = this.fp_y;
        short imax = -this.rectDocument.y0;
        int imin = -(0 > this.rectDocument.h - this.clipRect.h ? 0 : this.rectDocument.h - this.clipRect.h);
        this.fp_y = this.fp_y + fp_moveamount < (imin < 0 ? -(-imin << 16) : imin << 16) ? (imin < 0 ? -(-imin << 16) : imin << 16) : (this.fp_y + fp_moveamount > (imax < 0 ? -(-imax << 16) : imax << 16) ? (imax < 0 ? -(-imax << 16) : imax << 16) : this.fp_y + fp_moveamount);
        this.iYScroll = this.fp_y < 0 ? -(-this.fp_y >> 16) : this.fp_y >> 16;
        return fp_lastY != this.fp_y || fp_moveamount == 0;
    }
}

