/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class AStar {
    GameCanvas gameCanvas;
    AniObj currentAni;
    MapNode[][] AllNode;
    Vector srcOpenList = new Vector();
    Vector srcCloseList = new Vector();

    public AStar(GameCanvas _gameCanvas, AniObj currentAni) {
        this.gameCanvas = _gameCanvas;
        this.currentAni = currentAni;
        this.AllNode = new MapNode[this.gameCanvas.Map.mapMaxX][this.gameCanvas.Map.mapMaxY];
        for (int x = 0; x < this.gameCanvas.Map.mapMaxX; x = (int)((byte)(x + 1))) {
            for (int y = 0; y < this.gameCanvas.Map.mapMaxY; y = (int)((byte)(y + 1))) {
                this.AllNode[x][y] = new MapNode(this, x, y);
            }
        }
    }

    public int[][] findPath(int sx, int sy, int dx, int dy) {
        if (sx < 0 || sy < 0 | dx < 0 || dy < 0) {
            return null;
        }
        this.srcOpenList.removeAllElements();
        this.srcCloseList.removeAllElements();
        MapNode srcNode = this.AllNode[sx][sy];
        srcNode.sG = 0;
        srcNode.sH = Math.abs(srcNode.X - dx) + Math.abs(srcNode.Y - dy);
        srcNode.sF = srcNode.sG + srcNode.sH;
        srcNode.sFather = srcNode;
        this.srcOpenList.addElement(srcNode);
        int[][] path = null;
        int[][] near = new int[][]{{0, -1}, {-1, 0}, {1, 0}, {0, 1}};
        do {
            try {
                MapNode curSrcNode = this.getMinF(this.srcOpenList);
                this.srcOpenList.removeElement(curSrcNode);
                this.srcCloseList.addElement(curSrcNode);
                for (int i = 0; i < near.length; ++i) {
                    MapNode block;
                    if (curSrcNode.Y + near[i][1] < 1 || curSrcNode.Y + near[i][1] > this.gameCanvas.Map.mapMaxY - 2 || curSrcNode.X + near[i][0] < 1 || curSrcNode.X + near[i][0] > this.gameCanvas.Map.mapMaxX - 2 || this.srcCloseList.contains(block = this.AllNode[curSrcNode.X + near[i][0]][curSrcNode.Y + near[i][1]]) || this.gameCanvas.ckMapblock(block.X, block.Y) != 0) continue;
                    int bG = curSrcNode.sG;
                    bG = near[i][0] != 0 && near[i][1] != 0 ? (bG += 32) : (bG += 16);
                    if (!this.srcOpenList.contains(block)) {
                        this.srcOpenList.addElement(block);
                        block.sFather = curSrcNode;
                        block.sG = bG;
                        block.sH = Math.abs(block.X - dx) + Math.abs(block.Y - dy);
                        block.sF = block.sG + block.sH;
                        continue;
                    }
                    if (bG >= curSrcNode.sG) continue;
                    block.sFather = curSrcNode;
                    block.sG = bG;
                    block.sH = Math.abs(block.X - dx) + Math.abs(block.Y - dy);
                    block.sF = block.sG + block.sH;
                }
                if (curSrcNode.X == dx && curSrcNode.Y == dy) {
                    Vector<Integer> X = new Vector<Integer>();
                    Vector<Integer> Y = new Vector<Integer>();
                    while (Game.isTrue && (curSrcNode.X != sx || curSrcNode.Y != sy) && curSrcNode.sFather != curSrcNode) {
                        X.addElement(new Integer(curSrcNode.X));
                        Y.addElement(new Integer(curSrcNode.Y));
                        curSrcNode = curSrcNode.sFather;
                    }
                    path = new int[X.size()][2];
                    for (int i = 0; i < X.size(); ++i) {
                        path[i][0] = (Integer)X.elementAt(i);
                        path[i][1] = (Integer)Y.elementAt(i);
                    }
                    if (X != null) {
                        X = null;
                    }
                    if (Y == null) break;
                    Y = null;
                    break;
                }
                if (!this.srcOpenList.isEmpty()) continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            break;
        } while (Game.isTrue);
        return path;
    }

    public MapNode getMinF(Vector list) {
        int min = Integer.MAX_VALUE;
        MapNode ret = null;
        for (int i = 0; i < list.size(); ++i) {
            int v = ((MapNode)list.elementAt((int)i)).sF;
            if (min <= v) continue;
            ret = (MapNode)list.elementAt(i);
            min = v;
        }
        return ret;
    }

    public void putMinF(Vector list) {
        int min = Integer.MAX_VALUE;
        MapNode ret = null;
        for (int i = 0; i < list.size(); ++i) {
            int v = ((MapNode)list.elementAt((int)i)).sF;
            if (min <= v) continue;
            ret = (MapNode)list.elementAt(i);
            min = v;
        }
    }

    class MapNode {
        public int X;
        public int Y;
        public MapNode sFather;
        public int sG = 0;
        public int sH = 0;
        public int sF = 0;

        public MapNode(AStar this$0, int x, int y) {
            this.X = x;
            this.Y = y;
        }
    }
}

