/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DataReader {
    private static final byte FILE_MAPINFOTag = 1;
    private static final byte FILE_PICTag = 2;
    private static final byte FILE_RESTag = 3;
    private static final byte FILE_BGLAYERTag = 7;
    private static final byte FILE_RGLAYERTag = 11;
    private static final byte FILE_LAYERORDER = 12;
    public static final byte LAYER_BG = 1;
    public static final byte LAYER_SP = 2;
    public static final byte LAYER_PH = 3;
    public static final byte LAYER_AF = 4;
    public static final byte LAYER_RG = 5;
    public PicObj[] picArr;
    public ResObj[] resArr;
    public BgTileObj[][] bgTileArr;
    public Rect[][] rgTileArr;
    private byte[] fileBytes;
    public int mapWidth;
    public int mapHeight;
    public int mapTileWidth;
    public int mapTileHeight;
    public byte[] layerOrder;
    private String dataFilepath;
    String fathPath;

    public void setDataFile(String filePath) {
        this.dataFilepath = filePath;
        this.fathPath = Tool.getFatherPath(filePath);
        this.fileBytes = null;
    }

    private byte[] getFileBytesFromFile(String filePath) {
        byte[] returnBytes = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(filePath);
            int fileLen = 0;
            fileLen = is.available();
            if (fileLen <= 0) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
                byte[] readBytes = new byte[256];
                while (is.read(readBytes) != -1) {
                    bos.write(readBytes);
                }
                returnBytes = bos.toByteArray();
            } else {
                returnBytes = new byte[fileLen];
                is.read(returnBytes);
            }
            is.close();
            is = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnBytes;
    }

    private int findStartPosition(int tag) {
        int infoStart = -1;
        byte[] storeByte = new byte[2];
        int bytePoint = 0;
        for (int i = 0; this.fileBytes != null && i < this.fileBytes.length; ++i) {
            byte checkByte = this.fileBytes[i];
            if (bytePoint <= 1) {
                storeByte[bytePoint] = checkByte;
                ++bytePoint;
            } else {
                storeByte[0] = storeByte[1];
                storeByte[1] = checkByte;
            }
            if (storeByte[0] != -1 || storeByte[1] != tag) continue;
            infoStart = i;
            break;
        }
        return infoStart;
    }

    public boolean readMapInfo() {
        if (this.dataFilepath == null) {
            return false;
        }
        try {
            ByteArrayInputStream bis;
            if (this.fileBytes == null) {
                this.fileBytes = this.getFileBytesFromFile(this.dataFilepath);
            }
            int mapInfoStart = this.findStartPosition(1);
            int orderInfoStart = this.findStartPosition(12);
            DataInputStream dis = null;
            if (mapInfoStart > -1) {
                bis = new ByteArrayInputStream(this.fileBytes, mapInfoStart + 1, this.fileBytes.length - mapInfoStart - 1);
                dis = new DataInputStream(bis);
                this.mapWidth = dis.readShort();
                this.mapHeight = dis.readShort();
                this.mapTileWidth = dis.readByte();
                this.mapTileHeight = dis.readByte();
                dis.close();
                bis.close();
                dis = null;
                bis = null;
            }
            if (orderInfoStart > -1) {
                bis = new ByteArrayInputStream(this.fileBytes, orderInfoStart + 1, this.fileBytes.length - orderInfoStart - 1);
                dis = new DataInputStream(bis);
                int layerCount = dis.readByte() & 0xFF;
                if (layerCount > 0) {
                    this.layerOrder = new byte[layerCount];
                    for (int i = 0; i < layerCount; ++i) {
                        this.layerOrder[i] = dis.readByte();
                    }
                }
                dis.close();
                bis.close();
                dis = null;
                bis = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public boolean readPicData() {
        if (this.dataFilepath == null) {
            return false;
        }
        try {
            if (this.fileBytes == null) {
                this.fileBytes = this.getFileBytesFromFile(this.dataFilepath);
            }
            int picStart = this.findStartPosition(2);
            DataInputStream dis = null;
            if (picStart > -1) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.fileBytes, picStart + 1, this.fileBytes.length - picStart - 1);
                dis = new DataInputStream(bis);
                int picAmount = dis.readByte() & 0xFF;
                if (picAmount > 0) {
                    this.picArr = new PicObj[picAmount];
                }
                for (int i = 0; i < picAmount; ++i) {
                    this.picArr[i] = new PicObj();
                    this.picArr[i].id = dis.readByte();
                    this.picArr[i].path = dis.readUTF();
                    if (!this.picArr[i].path.substring(0, 1).equals("/")) {
                        this.picArr[i].path = "/".concat(String.valueOf(String.valueOf(this.picArr[i].path)));
                    }
                    this.picArr[i].path = String.valueOf(String.valueOf(this.fathPath)).concat(String.valueOf(String.valueOf(this.picArr[i].path)));
                    int index = 0;
                    index = this.picArr[i].path.indexOf(".ps");
                    if (index == -1) continue;
                    String t = this.picArr[i].path.substring(0, index);
                    this.picArr[i].path = String.valueOf(String.valueOf(t)).concat(".png");
                }
                dis.close();
                bis.close();
                dis = null;
                Object var3_5 = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public boolean readResData() {
        if (this.dataFilepath == null) {
            return false;
        }
        try {
            if (this.fileBytes == null) {
                this.fileBytes = this.getFileBytesFromFile(this.dataFilepath);
            }
            int resStart = this.findStartPosition(3);
            DataInputStream dis = null;
            if (resStart > -1) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.fileBytes, resStart + 1, this.fileBytes.length - resStart - 1);
                dis = new DataInputStream(bis);
                int resAmount = dis.readByte() & 0xFF;
                if (resAmount > 0) {
                    this.resArr = new ResObj[resAmount];
                }
                for (int i = 0; i < resAmount; ++i) {
                    this.resArr[i] = new ResObj();
                    this.resArr[i].id = (short)(dis.readShort() & 0xFF);
                    this.resArr[i].picId = dis.readShort();
                    this.resArr[i].x = dis.readShort();
                    this.resArr[i].y = dis.readShort();
                    this.resArr[i].width = dis.readByte();
                    this.resArr[i].height = dis.readByte();
                    this.resArr[i].flipH = dis.readByte();
                    this.resArr[i].flipV = dis.readByte();
                }
                dis.close();
                bis.close();
                dis = null;
                Object var3_5 = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public boolean readBgLayerData() {
        if (this.dataFilepath == null) {
            return false;
        }
        try {
            if (this.fileBytes == null) {
                this.fileBytes = this.getFileBytesFromFile(this.dataFilepath);
            }
            int bgLayerStart = this.findStartPosition(7);
            DataInputStream dis = null;
            if (bgLayerStart > -1) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.fileBytes, bgLayerStart + 1, this.fileBytes.length - bgLayerStart - 1);
                dis = new DataInputStream(bis);
                int bgLayerCount = dis.readByte() & 0xFF;
                this.bgTileArr = new BgTileObj[bgLayerCount][];
                for (int i = 0; i < bgLayerCount; ++i) {
                    int tileCount = dis.readShort();
                    this.bgTileArr[i] = new BgTileObj[tileCount];
                    for (int j = 0; j < tileCount; ++j) {
                        this.bgTileArr[i][j] = new BgTileObj();
                        this.bgTileArr[i][j].x = dis.readByte();
                        this.bgTileArr[i][j].y = dis.readByte();
                        this.bgTileArr[i][j].resId = (short)(dis.readByte() & 0xFF);
                    }
                }
                dis.close();
                bis.close();
                dis = null;
                Object var3_5 = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public boolean readRgLayerData() {
        if (this.dataFilepath == null) {
            return false;
        }
        try {
            if (this.fileBytes == null) {
                this.fileBytes = this.getFileBytesFromFile(this.dataFilepath);
            }
            int rgLayerStart = this.findStartPosition(11);
            DataInputStream dis = null;
            if (rgLayerStart > -1) {
                ByteArrayInputStream bis = new ByteArrayInputStream(this.fileBytes, rgLayerStart + 1, this.fileBytes.length - rgLayerStart - 1);
                dis = new DataInputStream(bis);
                int rgLayerCount = dis.readByte() & 0xFF;
                this.rgTileArr = new Rect[rgLayerCount][];
                for (int i = 0; i < rgLayerCount; ++i) {
                    int tileCount = dis.readShort();
                    this.rgTileArr[i] = new Rect[tileCount];
                    for (int j = 0; j < tileCount; ++j) {
                        this.rgTileArr[i][j] = new Rect();
                        this.rgTileArr[i][j].startX = dis.readShort();
                        this.rgTileArr[i][j].startY = dis.readShort();
                        this.rgTileArr[i][j].width = dis.readShort();
                        this.rgTileArr[i][j].height = dis.readShort();
                        dis.readByte();
                    }
                }
                dis.close();
                bis.close();
                dis = null;
                Object var3_5 = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }

    public boolean readAllData() {
        this.readMapInfo();
        this.readPicData();
        this.readResData();
        this.readBgLayerData();
        this.readRgLayerData();
        return true;
    }

    static {
        FILE_MAPINFOTag = 1;
        FILE_PICTag = (byte)2;
        FILE_RESTag = (byte)3;
        FILE_BGLAYERTag = (byte)7;
        FILE_RGLAYERTag = (byte)11;
        FILE_LAYERORDER = (byte)12;
        LAYER_BG = 1;
        LAYER_SP = (byte)2;
        LAYER_PH = (byte)3;
        LAYER_AF = (byte)4;
        LAYER_RG = (byte)5;
    }
}

