/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.debug;

import at.emini.physics2D.Body;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.util.FXVector;
import com.ximad.pvn.debug.Monitor;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.MyWorld;
import javax.microedition.lcdui.Graphics;

public class DebugDraw {
    public static void draw(Graphics g, MyWorld world) {
        Monitor.begin("DEBUG");
        g.setColor(12130047);
        int bodyCount = world.getBodyCount();
        Body[] bodies = world.getBodies();
        for (int i = 0; i < bodyCount; ++i) {
            if (bodies[i] == null) continue;
            DebugDraw.drawBody(g, bodies[i]);
        }
        DebugDraw.drawLandscape(g, world);
        Monitor.end("DEBUG");
    }

    public static void drawBody(Graphics g, Body b) {
        FXVector[] positions = b.getVertices();
        if (positions.length == 1) {
            int radius = b.shape().getBoundingRadiusFX() >> 12;
            g.drawArc(b.positionFX().xAsInt() - radius - Camera.position, b.positionFX().yAsInt() - radius, radius * 2, radius * 2, 0, 360);
            int anglee = (b.rotation2FX() >> 105414356) * 360 / 100;
            float myAngle = anglee % 90 < 45 ? (float)(45 - anglee % 90) : (float)(anglee % 90 - 45);
            myAngle = (float)((double)myAngle * Math.PI / 180.0);
            float anggle = (float)((double)(anglee * 2) * Math.PI / 360.0);
            g.drawLine(b.positionFX().xAsInt() - Camera.position, b.positionFX().yAsInt(), (int)((double)b.positionFX().xAsInt() + (double)radius * Math.cos(anggle)) - Camera.position, (int)((double)b.positionFX().yAsInt() + (double)radius * Math.sin(anggle)));
        } else {
            for (int i = 0; i < positions.length - 1; ++i) {
                g.drawLine(positions[i].xAsInt() - Camera.position, positions[i].yAsInt(), positions[i + 1].xAsInt() - Camera.position, positions[i + 1].yAsInt());
            }
            g.drawLine(positions[positions.length - 1].xAsInt() - Camera.position, positions[positions.length - 1].yAsInt(), positions[0].xAsInt() - Camera.position, positions[0].yAsInt());
            g.setColor(16714793);
            g.drawLine(b.positionFX().xAsInt() - Camera.position, b.positionFX().yAsInt(), b.positionFX().xAsInt() - Camera.position, b.positionFX().yAsInt());
            g.setColor(12130047);
        }
    }

    public static void drawLandscape(Graphics g, MyWorld mWorld) {
        int i;
        g.setColor(12130047);
        Landscape ls = mWorld.getLandscape();
        if (ls == null) {
            return;
        }
        for (i = 0; i < ls.segmentCount(); ++i) {
            g.drawLine(ls.startPoint(i).xAsInt(), ls.startPoint(i).yAsInt(), ls.endPoint(i).xAsInt(), ls.endPoint(i).yAsInt());
        }
        for (i = 0; i < 2000; i += 50) {
            g.drawLine(i - Camera.position, MyWorld.floor, i - Camera.position, MyWorld.floor + 10);
            g.drawString("" + i, i - 5 - Camera.position, MyWorld.floor + 20, 0);
        }
        g.setColor(12130047);
        for (i = 0; i < 360; i += 20) {
            g.drawLine(0, i, 10, i);
            g.drawString("" + i, 15, i - 5, 0);
        }
        g.setColor(16714793);
        g.drawLine(MyWorld.center - Camera.position, MyWorld.floor, MyWorld.center - Camera.position, MyWorld.floor + 40);
    }
}

