/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.HomeScreen;
import javax.microedition.lcdui.Graphics;

public class StatisticScreen
extends UiScreen {
    private static StatisticScreen instance;
    private Bitmap farBackground = Textures.mainMenuBackground;
    private Bitmap mainBackground = Textures.statisticMainBackground;
    private Bitmap caption = Textures.statisticCaption;
    private Bitmap score = Textures.statisticScore;
    private Bitmap panda = Textures.statisticPanda;
    private Bitmap ninja = Textures.statisticNinja;
    private Bitmap pregrada = Textures.statisticPregrada;
    private CustomLabelField lbPanda;
    private CustomLabelField lbNinja;
    private CustomLabelField lbPregrada;
    private CustomLabelField lbBronze;
    private CustomLabelField lbSilver;
    private CustomLabelField lbGold;
    private CustomLabelField lbScore;

    public StatisticScreen() {
        CustomButton btBack = new CustomButton(Textures.back, 0, 1){

            protected void touchAction() {
                Application.setScreen(HomeScreen.getInstance());
            }
        };
        this.lbPanda = new CustomLabelField("0", 22, 5646607);
        this.lbNinja = new CustomLabelField("0", 22, 5646607);
        this.lbPregrada = new CustomLabelField("0", 22, 5646607);
        this.lbBronze = new CustomLabelField("0", 22, 5646607);
        this.lbSilver = new CustomLabelField("0", 22, 5646607);
        this.lbGold = new CustomLabelField("0", 22, 5646607);
        this.lbScore = new CustomLabelField("score", 22, 5646607);
        this.add(btBack, 257, 310);
        this.add(this.lbScore, 330, 115);
        this.add(this.lbGold, 460, 170);
        this.add(this.lbSilver, 325, 170);
        this.add(this.lbBronze, 200, 170);
        this.add(this.lbPanda, 330, 260);
        this.add(this.lbNinja, 465, 260);
        this.add(this.lbPregrada, 205, 260);
    }

    public void onPaint(Graphics g) {
        this.farBackground.draw(g, 0, 0);
        this.mainBackground.draw(g, 33, 0);
        this.caption.drawFlag(g, 321, 72, 3);
        this.score.draw(g, 220, 112);
        Textures.statisticMedals.drawSprite(g, 140, 160, 0);
        Textures.statisticMedals.drawSprite(g, 270, 160, 1);
        Textures.statisticMedals.drawSprite(g, 400, 160, 2);
        this.ninja.draw(g, 260, 240);
        this.panda.draw(g, 390, 240);
        this.pregrada.draw(g, 130, 240);
        super.onPaint(g);
    }

    public void onShow() {
        int panda = 0;
        int ninja = 0;
        int obstacles = 0;
        int gold = 0;
        int silver = 0;
        int bronze = 0;
        long score = 0L;
        for (int i = 0; i < GameParameters.scenarios_size; ++i) {
            Scenario scenario = (Scenario)GameParameters.scenarios.get(i);
            for (int j = 0; j < scenario.level.size(); ++j) {
                LevelCompleteStat level = (LevelCompleteStat)scenario.level.get(j);
                panda += level.pandaUsed;
                ninja += level.ninjas;
                obstacles += level.obstacles;
                if (level.medal.equals("gold")) {
                    ++gold;
                }
                if (level.medal.equals("silver")) {
                    ++silver;
                }
                if (level.medal.equals("bronze")) {
                    ++bronze;
                }
                score += level.score;
            }
        }
        this.lbPanda.setText("" + panda);
        this.lbNinja.setText("" + ninja);
        this.lbPregrada.setText("" + obstacles);
        this.lbGold.setText("" + gold);
        this.lbSilver.setText("" + silver);
        this.lbBronze.setText("" + bronze);
        this.lbScore.setText("" + score);
        StatisticScreen.repaint();
    }

    public static StatisticScreen getInstance() {
        if (instance == null) {
            instance = new StatisticScreen();
        }
        return instance;
    }
}

