/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class game13
extends game {
    Image[] charImg;
    Image[] guideImg;
    Image[] tileImg;
    int[][] keyFunc;
    int[][] mapStart;
    int mapStartCount;
    int mapExitMax;
    int stageExip;
    Tile[][] map;
    Guest[] guest;
    int[] switchKeyMax = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3};
    int[] exitMap = new int[]{-1, -1, -1, -1, -1};
    int startX;
    int startY;
    int missionCount;
    int missionMax;
    int guestDelay;
    int batTime;
    int batX;
    int batY;
    int tileSize;
    int mapWidth;
    int mapHeight;
    int gameCount;
    int crashCount;
    int selectStoreItem;
    int guestScreenMax;
    int[] MISSION_STAGE = new int[]{0, 0, 0};
    int[] MISSION_TYPE = new int[]{0, 0, 0};
    int[] MISSION_CONDITION = new int[]{100, 200, 250};
    boolean[] MISSION_SUCCESS = new boolean[]{false, false, false};

    public boolean missionCheck(int gameIdx, int missionIdx, boolean stageFlag) {
        int tmp = 0;
        if (stageFlag) {
            tmp = this.gameStage;
        }
        if (this.MISSION_TYPE[missionIdx] != -1 && !base.cmn.checkMission(gameIdx, missionIdx + 1) && tmp + this.MISSION_TYPE[missionIdx] < this.MISSION_CONDITION[missionIdx]) {
            int n = missionIdx;
            this.MISSION_TYPE[n] = this.MISSION_TYPE[n] + 1;
            int n2 = missionIdx;
            this.MISSION_STAGE[n2] = this.MISSION_STAGE[n2] + 1;
            if (tmp + this.MISSION_TYPE[missionIdx] >= this.MISSION_CONDITION[missionIdx]) {
                common.MISSIONS[(gameIdx - 1) * 3 + missionIdx] = true;
                this.completedMission = missionIdx + 1;
                switch (this.completedMission) {
                    case 1: {
                        common.ITEMS[13] = common.ITEMS[13] + 200;
                        break;
                    }
                    case 2: {
                        common.ITEMS[13] = common.ITEMS[13] + 300;
                        break;
                    }
                    case 3: {
                        common.ITEMS[13] = common.ITEMS[13] + 500;
                    }
                }
                base.cmn.setMission(base.TheGame, missionIdx + 1);
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
                return true;
            }
        }
        return false;
    }

    void missionCountInit() {
        this.MISSION_TYPE[0] = 0;
        this.MISSION_TYPE[1] = 0;
        this.MISSION_TYPE[2] = 0;
    }

    void missionCountFail() {
        this.MISSION_TYPE[0] = -1;
        this.MISSION_TYPE[1] = -1;
        this.MISSION_TYPE[2] = -1;
    }

    void missionStageCountInit() {
        this.MISSION_STAGE[0] = 0;
        this.MISSION_STAGE[1] = 0;
        this.MISSION_STAGE[2] = 0;
    }

    void missionStageReset() {
        this.MISSION_TYPE[0] = this.MISSION_TYPE[0] - this.MISSION_STAGE[0];
        this.MISSION_TYPE[1] = this.MISSION_TYPE[1] - this.MISSION_STAGE[1];
        this.MISSION_TYPE[2] = this.MISSION_TYPE[2] - this.MISSION_STAGE[2];
    }

    game13() {
        base.TheGame = 13;
        this.loadImage();
        this.initGame();
        this.loadGame(base.TheGame);
        this.setupStage(true);
    }

    public void initGame() {
        int i;
        this.map = new Tile[13][12];
        this.guest = new Guest[8];
        this.keyFunc = new int[9][2];
        this.mapStart = new int[5][2];
        for (i = 0; i < this.map.length; ++i) {
            for (int j = 0; j < this.map[0].length; ++j) {
                this.map[i][j] = new Tile();
            }
        }
        for (i = 0; i < this.guest.length; ++i) {
            this.guest[i] = new Guest();
        }
        this.loadMap("map1");
        base.counter = 0;
        this.limitTime = 0;
        this.remainTime = 0;
        this.startX = 23;
        this.startY = base.yOffset + 53;
        this.tileSize = 16;
        game.LIFE = 3;
    }

    private int[] randOverlap(int end) {
        int ranNum = 0;
        int i = 0;
        int j = 0;
        int[] check = new int[end];
        for (i = 0; i < check.length; ++i) {
            boolean tell;
            do {
                tell = false;
                check[i] = ranNum = base.Random(0, check.length - 1);
                for (j = 0; j < i; ++j) {
                    if (check[i] != check[j]) continue;
                    tell = true;
                }
            } while (tell);
        }
        return check;
    }

    private void sendGuest() {
        int rand = 0;
        int start = 0;
        int x = 0;
        int y = 0;
        int delay = 0;
        delay = this.itemTimers[3] == 0 ? this.guestDelay : this.guestDelay * 2;
        for (int i = 0; i < this.guestScreenMax; ++i) {
            if (this.guest[i].start || base.counter % delay != 0) continue;
            this.guest[i].idx = base.Random(0, 1);
            this.guest[i].speed = 3;
            this.guest[i].target = this.exitMap[base.Random(0, this.mapExitMax - 1)];
            this.guest[i].state = 0;
            rand = base.Random(1, 100);
            start = base.Random(0, this.mapStartCount - 1);
            this.guest[i].x = this.startX + this.mapStart[start][0] * this.tileSize + (this.tileSize >> 1);
            this.guest[i].y = this.startY + this.mapStart[start][1] * this.tileSize + (this.tileSize >> 1);
            this.guest[i].w = 13;
            this.guest[i].h = 13;
            x = (this.guest[i].x - this.startX) / this.tileSize;
            y = (this.guest[i].y - this.startY) / this.tileSize;
            switch (this.map[y][x].attrib) {
                case 20: {
                    this.guest[i].dir = 1;
                    break;
                }
                case 21: {
                    this.guest[i].dir = 2;
                    break;
                }
                case 22: {
                    this.guest[i].dir = 0;
                    break;
                }
                case 23: {
                    this.guest[i].dir = 3;
                }
            }
            this.guest[i].start = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collisionGuest(int i) {
        int k = 0;
        k = 0;
        while (true) {
            block14: {
                if (k >= this.guestScreenMax) {
                    return;
                }
                if (i == k) break block14;
                switch (this.guest[k].dir) {
                    case 0: {
                        if (this.guest[i].y < this.guest[k].y) break;
                        break block14;
                    }
                    case 1: {
                        if (this.guest[i].y > this.guest[k].y) break;
                        break block14;
                    }
                    case 2: {
                        if (this.guest[i].x < this.guest[k].x) break;
                        break block14;
                    }
                    case 3: {
                        if (this.guest[i].x <= this.guest[k].x) break block14;
                    }
                }
                if (this.collision(this.guest[i].x - (this.guest[i].w >> 1), this.guest[i].y - (this.guest[i].h >> 1), this.guest[i].w, this.guest[i].h, this.guest[k].x - (this.guest[k].w >> 1), this.guest[k].y - (this.guest[k].h >> 1), this.guest[k].w, this.guest[k].h)) {
                    if (this.collisionDir(this.guest[k].dir, this.guest[k].x - (this.guest[k].w >> 1), this.guest[k].y - (this.guest[k].h >> 1), this.guest[k].w, this.guest[k].h, this.guest[i].x - (this.guest[i].w >> 1), this.guest[i].y - (this.guest[i].h >> 1), this.guest[i].w, this.guest[i].h)) {
                        this.guest[k].speed = 0;
                    } else {
                        this.guest[i].speed = 3;
                    }
                } else {
                    this.guest[k].speed = 3;
                }
                if (20 > this.getDistance(this.guest[i].x, this.guest[i].y, this.guest[k].x, this.guest[k].y)) {
                    this.guest[i].speed = 3;
                    this.guest[k].speed = 0;
                }
            }
            ++k;
        }
    }

    private int abs(int x) {
        return x < 0 ? ~x + 1 : x;
    }

    private int getDistance(int x1, int y1, int x2, int y2) {
        int x = this.abs(this.getDistance2(x1, x2));
        int y = this.abs(this.getDistance2(y1, y2));
        int z = Math.min(x, y);
        return x + y - (z >> 1) - (z >> 2) + (z >> 4);
    }

    private int getDistance2(int p1, int p2) {
        return p1 > p2 ? p1 - p2 : p2 - p1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawGuest(Graphics g) {
        int i;
        if (base.playState == 64) {
            if (this.itemTimers[3] == 0) {
                if (this.itemTimers[2] == 0) {
                    this.sendGuest();
                }
            } else {
                this.sendGuest();
            }
        }
        for (i = 0; i < this.guestScreenMax; ++i) {
            for (int j = i + 1; j < this.guestScreenMax; ++j) {
                if (this.guest[i].y <= this.guest[j].y) continue;
                Guest tmp = this.guest[i];
                this.guest[i] = this.guest[j];
                this.guest[j] = tmp;
            }
        }
        i = 0;
        while (i < this.guestScreenMax) {
            if (this.guest[i].start) {
                if (base.playState == 64) {
                    this.collisionGuest(i);
                    this.guestDirectionChange(i);
                }
                switch (this.guest[i].dir) {
                    case 0: {
                        g.drawImage(this.charImg[0 + this.guest[i].idx * 4], this.guest[i].x - (this.tileSize >> 1) - 2, this.guest[i].y - this.tileSize - (this.tileSize >> 1) - 4, 0x10 | 4);
                        g.drawImage(this.guideImg[6], this.guest[i].x, this.guest[i].y - 55, 0x10 | 4);
                        g.drawImage(this.guideImg[this.guest[i].target - 4], this.guest[i].x + 14, this.guest[i].y - 44, 2 | 1);
                        if (base.playState != 64) break;
                        switch (this.guest[i].state) {
                            case 0: {
                                if (this.itemTimers[3] == 0) {
                                    if (this.itemTimers[2] != 0) break;
                                    this.guest[i].y -= this.guest[i].speed;
                                    break;
                                }
                                if (this.itemTimers[3] % 2 != 0) break;
                                this.guest[i].y -= this.guest[i].speed;
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        g.drawImage(this.charImg[1 + this.guest[i].idx * 4], this.guest[i].x - (this.tileSize >> 1), this.guest[i].y - this.tileSize - (this.tileSize >> 1), 0x10 | 4);
                        g.drawImage(this.guideImg[6], this.guest[i].x, this.guest[i].y - 55, 0x10 | 4);
                        g.drawImage(this.guideImg[this.guest[i].target - 4], this.guest[i].x + 14, this.guest[i].y - 44, 2 | 1);
                        if (base.playState != 64) break;
                        switch (this.guest[i].state) {
                            case 0: {
                                if (this.itemTimers[3] == 0) {
                                    if (this.itemTimers[2] != 0) break;
                                    this.guest[i].y += this.guest[i].speed;
                                    break;
                                }
                                if (this.itemTimers[3] % 2 != 0) break;
                                this.guest[i].y += this.guest[i].speed;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        g.drawImage(this.charImg[2 + this.guest[i].idx * 4], this.guest[i].x - (this.tileSize >> 1) - 2, this.guest[i].y - this.tileSize - (this.tileSize >> 1) - 2, 0x10 | 4);
                        g.drawImage(this.guideImg[6], this.guest[i].x - 2, this.guest[i].y - 55, 0x10 | 4);
                        g.drawImage(this.guideImg[this.guest[i].target - 4], this.guest[i].x + 12, this.guest[i].y - 44, 2 | 1);
                        if (base.playState != 64) break;
                        switch (this.guest[i].state) {
                            case 0: {
                                if (this.itemTimers[3] == 0) {
                                    if (this.itemTimers[2] != 0) break;
                                    this.guest[i].x -= this.guest[i].speed;
                                    break;
                                }
                                if (this.itemTimers[3] % 2 != 0) break;
                                this.guest[i].x -= this.guest[i].speed;
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        g.drawImage(this.charImg[3 + this.guest[i].idx * 4], this.guest[i].x - (this.tileSize >> 1) + 7, this.guest[i].y - this.tileSize - (this.tileSize >> 1) - 2, 0x10 | 4);
                        g.drawImage(this.guideImg[6], this.guest[i].x + 5, this.guest[i].y - 55, 0x10 | 4);
                        g.drawImage(this.guideImg[this.guest[i].target - 4], this.guest[i].x + 19, this.guest[i].y - 44, 2 | 1);
                        if (base.playState != 64) break;
                        switch (this.guest[i].state) {
                            case 0: {
                                if (this.itemTimers[3] == 0) {
                                    if (this.itemTimers[2] != 0) break;
                                    this.guest[i].x += this.guest[i].speed;
                                    break;
                                }
                                if (this.itemTimers[3] % 2 != 0) break;
                                this.guest[i].x += this.guest[i].speed;
                            }
                        }
                        break;
                    }
                }
            }
            ++i;
        }
        return;
    }

    public boolean collisionDir(int dir, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        switch (dir) {
            case 0: {
                if (y1 + h1 <= y2) {
                    return true;
                }
            }
            case 1: {
                if (y1 <= y2 - h2) {
                    return true;
                }
            }
            case 2: {
                if (x1 + w2 <= x2) {
                    return true;
                }
            }
            case 3: {
                if (x1 > x2 + w2) break;
                return true;
            }
        }
        return false;
    }

    private void guestDirectionChange(int i) {
        switch (this.getTileAttrib((int)i).img) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.guest[i].blockFlag = false;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.guest[i].target == this.getTileAttrib((int)i).img) {
                    ++this.missionCount;
                    this.stageScore += 10 + (this.gameStage - 1) / 5;
                    this.playSound("/sound/accept");
                    this.guest[i].start = false;
                    this.missionCheck(base.TheGame, 0, false);
                    if (this.guest[i].target == 5) {
                        this.missionCheck(base.TheGame, 1, false);
                    }
                    if (this.guest[i].target != 6) break;
                    this.missionCheck(base.TheGame, 2, false);
                    break;
                }
                if (--game.LIFE <= 0) {
                    game.LIFE = 0;
                } else {
                    this.playSound("/sound/despari");
                    this.vibration();
                }
                this.guest[i].start = false;
                break;
            }
            case 19: {
                if (this.guest[i].blockFlag) break;
                this.guest[i].dir = 0;
                this.guest[i].blockFlag = true;
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                break;
            }
            case 20: {
                if (this.guest[i].blockFlag) break;
                this.guest[i].dir = 1;
                this.guest[i].blockFlag = true;
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                break;
            }
            case 21: {
                if (this.guest[i].blockFlag) break;
                this.guest[i].dir = 2;
                this.guest[i].blockFlag = true;
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                break;
            }
            case 22: {
                if (this.guest[i].blockFlag) break;
                this.guest[i].dir = 3;
                this.guest[i].blockFlag = true;
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                break;
            }
            case 23: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 3;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 24: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 1;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 25: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 1;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 26: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 27: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 1;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 28: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 29: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 2: {
                        this.guest[i].dir = 1;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 30: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 2: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 31: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 1;
                        break;
                    }
                    case 2: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 32: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 1;
                        break;
                    }
                    case 2: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
                break;
            }
            case 33: {
                if (this.guest[i].blockFlag) break;
                switch (this.getTileAttrib((int)i).dir) {
                    case 0: {
                        this.guest[i].dir = 0;
                        break;
                    }
                    case 1: {
                        this.guest[i].dir = 3;
                        break;
                    }
                    case 2: {
                        this.guest[i].dir = 1;
                        break;
                    }
                    case 3: {
                        this.guest[i].dir = 2;
                    }
                }
                this.guest[i].x = this.getTileAttrib((int)i).x + (this.tileSize >> 1);
                this.guest[i].y = this.getTileAttrib((int)i).y + (this.tileSize >> 1);
                this.guest[i].blockFlag = true;
            }
        }
    }

    private Tile getTileAttrib(int i) {
        int x = 0;
        int y = 0;
        x = (this.guest[i].x - this.startX) / this.tileSize;
        y = (this.guest[i].y - this.startY) / this.tileSize;
        return this.map[y][x];
    }

    public void loadImage() {
        try {
            int i = 0;
            boolean j = false;
            this.charImg = new Image[8];
            this.guideImg = new Image[7];
            this.tileImg = new Image[23];
            for (i = 0; i < this.charImg.length; ++i) {
                this.charImg[i] = Image.createImage((String)("/img/walk/character_" + i + ".png"));
            }
            for (i = 0; i < this.guideImg.length; ++i) {
                this.guideImg[i] = Image.createImage((String)("/img/walk/guide_" + i + ".png"));
            }
            for (i = 0; i < this.tileImg.length; ++i) {
                this.tileImg[i] = Image.createImage((String)("/img/walk/tile_" + i + ".png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("\u9738\u70d9 13 \u635e\u56fa\u7624 \u80ba\u7239 \u89d2\u83e9");
        }
    }

    public void processKeyEvent(int key) {
        switch (base.playState) {
            case 61: {
                this.processPreMissionKeyEvent(key);
                break;
            }
            case 62: {
                this.processReadyKeyEvent(key);
                break;
            }
            case 64: {
                switch (key) {
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.arrowSwitch(key - 48);
                        break;
                    }
                    case -6: {
                        this.playSound("/sound/popup");
                        this.selectSubMenu = 1;
                        base.playState = 80;
                        break;
                    }
                    case 42: {
                        this.playSound("/sound/popup");
                        base.selectedItem = 1;
                        base.playState = 67;
                        break;
                    }
                    case 35: {
                        this.playSound("/sound/popup");
                        base.counter = 0;
                        this.readQuestExplanation(base.TheGame, 6);
                        base.playState = 65;
                    }
                }
                break;
            }
            case 69: {
                this.workCheatKey(key);
                switch (key) {
                    case -5: 
                    case 53: {
                        if (base.menuDepth == 1) {
                            base.counter = 0;
                            switch (base.yesNo) {
                                case 0: {
                                    this.missionCountFail();
                                    break;
                                }
                                case 1: {
                                    if (common.ITEMS[13] >= 5) {
                                        this.missionStageReset();
                                        this.MISSION_TYPE[2] = -1;
                                        break;
                                    }
                                    base.menuDepth = 2;
                                }
                            }
                            break;
                        }
                        this.missionCountFail();
                    }
                }
                this.processFailKeyEvent(key);
                break;
            }
            case 68: {
                this.workCheatKey(key);
                this.processClearKeyEvent(key);
                break;
            }
            case 60: {
                this.playHelpKeyProcess(key, base.TheGame);
                break;
            }
            case 65: {
                this.processMissionKeyEvent(key);
                break;
            }
            case 70: {
                this.missionCountInit();
                this.processResultKeyEvent(key);
                break;
            }
            case 67: {
                this.itemKeyProcess(key);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (base.playState == 81 && this.selectSubMenu == 2 && (key == -5 || key == 53) && base.menuDepth == 1 && base.yesNo == 1 && common.ITEMS[13] >= 5) {
                    this.missionStageReset();
                }
                this.processSubMenuKeyEvent(key, base.TheGame);
                break;
            }
            case 71: {
                this.processStage50ClearKeyEvent(key);
                break;
            }
            case 100: {
                this.processSubMenuKeyEvent_111(key, base.TheGame);
            }
        }
    }

    public void cleanItemUse() {
    }

    public void playGame() {
        ++base.counter;
        if (base.playState == 64) {
            ++this.gameCount;
            if (!cSndPlay._onPlaying) {
                this.playSound("/sound/movework01", true);
            }
            if (this.missionCount >= this.missionMax) {
                this.playSound("/sound/success");
                base.playState = 68;
                base.counter = 0;
                return;
            }
            if (game.LIFE == 0) {
                base.playState = 69;
                base.counter = 0;
                this.playSound("/sound/fail");
                this.vibration();
                return;
            }
        }
    }

    private void arrowSwitch(int key) {
        int tmpKey = key - 1;
        int tmpIdx = 0;
        if (this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].img >= 23 && this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].img <= 33) {
            switch (this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].img) {
                case 23: {
                    tmpIdx = 0;
                    break;
                }
                case 24: {
                    tmpIdx = 1;
                    break;
                }
                case 25: {
                    tmpIdx = 2;
                    break;
                }
                case 26: {
                    tmpIdx = 3;
                    break;
                }
                case 27: {
                    tmpIdx = 4;
                    break;
                }
                case 28: {
                    tmpIdx = 5;
                    break;
                }
                case 29: {
                    tmpIdx = 6;
                    break;
                }
                case 30: {
                    tmpIdx = 7;
                    break;
                }
                case 31: {
                    tmpIdx = 8;
                    break;
                }
                case 32: {
                    tmpIdx = 9;
                    break;
                }
                case 33: {
                    tmpIdx = 10;
                }
            }
            this.playSound("/sound/gselect");
            this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].dir = this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].dir < this.switchKeyMax[tmpIdx] ? ++this.map[this.keyFunc[tmpKey][0]][this.keyFunc[tmpKey][1]].dir : 0;
        }
    }

    public void setupStage(boolean reset) {
        int i = 0;
        this.stageScore = 0;
        this.targetScore = 0;
        this.crashCount = 0;
        base.counter = 0;
        this.gameCount = 0;
        this.slowItem = false;
        this.stopItem = false;
        this.powerItem = false;
        this.usingItem = false;
        this.bombItem = false;
        this.slotItemChecker = 0;
        this.slotItemDuration = 0;
        this.missionStageCountInit();
        for (i = 0; i < this.itemTimers.length; ++i) {
            this.itemTimers[i] = 0;
        }
        for (i = 0; i < this.guest.length; ++i) {
            this.guest[i].start = false;
        }
        this.loadStage50ClearImg();
        this.missionCount = 0;
        this.missionMax = 5 + (this.gameStage - 1);
        this.guestScreenMax = 2 + this.gameStage / 5;
        if (this.guestScreenMax > 8) {
            this.guestScreenMax = 8;
        }
        this.guestDelay = 21 - this.gameStage / 4;
        game.LIFE = this.gameStage <= 24 ? 3 : (this.gameStage <= 34 ? 4 : 5);
        this.stageExip = this.gameStage <= 5 ? 2 : (this.gameStage <= 10 ? 3 : (this.gameStage <= 15 ? 4 : 5));
        if (this.gameStage >= 51) {
            this.loadMap("map50");
        } else {
            if (this.gameStage == 0) {
                this.gameStage = 1;
            }
            this.loadMap("map" + this.gameStage);
        }
    }

    private void loadMap(String mapFile) {
        int i = 0;
        int j = 0;
        int keyFuncTic = 0;
        this.mapStartCount = 0;
        this.mapExitMax = 0;
        for (i = 0; i < this.exitMap.length; ++i) {
            this.exitMap[i] = -1;
        }
        for (i = 0; i < this.mapStart.length; ++i) {
            for (j = 0; j < this.mapStart[0].length; ++j) {
                this.mapStart[i][j] = -1;
            }
        }
        for (i = 0; i < this.keyFunc.length; ++i) {
            for (j = 0; j < this.keyFunc[0].length; ++j) {
                this.keyFunc[i][j] = 0;
            }
        }
        try {
            DataInputStream dis = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/img/walk/map/" + mapFile + ".brm"));
            this.mapWidth = dis.read();
            this.mapHeight = dis.read();
            for (i = 0; i < this.mapHeight; ++i) {
                for (j = 0; j < this.mapWidth; ++j) {
                    this.map[i][j].img = dis.read();
                    this.map[i][j].dir = -1;
                    if (this.map[i][j].img >= 5 && this.map[i][j].img <= 9) {
                        this.exitMap[this.mapExitMax] = this.map[i][j].img;
                        ++this.mapExitMax;
                    }
                    switch (this.map[i][j].img) {
                        case 23: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[0]);
                            break;
                        }
                        case 24: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[1]);
                            break;
                        }
                        case 25: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[2]);
                            break;
                        }
                        case 26: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[3]);
                            break;
                        }
                        case 27: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[4]);
                            break;
                        }
                        case 28: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[5]);
                            break;
                        }
                        case 29: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[6]);
                            break;
                        }
                        case 30: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[7]);
                            break;
                        }
                        case 31: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[8]);
                            break;
                        }
                        case 32: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[9]);
                            break;
                        }
                        case 33: {
                            this.map[i][j].dir = base.Random(0, this.switchKeyMax[10]);
                        }
                    }
                    this.map[i][j].dirTic = this.map[i][j].dir;
                }
            }
            for (i = 0; i < this.mapHeight; ++i) {
                for (j = 0; j < this.mapWidth; ++j) {
                    this.map[i][j].attrib = dis.read();
                    if (this.map[i][j].attrib >= 1 && this.map[i][j].attrib <= 9) {
                        this.keyFunc[this.map[i][j].attrib - 1][0] = i;
                        this.keyFunc[this.map[i][j].attrib - 1][1] = j;
                        ++keyFuncTic;
                    }
                    if (this.map[i][j].attrib < 20 || this.map[i][j].attrib > 23) continue;
                    this.mapStart[this.mapStartCount][0] = j;
                    this.mapStart[this.mapStartCount][1] = i;
                    ++this.mapStartCount;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("dddddddddddddddddd\u77fe");
        }
    }

    private void drawMap(Graphics g) {
        for (int i = 0; i < this.mapHeight; ++i) {
            block68: for (int j = 0; j < this.mapWidth; ++j) {
                this.map[i][j].x = this.startX + j * this.tileSize;
                this.map[i][j].y = this.startY + i * this.tileSize;
                if (this.map[i][j].img <= 9) {
                    g.drawImage(this.tileImg[this.map[i][j].img], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                    switch (this.map[i][j].img) {
                        case 0: {
                            if (base.playState != 64 || this.gameCount % 2 != 0) break;
                            g.drawImage(this.tileImg[1], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            break;
                        }
                        case 2: {
                            if (base.playState != 64 || this.gameCount % 2 != 0) break;
                            g.drawImage(this.tileImg[3], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                        }
                    }
                } else if (this.map[i][j].img >= 10 && this.map[i][j].img <= 18) {
                    g.drawImage(this.tileImg[this.map[i][j].img], this.startX + j * this.tileSize - 5, this.startY + i * this.tileSize - 5, 0);
                } else if (this.map[i][j].img <= 22) {
                    g.drawImage(this.tileImg[this.map[i][j].img], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                }
                block4 : switch (this.map[i][j].img) {
                    case 23: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 24: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 25: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 26: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 27: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 28: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 29: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 2: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 30: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 2: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 31: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 2: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 32: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break;
                            }
                            case 2: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                        continue block68;
                    }
                    case 33: {
                        switch (this.map[i][j].dir) {
                            case 0: {
                                g.drawImage(this.tileImg[19], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break block4;
                            }
                            case 1: {
                                g.drawImage(this.tileImg[22], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break block4;
                            }
                            case 2: {
                                g.drawImage(this.tileImg[20], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                                break block4;
                            }
                            case 3: {
                                g.drawImage(this.tileImg[21], this.startX + j * this.tileSize, this.startY + i * this.tileSize, 0);
                            }
                        }
                    }
                }
            }
        }
        if (base.playState == 64 && !cSndPlay._onPlaying) {
            this.playSound("/sound/movework", true);
        }
    }

    public void drawGame() {
        this.drawBg();
        this.drawGameUILife(this.missionCount, this.missionMax);
        this.drawDownUI();
        this.drawMap(base.offScreen);
        switch (base.playState) {
            case 60: {
                this.drawGameHelp(base.TheGame);
                break;
            }
            case 65: {
                base.cmn.drawDarkCurtain();
                this.drawSubMenuEdge(base.TheGame);
                this.drawMission(base.TheGame, this.MISSION_CONDITION[0], this.MISSION_TYPE[0], this.MISSION_CONDITION[1], this.MISSION_TYPE[1], this.MISSION_CONDITION[2], this.MISSION_TYPE[2]);
                break;
            }
            case 61: {
                base.cmn.drawDarkCurtain();
                this.drawSubMenuEdge(base.TheGame);
                this.drawPreMission(base.TheGame);
                break;
            }
            case 66: {
                this.drawGuest(base.offScreen);
                this.drawMissionComplete();
                break;
            }
            case 62: {
                this.processReady();
                break;
            }
            case 64: {
                this.drawGuest(base.offScreen);
                this.drawUsingItem();
                break;
            }
            case 68: {
                this.drawGuest(base.offScreen);
                this.drawClear();
                break;
            }
            case 69: {
                this.drawGuest(base.offScreen);
                this.drawFail();
                break;
            }
            case 70: {
                this.drawResult(base.TheGame, this.totalScore);
                break;
            }
            case 67: {
                this.drawGuest(base.offScreen);
                this.drawItemWindow();
                break;
            }
            case 83: {
                this.drawGameHelp(base.TheGame);
                break;
            }
            case 80: {
                this.drawSubMenu(base.TheGame, this.selectSubMenu);
                break;
            }
            case 100: {
                this.drawSub_111();
                break;
            }
            case 81: {
                this.drawGameRetry(base.TheGame);
                break;
            }
            case 82: {
                this.drawGameOption(base.TheGame);
                break;
            }
            case 71: 
            case 84: {
                this.drawStage50Clear();
            }
        }
    }

    class Guest {
        int idx;
        int state;
        int x;
        int y;
        int w;
        int h;
        int target;
        int dir;
        int speed;
        boolean start;
        boolean blockFlag;

        Guest() {
        }
    }

    class Tile {
        int img;
        int attrib;
        int dir;
        int x;
        int y;
        int dirTic;

        Tile() {
        }
    }
}

