/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class game5
extends game {
    boolean match = false;
    boolean firstCardSelected = false;
    boolean sameItemSelecting = false;
    boolean sameItemEmptyRock = false;
    boolean sameCardMatch = false;
    int burstIndex = 0;
    int origDrawX = 0;
    int origDrawY = 0;
    int firstCardX;
    int firstCardY;
    int secondCardX;
    int secondCardY;
    int bendCount = -1;
    int sameBlockCounter;
    int[][] sameBlocks = new int[2][50];
    int genBlockTimer = 0;
    int genBlockCounter = 0;
    int bendingPoint1X;
    int bendingPoint1Y;
    int bendingPoint2X;
    int bendingPoint2Y;
    int maxCardType = 3;
    int totalCardNumber;
    int remainedCardCounter;
    Image[] cardImg;
    Image[] cursorImg;
    Image[] efct1Img;
    Image[] bgImg;
    int qst1Remove180 = 0;
    int qst2RemoveRobot100 = 0;
    int qst3NoItem1100 = 0;
    int qst1StageRemove180 = 0;
    int qst2StageRemoveRobot100 = 0;
    int qst3StageNoItem1100 = 0;

    game5() {
        base.TheGame = 5;
        this.loadImage();
        this.loadGame(base.TheGame);
        this.setupStage(true);
    }

    private void loadImage() {
        this.cardImg = new Image[31];
        this.cursorImg = new Image[4];
        this.efct1Img = new Image[3];
        this.bgImg = new Image[3];
        try {
            for (base.col = 0; base.col < 31; ++base.col) {
                this.cardImg[base.col] = Image.createImage((String)("/img/pair/block" + base.col + ".png"));
            }
            for (base.col = 0; base.col < 4; ++base.col) {
                this.cursorImg[base.col] = Image.createImage((String)("/img/pair/cursor" + base.col + ".png"));
            }
            for (base.col = 0; base.col < 3; ++base.col) {
                this.bgImg[base.col] = Image.createImage((String)("/img/rotary/bg" + base.col + ".png"));
                this.efct1Img[base.col] = Image.createImage((String)("/img/effect/eff5_" + base.col + ".png"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setupStage(boolean reset) {
        this.loadStage50ClearImg();
        this.qst1StageRemove180 = 0;
        this.qst2StageRemoveRobot100 = 0;
        this.qst3StageNoItem1100 = 0;
        base.counter = 0;
        this.match = false;
        this.burstIndex = 0;
        this.bendCount = -1;
        this.secondCardX = 0;
        this.firstCardX = 0;
        this.stageScore = 0;
        this.loadMapData("/img/pair/stage" + this.gameStage + ".dat");
        this.remainTime = this.gameStage <= 10 ? (this.limitTime = this.remainedCardCounter * 26) : (this.gameStage <= 20 ? (this.limitTime = this.remainedCardCounter * 22) : (this.gameStage <= 30 ? (this.limitTime = this.remainedCardCounter * 20) : (this.limitTime = this.remainedCardCounter * 18)));
        if (this.gameStage < 42) {
            switch (this.gameStage / 3) {
                case 0: {
                    this.maxCardType = 3;
                    break;
                }
                case 1: {
                    this.maxCardType = 4;
                    break;
                }
                case 2: {
                    this.maxCardType = 5;
                    break;
                }
                case 3: {
                    this.maxCardType = 6;
                    break;
                }
                case 4: {
                    this.maxCardType = 7;
                    break;
                }
                case 5: {
                    this.maxCardType = 8;
                    break;
                }
                case 6: {
                    this.maxCardType = 8;
                    break;
                }
                case 7: {
                    this.maxCardType = 9;
                    break;
                }
                case 8: {
                    this.maxCardType = 9;
                    break;
                }
                case 9: {
                    this.maxCardType = 10;
                    break;
                }
                case 10: {
                    this.maxCardType = 11;
                    break;
                }
                case 11: {
                    this.maxCardType = 12;
                    break;
                }
                case 12: {
                    this.maxCardType = 13;
                    break;
                }
                case 13: {
                    this.maxCardType = 14;
                    break;
                }
                case 14: {
                    this.maxCardType = 15;
                }
            }
        } else {
            this.maxCardType = 15;
        }
        this.genBlockTimer = this.genBlockCounter = 200 - this.gameStage / 4 * 5;
        base.userX = base.width / 2;
        base.userY = base.height / 2;
        switch (base.width) {
            case 1: {
                this.origDrawX = 88;
                break;
            }
            case 2: {
                this.origDrawX = 77;
                break;
            }
            case 3: {
                this.origDrawX = 66;
                break;
            }
            case 4: {
                this.origDrawX = 55;
                break;
            }
            case 5: {
                this.origDrawX = 44;
                break;
            }
            case 6: {
                this.origDrawX = 33;
                break;
            }
            case 7: {
                this.origDrawX = 22;
                break;
            }
            case 8: {
                this.origDrawX = 11;
                break;
            }
            case 9: {
                this.origDrawX = 0;
            }
        }
        switch (base.height) {
            case 1: {
                this.origDrawY = base.yOffset + 133;
                break;
            }
            case 2: {
                this.origDrawY = base.yOffset + 122;
                break;
            }
            case 3: {
                this.origDrawY = base.yOffset + 101;
                break;
            }
            case 4: {
                this.origDrawY = base.yOffset + 90;
                break;
            }
            case 5: {
                this.origDrawY = base.yOffset + 79;
                break;
            }
            case 6: {
                this.origDrawY = base.yOffset + 68;
                break;
            }
            case 7: {
                this.origDrawY = base.yOffset + 57;
                break;
            }
            case 8: {
                this.origDrawY = base.yOffset + 46;
                break;
            }
            case 9: {
                this.origDrawY = base.yOffset + 35;
                break;
            }
            case 10: {
                this.origDrawY = base.yOffset + 24;
            }
        }
        int[] shaker = new int[this.remainedCardCounter];
        for (base.col = 0; base.col < this.maxCardType; ++base.col) {
            int n = base.col + 1;
            shaker[base.col * 2 + 1] = n;
            shaker[base.col * 2] = n;
        }
        for (base.col = this.maxCardType; base.col < this.remainedCardCounter / 2; ++base.col) {
            int n = base.Random(1, this.maxCardType);
            shaker[base.col * 2 + 1] = n;
            shaker[base.col * 2] = n;
        }
        for (base.col = 0; base.col < this.remainedCardCounter; ++base.col) {
            int first = base.Random(0, this.remainedCardCounter - 1);
            int second = base.Random(0, this.remainedCardCounter - 1);
            int temp = shaker[first];
            shaker[first] = shaker[second];
            shaker[second] = temp;
        }
        int shakerIndex = 0;
        for (base.row = 1; base.row <= base.height; ++base.row) {
            for (base.col = 1; base.col <= base.width; ++base.col) {
                this.arena[base.row][base.col] = this.arena[base.row][base.col] == 1 ? shaker[shakerIndex++] : (this.arena[base.row][base.col] == 2 ? 30 : 0);
            }
        }
    }

    private void genNewBlock() {
        int nbCount;
        int nbx1 = base.Random(1, base.width - 1);
        int nby1 = base.Random(1, base.height - 1);
        int nbx2 = base.Random(1, base.width - 1);
        int nby2 = base.Random(1, base.height - 1);
        for (nbCount = 0; nbCount < 10 && (this.arena[nby1][nbx1] > 0 || this.arena[nby2][nbx2] > 0 || nbx1 == nbx2 && nby1 == nby2); ++nbCount) {
            nbx1 = base.Random(1, base.width - 1);
            nby1 = base.Random(1, base.height - 1);
            nbx2 = base.Random(1, base.width - 1);
            nby2 = base.Random(1, base.height - 1);
        }
        if (nbCount < 10) {
            int newBlock;
            int n = newBlock = base.Random(1, this.maxCardType);
            this.arena[nby2][nbx2] = n;
            this.arena[nby1][nbx1] = n;
            this.totalCardNumber += 2;
            this.remainedCardCounter += 2;
        }
    }

    void processKeyEvent(int key) {
        switch (base.playState) {
            case 60: {
                this.playHelpKeyProcess(key, base.TheGame);
                break;
            }
            case 61: {
                this.processPreMissionKeyEvent(key);
                break;
            }
            case 62: {
                this.processReadyKeyEvent(key);
                break;
            }
            case 64: {
                if (this.match) break;
                if (key == -3 || key == 52) {
                    base.userX = base.userX > 1 ? --base.userX : base.width;
                    this.playSound("/sound/gmove");
                }
                if (key == -4 || key == 54) {
                    base.userX = base.userX < base.width ? ++base.userX : 1;
                    this.playSound("/sound/gmove");
                }
                if (key == -1 || key == 50) {
                    base.userY = base.userY > 1 ? --base.userY : base.height;
                    this.playSound("/sound/gmove");
                }
                if (key == -2 || key == 56) {
                    base.userY = base.userY < base.height ? ++base.userY : 1;
                    this.playSound("/sound/gmove");
                }
                if (key == -5 || key == 53) {
                    if (this.sameItemSelecting) {
                        this.sameItemSelecting = false;
                        this.sameBurst(base.userX, base.userY);
                    } else if (this.firstCardX == 0) {
                        if (this.arena[base.userY][base.userX] > 0 && this.arena[base.userY][base.userX] < 30) {
                            this.firstCardX = base.userX;
                            this.firstCardY = base.userY;
                            this.firstCardSelected = true;
                            this.playSound("/sound/gselect");
                        }
                    } else if (this.firstCardX == base.userX && this.firstCardY == base.userY) {
                        this.firstCardX = 0;
                        this.firstCardSelected = false;
                        this.playSound("/sound/wrong");
                    } else if (!this.match && this.arena[base.userY][base.userX] > 0 && this.arena[base.userY][base.userX] < 30) {
                        this.secondCardX = base.userX;
                        this.secondCardY = base.userY;
                        if (this.arena[this.firstCardY][this.firstCardX] == this.arena[this.secondCardY][this.secondCardX]) {
                            this.checkConnected();
                            if (this.bendCount == 3) {
                                this.bendCount = -1;
                                this.secondCardX = 0;
                                this.firstCardX = 0;
                                this.playSound("/sound/wrong");
                            } else if (this.bendCount >= 0 && this.bendCount <= 2) {
                                this.match = true;
                                this.checkCardMission();
                                this.burstIndex = 1;
                                this.playSound("/sound/disappear");
                                this.stageScore += 5 + (this.gameStage - 1) / 6;
                            }
                        } else {
                            this.secondCardX = 0;
                            this.firstCardX = 0;
                            this.firstCardSelected = false;
                            this.playSound("/sound/wrong");
                        }
                    } else {
                        this.secondCardX = 0;
                        this.firstCardX = 0;
                        this.firstCardSelected = false;
                        this.playSound("/sound/wrong");
                    }
                }
                if (key == -6) {
                    this.playSound("/sound/popup");
                    this.selectSubMenu = 1;
                    base.playState = 80;
                }
                if (key == 42) {
                    this.playSound("/sound/popup");
                    base.selectedItem = 1;
                    base.playState = 67;
                }
                if (key != 35) break;
                this.playSound("/sound/popup");
                base.counter = 0;
                this.readQuestExplanation(base.TheGame, 6);
                base.playState = 65;
                break;
            }
            case 65: {
                this.processMissionKeyEvent(key);
                break;
            }
            case 67: {
                this.itemKeyProcess(key);
                if (!this.usingItem) break;
                this.qst3NoItem1100 = 0;
                this.qst3StageNoItem1100 = 0;
                break;
            }
            case 68: {
                this.workCheatKey(key);
                if (base.counter > 10 && (key == -5 || key == 53)) {
                    this.qst1Remove180 += this.qst1StageRemove180;
                    this.qst2RemoveRobot100 += this.qst2StageRemoveRobot100;
                    this.qst3NoItem1100 += this.qst3StageNoItem1100;
                }
                this.processClearKeyEvent(key);
                break;
            }
            case 71: {
                this.processStage50ClearKeyEvent(key);
                break;
            }
            case 69: {
                this.workCheatKey(key);
                if (key == -5 || key == 53) {
                    if (base.menuDepth == 1) {
                        if (base.yesNo == 1) {
                            if (common.ITEMS[13] < 5) {
                                base.menuDepth = 2;
                            }
                        } else {
                            this.qst1Remove180 = 0;
                            this.qst2RemoveRobot100 = 0;
                            this.qst3NoItem1100 = 0;
                        }
                    } else {
                        this.qst1Remove180 = 0;
                        this.qst2RemoveRobot100 = 0;
                        this.qst3NoItem1100 = 0;
                    }
                }
                this.processFailKeyEvent(key);
                break;
            }
            case 70: {
                this.processResultKeyEvent(key);
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                this.processSubMenuKeyEvent(key, base.TheGame);
                break;
            }
            case 100: {
                this.processSubMenuKeyEvent_111(key, base.TheGame);
            }
        }
    }

    private void checkConnected() {
        int i;
        int i2;
        int step;
        int gap;
        this.bendCount = 0;
        if (this.firstCardY == this.secondCardY) {
            gap = Math.abs(this.firstCardX - this.secondCardX);
            int startX = Math.min(this.firstCardX, this.secondCardX);
            if (gap == 1) {
                this.bendCount = 0;
                return;
            }
            for (step = 1; step < gap && this.arena[this.firstCardY][startX + step] == 0; ++step) {
            }
            if (step == gap) {
                this.bendCount = 0;
                return;
            }
        }
        if (this.firstCardX == this.secondCardX) {
            gap = Math.abs(this.firstCardY - this.secondCardY);
            int startY = Math.min(this.firstCardY, this.secondCardY);
            if (gap == 1) {
                this.bendCount = 0;
                return;
            }
            for (step = 1; step < gap && this.arena[startY + step][this.firstCardX] == 0; ++step) {
            }
            if (step == gap) {
                this.bendCount = 0;
                return;
            }
        }
        this.bendCount = 1;
        if (Math.abs(this.firstCardX - this.secondCardX) > 0 && Math.abs(this.firstCardY - this.secondCardY) > 0) {
            if (this.firstCardX < this.secondCardX && this.firstCardY < this.secondCardY) {
                if (this.checkClearX(this.firstCardX + 1, this.secondCardX, this.firstCardY) && this.checkClearY(this.firstCardY, this.secondCardY - 1, this.secondCardX)) {
                    this.bendingPoint1X = this.secondCardX;
                    this.bendingPoint1Y = this.firstCardY;
                    return;
                }
                if (this.checkClearY(this.firstCardY + 1, this.secondCardY, this.firstCardX) && this.checkClearX(this.firstCardX, this.secondCardX - 1, this.secondCardY)) {
                    this.bendingPoint1X = this.firstCardX;
                    this.bendingPoint1Y = this.secondCardY;
                    return;
                }
            } else if (this.firstCardX < this.secondCardX && this.firstCardY > this.secondCardY) {
                if (this.checkClearX(this.firstCardX + 1, this.secondCardX, this.firstCardY) && this.checkClearY(this.firstCardY, this.secondCardY + 1, this.secondCardX)) {
                    this.bendingPoint1X = this.secondCardX;
                    this.bendingPoint1Y = this.firstCardY;
                    return;
                }
                if (this.checkClearY(this.firstCardY - 1, this.secondCardY, this.firstCardX) && this.checkClearX(this.firstCardX, this.secondCardX - 1, this.secondCardY)) {
                    this.bendingPoint1X = this.firstCardX;
                    this.bendingPoint1Y = this.secondCardY;
                    return;
                }
            } else if (this.firstCardX > this.secondCardX && this.firstCardY > this.secondCardY) {
                if (this.checkClearX(this.secondCardX, this.firstCardX - 1, this.firstCardY) && this.checkClearY(this.firstCardY, this.secondCardY + 1, this.secondCardX)) {
                    this.bendingPoint1X = this.secondCardX;
                    this.bendingPoint1Y = this.firstCardY;
                    return;
                }
                if (this.checkClearY(this.firstCardY - 1, this.secondCardY, this.firstCardX) && this.checkClearX(this.secondCardX + 1, this.firstCardX, this.secondCardY)) {
                    this.bendingPoint1X = this.firstCardX;
                    this.bendingPoint1Y = this.secondCardY;
                    return;
                }
            } else {
                if (this.checkClearX(this.secondCardX + 1, this.firstCardX, this.secondCardY) && this.checkClearY(this.secondCardY, this.firstCardY + 1, this.firstCardX)) {
                    this.bendingPoint1X = this.firstCardX;
                    this.bendingPoint1Y = this.secondCardY;
                    return;
                }
                if (this.checkClearY(this.secondCardY - 1, this.firstCardY, this.secondCardX) && this.checkClearX(this.secondCardX, this.firstCardX - 1, this.firstCardY)) {
                    this.bendingPoint1X = this.secondCardX;
                    this.bendingPoint1Y = this.firstCardY;
                    return;
                }
            }
        }
        this.bendCount = 2;
        int xLeft = Math.min(this.firstCardX, this.secondCardX);
        int xRight = Math.max(this.firstCardX, this.secondCardX);
        for (i2 = (base.height + 1) / 2; i2 >= 0; --i2) {
            if (!this.checkClearX(xLeft, xRight, i2) || !this.checkClearY(i2, this.firstCardY > i2 ? this.firstCardY - 1 : this.firstCardY + 1, this.firstCardX) || !this.checkClearY(i2, this.secondCardY > i2 ? this.secondCardY - 1 : this.secondCardY + 1, this.secondCardX)) continue;
            this.bendingPoint1X = this.firstCardX;
            this.bendingPoint1Y = i2;
            this.bendingPoint2X = this.secondCardX;
            this.bendingPoint2Y = i2;
            return;
        }
        for (i2 = (base.height + 1) / 2; i2 <= base.height + 1; ++i2) {
            if (!this.checkClearX(xLeft, xRight, i2) || !this.checkClearY(i2, this.firstCardY > i2 ? this.firstCardY - 1 : this.firstCardY + 1, this.firstCardX) || !this.checkClearY(i2, this.secondCardY > i2 ? this.secondCardY - 1 : this.secondCardY + 1, this.secondCardX)) continue;
            this.bendingPoint1X = this.firstCardX;
            this.bendingPoint1Y = i2;
            this.bendingPoint2X = this.secondCardX;
            this.bendingPoint2Y = i2;
            return;
        }
        int yTop = Math.min(this.firstCardY, this.secondCardY);
        int yBottom = Math.max(this.firstCardY, this.secondCardY);
        for (i = (base.width + 1) / 2; i >= 0; --i) {
            if (!this.checkClearY(yTop, yBottom, i) || !this.checkClearX(i, this.firstCardX > i ? this.firstCardX - 1 : this.firstCardX + 1, this.firstCardY) || !this.checkClearX(i, this.secondCardX > i ? this.secondCardX - 1 : this.secondCardX + 1, this.secondCardY)) continue;
            this.bendingPoint1X = i;
            this.bendingPoint1Y = this.firstCardY;
            this.bendingPoint2X = i;
            this.bendingPoint2Y = this.secondCardY;
            return;
        }
        for (i = (base.width + 1) / 2; i <= base.width + 1; ++i) {
            if (!this.checkClearY(yTop, yBottom, i) || !this.checkClearX(i, this.firstCardX > i ? this.firstCardX - 1 : this.firstCardX + 1, this.firstCardY) || !this.checkClearX(i, this.secondCardX > i ? this.secondCardX - 1 : this.secondCardX + 1, this.secondCardY)) continue;
            this.bendingPoint1X = i;
            this.bendingPoint1Y = this.firstCardY;
            this.bendingPoint2X = i;
            this.bendingPoint2Y = this.secondCardY;
            return;
        }
        this.bendCount = 3;
    }

    private boolean checkClearX(int sx, int tx, int y) {
        int start = Math.min(sx, tx);
        int end = Math.max(sx, tx);
        for (int i = start; i < end + 1; ++i) {
            if (this.arena[y][i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkClearY(int sy, int ty, int x) {
        int start = Math.min(sy, ty);
        int end = Math.max(sy, ty);
        for (int i = start; i < end + 1; ++i) {
            if (this.arena[i][x] == 0) continue;
            return false;
        }
        return true;
    }

    private void checkCardMission() {
        if (!base.cmn.checkMission(base.TheGame, 1)) {
            this.qst1StageRemove180 += 2;
            if (this.qst1Remove180 + this.qst1StageRemove180 >= 180) {
                this.completedMission = 1;
                base.cmn.setMission(base.TheGame, 1);
                common.ITEMS[13] = common.ITEMS[13] + 200;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
        if (!base.cmn.checkMission(base.TheGame, 2) && this.arena[this.firstCardY][this.firstCardX] == 1) {
            this.qst2StageRemoveRobot100 += 2;
            if (this.qst2RemoveRobot100 + this.qst2StageRemoveRobot100 >= 100) {
                this.completedMission = 2;
                base.cmn.setMission(base.TheGame, 2);
                common.ITEMS[13] = common.ITEMS[13] + 300;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
        if (!base.cmn.checkMission(base.TheGame, 3)) {
            this.qst3StageNoItem1100 += 2;
            if (this.qst3NoItem1100 + this.qst3StageNoItem1100 >= 1100) {
                this.completedMission = 3;
                base.cmn.setMission(base.TheGame, 3);
                common.ITEMS[13] = common.ITEMS[13] + 500;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
    }

    private void checkCardMissionUsingItem() {
        if (!base.cmn.checkMission(base.TheGame, 1)) {
            this.qst1StageRemove180 += this.sameBlockCounter;
            if (this.qst1Remove180 + this.qst1StageRemove180 >= 180) {
                this.completedMission = 1;
                base.cmn.setMission(base.TheGame, 1);
                common.ITEMS[13] = common.ITEMS[13] + 200;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
        if (!base.cmn.checkMission(base.TheGame, 2)) {
            for (int scui = 0; scui < this.sameBlockCounter; ++scui) {
                if (this.arena[this.sameBlocks[1][scui]][this.sameBlocks[0][scui]] == 1) {
                    ++this.qst2StageRemoveRobot100;
                }
                if (this.qst2RemoveRobot100 + this.qst2StageRemoveRobot100 < 100) continue;
                this.completedMission = 2;
                base.cmn.setMission(base.TheGame, 2);
                common.ITEMS[13] = common.ITEMS[13] + 300;
                base.cmn.saveItemData();
                base.counter = 0;
                base.playState = 66;
            }
        }
    }

    public void workItem7SRemove() {
        common.ITEMS[6] = common.ITEMS[6] - 1;
        base.cmn.saveItemData();
        this.itemTimers[7] = 10000;
        this.sameItemSelecting = true;
        base.playState = 64;
    }

    private void clearArenaSameBlocks() {
        for (int idx = 0; idx < this.sameBlockCounter; ++idx) {
            int x = this.sameBlocks[0][idx];
            int y = this.sameBlocks[1][idx];
            this.arena[y][x] = 0;
        }
    }

    private void sameBurst(int sbx, int sby) {
        int target = this.arena[sby][sbx];
        if (target == 0 || target == 30) {
            this.sameBlocks[0][0] = sbx;
            this.sameBlocks[1][0] = sby;
            this.sameBlockCounter = 1;
            this.sameItemEmptyRock = true;
        } else {
            this.sameBlockCounter = 0;
            for (base.row = 1; base.row <= base.height; ++base.row) {
                for (base.col = 1; base.col <= base.width; ++base.col) {
                    if (this.arena[base.row][base.col] != target) continue;
                    this.sameBlocks[0][this.sameBlockCounter] = base.col;
                    this.sameBlocks[1][this.sameBlockCounter] = base.row;
                    ++this.sameBlockCounter;
                }
            }
            System.out.println(" \u5272\u4ffa\u554a \u78d0\u7624\u7ef0\u82ad\u5177 ? " + this.sameBlockCounter);
            this.stageScore += this.sameBlockCounter * (5 + (this.gameStage - 1) / 6);
        }
        this.usingItem = false;
        this.itemTimers[7] = 0;
        this.burstIndex = 1;
        this.sameCardMatch = true;
        this.playSound("/sound/disappear");
    }

    public void playGame() {
        ++base.counter;
        if (base.playState == 64) {
            if (this.itemTimers[3] == 0) {
                if (this.itemTimers[2] == 0) {
                    --this.genBlockCounter;
                    if (this.genBlockCounter <= 0) {
                        this.genBlockCounter = this.genBlockTimer;
                        this.genNewBlock();
                    }
                    if (this.remainTime > 0) {
                        --this.remainTime;
                    } else {
                        this.playSound("/sound/fail");
                        base.playState = 69;
                    }
                }
            } else if (base.counter % 2 == 0) {
                --this.genBlockCounter;
                if (this.genBlockCounter <= 0) {
                    this.genBlockCounter = this.genBlockTimer;
                    this.genNewBlock();
                }
                if (this.remainTime > 0) {
                    --this.remainTime;
                } else {
                    this.playSound("/sound/fail");
                    base.playState = 69;
                }
            }
        }
    }

    public void drawGame() {
        this.drawBg();
        this.drawGameUITime(this.totalCardNumber - this.remainedCardCounter, this.totalCardNumber);
        this.drawDownUI();
        switch (base.playState) {
            case 60: {
                this.drawGameHelp(base.TheGame);
                break;
            }
            case 61: {
                this.drawPreMission(base.TheGame);
                break;
            }
            case 62: {
                this.drawReady();
                this.processReady();
                break;
            }
            case 64: {
                this.drawPlaying();
                if (this.match && this.burstIndex < 3) {
                    this.drawCardLink();
                }
                this.drawBurst();
                this.drawSameCardBurst();
                this.drawUsingItem();
                this.drawSmallNumbers(this.remainedCardCounter, 22, 48);
                break;
            }
            case 67: {
                this.drawPlaying();
                this.drawItemWindow();
                break;
            }
            case 65: {
                this.drawMission(base.TheGame, 180, this.qst1Remove180 + this.qst1StageRemove180, 100, this.qst2RemoveRobot100 + this.qst2StageRemoveRobot100, 1100, this.qst3NoItem1100 + this.qst3StageNoItem1100);
                break;
            }
            case 66: {
                this.drawPlaying();
                this.drawMissionComplete();
                break;
            }
            case 68: {
                this.drawPlaying();
                this.drawClear();
                break;
            }
            case 71: {
                this.drawPlaying();
                this.drawStage50Clear();
                break;
            }
            case 69: {
                this.drawPlaying();
                this.drawFail();
                break;
            }
            case 70: {
                this.drawResult(base.TheGame, this.totalScore);
                break;
            }
            case 80: {
                this.drawSubMenu(base.TheGame, this.selectSubMenu);
                break;
            }
            case 100: {
                this.drawSub_111();
                break;
            }
            case 81: {
                this.drawGameRetry(base.TheGame);
                break;
            }
            case 83: {
                this.drawGameHelp(base.TheGame);
                break;
            }
            case 82: {
                this.drawGameOption(base.TheGame);
            }
        }
    }

    private void drawPlaying() {
        base.offScreen.drawImage(this.bgImg[1], 20, base.yOffset + 66, 0);
        base.offScreen.drawImage(this.bgImg[1], 110, base.yOffset + 48, 0);
        base.offScreen.drawImage(this.bgImg[0], 143, base.yOffset + 92, 0);
        base.offScreen.drawImage(this.bgImg[0], 95, base.yOffset + 132, 0);
        base.offScreen.drawImage(this.bgImg[0], 176, base.yOffset + 150, 0);
        base.offScreen.drawImage(this.bgImg[0], 22, base.yOffset + 165, 0);
        base.offScreen.drawImage(this.bgImg[2], 28, base.yOffset + 208, 0);
        base.offScreen.drawImage(this.bgImg[2], 140, base.yOffset + 208, 0);
        for (base.row = 1; base.row <= base.height; ++base.row) {
            for (base.col = 1; base.col <= base.width; ++base.col) {
                int val = this.arena[base.row][base.col];
                if (val > 0 && val < 30) {
                    base.offScreen.drawImage(this.cardImg[(val - 1) * 2 + 1], this.origDrawX + base.col * 22, this.origDrawY + base.row * 22, 0);
                    continue;
                }
                if (val != 30) continue;
                base.offScreen.drawImage(this.cardImg[30], this.origDrawX + base.col * 22, this.origDrawY + base.row * 22, 0);
            }
        }
        if (this.arena[base.userY][base.userX] > 0 && this.arena[base.userY][base.userX] < 30) {
            base.offScreen.drawImage(this.cardImg[(this.arena[base.userY][base.userX] - 1) * 2], this.origDrawX + base.userX * 22, this.origDrawY + base.userY * 22, 0);
        }
        if (this.firstCardX > 0) {
            base.offScreen.drawImage(this.cardImg[(this.arena[this.firstCardY][this.firstCardX] - 1) * 2], this.origDrawX + this.firstCardX * 22, this.origDrawY + this.firstCardY * 22, 0);
            base.offScreen.drawImage(this.cursorImg[2], this.origDrawX + this.firstCardX * 22 - 2, this.origDrawY + this.firstCardY * 22 - 2, 0);
        }
        if (base.playState == 64 && !this.match) {
            if (this.sameItemSelecting) {
                if (base.counter % 6 < 4) {
                    base.offScreen.drawImage(this.cursorImg[3], this.origDrawX + base.userX * 22 - 2, this.origDrawY + base.userY * 22 - 2, 0);
                }
            } else if (base.counter % 6 < 3) {
                base.offScreen.drawImage(this.cursorImg[0], this.origDrawX + base.userX * 22 - 3, this.origDrawY + base.userY * 22 - 3, 0);
            } else {
                base.offScreen.drawImage(this.cursorImg[1], this.origDrawX + base.userX * 22 - 1, this.origDrawY + base.userY * 22 - 1, 0);
            }
        }
    }

    private void drawBurst() {
        if (this.match) {
            switch (this.burstIndex) {
                case 1: {
                    base.offScreen.drawImage(this.efct1Img[0], this.origDrawX + this.firstCardX * 22 - 2, this.origDrawY + this.firstCardY * 22 - 2, 0);
                    base.offScreen.drawImage(this.efct1Img[0], this.origDrawX + this.secondCardX * 22 - 2, this.origDrawY + this.secondCardY * 22 - 2, 0);
                    ++this.burstIndex;
                    break;
                }
                case 2: {
                    base.offScreen.drawImage(this.efct1Img[1], this.origDrawX + this.firstCardX * 22 - 5, this.origDrawY + this.firstCardY * 22 - 3, 0);
                    base.offScreen.drawImage(this.efct1Img[1], this.origDrawX + this.secondCardX * 22 - 5, this.origDrawY + this.secondCardY * 22 - 3, 0);
                    ++this.burstIndex;
                    break;
                }
                case 3: {
                    base.offScreen.drawImage(this.efct1Img[2], this.origDrawX + this.firstCardX * 22 - 7, this.origDrawY + this.firstCardY * 22 - 6, 0);
                    base.offScreen.drawImage(this.efct1Img[2], this.origDrawX + this.secondCardX * 22 - 7, this.origDrawY + this.secondCardY * 22 - 6, 0);
                    ++this.burstIndex;
                    break;
                }
                case 4: {
                    this.match = false;
                    this.burstIndex = 0;
                    this.remainedCardCounter -= 2;
                    if (this.remainedCardCounter == 0) {
                        this.playSound("/sound/success");
                        base.counter = 0;
                        base.playState = 68;
                        break;
                    }
                    this.arena[this.firstCardY][this.firstCardX] = 0;
                    this.arena[this.secondCardY][this.secondCardX] = 0;
                    this.secondCardX = 0;
                    this.firstCardX = 0;
                    this.bendCount = -1;
                }
            }
        }
    }

    private void drawSameCardBurst() {
        if (this.sameCardMatch) {
            switch (this.burstIndex) {
                case 1: {
                    for (int scui = 0; scui < this.sameBlockCounter; ++scui) {
                        base.offScreen.drawImage(this.efct1Img[0], this.origDrawX + this.sameBlocks[0][scui] * 22 - 2, this.origDrawY + this.sameBlocks[1][scui] * 22 - 2, 0);
                    }
                    ++this.burstIndex;
                    break;
                }
                case 2: {
                    for (int scui = 0; scui < this.sameBlockCounter; ++scui) {
                        base.offScreen.drawImage(this.efct1Img[1], this.origDrawX + this.sameBlocks[0][scui] * 22 - 5, this.origDrawY + this.sameBlocks[1][scui] * 22 - 3, 0);
                    }
                    ++this.burstIndex;
                    break;
                }
                case 3: {
                    for (int scui = 0; scui < this.sameBlockCounter; ++scui) {
                        base.offScreen.drawImage(this.efct1Img[2], this.origDrawX + this.sameBlocks[0][scui] * 22 - 7, this.origDrawY + this.sameBlocks[1][scui] * 22 - 6, 0);
                    }
                    ++this.burstIndex;
                    break;
                }
                case 4: {
                    this.sameCardMatch = false;
                    this.burstIndex = 0;
                    if (this.sameItemEmptyRock) {
                        this.sameItemEmptyRock = false;
                        break;
                    }
                    this.remainedCardCounter -= this.sameBlockCounter;
                    this.qst3NoItem1100 = 0;
                    this.qst3StageNoItem1100 = 0;
                    if (this.remainedCardCounter <= 0) {
                        this.playSound("/sound/success");
                        base.counter = 0;
                        base.playState = 68;
                        break;
                    }
                    this.checkCardMissionUsingItem();
                    this.clearArenaSameBlocks();
                    this.secondCardX = 0;
                    this.firstCardX = 0;
                    this.firstCardSelected = false;
                    this.bendCount = -1;
                }
            }
        }
    }

    private void drawCardLink() {
        base.offScreen.setColor(0xFF0000);
        switch (this.bendCount) {
            case 0: {
                this.drawLineCard2Card(this.firstCardX, this.firstCardY, this.secondCardX, this.secondCardY);
                break;
            }
            case 1: {
                this.drawLineBp2Card(this.bendingPoint1X, this.bendingPoint1Y, this.firstCardX, this.firstCardY);
                this.drawLineBp2Card(this.bendingPoint1X, this.bendingPoint1Y, this.secondCardX, this.secondCardY);
                break;
            }
            case 2: {
                this.drawLineBp2Card(this.bendingPoint1X, this.bendingPoint1Y, this.firstCardX, this.firstCardY);
                this.drawLineBp2Bp(this.bendingPoint1X, this.bendingPoint1Y, this.bendingPoint2X, this.bendingPoint2Y);
                this.drawLineBp2Card(this.bendingPoint2X, this.bendingPoint2Y, this.secondCardX, this.secondCardY);
            }
        }
    }

    private void drawLineCard2Card(int c1x, int c1y, int c2x, int c2y) {
        if (c1x == c2x) {
            int gap = Math.abs(c1y - c2y);
            if (gap > 1) {
                if (c1y > c2y) {
                    base.offScreen.fillRect(this.origDrawX + c1x * 22 + 9, this.origDrawY + c2y * 22 + 22, 4, (gap - 1) * 22);
                } else {
                    base.offScreen.fillRect(this.origDrawX + c1x * 22 + 9, this.origDrawY + c1y * 22 + 22, 4, (gap - 1) * 22);
                }
            }
        } else {
            int gap = Math.abs(c1x - c2x);
            if (gap > 1) {
                if (c1x > c2x) {
                    base.offScreen.fillRect(this.origDrawX + c2x * 22 + 22, this.origDrawY + c1y * 22 + 9, (gap - 1) * 22, 4);
                } else {
                    base.offScreen.fillRect(this.origDrawX + c1x * 22 + 22, this.origDrawY + c1y * 22 + 9, (gap - 1) * 22, 4);
                }
            }
        }
    }

    private void drawLineBp2Card(int bx, int by, int cx, int cy) {
        if (bx == cx) {
            int gap = Math.abs(by - cy);
            if (by > cy) {
                base.offScreen.fillRect(this.origDrawX + bx * 22 + 9, this.origDrawY + cy * 22 + 22, 4, (gap - 1) * 22 + 9 + 4);
            } else {
                base.offScreen.fillRect(this.origDrawX + bx * 22 + 9, this.origDrawY + by * 22 + 9, 4, (gap - 1) * 22 + 9 + 4);
            }
        } else {
            int gap = Math.abs(bx - cx);
            if (bx > cx) {
                base.offScreen.fillRect(this.origDrawX + cx * 22 + 22, this.origDrawY + by * 22 + 9, (gap - 1) * 22 + 9 + 4, 4);
            } else {
                base.offScreen.fillRect(this.origDrawX + bx * 22 + 9, this.origDrawY + by * 22 + 9, (gap - 1) * 22 + 9 + 4, 4);
            }
        }
    }

    private void drawLineBp2Bp(int b1x, int b1y, int b2x, int b2y) {
        if (b1x == b2x) {
            int gap = Math.abs(b1y - b2y);
            if (b1y > b2y) {
                base.offScreen.fillRect(this.origDrawX + b1x * 22 + 9, this.origDrawY + b2y * 22 + 9, 4, (gap - 1) * 22 + 18 + 8);
            } else {
                base.offScreen.fillRect(this.origDrawX + b1x * 22 + 9, this.origDrawY + b1y * 22 + 9, 4, (gap - 1) * 22 + 18 + 8);
            }
        } else {
            int gap = Math.abs(b1x - b2x);
            if (b1x > b2x) {
                base.offScreen.fillRect(this.origDrawX + b2x * 22 + 9, this.origDrawY + b1y * 22 + 9, (gap - 1) * 22 + 18 + 8, 4);
            } else {
                base.offScreen.fillRect(this.origDrawX + b1x * 22 + 9, this.origDrawY + b1y * 22 + 9, (gap - 1) * 22 + 18 + 8, 4);
            }
        }
    }

    public void loadMapData(String srcFile) {
        try {
            DataInputStream input = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(srcFile));
            base.width = input.readByte();
            base.height = input.readByte();
            this.remainedCardCounter = 0;
            for (base.row = 1; base.row <= base.height; ++base.row) {
                for (base.col = 1; base.col <= base.width; ++base.col) {
                    this.arena[base.row][base.col] = input.readByte();
                    if (this.arena[base.row][base.col] != 1) continue;
                    ++this.remainedCardCounter;
                }
            }
            this.totalCardNumber = this.remainedCardCounter;
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

