/*
 * Decompiled with CFR 0.152.
 */
package SAF_Core;

import SAF_Application.Application;
import SAF_Core.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class C
extends Canvas {
    public static final String N = "";
    private static final String CONFIG_FILE_NAME = "k.txt";
    private static final int CONFIG_AUTO_PAUSE_AFTER_TIME_MS = 2000;
    public static final int SCREEN_WIDTH = C.getScreenWidth();
    public static final int SCREEN_HEIGHT = C.getScreenHeight();
    private static C c;
    public static Canvas canvas;
    private static MIDlet midlet;
    private static Display display;
    private MainThread mainThread;
    public static Sound sound;
    public static Application app;
    public static boolean app_isRunning;
    public static boolean app_isActive;
    private static boolean app_isFirstPassAfterResume;
    public static boolean app_enablePauseWhenReady;
    private static boolean app_isAutoPauseSuspended;
    private static boolean app_isPauseSuspended;
    private static boolean app_isSoundSuspendedAfterPause;
    public static long time_Elapsed;
    public static int time_LastFrame;
    private static boolean control_isSoftsClear;
    private static boolean control_isAutoPause;
    private static boolean control_isDoublePixel;
    private static boolean control_isKeyNumericAction;
    private static boolean control_isKeyNumericBias;
    private static String linkRequest;
    private static RecordStore recordStore;
    public int currentState;
    public boolean wasLandscape = false;
    public boolean returnToInit = false;
    private static int action;
    static int[] keyCodes;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_DOWN = 2;
    public static final int ACTION_LEFT = 4;
    public static final int ACTION_RIGHT = 8;
    public static final int ACTION_FIRE = 16;
    public static final int ACTION_FIRE2 = 32;
    public static final int ACTION_SOFT1 = 64;
    public static final int ACTION_SOFT2 = 128;
    public static final int ACTION_CANCEL = 256;
    public static final int ACTION_BACK = 512;
    public static final int ACTION_POUND = 1024;
    public static final int ACTION_STAR = 2048;
    public static final int ACTION_0 = 4096;
    public static final int K_NONE = 0;
    public static final int K_LEFT = 1;
    public static final int K_RIGHT = 2;
    public static final int K_UP = 3;
    public static final int K_DOWN = 4;
    public static final int K_FIRE = 5;
    public static final int K_1 = 6;
    public static final int K_2 = 7;
    public static final int K_3 = 8;
    public static final int K_4 = 9;
    public static final int K_5 = 10;
    public static final int K_6 = 11;
    public static final int K_7 = 12;
    public static final int K_8 = 13;
    public static final int K_9 = 14;
    public static final int K_0 = 15;
    public static final int K_SOFT1 = 16;
    public static final int K_SOFT2 = 17;
    public static final int K_POUND = 18;
    public static final int K_STAR = 19;
    public static final int K_BACK = 20;
    public static final int K_CANCEL = 21;
    private static int keyCodeLastPressed;
    private static int keyCodeLastReleased;
    private static int action_LastPressed;
    private static int action_LastReleased;
    private static boolean isKeyChanged;
    private static final int VIBRA_DEFAULT_TIME_MS = 300;
    private static boolean vibra_IsEnabled;
    private static final boolean VIBRA_IS_AVAILABLE = true;

    public C(MIDlet mIDlet) {
        c = this;
        C.setFullScreen();
        canvas = this;
        midlet = mIDlet;
        display = null;
    }

    public void launch(Display display) {
        C.display = display;
        this.configInit();
        C.keyInitDefault();
        C.keyInit(midlet, CONFIG_FILE_NAME);
        sound = Sound.getSingleton();
        sound.init(midlet, (byte)10, (byte)1);
        this.mainThread = new MainThread();
        this.mainThread.start();
    }

    private void configInit() {
        control_isSoftsClear = false;
        control_isAutoPause = false;
        control_isDoublePixel = false;
        control_isKeyNumericAction = true;
        control_isKeyNumericBias = true;
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        if (app != null) {
            app.paint(graphics);
        }
    }

    protected void showNotify() {
        if (display != null) {
            C.resume();
        }
    }

    protected void hideNotify() {
        C.pause();
    }

    public static void autoPauseEnable() {
        app_isAutoPauseSuspended = false;
    }

    public static void autoPauseDisable() {
        app_isAutoPauseSuspended = true;
    }

    public static void pause() {
        if (!app_isActive || app_isPauseSuspended) {
            return;
        }
        app_isActive = false;
        app_isFirstPassAfterResume = true;
        sound.stop();
        if (app != null) {
            app.pause();
        }
        C.keyClear();
    }

    public static void pauseEnable() {
        if (canvas != null && canvas.isShown()) {
            app_enablePauseWhenReady = false;
            app_isPauseSuspended = false;
        } else {
            app_enablePauseWhenReady = true;
        }
    }

    public static void pauseDisable() {
        app_isPauseSuspended = true;
    }

    public static void resume() {
        C.keyClear();
        if (app_isActive) {
            return;
        }
        app_isActive = true;
        if (!app_isPauseSuspended) {
            sound.stop();
            app_isSoundSuspendedAfterPause = true;
        }
    }

    public static boolean isDoublePixel() {
        return control_isDoublePixel;
    }

    public static int twiceOnDoublePix() {
        return 1;
    }

    public static boolean isSoftsClear() {
        return control_isSoftsClear;
    }

    public static void gc() {
        System.gc();
    }

    public static void sleep(int n) {
        try {
            C.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleepTo(int n) {
        if (time_LastFrame < n) {
            try {
                C.sleep(n - time_LastFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Canvas getCanvas() {
        return canvas;
    }

    public static MIDlet getMidlet() {
        return midlet;
    }

    public static void setFullScreen() {
        c.setFullScreenMode(true);
    }

    public static void repaintScreen() {
        C.repaintDoubleBuffer();
        c.repaint();
        c.serviceRepaints();
    }

    private static void repaintDoubleBuffer() {
    }

    public static void setLinkRequest(String string) {
        linkRequest = string;
    }

    public static String getLinkRequest() {
        return linkRequest;
    }

    public static void err(String string, String string2) {
    }

    public static void err(String string, String string2, Exception exception) {
    }

    public static void out(String string, String string2) {
    }

    public static void out(String string, String string2, Exception exception) {
    }

    public static int getAction() {
        return action;
    }

    public static void setAction(int n) {
        action = n;
    }

    public static boolean getAction(int n) {
        return (action & n) == n;
    }

    public static int getActionKey(int n) {
        app.musicResumeAfterPause();
        if (Math.abs(n) == Math.abs(keyCodes[16])) {
            return 64;
        }
        if (Math.abs(n) == Math.abs(keyCodes[17])) {
            return 128;
        }
        if (control_isKeyNumericAction) {
            if (Math.abs(n) == Math.abs(keyCodes[5]) || Math.abs(n) == Math.abs(keyCodes[10]) || n == 53) {
                return 16;
            }
            if (Math.abs(n) == Math.abs(keyCodes[3]) || Math.abs(n) == Math.abs(keyCodes[7]) || n == 50) {
                return 1;
            }
            if (Math.abs(n) == Math.abs(keyCodes[4]) || Math.abs(n) == Math.abs(keyCodes[13]) || n == 56) {
                return 2;
            }
            if (Math.abs(n) == Math.abs(keyCodes[1]) || Math.abs(n) == Math.abs(keyCodes[9]) || n == 52) {
                return 4;
            }
            if (Math.abs(n) == Math.abs(keyCodes[2]) || Math.abs(n) == Math.abs(keyCodes[11]) || n == 54) {
                return 8;
            }
            if (control_isKeyNumericBias) {
                // empty if block
            }
        } else {
            if (Math.abs(n) == Math.abs(keyCodes[5])) {
                return 16;
            }
            if (Math.abs(n) == Math.abs(keyCodes[3])) {
                return 1;
            }
            if (Math.abs(n) == Math.abs(keyCodes[4])) {
                return 2;
            }
            if (Math.abs(n) == Math.abs(keyCodes[1])) {
                return 4;
            }
            if (Math.abs(n) == Math.abs(keyCodes[2])) {
                return 8;
            }
        }
        if (Math.abs(n) == Math.abs(keyCodes[19]) || n == 42) {
            return 2048;
        }
        if (Math.abs(n) == Math.abs(keyCodes[15]) || n == 48) {
            return 4096;
        }
        if (Math.abs(n) == Math.abs(keyCodes[18]) || n == 35) {
            return 1024;
        }
        if (Math.abs(n) == Math.abs(keyCodes[21])) {
            return 256;
        }
        if (Math.abs(n) == Math.abs(keyCodes[20])) {
            return 512;
        }
        return 0;
    }

    public static int getKey(int n) {
        return keyCodes[n];
    }

    public void keyPressed(int n) {
        keyCodeLastPressed = n;
        action_LastPressed = C.getActionKey(n);
        action |= action_LastPressed;
        isKeyChanged = true;
        if (app_isSoundSuspendedAfterPause) {
            app_isSoundSuspendedAfterPause = false;
        }
    }

    public void keyReleased(int n) {
        keyCodeLastReleased = n;
        action_LastReleased = C.getActionKey(n);
        action &= ~action_LastReleased;
        isKeyChanged = true;
    }

    public static void keyClear() {
        keyCodeLastPressed = keyCodeLastReleased = keyCodes[0];
        action_LastReleased = 0;
        action_LastPressed = 0;
        action = 0;
        isKeyChanged = true;
    }

    public static int getLastKeyPressed() {
        return keyCodeLastPressed;
    }

    public static int getLastkeyReleased() {
        return keyCodeLastReleased;
    }

    private static void keyInitDefault() {
        keyCodes = new int[22];
        C.keyCodes[16] = 6;
        C.keyCodes[17] = 7;
        C.keyCodes[1] = 2;
        C.keyCodes[2] = 5;
        C.keyCodes[3] = 1;
        C.keyCodes[4] = 6;
        C.keyCodes[5] = 8;
        C.keyCodes[6] = 49;
        C.keyCodes[7] = 50;
        C.keyCodes[8] = 51;
        C.keyCodes[9] = 52;
        C.keyCodes[10] = 53;
        C.keyCodes[11] = 54;
        C.keyCodes[12] = 55;
        C.keyCodes[13] = 56;
        C.keyCodes[14] = 57;
        C.keyCodes[15] = 48;
        C.keyCodes[18] = 35;
        C.keyCodes[19] = 42;
        C.keyCodes[20] = 0;
        C.keyCodes[21] = -8;
    }

    public static boolean isKeyChanged() {
        return isKeyChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void keyInit(MIDlet mIDlet, String string) {
        String string2;
        String string3;
        int n;
        Vector<String> vector;
        block24: {
            vector = new Vector<String>();
            n = 0;
            string3 = N;
            string2 = N;
            DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
            try {
                while (true) {
                    string2 = string2 + (char)dataInputStream.readByte();
                }
            }
            catch (EOFException eOFException) {
                if (dataInputStream == null) break block24;
                try {
                    dataInputStream.close();
                }
                catch (Exception exception) {
                    return;
                }
                dataInputStream = null;
            }
            catch (Exception exception) {
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (Exception exception2) {
                        return;
                    }
                    dataInputStream = null;
                }
                return;
                catch (Throwable throwable) {
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Exception exception3) {
                            return;
                        }
                        dataInputStream = null;
                    }
                    throw throwable;
                }
            }
        }
        while (n < string2.length()) {
            if (string2.charAt(n) == '\r') {
                ++n;
                continue;
            }
            if (string2.charAt(n) == '\n' || string2.charAt(n) == ' ') {
                if (string3.length() > 0) {
                    vector.addElement(string3);
                }
                string3 = new String();
                ++n;
                continue;
            }
            string3 = string3 + string2.charAt(n);
            ++n;
        }
        if (string3.length() > 0) {
            vector.addElement(string3);
        }
        n ^= n;
        try {
            C.keyCodes[16] = ((String)vector.elementAt(n)).charAt(0) == 'n' ? 42 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[17] = ((String)vector.elementAt(++n)).charAt(0) == 'n' ? 35 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[1] = ((String)vector.elementAt(++n)).charAt(0) == 'c' ? 2 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[2] = ((String)vector.elementAt(++n)).charAt(0) == 'c' ? 5 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[3] = ((String)vector.elementAt(++n)).charAt(0) == 'c' ? 1 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[4] = ((String)vector.elementAt(++n)).charAt(0) == 'c' ? 6 : Integer.parseInt((String)vector.elementAt(n));
            C.keyCodes[5] = ((String)vector.elementAt(++n)).charAt(0) == 'c' ? 8 : Integer.parseInt((String)vector.elementAt(n));
            if (vector.size() > ++n) {
                C.keyCodes[20] = Integer.parseInt((String)vector.elementAt(n++));
            }
            if (vector.size() > n) {
                C.keyCodes[21] = Integer.parseInt((String)vector.elementAt(n++));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrate() {
        C.vibrate(300);
    }

    public static void vibraToggle(boolean bl) {
        vibra_IsEnabled = bl;
    }

    public static boolean getVibraState() {
        return vibra_IsEnabled;
    }

    public static boolean getVibraAvailability() {
        return true;
    }

    public static void vibrate(int n) {
        if (!vibra_IsEnabled) {
            return;
        }
        try {
            display.vibrate(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmsSave(String string, ByteArrayOutputStream byteArrayOutputStream) {
        recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)(C.getApplicationName() + string), (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.deleteRecord(recordStore.getNextRecordID() - 1);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static DataInputStream rmsLoad(String string) {
        try {
            recordStore = RecordStore.openRecordStore((String)(C.getApplicationName() + string), (boolean)true);
            byte[] byArray = null;
            if (recordStore == null || recordStore.getNumRecords() <= 0) {
                recordStore.closeRecordStore();
                return null;
            }
            byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void rmsClose() {
        try {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void rmsDelete(String string) {
        try {
            RecordStore.deleteRecordStore((String)(C.getApplicationName() + string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getScreenWidth() {
        return 240;
    }

    public static int getScreenHeight() {
        return 320;
    }

    public static String getApplicationName() {
        return midlet.getAppProperty("MIDlet-Name");
    }

    public static String getApplicationVersion() {
        return midlet.getAppProperty("MIDlet-Version");
    }

    public static String getBuildName() {
        return "nokia_n71";
    }

    static {
        app = null;
        app_isRunning = false;
        app_isActive = false;
        app_isFirstPassAfterResume = false;
        app_enablePauseWhenReady = false;
        app_isAutoPauseSuspended = false;
        app_isPauseSuspended = false;
        app_isSoundSuspendedAfterPause = false;
        time_Elapsed = 0L;
        time_LastFrame = 0;
        control_isSoftsClear = false;
        control_isAutoPause = false;
        control_isDoublePixel = false;
        control_isKeyNumericAction = false;
        control_isKeyNumericBias = false;
        linkRequest = null;
        isKeyChanged = true;
        vibra_IsEnabled = true;
    }

    private class MainThread
    extends Thread {
        private MainThread() {
        }

        public void run() {
            app_isRunning = true;
            app = Application.getSingleton(midlet);
            app_isActive = true;
            time_LastFrame = 0;
            time_Elapsed = System.currentTimeMillis();
            while (app_isRunning) {
                if (!C.this.isShown()) {
                    C.pause();
                } else {
                    if (app_enablePauseWhenReady) {
                        C.pauseEnable();
                    }
                    if (app_isFirstPassAfterResume) {
                        app_isFirstPassAfterResume = false;
                        C.resume();
                    }
                }
                if (app_isActive) {
                    try {
                        MainThread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (control_isAutoPause) {
                        if (!app_isAutoPauseSuspended) {
                            if (time_LastFrame > 2000 && !app_isAutoPauseSuspended) {
                                C.pause();
                            }
                        } else {
                            app_isAutoPauseSuspended = false;
                        }
                    }
                    app.update(time_LastFrame);
                    if (isKeyChanged) {
                        isKeyChanged = false;
                    }
                    if (control_isSoftsClear) {
                        action &= -193;
                    }
                    C.repaintDoubleBuffer();
                    C.this.repaint();
                    C.this.serviceRepaints();
                    long l = System.currentTimeMillis();
                    time_LastFrame = (int)(l - time_Elapsed);
                    time_Elapsed = l;
                    continue;
                }
                try {
                    MainThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (C.getLinkRequest() != null) {
                try {
                    midlet.platformRequest(C.getLinkRequest());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            midlet.notifyDestroyed();
        }
    }
}

