/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.CitizenType;
import Game.Sprite;
import SAF_Engine.Trigger;
import SAF_Util.Util;

public class Citizen
extends Sprite {
    static final byte STATE_WAITING_FOR_REMOVE = -2;
    static final byte STATE_UNDEFINED = -1;
    static final byte STATE_WALK = 0;
    static final byte STATE_DEATH = 1;
    static final byte STATE_PANIC = 2;
    static final byte STATE_PANIC_EXIT = 3;
    static final byte STATE_WAITING = 4;
    static final byte STATE_BUSY_BEGINNING = 5;
    static final byte STATE_STAND = 6;
    static final byte STATE_BUSY = 7;
    static final byte STATE_AFTER_CAR_HIJACK = 8;
    static final byte SEQUENCE_WALK = 0;
    static final byte SEQUENCE_DEATH = 4;
    static final byte SEQUENCE_STAND = 5;
    static final byte SEQUENCE_BUSY_BEGINNING = 6;
    static final byte SEQUENCE_BUSY = 7;
    static final byte CITIZEN_TYPE_RANDOM = -1;
    CitizenType citizenType;
    private byte state = (byte)-1;
    long stateTime = 0L;
    int speedXf;
    int speedYf;
    short spawnPositionX;
    short spawnPositionY;
    byte spawnDirection;
    byte spawnTypeId;
    int proposedPositionXf;
    int proposedPositionYf;
    short healthPoints = (short)10;
    int stateTimeOverall;

    void init() {
        this.type = (byte)3;
    }

    void reset() {
    }

    void update(int n) {
    }

    private void stateInit() {
        switch (this.state) {
            case 4: {
                this.stateTimeOverall = 1000;
                break;
            }
            case 3: {
                this.setDirection((byte)Util.getRandom(0, 3));
                if (this.direction == 0 || this.direction == 1) {
                    this.positionYf = this.positionYf & 0x7FFFFC00 | 0x200;
                    break;
                }
                this.positionXf = this.positionXf & 0x7FFFFC00 | 0x200;
                break;
            }
            case 0: {
                this.stateTimeOverall = Util.getRandom(this.citizenType.walkingTimeMin, this.citizenType.walkingTimeMax);
                this.speedCalculate();
                break;
            }
            case 6: 
            case 7: {
                this.stateTimeOverall = Util.getRandom(this.citizenType.busyTimeMin, this.citizenType.busyTimeMax);
                break;
            }
            case 5: {
                this.stateTimeOverall = 200;
                break;
            }
            case 1: {
                this.stateTimeOverall = 500;
            }
        }
    }

    void stateReset() {
        this.state = (byte)-1;
    }

    void stateChange(byte by) {
        if (by != this.state) {
            this.animationFrameCounterReset();
            this.state = by;
            this.stateTime ^= this.stateTime;
            this.stateInit();
        }
    }

    byte getState() {
        return this.state;
    }

    private void speedCalculate() {
        switch (this.direction) {
            case 0: {
                this.speedXf = -Util.getRandom(this.citizenType.movementSpeedMin, this.citizenType.movementSpeedMax);
                this.speedYf ^= this.speedYf;
                break;
            }
            case 1: {
                this.speedXf = Util.getRandom(this.citizenType.movementSpeedMin, this.citizenType.movementSpeedMax);
                this.speedYf ^= this.speedYf;
                break;
            }
            case 2: {
                this.speedXf ^= this.speedXf;
                this.speedYf = -Util.getRandom(this.citizenType.movementSpeedMin, this.citizenType.movementSpeedMax);
                break;
            }
            case 3: {
                this.speedXf ^= this.speedXf;
                this.speedYf = Util.getRandom(this.citizenType.movementSpeedMin, this.citizenType.movementSpeedMax);
            }
        }
    }

    void setDirection(byte by) {
        this.direction = by;
        if (this.state == 0 || this.state == 3) {
            this.speedCalculate();
        }
    }

    void directionChangeOnTrigger(Trigger trigger) {
        this.setDirection(Sprite.directionRandomGenerate((byte)trigger.params[0], Sprite.getDirectionMask(Sprite.getDirectionOpposite(this.direction))));
        this.proposedPositionXf = this.positionXf & 0x7FFFFC00 | 0x200;
        this.proposedPositionYf = this.positionYf & 0x7FFFFC00 | 0x200;
    }

    void positionAccept() {
        this.positionXf = this.proposedPositionXf;
        this.positionYf = this.proposedPositionYf;
    }

    boolean damageTake(int n) {
        if (this.state != 1 && this.state != -2) {
            this.healthPoints = (short)(this.healthPoints - n);
            if (this.healthPoints <= 0) {
                this.stateChange((byte)1);
                return true;
            }
        }
        return false;
    }

    byte getCurrentFrame() {
        return this.animationFrameCounter;
    }

    byte getCurrentSequence() {
        switch (this.state) {
            case 1: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 4: 
            case 6: 
            case 8: {
                return 5;
            }
        }
        return (byte)(0 + this.direction);
    }
}

