/*
 * Decompiled with CFR 0.152.
 */
package SAF_GUI;

import SAF_Core.Anim;
import SAF_Core.C;
import SAF_Util.Mat;
import SAF_Util.Util;
import javax.microedition.lcdui.Graphics;

public class ProgressBar {
    public static final String N = "";
    private int positionX;
    private int positionY;
    private int graphicsPositionX;
    private int graphicsPositionY;
    private int width;
    private int height;
    private int anchorPoint;
    private int backgroundColor;
    private boolean isBackgroundVisible;
    private int borderColor;
    private boolean isBorderVisible;
    private int gradientColor1;
    private int gradientColor2;
    private boolean isGradientHorizontal;
    private int screenColor;
    private Anim graphics;
    private boolean isVisible;
    private int numberOfProgressStages;
    private int progressStage;

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28, int n29, int n30, int n31, int n32) {
        this.isVisible = true;
        switch (n2) {
            case 0: {
                this.positionX = n * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.positionX = Mat.percentOf(n, C.getScreenWidth());
            }
        }
        switch (n4) {
            case 0: {
                this.positionY = n3 * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.positionY = Mat.percentOf(n3, C.getScreenHeight());
            }
        }
        switch (n8) {
            case 0: {
                this.width = n7 * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.width = Mat.percentOf(n7, C.getScreenWidth());
            }
        }
        switch (n10) {
            case 0: {
                this.height = n9 * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.height = Mat.percentOf(n9, C.getScreenHeight());
            }
        }
        this.anchorPoint = 0;
        switch (n5) {
            case 0: {
                this.anchorPoint |= 1;
                break;
            }
            case 1: {
                this.anchorPoint |= 4;
                break;
            }
            case 2: {
                this.anchorPoint |= 8;
            }
        }
        switch (n6) {
            case 0: {
                this.anchorPoint |= 2;
                break;
            }
            case 1: {
                this.anchorPoint |= 0x10;
                break;
            }
            case 2: {
                this.anchorPoint |= 0x20;
            }
        }
        this.isBackgroundVisible = n11 != 0;
        this.backgroundColor = Util.getRGB(n12, n13, n14);
        this.isBorderVisible = n15 != 0;
        this.borderColor = Util.getRGB(n12, n13, n14);
        this.isGradientHorizontal = n25 == 0;
        this.gradientColor1 = Util.getRGB(n19, n20, n21);
        this.gradientColor2 = Util.getRGB(n22, n23, n24);
        this.screenColor = Util.getRGB(n26, n27, n28);
        switch (n30) {
            case 0: {
                this.graphicsPositionX = n29 * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.graphicsPositionX = Mat.percentOf(n29, C.getScreenWidth());
            }
        }
        switch (n30) {
            case 0: {
                this.graphicsPositionY = n31 * C.twiceOnDoublePix();
                break;
            }
            default: {
                this.graphicsPositionY = Mat.percentOf(n31, C.getScreenHeight());
            }
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible) {
            return;
        }
        graphics.setColor(this.screenColor);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        int n = this.progressStage * 100 / this.numberOfProgressStages;
        if (this.graphics != null) {
            this.graphics.drawFrame(graphics, 0, 0, 0, this.graphicsPositionX, this.graphicsPositionY, 0);
            short s = this.graphics.frameInSequenceId[1][0];
            short s2 = this.graphics.frameInSequencePositionX[1][0];
            short s3 = this.graphics.frameBoundLeft[s];
            int n2 = Mat.percentOf(n, this.graphics.getFrameWidth(1, 0));
            graphics.setClip(this.graphicsPositionX + s2 + s3, 0, this.graphicsPositionX + s2 + s3 + n2, C.getScreenHeight());
            this.graphics.drawFrame(graphics, 1, 0, 0, this.graphicsPositionX, this.graphicsPositionY, 0);
        } else {
            int n3 = this.positionX;
            if ((this.anchorPoint & 1) != 0) {
                n3 -= this.width >> 1;
            } else if ((this.anchorPoint & 8) != 0) {
                n3 -= this.width;
            }
            int n4 = this.positionY;
            if ((this.anchorPoint & 2) != 0) {
                n4 -= this.height >> 1;
            } else if ((this.anchorPoint & 0x20) != 0) {
                n4 -= this.height;
            }
            if (this.isBackgroundVisible) {
                graphics.setColor(this.backgroundColor);
                graphics.fillRect(n3, n4, this.width, this.height);
            }
            if (this.isGradientHorizontal) {
                Util.drawGradientBarH(graphics, n3, n4, this.width, this.height, this.gradientColor1, this.gradientColor2, n, 8);
            } else {
                Util.drawGradientBarH(graphics, n3, n4, this.width, this.height, this.gradientColor1, this.gradientColor2, n, 8);
            }
            if (this.isBorderVisible) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n3, n4, this.width, this.height);
            }
        }
    }

    public void visibilityToggle(boolean bl) {
        this.isVisible = bl;
    }

    public void setGfx(Anim anim) {
        this.graphics = anim;
    }

    public void flushGfx() {
        this.graphics = null;
        C.gc();
    }

    public void setNumberOfStages(int n) {
        this.numberOfProgressStages = n;
    }

    public void resetStage() {
        this.progressStage ^= this.progressStage;
    }

    public void tickStage() {
        ++this.progressStage;
    }
}

