/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.misslie;

import javax.microedition.lcdui.Graphics;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Missile;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.Wall;
import org.kyxh.tank.gameobjects.booms.BigBoom;
import org.kyxh.tank.util.Rect;

public class BombMissile
extends Missile {
    protected int WIDTH = 50;
    protected int HEIGHT = 50;
    private int XSPEED = 6;
    private int YSPEED = 6;

    public BombMissile(int x, int y, boolean good, int dir, GameMediator gm) {
        super(x, y, good, dir, gm);
    }

    public void draw(Graphics g) {
        if (this.boomstep == 10) {
            this.gm.gameObjects.add(new BigBoom(this.x, this.y, this.gm));
            this.boomstep = 0;
        } else {
            ++this.boomstep;
        }
        this.move();
    }

    public void move() {
        switch (this.dir) {
            case 0: {
                this.x -= this.XSPEED;
                break;
            }
            case 1: {
                this.x -= this.XSPEED - 1;
                this.y -= this.YSPEED - 1;
                break;
            }
            case 2: {
                this.y -= this.YSPEED;
                break;
            }
            case 3: {
                this.y -= this.YSPEED - 1;
                this.x += this.XSPEED - 1;
                break;
            }
            case 4: {
                this.x += this.XSPEED;
                break;
            }
            case 5: {
                this.x += this.XSPEED - 1;
                this.y += this.YSPEED - 1;
                break;
            }
            case 6: {
                this.y += this.YSPEED;
                break;
            }
            case 7: {
                this.x -= this.XSPEED - 1;
                this.y += this.YSPEED - 1;
            }
        }
        this.checkBounds();
    }

    public boolean hitTank(Tank t) {
        if (this.getRect().collideRect(t.rect) && t.isLive() && this.good != t.good) {
            t.die();
            return true;
        }
        return false;
    }

    public boolean hitWall(Wall w) {
        return false;
    }

    public Rect getRect() {
        this.rect.x = this.x;
        this.rect.y = this.y;
        this.rect.height = this.HEIGHT;
        this.rect.width = this.WIDTH;
        return this.rect;
    }
}

