/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects.tanks;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.booms.NormalBoom;
import org.kyxh.tank.gameobjects.misslie.DoubleLaserMissile;
import org.kyxh.tank.util.Direction;
import org.kyxh.tank.util.Rect;

public class BigTank
extends Tank {
    public Sprite bigTank;
    public static Image bigTankImg;
    int XSPEED = 2;
    int YSPEED = 2;
    public static int WIDTH;
    public static int HEIGHT;
    int hp = 4;

    static {
        WIDTH = 20;
        HEIGHT = 20;
        try {
            bigTankImg = Image.createImage((String)"/images/tank/bigtank1.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BigTank(int x, int y, boolean good, int dir, GameMediator gm) {
        super(x, y, good, dir, gm);
        if (good) {
            GameMediator.myTankSpeed = this.XSPEED;
        }
        this.bigTank = new Sprite(bigTankImg, 20, 20);
        this.rect = new Rect(x, y, WIDTH, HEIGHT);
    }

    public void draw(Graphics g) {
        int x = this.x - this.gm.mapPosX;
        int y = this.y - this.gm.mapPosY;
        if (!this.live && !this.good) {
            this.gm.gameObjects.remove(this);
            return;
        }
        if (this.good && this.live) {
            g.setColor(0x808080);
            g.fillRect(x - 5, y - 15, WIDTH + 10, 8);
            g.setColor(0);
            g.fillRect(x - 4, y - 14, WIDTH + 8, 6);
            if (this.hp < 31) {
                g.setColor(0xFF0000);
            } else if (this.hp < 65) {
                g.setColor(0xFFFF00);
            } else {
                g.setColor(32768);
            }
            g.fillRect(x - 4, y - 14, (WIDTH + 7) * this.hp / 100, 6);
        }
        if (!this.live) {
            return;
        }
        this.move();
        this.bigTank.setFrameSequence(new int[]{this.ptdir});
        this.bigTank.setPosition(x, y);
        if (x < 280 && x > -40 && y < 340 && y > -40) {
            this.bigTank.paint(g);
        }
        this.drawOnMap(g);
    }

    public void die() {
        if (this.hp > 0) {
            --this.hp;
        } else {
            this.setLive(false);
            this.gm.gameObjects.remove(this);
            --Tank.enemyTankCount;
            this.gm.gameObjects.add(new NormalBoom(this.x, this.y, this.gm));
        }
    }

    protected void move() {
        this.oldX = this.x;
        this.oldY = this.y;
        if (!this.good) {
            if (this.step == 0) {
                int rn;
                this.step = Tank.r.nextInt(30) + 8;
                this.dir = rn = Tank.r.nextInt(8);
            }
            --this.step;
            if (Tank.r.nextInt(40) > 37) {
                this.fire();
            }
        }
        switch (this.dir) {
            case 0: {
                this.x -= this.XSPEED + 1;
                break;
            }
            case 1: {
                this.x -= this.XSPEED;
                this.y -= this.YSPEED;
                break;
            }
            case 2: {
                this.y -= this.YSPEED + 1;
                break;
            }
            case 3: {
                this.y -= this.YSPEED;
                this.x += this.XSPEED;
                break;
            }
            case 4: {
                this.x += this.XSPEED + 1;
                break;
            }
            case 5: {
                this.x += this.XSPEED;
                this.y += this.YSPEED;
                break;
            }
            case 6: {
                this.y += this.YSPEED + 1;
                break;
            }
            case 7: {
                this.x -= this.XSPEED;
                this.y += this.YSPEED;
            }
        }
        if (this.dir != Direction.STOP) {
            this.ptdir = this.dir;
        }
        this.rect.x = this.x;
        this.rect.y = this.y;
        this.checkBounds();
    }

    public void fire() {
        if (!this.live) {
            return;
        }
        int x = this.x + WIDTH / 2;
        int y = this.y + HEIGHT / 2;
        this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, this.ptdir, this.gm, 0));
    }
}

