/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import org.kyxh.tank.GameObject;
import org.kyxh.tank.IndexForm;
import org.kyxh.tank.TankClient;
import org.kyxh.tank.TankStart;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.tanks.LittleTank;
import org.kyxh.tank.gameobjects.walls.Building;
import org.kyxh.tank.util.List;

public class BlueService
implements Runnable,
DiscoveryListener {
    String flag = "";
    int id = 0;
    int x = 0;
    int y = 0;
    int hp = 100;
    int dir = 0;
    int ptDir = 0;
    int pos = 0;
    boolean[] bF = new boolean[22];
    public List gameObjects = new List();
    private static final UUID TARGET_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    public String readString = "";
    private Vector devices = new Vector();
    private Vector records = new Vector();
    private UUID[] uuidSet = null;
    private DiscoveryAgent discoveryAgent = null;
    private int[] transIDs;
    int activeIndex = -1;
    private IndexForm indexForm;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private int shuaiQiangid = 0;
    private String name = "";
    public static boolean replace = false;

    public BlueService(IndexForm frm) {
        this.indexForm = frm;
    }

    public synchronized void run() {
        Gauge g = new Gauge(null, false, -1, 2);
        this.indexForm.append((Item)g);
        if (!this.initLocalDevice()) {
            System.out.println("bluetooth init failed~");
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = TARGET_UUID;
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        System.out.println("search device completed,find " + this.devices.size() + " devices~");
        System.out.println("now begin to search service...");
        this.transIDs = new int[this.devices.size()];
        int i = 0;
        while (i < this.devices.size()) {
            RemoteDevice rd = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.transIDs[i] = this.discoveryAgent.searchServices(null, this.uuidSet, rd, (DiscoveryListener)this);
            }
            catch (BluetoothStateException bluetoothStateException) {
                // empty catch block
            }
            ++i;
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        System.out.println("service search finished~,find " + this.records.size() + " services");
        if (this.records.size() > 0) {
            this.activeIndex = this.getActiveService();
            TankClient.gameStart = true;
            TankClient.bs = this;
            TankStart.navigateTo((Displayable)TankClient.tc);
        }
        while (true) {
            try {
                while (true) {
                    this.readString = this.dis.readUTF();
                    this.checkXieYi(this.readString, this.dis);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void checkXieYi(String readString, DataInputStream dis) throws IOException {
        int i;
        if ("ID".equals(readString)) {
            TankClient.tc.gm.myTank.id = this.id = dis.readInt();
            GameMediator.id = this.id;
            this.sendTank(TankClient.tc.gm.myTank);
        }
        if ("game".equals(readString)) {
            replace = false;
            this.gameObjects.clear();
            while (!"end".equals(this.flag)) {
                this.flag = dis.readUTF();
                if ("tank".equals(this.flag)) {
                    this.id = dis.readInt();
                    this.x = dis.readInt();
                    this.y = dis.readInt();
                    this.hp = dis.readInt();
                    this.dir = dis.readInt();
                    this.ptDir = dis.readInt();
                    LittleTank tank = new LittleTank(this.x / 2, this.y / 2, false, this.dir, TankClient.tc.gm, this.id, this.name);
                    tank.hp = this.hp;
                    if (this.hp <= 0) {
                        tank.live = false;
                    }
                    tank.ptdir = this.ptDir;
                    this.gameObjects.add(tank);
                    replace = true;
                } else if ("dir".equals(this.flag)) {
                    this.id = dis.readInt();
                    this.dir = dis.readInt();
                    TankClient.tc.gm.gameObjects.modifydir(this.id, this.dir);
                } else if ("ptdir".equals(this.flag)) {
                    this.id = dis.readInt();
                    this.ptDir = dis.readInt();
                    TankClient.tc.gm.gameObjects.modifyptdir(this.id, this.ptDir);
                } else if ("fire".equals(this.flag)) {
                    this.shuaiQiangid = dis.readInt();
                    this.bF[this.shuaiQiangid - 100] = dis.readBoolean();
                } else if ("wall".equals(this.flag)) {
                    this.x = dis.readInt();
                    this.y = dis.readInt();
                    TankClient.tc.gm.gameObjects.add(new Building(this.x, this.y, 225, 30, TankClient.tc.gm));
                } else if ("kofire".equals(this.flag)) {
                    this.id = dis.readInt();
                    TankClient.tc.gm.gameObjects.koFire(this.id);
                } else if ("reborn".equals(this.flag)) {
                    this.id = dis.readInt();
                    TankClient.tc.gm.gameObjects.reborn(this.id);
                }
                i = 0;
                while (i < this.bF.length) {
                    if (this.bF[i]) {
                        TankClient.tc.gm.gameObjects.fire(100 + i);
                    }
                    ++i;
                }
            }
        }
        this.flag = "";
        if (replace) {
            TankClient.tc.gm.gameObjects.replace(this.gameObjects);
        }
        i = 0;
        while (i < this.gameObjects.getSize()) {
            GameObject gm = (GameObject)this.gameObjects.get(i);
            if (gm instanceof Tank) {
                Tank tank = (Tank)gm;
                if (tank.id == GameMediator.id) {
                    tank.good = true;
                    TankClient.tc.gm.myTank = tank;
                }
            }
            ++i;
        }
    }

    private void sendTank(Tank myTank) {
        try {
            this.dos.writeUTF("mytank");
            this.dos.writeInt(myTank.id);
            this.dos.writeInt(myTank.x);
            this.dos.writeInt(myTank.y);
            this.dos.writeInt(myTank.dir);
            this.dos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getActiveService() {
        int i = 0;
        while (i < this.records.size()) {
            ServiceRecord sr = (ServiceRecord)this.records.elementAt(i);
            if (this.accessService(sr, "0")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean initLocalDevice() {
        boolean isReady = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            localDevice.setDiscoverable(0);
            isReady = true;
        }
        catch (Exception ex) {
            isReady = false;
        }
        return isReady;
    }

    public void sendK(int k, int id) {
        try {
            this.dos.writeUTF("k");
            this.dos.writeInt(id);
            this.dos.writeInt(k);
            this.dos.flush();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean accessService(ServiceRecord sr, String msg) {
        boolean result = false;
        try {
            String url = sr.getConnectionURL(0, false);
            StreamConnection conn = (StreamConnection)Connector.open((String)url);
            this.dos = conn.openDataOutputStream();
            this.dis = conn.openDataInputStream();
            this.dos.writeUTF(msg);
            this.dos.flush();
            result = true;
        }
        catch (IOException e) {
            System.out.println("exception here");
        }
        return result;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devices.indexOf(btDevice) == -1) {
            this.devices.addElement(btDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int disType) {
        BlueService blueService = this;
        synchronized (blueService) {
            this.notify();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        int i = 0;
        while (i < this.transIDs.length) {
            if (this.transIDs[i] == transID) {
                this.transIDs[i] = -1;
            }
            ++i;
        }
        boolean finished = false;
        int i2 = 0;
        while (i2 < this.transIDs.length) {
            if (this.transIDs[i2] == -1) {
                finished = true;
                break;
            }
            ++i2;
        }
        if (finished) {
            BlueService blueService = this;
            synchronized (blueService) {
                this.notify();
            }
        }
    }
}

