/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import org.kyxh.tank.CtrlPcCanvas;
import org.kyxh.tank.IndexForm;
import org.kyxh.tank.TankStart;

public class CtrlService
implements Runnable,
DiscoveryListener {
    private static final UUID TARGET_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    private Vector devices = new Vector();
    private Vector records = new Vector();
    private UUID[] uuidSet = null;
    private DiscoveryAgent discoveryAgent = null;
    private int[] transIDs;
    int activeIndex = -1;
    private IndexForm indexForm;
    private DataOutputStream dos = null;
    private int orgKey;
    public int k = 0;

    public CtrlService(IndexForm frm) {
        this.indexForm = frm;
    }

    public synchronized void run() {
        Gauge g = new Gauge(null, false, -1, 2);
        this.indexForm.append((Item)g);
        if (!this.initLocalDevice()) {
            System.out.println("bluetooth init failed~");
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = TARGET_UUID;
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        System.out.println("search device completed,find " + this.devices.size() + " devices~");
        System.out.println("now begin to search service...");
        this.transIDs = new int[this.devices.size()];
        int i = 0;
        while (i < this.devices.size()) {
            RemoteDevice rd = (RemoteDevice)this.devices.elementAt(i);
            try {
                this.transIDs[i] = this.discoveryAgent.searchServices(null, this.uuidSet, rd, (DiscoveryListener)this);
            }
            catch (BluetoothStateException bluetoothStateException) {
                // empty catch block
            }
            ++i;
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        System.out.println("service search finished~,find " + this.records.size() + " services");
        CtrlPcCanvas cc = new CtrlPcCanvas(this);
        if (this.records.size() > 0) {
            this.activeIndex = this.getActiveService();
            TankStart.navigateTo((Displayable)cc);
        }
        while (true) {
            this.k = cc.getKey();
            if (this.k != this.orgKey) {
                this.sendMsg(this.k);
                this.orgKey = this.k;
                this.sendMsg(this.k);
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private int getActiveService() {
        int i = 0;
        while (i < this.records.size()) {
            ServiceRecord sr = (ServiceRecord)this.records.elementAt(i);
            if (this.accessService(sr, "0")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean initLocalDevice() {
        boolean isReady = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            localDevice.setDiscoverable(0);
            isReady = true;
        }
        catch (Exception ex) {
            isReady = false;
        }
        return isReady;
    }

    public void sendMsg(int playFromBegin) {
        try {
            this.dos.writeInt(playFromBegin);
            this.dos.flush();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean accessService(ServiceRecord sr, String msg) {
        boolean result = false;
        try {
            String url = sr.getConnectionURL(0, false);
            StreamConnection conn = (StreamConnection)Connector.open((String)url);
            this.dos = conn.openDataOutputStream();
            this.dos.writeUTF(msg);
            this.dos.flush();
            result = true;
        }
        catch (IOException e) {
            System.out.println("exception here");
        }
        return result;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devices.indexOf(btDevice) == -1) {
            this.devices.addElement(btDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int disType) {
        CtrlService ctrlService = this;
        synchronized (ctrlService) {
            this.notify();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        int i = 0;
        while (i < this.transIDs.length) {
            if (this.transIDs[i] == transID) {
                this.transIDs[i] = -1;
            }
            ++i;
        }
        boolean finished = false;
        int i2 = 0;
        while (i2 < this.transIDs.length) {
            if (this.transIDs[i2] == -1) {
                finished = true;
                break;
            }
            ++i2;
        }
        if (finished) {
            CtrlService ctrlService = this;
            synchronized (ctrlService) {
                this.notify();
            }
        }
    }
}

