/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.control;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import org.kyxh.tank.Collider;
import org.kyxh.tank.ColliderChain;
import org.kyxh.tank.GameObject;
import org.kyxh.tank.TankClient;
import org.kyxh.tank.gameobjects.Food;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.Wall;
import org.kyxh.tank.gameobjects.foods.Bomb;
import org.kyxh.tank.gameobjects.foods.HP;
import org.kyxh.tank.gameobjects.tanks.BigTank;
import org.kyxh.tank.gameobjects.tanks.GhostTank;
import org.kyxh.tank.gameobjects.tanks.LaserTank;
import org.kyxh.tank.gameobjects.tanks.LittleTank;
import org.kyxh.tank.gameobjects.walls.Building;
import org.kyxh.tank.gameobjects.walls.BuildingNight;
import org.kyxh.tank.util.Direction;
import org.kyxh.tank.util.List;

public class GameMediator {
    public static int id = 0;
    public static final int M_X = 600;
    public static final int M_Y = 480;
    private static Random r = new Random();
    public int mapPosX;
    public int mapPosY;
    public Collider collider = new ColliderChain();
    public Tank myTank = new LaserTank(120, 150, true, Direction.STOP, this);
    public static int myTankSpeed;
    public List gameObjects = new List();
    public TankClient tc;
    public Wall w1;
    public Wall w2;
    public Wall w3;
    public Wall w4;

    public GameMediator(TankClient tc) {
        this.tc = tc;
    }

    public boolean checkLevel() {
        if (Tank.getCount() < 3) {
            this.initTanks();
            this.initFoods();
            TankClient.stageBG = TankClient.stageBG > 1 ? 0 : ++TankClient.stageBG;
            this.changeWalls();
            return true;
        }
        return false;
    }

    public void initFoods() {
        if (Food.getCount() >= 3) {
            return;
        }
        if (TankClient.stage % 2 == 0) {
            this.gameObjects.add(new HP(r.nextInt(600), 0, this));
        } else {
            this.gameObjects.add(new Bomb(r.nextInt(600), 0, this));
        }
    }

    public void drawObjects(Graphics g) {
        int i = 0;
        while (i < this.gameObjects.getSize()) {
            GameObject obj = (GameObject)this.gameObjects.get(i);
            if (obj != null && obj.isLive()) {
                obj.draw(g);
            }
            ++i;
        }
    }

    private void changeWalls() {
        switch (TankClient.stageBG) {
            case 0: {
                this.w1.setLive(true);
                this.w2.setLive(true);
                this.w3.setLive(false);
                this.w4.setLive(false);
                break;
            }
            case 1: {
                this.w1.setLive(false);
                this.w2.setLive(false);
                this.w3.setLive(true);
                this.w4.setLive(true);
                break;
            }
            case 2: {
                this.w1.setLive(false);
                this.w2.setLive(false);
                this.w3.setLive(false);
                this.w4.setLive(false);
            }
        }
    }

    public void checkCollides() {
        int i = 0;
        while (i < this.gameObjects.getSize()) {
            GameObject go1 = (GameObject)this.gameObjects.get(i);
            int j = i + 1;
            while (j < this.gameObjects.getSize()) {
                GameObject go2 = (GameObject)this.gameObjects.get(j);
                this.collider.collides(go1, go2);
                ++j;
            }
            ++i;
        }
    }

    public void initWalls(String style) {
        this.w1 = new Building(r.nextInt(240), r.nextInt(300), 225, 30, this);
        this.w2 = new Building(r.nextInt(240), 210, 225, 30, this);
        this.w3 = new BuildingNight(r.nextInt(240), r.nextInt(50), 225, 30, this);
        this.w4 = new BuildingNight(r.nextInt(400), 210, 225, 30, this);
        this.w3.setLive(false);
        this.w4.setLive(false);
        this.gameObjects.add(this.w1);
        this.gameObjects.add(this.w2);
        this.gameObjects.add(this.w3);
        this.gameObjects.add(this.w4);
    }

    public void moveRight() {
        if (this.mapPosX <= 360) {
            this.mapPosX += myTankSpeed;
            this.tc.bgbf.scroll(myTankSpeed, 0);
            this.tc.bgbf.buffer(true);
        }
    }

    public void initTanks() {
        int i = 0;
        while (i < 5) {
            this.gameObjects.add(new LittleTank(r.nextInt(600 - Tank.WIDTH), r.nextInt(450), false, Direction.STOP, this));
            ++i;
        }
        i = 0;
        while (i < TankClient.stage) {
            this.gameObjects.add(new BigTank(r.nextInt(600 - Tank.WIDTH), r.nextInt(450), false, Direction.D, this));
            ++i;
        }
        i = 0;
        while (i < TankClient.stage / 2) {
            this.gameObjects.add(new GhostTank(r.nextInt(600 - Tank.WIDTH), r.nextInt(450), false, Direction.D, this));
            ++i;
        }
        ++TankClient.stage;
        TankClient.showStage = true;
    }

    public void moveLeft() {
        if (this.mapPosX >= 0) {
            this.mapPosX = this.mapPosX - myTankSpeed - 2;
            this.tc.bgbf.scroll(-myTankSpeed, 0);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveUp() {
        if (this.mapPosY >= 0) {
            this.mapPosY = this.mapPosY - myTankSpeed - 2;
            this.tc.bgbf.scroll(0, -myTankSpeed);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveDown() {
        if (this.mapPosY <= 100) {
            this.mapPosY = this.mapPosY + myTankSpeed + 2;
            this.tc.bgbf.scroll(0, myTankSpeed + 2);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveDownRight() {
        if (this.mapPosY <= 100 && this.mapPosX <= 360) {
            this.mapPosY = this.mapPosY + myTankSpeed + 2;
            this.mapPosX = this.mapPosX + myTankSpeed + 2;
            this.tc.bgbf.scroll(myTankSpeed + 2, myTankSpeed + 2);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveUpRight() {
        if (this.mapPosY >= 0 && this.mapPosX <= 360) {
            this.mapPosY = this.mapPosY - myTankSpeed - 2;
            this.mapPosX = this.mapPosX + myTankSpeed + 2;
            System.out.println(myTankSpeed);
            this.tc.bgbf.scroll(myTankSpeed + 2, -myTankSpeed - 2);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveDownLeft() {
        if (this.mapPosY <= 100 && this.mapPosX >= 0) {
            this.mapPosY = this.mapPosY + myTankSpeed + 2;
            this.mapPosX = this.mapPosX - myTankSpeed - 2;
            this.tc.bgbf.scroll(-myTankSpeed - 2, myTankSpeed + 2);
            this.tc.bgbf.buffer(true);
        }
    }

    public void moveUpLeft() {
        if (this.mapPosY >= 0 && this.mapPosX >= 0) {
            this.mapPosY = this.mapPosY - myTankSpeed - 2;
            this.mapPosX = this.mapPosX - myTankSpeed - 2;
            this.tc.bgbf.scroll(-myTankSpeed - 2, -myTankSpeed - 2);
            this.tc.bgbf.buffer(true);
        }
    }
}

