/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import org.kyxh.tank.GameObject;
import org.kyxh.tank.TankClient;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Tank;
import org.kyxh.tank.gameobjects.Wall;
import org.kyxh.tank.gameobjects.booms.LittleBoom;
import org.kyxh.tank.util.Rect;

public abstract class Missile
extends GameObject {
    public int id = 0;
    public int XSPEED = 6;
    public int YSPEED = 6;
    public int x;
    public int y;
    public int WIDTH = 7;
    public int HEIGHT = 7;
    public int dir;
    public Random r = new Random();
    public boolean good;
    public GameMediator gm;
    public Rect rect;
    public int pos = 0;
    public static int count = 0;
    public int boomstep = 9;

    public Missile(int x, int y, boolean good, int dir, GameMediator gm) {
        this.x = x - 3;
        this.y = y - 3;
        this.dir = dir;
        this.gm = gm;
        this.good = good;
        this.rect = new Rect(x, y, this.WIDTH, this.HEIGHT);
    }

    public Missile(int x, int y, boolean good, int dir, GameMediator gm, int pos) {
        this.x = x - 3;
        this.y = y - 3;
        this.dir = dir;
        this.gm = gm;
        this.good = good;
        this.pos = pos;
        this.rect = new Rect(x, y, this.WIDTH, this.HEIGHT);
    }

    public abstract void draw(Graphics var1);

    public abstract void move();

    public void checkBounds() {
        if (this.x < -140 || this.y < -140 || this.x > 600 + 140 || this.y > 480 + 140) {
            this.die();
        }
    }

    public boolean hitTank(Tank t) {
        if (this.rect.collideRect(t.rect) && t.isLive() && this.good != t.good && this.pos < 3 && !TankClient.gameClient) {
            t.die();
            if (this.HEIGHT != 100) {
                this.die();
            }
            return true;
        }
        if (this.rect.collideRect(t.rect) && t.isLive() && this.id != t.id && this.pos < 3) {
            t.hp -= 15;
            if (t.hp < 0) {
                t.die();
            }
            this.die();
            return true;
        }
        return false;
    }

    public boolean hitWall(Wall w) {
        if (this.rect.collideRect(w.rect) && w.isLive() && this.HEIGHT != 100 && this.pos < 3) {
            this.die();
            return true;
        }
        return false;
    }

    public static int getCount() {
        return count;
    }

    public void die() {
        this.live = false;
        this.gm.gameObjects.remove(this);
        this.gm.gameObjects.add(new LittleBoom(this.x, this.y, this.gm));
    }

    public void moveX() {
        this.x += GameMediator.myTankSpeed;
    }

    public void moveY() {
        this.y += GameMediator.myTankSpeed;
    }

    public void moveXB() {
        this.x -= GameMediator.myTankSpeed;
    }

    public void moveYB() {
        this.y -= GameMediator.myTankSpeed;
    }
}

