/*
 * Decompiled with CFR 0.152.
 */
package org.kyxh.tank.gameobjects;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import org.kyxh.tank.GameObject;
import org.kyxh.tank.TankClient;
import org.kyxh.tank.control.GameMediator;
import org.kyxh.tank.gameobjects.Food;
import org.kyxh.tank.gameobjects.Wall;
import org.kyxh.tank.gameobjects.booms.NormalBoom;
import org.kyxh.tank.gameobjects.misslie.BombMissile;
import org.kyxh.tank.gameobjects.misslie.DoubleLaserMissile;
import org.kyxh.tank.gameobjects.misslie.PlaneSeemMissile;
import org.kyxh.tank.util.Direction;
import org.kyxh.tank.util.Rect;

public abstract class Tank
extends GameObject {
    public int id = 0;
    public String name = "";
    public static int WIDTH = 15;
    public static int HEIGHT = 15;
    public static int XSPEED = 6;
    public static int YSPEED = 6;
    public int oldX;
    public int oldY;
    public int hp = 100;
    public static int bomb = 3;
    public static int suMissiles = 150;
    public boolean bL = false;
    public boolean bU = false;
    public boolean bR = false;
    public boolean bD = false;
    public boolean bF = false;
    public boolean good;
    public static Random r = new Random();
    public int step = r.nextInt(5) + 5;
    public int kstep = 0;
    public int dir = Direction.STOP;
    public int ptdir = Direction.D;
    public GameMediator gm;
    public static int enemyTankCount = 0;
    public static int drawStep = 0;
    public Rect rect;

    public Tank(int x, int y, boolean good, int dir, GameMediator gm) {
        this.gm = gm;
        this.x = x;
        this.y = y;
        this.good = good;
        this.dir = dir;
        this.oldX = x;
        this.oldY = y;
        this.rect = new Rect(x, y, WIDTH, HEIGHT);
        if (!good) {
            ++enemyTankCount;
        }
    }

    public abstract void draw(Graphics var1);

    protected void checkBounds() {
        if (this.x > 0 && this.x < 600 - HEIGHT && this.y > 0 && this.y < 400 - HEIGHT) {
            if (!(!this.good || this.y - this.gm.mapPosY < 300 - HEIGHT - 25 || this.good && this.x - this.gm.mapPosX > 240 - WIDTH - 25 || this.good && this.x < 25)) {
                this.gm.moveDown();
            }
            if (!(!this.good || this.x - this.gm.mapPosX > 25 || this.good && this.y - this.gm.mapPosY > 300 - HEIGHT - 25 || this.good && this.y - this.gm.mapPosY < HEIGHT + 25)) {
                this.gm.moveLeft();
            }
            if (!(!this.good || this.x - this.gm.mapPosX < 240 - WIDTH - 25 || this.good && this.y - this.gm.mapPosY > 300 - HEIGHT - 25 || this.good && this.y - this.gm.mapPosY < HEIGHT + 25)) {
                this.gm.moveRight();
            }
            if (!(!this.good || this.y - this.gm.mapPosY > HEIGHT + 25 || this.good && this.x - this.gm.mapPosX > 240 - WIDTH - 25 || this.good && this.x - this.gm.mapPosX < 25)) {
                this.gm.moveUp();
            }
            if (this.good && this.y - this.gm.mapPosY >= 300 - HEIGHT - 25 && this.good && this.x - this.gm.mapPosX >= 240 - WIDTH - 25) {
                this.gm.moveDownRight();
            }
            if (this.good && this.y - this.gm.mapPosY <= HEIGHT + 25 && this.good && this.x - this.gm.mapPosX >= 240 - WIDTH - 25) {
                this.gm.moveUpRight();
            }
            if (this.good && this.y - this.gm.mapPosY >= 300 - HEIGHT - 25 && this.good && this.x - this.gm.mapPosX <= 25) {
                this.gm.moveDownLeft();
            }
            if (this.good && this.y - this.gm.mapPosY <= HEIGHT + 25 && this.good && this.x - this.gm.mapPosX <= 25) {
                this.gm.moveUpLeft();
            }
            if (this.good && this.y - this.gm.mapPosY < HEIGHT + 25 && this.gm.mapPosY > 0) {
                this.y += GameMediator.myTankSpeed;
            }
            if (this.good && this.y - this.gm.mapPosY > 300 - HEIGHT - 25 && this.gm.mapPosY < 100) {
                this.y -= GameMediator.myTankSpeed;
            }
            if (this.good && this.x - this.gm.mapPosX > 240 - WIDTH - 25 && this.gm.mapPosX < 360) {
                this.x -= GameMediator.myTankSpeed;
            }
            if (this.good && this.x - this.gm.mapPosX < 25 && this.gm.mapPosX > 0) {
                this.x += GameMediator.myTankSpeed;
            }
        } else if (this.x < 0) {
            this.x = 0;
        } else if (this.x > 600 - HEIGHT) {
            this.x = 600 - HEIGHT;
        } else if (this.y < 0) {
            this.y = 0;
        } else if (this.y > 400 - HEIGHT) {
            this.y = 400 - HEIGHT;
        }
    }

    protected void drawOnMap(Graphics g) {
        if (!this.good) {
            g.setColor(0xFF0000);
            g.fillRoundRect(160 + this.x / 10, 10 + this.y / 10, 3, 3, 1, 1);
        } else {
            g.setColor(255);
            g.fillRoundRect(160 + this.x / 10, 10 + this.y / 10, 3, 3, 1, 1);
        }
    }

    protected void move() {
        this.oldX = this.x;
        this.oldY = this.y;
        if (!this.good && !TankClient.gameClient) {
            if (this.step == 0) {
                int rn;
                this.step = r.nextInt(30) + 8;
                this.dir = rn = r.nextInt(8);
            }
            --this.step;
            if (r.nextInt(40) > 37) {
                this.fire(this.ptdir);
            }
        }
        if (this.dir == Direction.L) {
            this.x -= XSPEED + 1;
        } else if (this.dir == Direction.LU) {
            this.x -= XSPEED;
            this.y -= YSPEED;
        } else if (this.dir == Direction.U) {
            this.y -= YSPEED + 1;
        } else if (this.dir == Direction.UR) {
            this.y -= YSPEED;
            this.x += XSPEED;
        } else if (this.dir == Direction.R) {
            this.x += XSPEED + 1;
        } else if (this.dir == Direction.RD) {
            this.x += XSPEED;
            this.y += YSPEED;
        } else if (this.dir == Direction.D) {
            this.y += YSPEED + 1;
        } else if (this.dir == Direction.DL) {
            this.x -= XSPEED;
            this.y += YSPEED;
        }
        this.rect.x = this.x;
        this.rect.y = this.y;
        if (this.dir != Direction.STOP) {
            this.ptdir = this.dir;
        }
        this.checkBounds();
    }

    protected void locateDirection() {
        if (this.bL && !this.bU && !this.bR && !this.bD) {
            this.dir = Direction.L;
        } else if (this.bL && this.bU && !this.bR && !this.bD) {
            this.dir = Direction.LU;
        } else if (!this.bL && this.bU && !this.bR && !this.bD) {
            this.dir = Direction.U;
        } else if (!this.bL && this.bU && this.bR && !this.bD) {
            this.dir = Direction.UR;
        } else if (!this.bL && !this.bU && this.bR && !this.bD) {
            this.dir = Direction.R;
        } else if (!this.bL && !this.bU && this.bR && this.bD) {
            this.dir = Direction.RD;
        } else if (!this.bL && !this.bU && !this.bR && this.bD) {
            this.dir = Direction.D;
        } else if (this.bL && !this.bU && !this.bR && this.bD) {
            this.dir = Direction.DL;
        } else if (!(this.bL || this.bU || this.bR || this.bD)) {
            this.dir = Direction.STOP;
        }
    }

    public void stay() {
        this.x = this.oldX;
        this.y = this.oldY;
    }

    public void input(int k) {
        if (this.kstep < 20) {
            ++this.kstep;
        }
        if ((k & 2) > 0) {
            this.bU = true;
            this.bD = false;
        }
        if ((k & 4) > 0) {
            this.bL = true;
            this.bR = false;
        }
        if ((k & 0x20) > 0) {
            this.bR = true;
            this.bL = false;
        }
        if ((k & 0x40) > 0) {
            this.bD = true;
            this.bU = false;
        }
        if ((k & 0x200) > 0) {
            this.bU = true;
            this.bL = true;
            this.bD = false;
            this.bR = false;
        }
        if ((k & 0x400) > 0) {
            this.bU = true;
            this.bR = true;
            this.bD = false;
            this.bL = false;
        }
        if ((k & 0x800) > 0) {
            this.bD = true;
            this.bL = true;
            this.bR = false;
            this.bU = false;
        }
        if ((k & 0x1000) > 0 && bomb > 0 && this.kstep > 15) {
            this.koFire();
            --bomb;
            this.kstep = 0;
        }
        if ((k & 0x100) > 0 && TankClient.GameRun) {
            this.bF = true;
            this.fire(this.ptdir);
            if (this.good && !this.live && TankClient.life >= 1) {
                this.live = true;
                this.hp = 100;
                this.superFirex(true);
                --TankClient.life;
                TankClient.showLife = true;
            }
            if (!TankClient.gameStart) {
                TankClient.gameStart = true;
            }
        }
        if (k == 0) {
            this.bD = false;
            this.bR = false;
            this.bL = false;
            this.bU = false;
            this.bF = false;
        }
        this.locateDirection();
    }

    public boolean collideTank(Tank t) {
        if (this.rect.collideRect(t.rect) && this != t && t.isLive() && this.isLive()) {
            this.stay();
            t.stay();
            Rect oldrect = new Rect(this.oldX, this.oldY, WIDTH, HEIGHT);
            Rect oldtrect = new Rect(t.oldX, t.oldY, WIDTH, HEIGHT);
            if (oldrect.collideRect(oldtrect)) {
                --this.x;
                --this.y;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean collideWall(Wall w) {
        if (w.isLive() && this.rect.collideRect(w.rect)) {
            this.stay();
            Rect oldrect = new Rect(this.oldX, this.oldY, WIDTH, HEIGHT);
            if (oldrect.collideRect(w.rect)) {
                this.x = w.x + r.nextInt(w.HEIGHT);
                this.y = w.y + w.HEIGHT + 2;
                return true;
            }
        }
        return false;
    }

    public void fire() {
    }

    public void firex(int dir) {
        int x = this.x + WIDTH / 2;
        int y = this.y + HEIGHT / 2;
        this.gm.gameObjects.add(new BombMissile(x - 25 + 7, y - 25 + 7, this.good, dir, this.gm));
    }

    public void fire(int dir) {
        int x = this.x + WIDTH / 2;
        int y = this.y + HEIGHT / 2;
        if (this.good && this.live) {
            this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 1));
            this.gm.gameObjects.add(new DoubleLaserMissile(x, y, this.good, dir, this.gm, 2));
        }
    }

    public void superFirex(boolean force) {
        if (force) {
            int i = 0;
            while (i < 8) {
                this.firex(i);
                ++i;
            }
        }
    }

    public void koFire() {
        if (!this.live) {
            return;
        }
        int x = this.x - 40;
        int y = this.y - 40;
        this.gm.gameObjects.add(new PlaneSeemMissile(x, y, this.good, this.ptdir, this.gm, 3));
        this.gm.gameObjects.add(new BombMissile(x, y, this.good, this.ptdir, this.gm));
    }

    public boolean eatFood(Food f) {
        if (this.rect.collideRect(f.getRect()) && this.live && f.isLive()) {
            f.effect(this);
            return true;
        }
        return false;
    }

    public static int getCount() {
        return enemyTankCount;
    }

    public void die() {
        if (this.good && this.hp >= 14) {
            this.hp -= 15;
        } else if (this.good) {
            this.hp = 0;
            this.setLive(false);
            this.gm.gameObjects.add(new NormalBoom(this.x, this.y, this.gm));
        } else {
            this.setLive(false);
            this.gm.gameObjects.remove(this);
            --enemyTankCount;
            this.gm.gameObjects.add(new NormalBoom(this.x, this.y, this.gm));
        }
    }

    public void moveX() {
        if (!this.good) {
            this.x += GameMediator.myTankSpeed;
            this.oldX += GameMediator.myTankSpeed;
        }
    }

    public void moveY() {
        if (!this.good) {
            this.y += GameMediator.myTankSpeed;
            this.oldY += GameMediator.myTankSpeed;
        }
    }

    public void moveXB() {
        if (!this.good) {
            this.x -= GameMediator.myTankSpeed;
            this.oldX -= GameMediator.myTankSpeed;
        }
    }

    public void moveYB() {
        if (!this.good) {
            this.y -= GameMediator.myTankSpeed;
            this.oldY -= GameMediator.myTankSpeed;
        }
    }
}

