/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.vm;

import java.util.Vector;
import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;
import se.krka.kahlua.vm.UpValue;

public class LuaThread {
    public LuaTable environment;
    public LuaThread parent;
    public String stackTrace = "";
    public Vector liveUpvalues;
    public static final int MAX_STACK_SIZE = 1000;
    public static final int INITIAL_STACK_SIZE = 10;
    private static final int MAX_CALL_FRAME_STACK_SIZE = 100;
    private static final int INITIAL_CALL_FRAME_STACK_SIZE = 10;
    public Object[] objectStack;
    public int top;
    public LuaCallFrame[] callFrameStack;
    public int callFrameTop;
    public LuaState state;
    public int expectedResults;

    public LuaThread(LuaState state, LuaTable environment) {
        this.state = state;
        this.environment = environment;
        this.objectStack = new Object[10];
        this.callFrameStack = new LuaCallFrame[10];
        this.liveUpvalues = new Vector();
    }

    public final LuaCallFrame pushNewCallFrame(LuaClosure closure, int localBase, int returnBase, int nArguments, boolean fromLua, boolean insideCoroutine) {
        this.setCallFrameStackTop(this.callFrameTop + 1);
        LuaCallFrame callFrame = this.currentCallFrame();
        callFrame.localBase = localBase;
        callFrame.returnBase = returnBase;
        callFrame.nArguments = nArguments;
        callFrame.fromLua = fromLua;
        callFrame.insideCoroutine = insideCoroutine;
        callFrame.closure = closure;
        return callFrame;
    }

    public void popCallFrame() {
        if (this.isDead()) {
            throw new RuntimeException("Stack underflow");
        }
        this.setCallFrameStackTop(this.callFrameTop - 1);
    }

    private final void ensureCallFrameStackSize(int index) {
        int oldSize;
        int newSize;
        if (index > 100) {
            throw new RuntimeException("Stack overflow");
        }
        for (newSize = oldSize = this.callFrameStack.length; newSize <= index; newSize = 2 * newSize) {
        }
        if (newSize > oldSize) {
            LuaCallFrame[] newStack = new LuaCallFrame[newSize];
            System.arraycopy(this.callFrameStack, 0, newStack, 0, oldSize);
            this.callFrameStack = newStack;
        }
    }

    public final void setCallFrameStackTop(int newTop) {
        if (newTop > this.callFrameTop) {
            this.ensureCallFrameStackSize(newTop);
        } else {
            this.callFrameStackClear(newTop, this.callFrameTop - 1);
        }
        this.callFrameTop = newTop;
    }

    private void callFrameStackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            LuaCallFrame callFrame = this.callFrameStack[startIndex];
            if (callFrame != null) {
                this.callFrameStack[startIndex].closure = null;
            }
            ++startIndex;
        }
    }

    private final void ensureStacksize(int index) {
        int oldSize;
        int newSize;
        if (index > 1000) {
            throw new RuntimeException("Stack overflow");
        }
        for (newSize = oldSize = this.objectStack.length; newSize <= index; newSize = 2 * newSize) {
        }
        if (newSize > oldSize) {
            Object[] newStack = new Object[newSize];
            System.arraycopy(this.objectStack, 0, newStack, 0, oldSize);
            this.objectStack = newStack;
        }
    }

    public final void setTop(int newTop) {
        if (this.top < newTop) {
            this.ensureStacksize(newTop);
        } else {
            this.stackClear(newTop, this.top - 1);
        }
        this.top = newTop;
    }

    public final void stackCopy(int startIndex, int destIndex, int len) {
        if (len > 0 && startIndex != destIndex) {
            System.arraycopy(this.objectStack, startIndex, this.objectStack, destIndex, len);
        }
    }

    public final void stackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            this.objectStack[startIndex] = null;
            ++startIndex;
        }
    }

    public final void closeUpvalues(int closeIndex) {
        int loopIndex = this.liveUpvalues.size();
        while (--loopIndex >= 0) {
            UpValue uv = (UpValue)this.liveUpvalues.elementAt(loopIndex);
            if (uv.index < closeIndex) {
                return;
            }
            uv.value = this.objectStack[uv.index];
            uv.thread = null;
            this.liveUpvalues.removeElementAt(loopIndex);
        }
    }

    public final UpValue findUpvalue(int scanIndex) {
        UpValue uv;
        int loopIndex = this.liveUpvalues.size();
        while (--loopIndex >= 0) {
            uv = (UpValue)this.liveUpvalues.elementAt(loopIndex);
            if (uv.index == scanIndex) {
                return uv;
            }
            if (uv.index >= scanIndex) continue;
            break;
        }
        uv = new UpValue();
        uv.thread = this;
        uv.index = scanIndex;
        this.liveUpvalues.insertElementAt(uv, loopIndex + 1);
        return uv;
    }

    public final LuaCallFrame currentCallFrame() {
        if (this.isDead()) {
            return null;
        }
        LuaCallFrame callFrame = this.callFrameStack[this.callFrameTop - 1];
        if (callFrame == null) {
            this.callFrameStack[this.callFrameTop - 1] = callFrame = new LuaCallFrame(this);
        }
        return callFrame;
    }

    public int getTop() {
        return this.top;
    }

    public LuaCallFrame getParent(int level) {
        BaseLib.luaAssert(level >= 0, "Level must be non-negative");
        int index = this.callFrameTop - level - 1;
        BaseLib.luaAssert(index >= 0, "Level too high");
        return this.callFrameStack[index];
    }

    public String getCurrentStackTrace(int level, int count, int haltAt) {
        if (level < 0) {
            level = 0;
        }
        if (count < 0) {
            count = 0;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = this.callFrameTop - 1 - level; i2 >= haltAt && count-- > 0; --i2) {
            buffer.append(this.getStackTrace(this.callFrameStack[i2]));
        }
        return buffer.toString();
    }

    public void cleanCallFrames(LuaCallFrame callerFrame) {
        LuaCallFrame frame;
        while ((frame = this.currentCallFrame()) != null && frame != callerFrame) {
            this.addStackTrace(frame);
            this.popCallFrame();
        }
    }

    public void addStackTrace(LuaCallFrame frame) {
        this.stackTrace = this.stackTrace + this.getStackTrace(frame);
    }

    private String getStackTrace(LuaCallFrame frame) {
        int pc;
        int[] lines;
        if (frame.isLua() && (lines = frame.closure.prototype.lines) != null && (pc = frame.pc - 1) >= 0 && pc < lines.length) {
            return "at " + frame.closure.prototype + ":" + lines[pc] + "\n";
        }
        return "";
    }

    public boolean isDead() {
        return this.callFrameTop == 0;
    }
}

