/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.vm;

import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;

public final class LuaTableImpl
implements LuaTable {
    private static final int MIN_CAPACITY = 16;
    private Object[] keys;
    private Object[] values;
    private int[] next;
    private int freeIndex;
    private boolean weakKeys;
    private boolean weakValues;
    private LuaTable metatable;

    private static int nearestPowerOfTwo(int x2) {
        if (x2 < 16) {
            return 16;
        }
        --x2;
        x2 |= x2 >> 1;
        x2 |= x2 >> 2;
        x2 |= x2 >> 4;
        x2 |= x2 >> 8;
        x2 |= x2 >> 16;
        return x2 + 1;
    }

    public LuaTableImpl(int capacity) {
        capacity = LuaTableImpl.nearestPowerOfTwo(capacity);
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.next = new int[capacity];
        this.freeIndex = capacity;
    }

    public LuaTableImpl() {
        this(16);
    }

    int getMP(Object key) {
        int capacity = this.keys.length;
        return LuaTableImpl.luaHashcode(key) & capacity - 1;
    }

    private final Object unref(Object o2) {
        if (!this.canBeWeakObject(o2)) {
            return o2;
        }
        return o2;
    }

    private final Object ref(Object o2) {
        if (!this.canBeWeakObject(o2)) {
            return o2;
        }
        return o2;
    }

    private boolean canBeWeakObject(Object o2) {
        return o2 != null && !(o2 instanceof String) && !(o2 instanceof Integer) && !(o2 instanceof Boolean);
    }

    final Object __getKey(int index) {
        Object key = this.keys[index];
        if (this.weakKeys) {
            return this.unref(key);
        }
        return key;
    }

    private final void __setKey(int index, Object key) {
        if (this.weakKeys) {
            key = this.ref(key);
        }
        this.keys[index] = key;
    }

    final Object __getValue(int index) {
        Object value = this.values[index];
        if (this.weakValues) {
            return this.unref(value);
        }
        return value;
    }

    final void __setValue(int index, Object value) {
        if (this.weakValues) {
            value = this.ref(value);
        }
        this.values[index] = value;
    }

    final int hash_primitiveFindKey(Object key, int index) {
        Object currentKey = this.__getKey(index);
        if (currentKey == null) {
            return -1;
        }
        if (key instanceof Integer) {
            int dkey = LuaState.fromInt(key);
            while (true) {
                int dCurrentKey;
                if (currentKey instanceof Integer && dkey == (dCurrentKey = LuaState.fromInt(currentKey))) {
                    return index;
                }
                if ((index = this.next[index]) == -1) {
                    return -1;
                }
                currentKey = this.__getKey(index);
            }
        }
        if (key instanceof String) {
            while (true) {
                if (key.equals(currentKey)) {
                    return index;
                }
                if ((index = this.next[index]) == -1) {
                    return -1;
                }
                currentKey = this.__getKey(index);
            }
        }
        while (key != currentKey) {
            if ((index = this.next[index]) == -1) {
                return -1;
            }
            currentKey = this.__getKey(index);
        }
        return index;
    }

    final int hash_primitiveNewKey(Object key, int mp) {
        Object key2 = this.__getKey(mp);
        if (key2 == null) {
            this.__setKey(mp, key);
            this.next[mp] = -1;
            return mp;
        }
        try {
            while (this.__getKey(--this.freeIndex) != null) {
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            this.hash_rehash();
            mp = this.getMP(key);
            return this.hash_primitiveNewKey(key, mp);
        }
        int mp2 = this.getMP(key2);
        if (mp2 == mp) {
            this.__setKey(this.freeIndex, key);
            this.next[this.freeIndex] = this.next[mp];
            this.next[mp] = this.freeIndex;
            return this.freeIndex;
        }
        this.keys[this.freeIndex] = this.keys[mp];
        this.values[this.freeIndex] = this.values[mp];
        this.next[this.freeIndex] = this.next[mp];
        this.__setKey(mp, key);
        this.next[mp] = -1;
        int prev = mp2;
        while (true) {
            int tmp;
            if ((tmp = this.next[prev]) == mp) break;
            prev = tmp;
        }
        this.next[prev] = this.freeIndex;
        return mp;
    }

    private void hash_rehash() {
        boolean oldWeakKeys = this.weakKeys;
        boolean oldWeakValues = this.weakValues;
        this.updateWeakSettings(false, false);
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        int n2 = oldKeys.length;
        int used = 0;
        int i2 = n2;
        while (i2-- > 0) {
            if (this.keys[i2] == null || this.values[i2] == null) continue;
            ++used;
        }
        int capacity = 2 * LuaTableImpl.nearestPowerOfTwo(used);
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
        this.next = new int[capacity];
        this.freeIndex = capacity;
        i2 = n2;
        while (i2-- > 0) {
            Object value;
            Object key = oldKeys[i2];
            if (key == null || (value = oldValues[i2]) == null) continue;
            this.rawset(key, value);
        }
        this.updateWeakSettings(oldWeakKeys, oldWeakValues);
    }

    public final void rawset(Object key, Object value) {
        LuaTableImpl.checkKey(key);
        int mp = this.getMP(key);
        int index = this.hash_primitiveFindKey(key, mp);
        if (index < 0) {
            index = this.hash_primitiveNewKey(key, mp);
        }
        this.__setValue(index, value);
    }

    public final Object rawget(Object key) {
        LuaTableImpl.checkKey(key);
        int mp = this.getMP(key);
        int index = this.hash_primitiveFindKey(key, mp);
        if (index >= 0) {
            return this.__getValue(index);
        }
        return null;
    }

    private static void checkKey(Object key) {
        BaseLib.luaAssert(key != null, "table index is nil");
        if (key instanceof Integer) {
            // empty if block
        }
    }

    public final Object next(Object key) {
        int index = 0;
        if (key != null) {
            int mp = this.getMP(key);
            index = 1 + this.hash_primitiveFindKey(key, mp);
            BaseLib.luaAssert(index > 0, "invalid key to 'next'");
        }
        while (index != this.keys.length) {
            Object next = this.__getKey(index);
            if (next != null && this.__getValue(index) != null) {
                return next;
            }
            ++index;
        }
        return null;
    }

    public final int len() {
        int high = this.keys.length;
        int low = 0;
        while (low < high) {
            int middle = high + low + 1 >> 1;
            Integer key = LuaState.toInt(middle);
            Object value = this.rawget(key);
            if (value == null) {
                high = middle - 1;
                continue;
            }
            low = middle;
        }
        return low;
    }

    public static int luaHashcode(Object a2) {
        if (a2 instanceof Integer) {
            Integer ad2 = (Integer)a2;
            int ad_primitive = LuaState.fromInt(ad2);
            if (ad_primitive == 0) {
                return 0;
            }
            return ad2.hashCode();
        }
        if (a2 instanceof String) {
            return a2.hashCode();
        }
        return System.identityHashCode(a2);
    }

    public void updateWeakSettings(boolean k2, boolean v2) {
        if (k2 != this.weakKeys) {
            this.fixWeakRefs(this.keys, k2);
            this.weakKeys = k2;
        }
        if (v2 != this.weakValues) {
            this.fixWeakRefs(this.values, v2);
            this.weakValues = v2;
        }
    }

    private void fixWeakRefs(Object[] entries, boolean weak) {
        for (int i2 = entries.length - 1; i2 >= 0; --i2) {
            Object o2 = entries[i2];
            o2 = weak ? this.ref(o2) : this.unref(o2);
            entries[i2] = o2;
        }
    }

    public LuaTable getMetatable() {
        return this.metatable;
    }

    public void setMetatable(LuaTable metatable) {
        this.metatable = metatable;
    }

    public Object rawget(int key) {
        return this.rawget(LuaState.toInt(key));
    }

    public void rawset(int key, Object value) {
        this.rawset(LuaState.toInt(key), value);
    }
}

