/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.Human;
import tjge.MainActor;

public class Flagon
extends Human {
    private int _flagonTimeTick = 0;
    public final int C_ACT_FLAGON_WAIT;
    public final int C_ACT_FLAGON_MOVING;
    public final int C_ACT_FLAGON_BROKEN;
    public int _flagonStartID;
    public int _flagonEndID;
    public boolean _flyBreak;
    boolean _trigeted = false;
    int _timeTick = 0;
    public static final int C_ACTIVE = -2;
    public static final int C_THIEF = -1;
    public static final int C_TRIGGER = 0;

    public Flagon(int n, Animation animation) {
        super(n, animation);
        this.C_ACT_FLAGON_WAIT = 0;
        this.C_ACT_FLAGON_MOVING = 1;
        this.C_ACT_FLAGON_BROKEN = 2;
        this._ownKind = 2;
    }

    protected boolean init(byte[] byArray) {
        boolean bl = super.init(byArray);
        this._flagonTimeTick = 0;
        this._relation = 3;
        this._flagonStartID = byArray[7];
        this._flagonEndID = byArray[8];
        this._boff = 5;
        this._trigeted = false;
        this._flyBreak = false;
        this._timeTick = 0;
        return bl;
    }

    public void init(int n, int n2) {
        this._x = n;
        this._y = n2;
        this._flyBreak = false;
        this._boff = 5;
        this._trigeted = false;
        this._timeTick = 0;
        this._relation = 3;
    }

    public void step() {
        if (this._action != 0) {
            super.step();
        }
    }

    public void ai() {
        Actor actor;
        if (this._flagonStartID == -1) {
            Actor actor2 = this.triggerFeedback(0);
            if (actor2 != null && (actor2._type == 6 || actor2._type == 9 || actor2._type == 5 || actor2._type == 10)) {
                actor2.disLife();
                this.changeAction(2);
                MainActor mainActor = (MainActor)this._scene.getMainActor();
                mainActor.bonus(18, 1);
            }
            if (this._action == 2 && this.isActionEnd()) {
                this.disLife();
            }
            return;
        }
        if (this._flagonStartID == -2 && this._visible && this._trigeted && this._timeTick++ > 15) {
            this._timeTick = 0;
            actor = (Flagon)this._scene.fetchActorFromPool(29, -1);
            actor.changeAction(1);
            ((Flagon)actor).init(this._x, this._y);
            actor._vx = this._flagonEndID == 0 ? 6000 : -6000;
        }
        if (this._action == 0) {
            this.checkCollideMainActor();
            actor = this._scene.getMainActor();
            if (actor._type == 9 && this.collide(actor)) {
                actor.notify(this);
            }
        } else if (this._action == 1) {
            if (this._flyBreak) {
                if (this._flagonTimeTick++ > 2) {
                    this._flagonTimeTick = 0;
                    this.changeAction(2);
                }
                return;
            }
            actor = this.checkFlagonHit();
            if (actor != null && actor._type != 29) {
                this._flagonTimeTick = 0;
                this._vx = 0;
                this.changeAction(2);
                this._loopAction = false;
            }
        } else if (this.isActionEnd()) {
            this.disLife();
        }
    }

    public int getHurtMode() {
        return 17;
    }

    public boolean notify(Actor actor) {
        if (actor._type == 16) {
            this._loopAction = false;
            this.changeAction(2);
        } else if (actor._type == 2) {
            this._gravity = 0;
            this._flyBreak = true;
            this.changeAction(1);
            if (actor._isFlip) {
                this._vx = -15360;
                this._vy = -5120;
            } else {
                this._vx = 15360;
                this._vy = -1024;
            }
            return true;
        }
        return false;
    }

    public Actor checkFlagonHit() {
        int[] nArray = new int[]{0};
        int n = -1;
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n2 = 0;
        while (n2 < nArray[0]) {
            block6: {
                Actor actor;
                block7: {
                    actor = actorArray[n2];
                    if (!actor._active || actor == this || (this._relation & actor._ownKind) == 0 || this._vx < 0 && actor._x > this._x || this._vx > 0 && actor._x < this._x || !this.collide(actor)) break block6;
                    if (actor._type != 0) break block7;
                    int n3 = actor._x - 15360;
                    int n4 = actor._x + 15360;
                    if (this._x < n3 || this._x > n4) break block6;
                }
                if (n == -1) {
                    n = n2;
                }
                if (actor.notify(this) && !this.process(actor)) break;
            }
            ++n2;
        }
        if (n >= 0) {
            return actorArray[n];
        }
        return null;
    }

    protected void startScriptCallFunction(int n, int n2, int n3) {
        if (n == 0) {
            this._timeTick = 10;
            this._trigeted = true;
        }
    }

    protected boolean endScriptCallFunction(int n, int n2, int n3) {
        return n == 0;
    }
}

