/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import koonsky.SNS.koonskySNSCenter;
import koonsky.sendMessage.SendControlCenter;
import tjge.Actor;
import tjge.Animation;
import tjge.BaiZhanTang;
import tjge.Function;
import tjge.GameMIDlet;
import tjge.MainActor;
import tjge.ProcessObject;
import tjge.Processor;
import tjge.RMS;
import tjge.Scene;
import tjge.SmsUi;
import tjge.SptSet;
import tjge.TiledBackground;

public final class GameScreen
extends FullCanvas
implements ProcessObject {
    public static final int GAME_TITLE = 0;
    public static final int GAME_LOADGLOBAL = 1;
    public static final int GAME_MENU = 2;
    public static final int GAME_LOADLEVEL = 3;
    public static final int GAME_PLAYING = 4;
    public static final int GAME_FINISHED = 5;
    public static final int GAME_OVER = 6;
    public static final int GAME_RECORD = 7;
    public static final int GAME_RECORD2 = 72;
    public static final int GAME_END = 8;
    public static final int GAME_HELP = 9;
    public static final int GAME_ABOUT = 10;
    public static final int GAME_CREDITS = 11;
    public static final int GAME_PROLOGUE = 12;
    public static final int GAME_WIN = 13;
    public static final int GAME_TIP = 14;
    public static final int GAME_SELLEVEL = 15;
    public static final int GAME_PASS_LEVEL = 16;
    public static final int GAME_LOGO = 17;
    public static final int GAME_LOSE_GAME = 18;
    public static final int GAME_INNER_MENU = 19;
    public static final int GAME_SOUND = 20;
    public static final int GAME_TIP_SOUND = 21;
    public static final int GAME_SHOW_FAMILY = 22;
    public static final int GAME_LOSE_LIFE_INT = 23;
    public static final int GAME_MEMBER = 24;
    public static final int GAME_SMS = 25;
    public static final int GAME_PROCESS_EXIT = 26;
    public static final int GAME_SNAPWAP = 33;
    public static final int KEY_RELEASED = Integer.MIN_VALUE;
    public static final int KEY_NONE = 0;
    public static final int KEY_LEFT = 1;
    public static final int KEY_RIGHT = 2;
    public static final int KEY_UP = 4;
    public static final int KEY_DOWN = 8;
    public static final int KEY_A = 16;
    public static final int KEY_JUMP_LEFT = 32;
    public static final int KEY_JUMP_UP = 4;
    public static final int KEY_JUMP_RIGHT = 128;
    public static final int KEY_WALK_LEFT = 1;
    public static final int KEY_WALK_RIGHT = 2;
    public static final int KEY_EATING = 1024;
    public static final int KEY_POINT = 8;
    public static final int KEY_USE_PROP = 4096;
    public static final int KEY_CALL_MOXIAOBEI = 8192;
    public static final int KEY_CALL_GUOFURONG = 16384;
    public static final int KEY_CALL_LIDAZUI = 32768;
    public static final int KEY_1 = 32;
    public static final int KEY_2 = 4;
    public static final int KEY_3 = 128;
    public static final int KEY_4 = 1;
    public static final int KEY_SOFT_LEFT = 262144;
    public static final int KEY_SOFT_RIGHT = 524288;
    public static final int C_CAMERA_VX = 15360;
    public static final int C_CAMERA_VY = 15360;
    public static final int C_CAMERA_W = 240;
    public static final int C_CAMERA_H = 320;
    public static final String[] INNER_MENU = new String[]{"\u8fd4\u56de\u6e38\u620f", "\u58f0\u97f3 \u5f00", "\u5e2e\u52a9", "\u8fd4\u56de\u4e3b\u83dc\u5355", "\u58f0\u97f3 \u5173"};
    public static final int C_YES = 0;
    public static final int C_NO = 1;
    public static final int C_NEXT_PAGE = 2;
    public static final int C_BACK = 3;
    public static final int C_FIRST_PAGE = 4;
    public static final int C_CONTINUE = 5;
    public static final int C_CONFIRM = 6;
    public static final String[] BUTTON = new String[]{"\u662f", "\u5426", "\u4e0b\u9875", "\u8fd4\u56de", "\u9996\u9875", "\u7ee7\u7eed", "\u786e\u5b9a"};
    public static final String[] TEXT = new String[]{"\u606d\u559c\u60a8\u901a\u5173", "\u6e38\u620f\u5931\u8d25", "\u52a0\u8f7d\u6570\u636e\u4e2d", "\u58f0\u97f3\u6a21\u5f0f", "\u751f\u547d\u6570\u52a0\u4e00"};
    public int _camx;
    public int _camy;
    public int _camw;
    public int _camh;
    public static Graphics graphics;
    public boolean _fixedMove;
    public int _camvx;
    private int _camvy;
    private int _lockCx;
    private int _lockCy;
    private int _lockL;
    private int _lockT;
    private int _lockR;
    private int _lockB;
    private boolean _lock;
    private boolean _vibrate;
    private int _vibrateTime;
    public int _loadProcess;
    public int _curLevel;
    private int _curKey;
    public int _keyInterval;
    private boolean _painting;
    private boolean _loaded;
    private boolean _continue;
    public int _state;
    public int _ticks;
    private int _menuItem;
    private int _innerMenuItem;
    private int _soundItem;
    boolean _helpFrom;
    public GameMIDlet _main;
    private Processor _processor;
    public static SmsUi smsUi;
    public static int _safeTimeTick;
    Actor _buttom = null;
    public Scene _scene;
    private String _text;
    private long _ctime;
    private long _stime;
    private static Image[] _image;
    private static Image _menu;
    private static Image _logo;
    private static SptSet _menuSpt;
    private static SptSet _closeSpt;
    private static final int MAX_KEYBUFF_SIZE = 3;
    private static int[] _keyBuff;
    private static int _keyRear;
    private static int _keyHead;
    public static final int MAX_RMS_NUM = 7;
    public static final int RMS_EXIST = 0;
    public static final int RMS_SCORE1 = 1;
    public static final int RMS_SCORE2 = 2;
    public static final int RMS_SCORE3 = 3;
    public static final int RMS_SCORE4 = 4;
    public static final int RMS_LIFENUM = 5;
    public static final int RMS_SEND_LEVELNUM = 6;
    public static RMS _feeRMS;
    public static byte[] data;
    static Font _font;
    static Graphics _graphics;
    public static boolean _canRewrite;
    int _passLeveltime = 0;
    int _drawMoneyNum = 0;
    int _drawEnemyNum = 0;
    boolean _lifeMoneyAdded = false;
    boolean _lifeEnemyAdded = false;
    private Image muzhi;
    private Image muzhi1;
    public static int isLifeTip;
    public static final int firstColor = 0;
    public static final int secondColor = 15724504;
    public static final int thirdColor = 255;
    private static final int[][] menu_pos;
    private static final int[] menu_index;
    private static final int[] menu_text_index;
    public boolean _questionVictory = false;
    private static int _scc;
    static String str;
    static final String[][] title;
    private int _moneyPrecent;
    private int _enemyPrecent;
    private String _moneyStr;
    private String _enemyStr;
    private boolean _pallLevelIni;
    private int left;
    private int right;
    private static String menuurl;
    private static String menuur2;
    private final String snap_url;
    public static boolean pay;
    public static final int PAYSUCC = 180;
    public static final int PAYFAIL = 280;
    public static final int NONE = 380;
    public static int buytype;
    public static int payres;
    public boolean _overGameBool = false;
    public static boolean buylevel;
    public static boolean buylife;
    SendControlCenter send;
    public static final String GAME_ID = "059004";

    public GameScreen(GameMIDlet gameMIDlet) {
        this.snap_url = "http://yx.d.cn/wml/pdcs.jw?act=index&id=58";
        this._main = gameMIDlet;
        this._painting = false;
        this._state = 0;
        this._camw = 245760;
        this._camh = 320 - TiledBackground.C_MAP_OFF_Y << 10;
        smsUi = new SmsUi(this);
        _feeRMS = new RMS("three", 1);
        data = _feeRMS.loadDataFromRMS(1);
        System.out.println(data[0]);
        if (data[0] == 0) {
            data = new byte[7];
            GameScreen.data[0] = 1;
            GameScreen.data[1] = 0;
            GameScreen.data[2] = 0;
            GameScreen.data[3] = 0;
            GameScreen.data[4] = 0;
            GameScreen.data[5] = 0;
            GameScreen.data[6] = 0;
            _feeRMS.saveDataToRMS(data, 1);
        } else {
            GameScreen.smsUi._sendNumlevel = data[6];
        }
        this.send = SendControlCenter.getInstance(this._main, GAME_ID);
    }

    public int getLockScreenPos(int n) {
        if (!TiledBackground._isFull) {
            return n + (TiledBackground.C_MAP_OFF_Y << 10);
        }
        return n;
    }

    public void process(int n, int n2) {
        switch (n) {
            case 0: {
                this.processLoadGlobal();
                break;
            }
            case 1: {
                this.processLoadLevel(this._curLevel);
            }
        }
        this._processor.disposeProcessor();
        this._processor = null;
    }

    public void lockCamera() {
        this._lock = true;
        this._lockCx = this._camx;
        this._lockCy = this._camy;
    }

    public void lockCamera(int n, int n2) {
        this._lock = true;
        this._lockCx = n;
        this._lockCy = this.getLockScreenPos(n2);
        this._lockL = -1;
        this._lockT = -1;
        this._lockR = -1;
        this._lockB = -1;
    }

    public void lockCamera(int n, int n2, int n3, int n4) {
        this._lock = true;
        this._lockL = n << 10;
        this._lockT = n2 << 10;
        this._lockR = n3 << 10;
        this._lockB = n4 << 10;
        this._lockCx = -1;
        this._lockCy = -1;
    }

    public void unlockCamera() {
        this._lock = false;
    }

    public boolean isCameraLocked() {
        return this._lock;
    }

    public void vibrateCamera() {
        this._vibrate = true;
        this._vibrateTime = 4;
    }

    public void vibrateCamera(int n) {
        this._vibrate = true;
        this._vibrateTime = n;
    }

    public boolean isVibrateCamera() {
        return this._vibrate;
    }

    public boolean isLockCamera() {
        return this._lock;
    }

    public boolean isStableCamera() {
        Actor actor = this._scene.getFocusActor();
        int n = actor.getXDirLocation(this._camw);
        int n2 = actor.getYDirLocation(this._camh);
        n >>= 10;
        n2 >>= 10;
        n = Math.min(n, this._scene.getWidth() - 240 - 1);
        n = Math.max(n, 0);
        n2 = Math.min(n2, this._scene.getHeight() - 320 + TiledBackground.C_MAP_OFF_Y - 1);
        n2 = Math.max(n2, 0);
        return (n <<= 10) == this._camx && (n2 <<= 10) == this._camy;
    }

    public void paint(Graphics graphics) {
        ++this._ticks;
        this._painting = true;
        _font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(_font);
        _graphics = graphics;
        switch (this._state) {
            case 0: {
                this.gameTitle(graphics);
                break;
            }
            case 17: {
                this.gameLogo(graphics);
                break;
            }
            case 7: {
                this.gameRecord(graphics);
                break;
            }
            case 72: {
                this.gameRecord2(graphics);
                break;
            }
            case 1: {
                this.gameLoadGlobal(graphics);
                break;
            }
            case 21: {
                this.gameTipSound(graphics);
                break;
            }
            case 20: {
                this.gameSound(graphics);
                break;
            }
            case 2: {
                this.gameMenu(graphics);
                break;
            }
            case 19: {
                this.gameInnerMenu(graphics);
                break;
            }
            case 15: {
                this.gameSelLevel(graphics);
                break;
            }
            case 3: {
                this.gameLoading(graphics);
                break;
            }
            case 4: {
                try {
                    this._scene.update();
                    this._scene.paint(graphics);
                }
                catch (Exception exception) {
                    graphics.setColor(0);
                    graphics.clipRect(0, 0, 240, 320);
                    graphics.drawString("" + exception, 20, 50, 0);
                }
                break;
            }
            case 9: 
            case 10: 
            case 24: {
                this.gameHelpAbout(graphics);
                break;
            }
            case 16: {
                if (!this._pallLevelIni) {
                    this.initPassLevel();
                    this._pallLevelIni = true;
                }
                if (!this.passLevel(graphics)) break;
                smsUi.start();
                smsUi.initTip("", "\u7ee7\u7eed", "");
                smsUi.setState(1);
                this.resetKeyBuff();
                break;
            }
            case 18: {
                this.GameOver(graphics, TEXT[1]);
                break;
            }
            case 22: {
                this.gameShowFamily(graphics);
                break;
            }
            case 13: {
                this.GameOver(graphics, TEXT[0]);
                this._overGameBool = true;
                break;
            }
            case 23: {
                this._scene.startup(true);
                this._state = 4;
                break;
            }
            case 25: {
                smsUi.draw(graphics);
                smsUi.upDate();
                break;
            }
            case 26: {
                this.gameExit(graphics);
            }
        }
        this._painting = false;
    }

    private void gameRecord2(Graphics graphics) {
        this.drawMenuBack(graphics, BUTTON[6], null);
        Function.draw3DString(graphics, "\u6682\u65e0\u8bb0\u5f55", 120, 160, 1 | 0x10, 0, 15724504);
        int n = this.consumeKey();
        if (n == 262144) {
            this.initMenuItem(1);
        }
    }

    private void gameRecord(Graphics graphics) {
        this.drawMenuBack(graphics, BUTTON[0], BUTTON[1]);
        Function.draw3DString(graphics, "\u662f\u5426\u8986\u76d6\u5b58\u6863", 120, 160, 1 | 0x10, 0, 15724504);
        int n = this.consumeKey();
        if (n == 262144) {
            this._curLevel = 0;
            _canRewrite = true;
            Scene.writeRecord(0, 0, 0);
            smsUi.clearSaves();
            if (this._processor == null) {
                this._processor = Processor.createProcessor(this, 1);
            } else {
                this._processor.setProcessID(1);
            }
            this._processor.startupProcessor();
            this._state = 3;
            MainActor._lifeNum = 0;
            isLifeTip = 0;
        } else if (n == 524288) {
            this.initMenuItem(0);
        }
    }

    private void initPassLevel() {
        if (Scene._totalMoney == 0 || Scene._totalEnemy == 0) {
            return;
        }
        if (MainActor._moneyNum > Scene._totalMoney) {
            MainActor._moneyNum = Scene._totalMoney;
        }
        if (MainActor._enemyNum > Scene._totalEnemy) {
            MainActor._enemyNum = Scene._totalEnemy;
        }
        if (this._curLevel == 5) {
            MainActor._enemyNum = Scene._totalEnemy;
        }
        this._moneyPrecent = MainActor._moneyNum * 100 / Scene._totalMoney;
        this._enemyPrecent = MainActor._enemyNum * 100 / Scene._totalEnemy;
        this._moneyStr = "";
        this._enemyStr = "";
        if (this._moneyPrecent == 100) {
            this._moneyStr = "\u55dc\u8d22\u5982\u547d";
        } else {
            this._lifeMoneyAdded = false;
            this._moneyStr = this._moneyPrecent < 80 ? "\u4ed7\u4e49\u758f\u8d22" : "\u94e2\u9531\u5fc5\u8ba1";
        }
        if (this._enemyPrecent == 100) {
            this._enemyStr = "\u5ac9\u6076\u5982\u4ec7";
        } else {
            this._lifeEnemyAdded = false;
            this._enemyStr = this._enemyPrecent < 80 ? "\u5b85\u5fc3\u4ec1\u539a" : "\u4fa0\u809d\u4e49\u80c6";
        }
        if (MainActor._lifeNum > 9) {
            MainActor._lifeNum = 9;
        }
    }

    private boolean passLevel(Graphics graphics) {
        if (this._curLevel > 6) {
            return true;
        }
        int n = 0;
        int n2 = 15724504;
        int n3 = 40;
        int n4 = 30;
        int n5 = 100;
        int n6 = 60;
        int n7 = 40;
        this.drawLoadBackGround(graphics, null, null);
        graphics.setClip(0, 0, 240, 320);
        Function.draw3DString(graphics, "\u91d1\u94b1\u767e\u5206\u6bd4", n3, n4, 0, n, n2);
        if (this._loadProcess > 1) {
            if (this._drawMoneyNum < 10) {
                Function.drawNumber(graphics, 240 - n6, n4 + 2, this._drawMoneyNum++ * this._moneyPrecent / 10, false, false);
                this.drawPrecent(graphics, 240 - n6, n4 + 2 + 2);
            } else {
                Function.drawNumber(graphics, 240 - n6, n4 + 2, this._moneyPrecent, false, false);
                this.drawPrecent(graphics, 240 - n6, n4 + 2 + 2);
                graphics.setClip(0, 0, 240, 320);
                Function.draw3DString(graphics, "\u8bc4\u4ef7:", n3, n4 + n7, 0, n, n2);
                Function.draw3DString(graphics, this._moneyStr, 240 - n6 - 30, n4 + n7, 8 | 0x10, n, n2);
                if (this._lifeMoneyAdded) {
                    if (this._loadProcess > 15) {
                        Function.draw3DString(graphics, TEXT[4], 120, n4 + n7 * 2, 0x10 | 1, n, n2);
                    } else if (this._loadProcess % 2 == 0) {
                        Function.playSound(1, 1);
                        Function.draw3DString(graphics, TEXT[4], 120, n4 + n7 * 2, 0x10 | 1, n, n2);
                    }
                }
            }
        }
        if (this._loadProcess > 15) {
            Function.draw3DString(graphics, "\u6740\u654c\u767e\u5206\u6bd4", n3, n4 + n5, 0, n, n2);
            if (this._drawEnemyNum < 10) {
                Function.drawNumber(graphics, 240 - n6, n4 + n5 + 2, this._drawEnemyNum++ * this._enemyPrecent / 10, false, false);
                this.drawPrecent(graphics, 240 - n6, n4 + n5 + 2 + 2);
            } else {
                Function.drawNumber(graphics, 240 - n6, n4 + n5 + 2, this._enemyPrecent, false, false);
                this.drawPrecent(graphics, 240 - n6, n4 + n5 + 2 + 2);
                graphics.setClip(0, 0, 240, 320);
                Function.draw3DString(graphics, "\u8bc4\u4ef7:", n3, n4 + n5 + n7, 0, n, n2);
                Function.draw3DString(graphics, this._enemyStr, 240 - n6 - 30, n4 + n5 + n7, 8 | 0x10, n, n2);
                if (this._lifeEnemyAdded) {
                    if (this._loadProcess > 30) {
                        Function.draw3DString(graphics, TEXT[4], 120, n4 + n5 + n7 * 2, 0x10 | 1, n, n2);
                    } else if (this._loadProcess % 2 == 0) {
                        Function.playSound(1, 1);
                        Function.draw3DString(graphics, TEXT[4], 120, n4 + n5 + n7 * 2, 0x10 | 1, n, n2);
                    }
                }
            }
        }
        if (this._loadProcess > 30) {
            Function.draw3DString(graphics, "\u7ee7\u7eed", 8, 290, 0, n, n2);
            int n8 = this.consumeKey();
            return n8 == 262144;
        }
        ++this._loadProcess;
        return false;
    }

    private void drawPrecent(Graphics graphics, int n, int n2) {
        SptSet sptSet = SptSet.getSptSet(10);
        sptSet.draw(graphics, n + 2, n2, 1);
    }

    private void gameLoadGlobal(Graphics graphics) {
        this.drawMenuBack(graphics, null, null);
        Function.draw3DString(graphics, TEXT[2], 120, 160, 1 | 0x10, 0, 15724504);
        _scc = Scene._loading * 130 / 15;
        this.drawProcessBar(graphics, _scc);
        if (this._loaded) {
            this._state = 21;
            this.resetKeyBuff();
        }
    }

    public void initCamera() {
        Actor actor = this._scene.getFocusActor();
        this._camh = 320 - TiledBackground.C_MAP_OFF_Y << 10;
        this._camx = actor.getXDirLocation(this._camw);
        this._camy = actor.getYDirLocation(this._camh);
        this._lock = false;
        this._camvy = 0;
        this._camvx = 0;
        this.validateCamera();
    }

    public void updateCamera() {
        Actor actor = this._scene.getFocusActor();
        int n = 0;
        int n2 = 0;
        if (this._lock) {
            if (this._lockCx > -1) {
                n = this._lockCx;
                n2 = this._lockCy;
            } else {
                n = actor.getXDirLocation(this._camw);
                n2 = actor.getYDirLocation(this._camh);
                if (n < this._lockL) {
                    n = this._lockL;
                } else if (this._lockR - n < this._camw) {
                    n = this._lockR - this._camw;
                }
                if (n2 < this._lockT) {
                    n2 = this._lockT;
                } else if (this._lockB - n2 < this._camh) {
                    n2 = this._lockB - this._camh;
                }
            }
        } else {
            n = actor.getXDirLocation(this._camw);
            n2 = actor.getYDirLocation(this._camh);
        }
        if (this._vibrate) {
            int n3 = -4096;
            if (this._vibrateTime % 2 > 0) {
                n3 = -n3;
            }
            n2 += n3;
            if (--this._vibrateTime < 1) {
                this._vibrate = false;
            }
        }
        this._camvy = 0;
        this._camvx = 0;
        if (this._camx < n) {
            if (n - this._camx > 15360) {
                this._camvx = 15360;
            } else {
                this._camx = n;
            }
        } else if (this._camx > n) {
            if (this._camx - n > 15360) {
                this._camvx = -15360;
            } else {
                this._camx = n;
            }
        }
        if (this._camy < n2) {
            if (n2 - this._camy > 15360) {
                this._camvy = 15360;
            } else {
                this._camy = n2;
            }
        } else if (this._camy > n2) {
            if (this._camy - n2 > 15360) {
                this._camvy = -15360;
            } else {
                this._camy = n2;
            }
        }
        if (this._fixedMove) {
            this._camvx = 5120;
        }
        Actor actor2 = this._scene.getFocusActor();
        if (actor2._type == 16) {
            this._camx = actor.getXDirLocation(this._camw);
            this._camy = actor.getYDirLocation(this._camh);
        } else {
            this._camx += this._camvx;
            this._camy += this._camvy;
        }
        this.validateCamera();
    }

    private void validateCamera() {
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        n = Math.min(n, this._scene.getWidth() - 240 - 1);
        n = Math.max(n, 0);
        n2 = Math.min(n2, this._scene.getHeight() - (320 - TiledBackground.C_MAP_OFF_Y) - 1);
        n2 = Math.max(n2, 0);
        this._camx = n << 10;
        this._camy = n2 << 10;
    }

    public void loadGlobal() {
        Function.createGameDatabase();
        Function.loadGameReocrd();
        Function.createSound(4);
    }

    private void gameTitle(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        if (this._loadProcess == 0) {
            this.loadGlobal();
            try {
                this.muzhi = Image.createImage((String)"/res/koon.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            _logo = Function.loadPng("/res/apng.bin", 38);
            ++this._loadProcess;
            this._stime = System.currentTimeMillis();
        } else if (this._loadProcess == 1) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, 240, 320);
            graphics.drawImage(this.muzhi, 120 - this.muzhi.getWidth() / 2, 160 - this.muzhi.getHeight() / 2, 0x10 | 4);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                this._loadProcess = 4;
                this._stime = System.currentTimeMillis();
                this.muzhi = null;
            }
        } else if (this._loadProcess == 2) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 240, 320);
            graphics.drawImage(this.muzhi1, 120 - this.muzhi1.getWidth() / 2, 160 - this.muzhi1.getHeight() / 2, 0x10 | 4);
            graphics.setColor(238, 25, 33);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                this._loadProcess = 4;
                this._stime = System.currentTimeMillis();
                this.muzhi1 = null;
            }
        } else if (this._loadProcess != 3 && this._loadProcess == 4) {
            GameScreen.graphics = graphics;
            this.callEnterGame();
        }
    }

    private void callEnterGame() {
        this._loadProcess = 0;
        this._state = 17;
    }

    private void processLoadGlobal() {
        Scene.loadGlobal();
        this._curLevel = 0;
        this._loadProcess = 0;
        this._continue = false;
        this.resetKeyBuff();
        this._buttom = Scene.getGoubleActor(44, 0);
        this._buttom.changeAction(0);
        this._buttom._loopAction = true;
        this._loaded = true;
    }

    private void drawMenuBack(Graphics graphics, String string, String string2) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 240, 320);
        graphics.drawImage(_menu, 0, (320 - _menu.getHeight()) / 2, 4 | 0x10);
        int n = 8;
        int n2 = 290;
        int n3 = 240 - n;
        if (string != null) {
            Function.draw3DString(graphics, string, n, n2, 4 | 0x10, 0, 15724504);
        }
        if (string2 != null) {
            Function.draw3DString(graphics, string2, n3, n2, 8 | 0x10, 0, 15724504);
        }
    }

    public void drawLoadBackGround(Graphics graphics, String string, String string2) {
        SptSet sptSet = Scene._panel;
        int n = 0;
        int n2 = 320 - sptSet.getSptHeight(14);
        Function.fillScreen(graphics, 0, 0, 240, 320, 13385);
        n = 0;
        while (n <= 320) {
            sptSet.draw(graphics, n, 0, 13);
            sptSet.draw(graphics, n, n2, 14);
            n += sptSet.getSptWidth(13);
        }
        n = 240 - sptSet.getSptWidth(12);
        n2 = 0;
        while (n2 <= 320) {
            sptSet.draw(graphics, 0, n2, 11);
            sptSet.draw(graphics, n, n2, 12);
            n2 += sptSet.getSptWidth(12);
        }
        sptSet.draw(graphics, 0, 0, 9);
        sptSet.draw(graphics, 240 - sptSet.getSptWidth(10), 320 - sptSet.getSptHeight(10), 10);
        sptSet.draw(graphics, 0, 320 - sptSet.getSptHeight(15), 15);
        sptSet.draw(graphics, 240 - sptSet.getSptWidth(16), 0, 16);
        graphics.setClip(0, 0, 240, 320);
        if (string != null) {
            Function.draw3DString(graphics, string, 8, 295, 4 | 0x10, 0, 15724504);
        }
        if (string2 != null) {
            Function.draw3DString(graphics, string2, 215, 298, 8 | 0x10, 0, 15724504);
        }
    }

    private void drawProcessBar(Graphics graphics, int n) {
        SptSet sptSet = Scene._panel;
        int n2 = 120 - sptSet.getSptWidth(17) / 2;
        int n3 = 320 - sptSet.getSptHeight(17) - 20;
        sptSet.draw(graphics, n2, n3, 17);
        int n4 = n2 + 11;
        int n5 = n3 + 5;
        graphics.setClip(n4, n5, 130, 3);
        graphics.setColor(255, 144, 0);
        graphics.drawLine(n4, n5, n4 + n, n5);
        graphics.setColor(255, 216, 0);
        graphics.drawLine(n4, n5 + 1, n4 + n, n5 + 1);
        graphics.setColor(190, 107, 0);
        graphics.drawLine(n4, n5 + 2, n4 + n, n5 + 2);
    }

    public void initMenuItem(int n) {
        this._menuItem = n;
        this._state = 2;
    }

    public void initInnerMenuItem(int n) {
        this._menuItem = n;
        this._state = 19;
    }

    private void drawAX(Graphics graphics) {
        int n = 10;
        int n2 = 20;
        graphics.clipRect(0, 0, 240, 320);
        _closeSpt.draw(graphics, n, n2, 0);
        n += _closeSpt.getSptWidth(0);
        while (n < 240 - _closeSpt.getSptWidth(2) - 10) {
            _closeSpt.draw(graphics, n, n2 + 10, 2);
            n += _closeSpt.getSptWidth(2);
        }
        n = 240 - _closeSpt.getSptWidth(1) - 10;
        _closeSpt.draw(graphics, n, n2, 1);
        int n3 = _closeSpt.getSptWidth(0) + 17;
        int n4 = n2 + 10 + 7;
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(239, 239, 216);
        graphics.fillRect(n3, n4, 240 - (n3 << 1), 72);
    }

    private void gameLogo(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        graphics.drawImage(_logo, (240 - _logo.getWidth()) / 2, 160 - _logo.getHeight(), 0);
        if (this._loadProcess++ > 20) {
            _logo = null;
            _menu = Function.loadPng("/res/bpng.bin", 2);
            _menuSpt = SptSet.load(37, 1);
            _closeSpt = SptSet.load(36, 1);
            Scene.loadInfoData();
            this.startLoading(0);
        }
    }

    private void gameTipSound(Graphics graphics) {
        this.drawMenuBack(graphics, BUTTON[0], BUTTON[1]);
        Function.draw3DString(graphics, "\u662f\u5426\u64ad\u653e\u58f0\u97f3", 120, 160, 1 | 0x10, 0, 15724504);
        int n = this.consumeKey();
        if (n == 262144) {
            this.resetKeyBuff();
            if (Function.readRecord(0) == 0) {
                Function.writeRecord(0, 1);
            }
            Function.playSound(0, 1);
            this.initMenuItem(0);
        } else if (n == 524288) {
            this.resetKeyBuff();
            Function.writeRecord(0, 0);
            this.initMenuItem(0);
        }
    }

    private void gameSound(Graphics graphics) {
        int n;
        this.drawMenuBack(graphics, BUTTON[6], BUTTON[3]);
        Function.draw3DString(graphics, TEXT[3], 120, 30, 1 | 0x10, 0, 15724504);
        int n2 = 0;
        while (n2 < 2) {
            String string = n2 == 0 ? INNER_MENU[4] : INNER_MENU[1];
            n = n2 == this._soundItem ? 255 : 0;
            Function.draw3DString(graphics, string, 120, 60 + n2 * 20, 1 | 0x10, n, 15724504);
            ++n2;
        }
        n = this.consumeKey();
        boolean bl = false;
        if (n == 262144) {
            Function.writeRecord(0, (byte)this._soundItem);
            bl = true;
        } else if (n == 524288) {
            bl = true;
        } else if (n == 4) {
            --this._soundItem;
            if (this._soundItem < 0) {
                this._soundItem = 0;
            }
        } else if (n == 8) {
            ++this._soundItem;
            if (this._soundItem >= 2) {
                this._soundItem = 1;
            }
        }
        if (bl) {
            this.resetKeyBuff();
            this.initMenuItem(0);
        }
    }

    private void gameMenu(Graphics graphics) {
        this.drawMenuBack(graphics, null, null);
        this.drawMouse(graphics);
        int n = this.consumeKey();
        if (n == 4) {
            --this._menuItem;
            if (this._menuItem < 0) {
                this._menuItem = 0;
            }
        } else if (n == 8) {
            ++this._menuItem;
            if (this._menuItem >= 7) {
                this._menuItem = 6;
            }
        } else if (n == 1) {
            int n2 = this._menuItem - 4;
            if (n2 >= 0) {
                this._menuItem = n2;
            }
        } else if (n == 2) {
            int n3 = this._menuItem + 4;
            if (n3 < 7) {
                this._menuItem = n3;
            }
        } else if (n == 16 || n == 262144) {
            this.resetKeyBuff();
            System.out.println("_menuItem " + this._menuItem);
            switch (this._menuItem) {
                case 0: {
                    if (Function.readRecord(1) != 0) {
                        this._state = 7;
                        break;
                    }
                    smsUi.clearSaves();
                    _canRewrite = true;
                    this._curLevel = 0;
                    this._loadProcess = 0;
                    _scc = 0;
                    if (this._processor == null) {
                        this._processor = Processor.createProcessor(this, 1);
                    } else {
                        this._processor.setProcessID(1);
                    }
                    this._processor.startupProcessor();
                    this._state = 3;
                    MainActor._lifeNum = 0;
                    break;
                }
                case 1: {
                    if (Function.readRecord(1) == 0) {
                        this._state = 72;
                        break;
                    }
                    _canRewrite = true;
                    this._curLevel = Function.readRecord(1);
                    this._loadProcess = 0;
                    _scc = 0;
                    if (this._processor == null) {
                        this._processor = Processor.createProcessor(this, 1);
                    } else {
                        this._processor.setProcessID(1);
                    }
                    this._processor.startupProcessor();
                    this._state = 3;
                    byte[] byArray = _feeRMS.loadDataFromRMS(1);
                    MainActor._lifeNum = 0;
                    isLifeTip = byArray[5];
                    smsUi.loadSaves();
                    break;
                }
                case 2: {
                    this._state = 20;
                    this.resetKeyBuff();
                    break;
                }
                case 3: {
                    this._text = Function.loadSpecialText("/res/string.bin", 0);
                    this._loadProcess = 0;
                    this._state = 9;
                    this._helpFrom = true;
                    break;
                }
                case 4: {
                    this._text = Function.loadSpecialText("/res/string.bin", 1);
                    this._loadProcess = 0;
                    this._state = 10;
                    this._helpFrom = true;
                    break;
                }
                case 5: {
                    try {
                        koonskySNSCenter.showkoonskySNS(this._main, (Displayable)this, "\u6b66\u6797\u5916\u4f20", 2, GAME_ID, this._overGameBool);
                    }
                    catch (Exception exception) {
                        System.out.println("asdfasdf");
                    }
                    break;
                }
                case 6: {
                    this._main.notifyDestroyed();
                }
            }
        }
    }

    private void gameInnerMenu(Graphics graphics) {
        int n;
        this.drawMenuBack(graphics, null, null);
        int n2 = INNER_MENU.length - 1;
        int n3 = 0;
        while (n3 < n2) {
            String string = n3 == 1 ? (Function.readRecord(0) > 0 ? INNER_MENU[1] : INNER_MENU[4]) : INNER_MENU[n3];
            n = n3 == this._innerMenuItem ? 255 : 0;
            Function.draw3DString(graphics, string, 120, 50 + n3 * 20, 1 | 0x10, n, 15724504);
            ++n3;
        }
        n = this.consumeKey();
        switch (n) {
            case 4: {
                --this._innerMenuItem;
                if (this._innerMenuItem >= 0) break;
                this._innerMenuItem = 0;
                break;
            }
            case 8: {
                ++this._innerMenuItem;
                if (this._innerMenuItem < n2) break;
                this._innerMenuItem = n2 - 1;
                break;
            }
            case 16: 
            case 262144: {
                this.resetKeyBuff();
                if (this._innerMenuItem == 0) {
                    this._state = 4;
                    break;
                }
                if (this._innerMenuItem == 1) {
                    int n4 = Function.readRecord(0);
                    if (n4 == 0) {
                        Function.writeRecord(0, 1);
                        break;
                    }
                    Function.writeRecord(0, 0);
                    break;
                }
                if (this._innerMenuItem == 2) {
                    this._text = Function.loadSpecialText("/res/string.bin", 0);
                    this._helpFrom = false;
                    this._loadProcess = 0;
                    this._state = 9;
                    break;
                }
                if (this._innerMenuItem != 3) break;
                this.initMenuItem(0);
            }
        }
    }

    private void drawMouse(Graphics graphics) {
        int n = 0;
        int n2 = 320 - _menuSpt.getSptHeight(15);
        _menuSpt.draw(graphics, n, n2, 15);
        n2 = 320 - _menuSpt.getSptHeight(16);
        n = _menuSpt.getSptWidth(15);
        while (n < 240) {
            _menuSpt.draw(graphics, n, n2, 16);
            n += _menuSpt.getSptWidth(16);
        }
        n = 240 - _menuSpt.getSptWidth(17);
        _menuSpt.draw(graphics, n, n2, 17);
        int n3 = 0;
        while (n3 < menu_pos.length) {
            _menuSpt.draw(graphics, menu_pos[n3][0] - 12, menu_pos[n3][1] - 12, menu_index[n3]);
            _menuSpt.draw(graphics, menu_pos[n3][0] - _menuSpt.getSptWidth(menu_text_index[n3]) / 2, menu_pos[n3][1] + 15, menu_text_index[n3]);
            ++n3;
        }
        int n4 = this._ticks % 8 / 2;
        _menuSpt.draw(graphics, menu_pos[this._menuItem][0] - n4, menu_pos[this._menuItem][1] - n4, 14);
    }

    private void gameSelLevel(Graphics graphics) {
        Function.drawFrame(graphics, false, false);
        graphics.setColor(0xFF0000);
        graphics.drawString("Level: " + this._curLevel, 120, 160, 1 | 0x10);
        int n = this.consumeKey();
        switch (n) {
            case 4: {
                --this._curLevel;
                if (this._curLevel >= 0) break;
                this._curLevel = 0;
                break;
            }
            case 8: {
                ++this._curLevel;
                break;
            }
            case 16: {
                this.startLoading(1);
                MainActor._lifeNum = 0;
            }
        }
    }

    public void nextLevel(Graphics graphics) {
        if (this._curLevel >= 8) {
            this._state = 22;
            this._loadProcess = 0;
            this.resetKeyBuff();
            return;
        }
        if (this._curLevel == 7 && this._questionVictory) {
            ++this._curLevel;
        }
        ++this._curLevel;
        this.startLoading(1);
    }

    public void startLoading(int n) {
        this._loaded = false;
        this._loadProcess = 0;
        Scene._loading = 0;
        if (this._processor == null) {
            this._processor = Processor.createProcessor(this, n);
        } else {
            this._processor.setProcessID(n);
        }
        this._processor.startupProcessor();
        this._state = n == 1 ? 3 : 1;
    }

    private void gameShowFamily(Graphics graphics) {
        this._state = 13;
    }

    private void GameOver(Graphics graphics, String string) {
        this.drawMenuBack(graphics, BUTTON[5], null);
        Function.draw3DString(graphics, string, 120, 160, 1 | 0x10, 0, 15724504);
        int n = this.consumeKey();
        if (n == 262144) {
            this.initMenuItem(0);
            this.resetKeyBuff();
        }
    }

    public void gameLoading(Graphics graphics) {
        try {
            int n = 120;
            int n2 = 65;
            int n3 = 85;
            int n4 = 0xFFFFFF;
            int n5 = 0x669966;
            this.drawMenuBack(graphics, null, null);
            this.drawAX(graphics);
            this.drawChinese(graphics, this._curLevel);
            graphics.setClip(0, 0, 240, 320);
            Function.draw3DString(graphics, title[this._curLevel][0], n, n2, 1 | 0x10, n4, n5);
            Function.draw3DString(graphics, title[this._curLevel][1], n, n3, 1 | 0x10, n4, n5);
            n4 = 0;
            n5 = 15724504;
            Function.draw3DString(graphics, TEXT[2], 120, 260, 1 | 0x10, n4, n5);
            _scc = Scene._loading * 130 / 58;
            this.drawProcessBar(graphics, _scc);
            System.out.println(this._loaded);
            if (this._loaded) {
                smsUi.restartTime();
                this._state = 4;
                this.resetCurKey();
                if (isLifeTip == 1) {
                    smsUi.start();
                    pay = true;
                    smsUi.setState(0);
                    smsUi.initTip(SmsUi.tipText[0], "\u7ee7\u7eed", "\u8fd4\u56de");
                    this.resetKeyBuff();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("sss");
        }
    }

    private void drawChinese(Graphics graphics, int n) {
        int n2 = 80;
        int n3 = 40;
        graphics.setClip(0, 0, 240, 320);
        _closeSpt.draw(graphics, n2, n3, 3);
        if (n == 9) {
            --n;
        }
        _closeSpt.draw(graphics, n2 += 30, n3, n + 5);
        _closeSpt.draw(graphics, n2 += 30, n3, 4);
    }

    public void processLoadLevel(int n) {
        this._loaded = false;
        if (this._continue) {
            if (Scene._id == n) {
                this._scene.reset();
            } else {
                Animation.resetLoadState();
                this._scene.dispose();
                this._scene = Scene.load(this, n);
                Animation.disposeLocal();
            }
        } else {
            this._scene = Scene.load(this, n);
        }
        this._scene.startup(false);
        this._continue = true;
        this._loaded = true;
    }

    private void gameHelpAbout(Graphics graphics) {
        String string = null;
        if (Function._lines > Function._pageLines) {
            string = BUTTON[2];
        }
        this.drawLoadBackGround(graphics, string, BUTTON[3]);
        graphics.setColor(135, 112, 83);
        graphics.setClip(0, 0, 240, 320);
        boolean bl = Function.drawString(graphics, this._text, this._loadProcess, Function._pageLines, Function._xff, Function._yff, Function._pitchLine, 4 | 0x10);
        int n = this.consumeKey();
        if (n == 262144) {
            this._loadProcess = bl ? 0 : (this._loadProcess += Function._pageLines);
            this.resetKeyBuff();
        } else if (n == 524288) {
            this._loadProcess = 0;
            if (this._helpFrom) {
                this.initMenuItem(this._menuItem);
            } else {
                this.initInnerMenuItem(this._innerMenuItem);
            }
            this._text = null;
            this.resetKeyBuff();
        }
    }

    private int translateKeyCode(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 4;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 8;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 1;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 2;
                break;
            }
            case -5: 
            case 53: {
                n2 = 16;
                break;
            }
            case 48: {
                n2 = 16384;
                break;
            }
            case 49: {
                n2 = 32;
                break;
            }
            case 51: {
                n2 = 128;
                break;
            }
            case 55: {
                n2 = 1024;
                break;
            }
            case 57: {
                n2 = 4096;
                break;
            }
            case 42: {
                n2 = 8192;
                break;
            }
            case 35: {
                n2 = 32768;
                break;
            }
            case -6: {
                n2 = 262144;
                break;
            }
            case -7: {
                n2 = 524288;
            }
        }
        return n2;
    }

    public void keyPressed(int n) {
        if (n == -6 || n == -7) {
            this.left = -6;
            this.right = -7;
        }
        if (n == -21 || n == -22) {
            this.left = -21;
            this.right = -22;
        }
        if (n == 21 || n == 22) {
            this.left = 21;
            this.right = 22;
        }
        this._curKey = this.translateKeyCode(n);
        if (this._curKey == 262144) {
            if (this._curLevel == 1) {
                if (this._state == 4) {
                    this.initInnerMenuItem(0);
                    this.resetKeyBuff();
                    return;
                }
            } else if (this._state == 4 && ((BaiZhanTang)this._scene.getFocusActor())._hp > 0) {
                this.initInnerMenuItem(0);
                this.resetKeyBuff();
                return;
            }
        }
        this.produceKey(this._curKey);
    }

    public void keyReleased(int n) {
        this._curKey = 0;
        this._keyInterval = 0;
    }

    protected void resetKeyBuff() {
        this._curKey = 0;
        _keyHead = 0;
        _keyRear = 0;
    }

    protected void produceKey(int n) {
        GameScreen._keyBuff[GameScreen._keyRear] = n;
        if (++_keyRear >= 3) {
            _keyRear = 0;
        }
        if (_keyRear == _keyHead && ++_keyHead >= 3) {
            _keyHead = 0;
        }
    }

    public int consumeKey() {
        if (_keyRear == _keyHead) {
            return 0;
        }
        int n = _keyBuff[_keyHead];
        if (++_keyHead == 3) {
            _keyHead = 0;
        }
        return n;
    }

    public int getCurKey() {
        return this._curKey;
    }

    public void resetCurKey() {
        this._curKey = 0;
    }

    protected void hideNotify() {
        if (this._state == 4) {
            this.initInnerMenuItem(0);
            this.resetKeyBuff();
            Function.stopSound();
        }
    }

    public boolean paintable() {
        return !this._painting;
    }

    protected void startScriptMoveCamera(int n, int n2) {
        this.lockCamera(n <<= 10, n2 <<= 10);
    }

    protected boolean endScriptMoveCamera(int n, int n2) {
        n2 <<= 10;
        n2 = this.getLockScreenPos(n2);
        if (this._camx == (n <<= 10) && this._camy == n2) {
            this.unlockCamera();
            return true;
        }
        return false;
    }

    protected void startScriptLockCamera(int n, int n2) {
        this.startScriptMoveCamera(n, n2);
    }

    protected boolean endScriptLockCamera(int n, int n2) {
        n2 <<= 10;
        n2 = this.getLockScreenPos(n2);
        return this._camx == (n <<= 10) && this._camy == n2;
    }

    protected boolean endScriptUnlockCamera() {
        return this.isStableCamera();
    }

    public void setPassLevelParameter() {
        this._drawMoneyNum = 0;
        this._drawEnemyNum = 0;
        this._state = 16;
        this._pallLevelIni = false;
        smsUi.stopTime();
        smsUi.countTimeEnd();
    }

    public void drawButtom(Graphics graphics, int n, int n2, int n3) {
        n = 108;
        n2 = 100;
        graphics.setClip(0, 0, 240, 320);
        this._buttom.nextFrame();
        this._buttom._anim.draw(graphics, n, n2, this._buttom._curAction, this._buttom._curFrame, this._buttom._palNo);
        Function.drawNumber(graphics, n + 9, n2 - 28, n3, false, true);
    }

    public void drawTimeLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Scene._panel.draw(graphics, n, n2, 44);
        int n5 = n + 3;
        int n6 = n2 + 3;
        int n7 = Scene._panel.getSptWidth(44) - 2;
        int n8 = 3;
        int n9 = n3 * n7 / n4;
        if (bl) {
            n9 = n7 - n9;
        }
        if (n9 == 0) {
            return;
        }
        graphics.setClip(n5, n6, n7, n8);
        graphics.setColor(255, 144, 0);
        graphics.drawLine(n5, n6, n9 + n5, n6);
        graphics.setColor(255, 216, 0);
        graphics.drawLine(n5, n6 + 1, n9 + n5, n6 + 1);
        graphics.setColor(190, 107, 0);
        graphics.drawLine(n5, n6 + 2, n9 + n5, n6 + 2);
    }

    public GameMIDlet getGameMIDlet() {
        return this._main;
    }

    public void browseWap(String string) {
        try {
            if (this._main.platformRequest(string)) {
                this._main.notifyDestroyed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void gameExit(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("\u786e\u8ba4\u9000\u51fa", 120, 160, 1 | 0x10);
        graphics.drawString("\u662f", 2, 318, 4 | 0x20);
        graphics.drawString("\u5426", 238, 318, 8 | 0x20);
        int n = this.consumeKey();
        switch (n) {
            case 262144: {
                this._main.notifyDestroyed();
                return;
            }
            case 524288: {
                this._state = 2;
                this.resetKeyBuff();
            }
        }
    }

    private void gameSnapLink(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 320);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("\u66f4\u591a\u7cbe\u5f69\u6e38\u620f", 120, 153, 1 | 0x20);
        graphics.drawString("\u5c3d\u5728\u98de\u626c\u793e\u533a", 120, 155, 1 | 0x10);
        graphics.drawString("g.sina.cn", 120, 170, 1 | 0x10);
        graphics.drawString("\u786e\u5b9a", 2, 318, 4 | 0x20);
        graphics.drawString("\u9000\u51fa", 238, 318, 8 | 0x20);
        int n = this.consumeKey();
        switch (n) {
            case 262144: {
                this.openWapExplorer(true, "http://yx.d.cn/wml/pdcs.jw?act=index&id=58");
                break;
            }
            case 524288: {
                this._main.notifyDestroyed();
                return;
            }
        }
    }

    private void openWapExplorer(boolean bl, String string) {
        try {
            if (this._main.platformRequest(string) || bl) {
                this._main.notifyDestroyed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGamePlaying() {
        this._loadProcess = 0;
        this._state = 4;
        this.resetCurKey();
        this.resetKeyBuff();
    }

    public void returnToMenu() {
        this._state = 2;
        this._menuItem = 0;
        this.resetKeyBuff();
    }

    public void updata() {
        if (this._overGameBool) {
            koonskySNSCenter.showkoonskySNS(this._main, (Displayable)this, "\u6b66\u6797\u5916\u4f20", 2, GAME_ID, this._overGameBool);
            this._overGameBool = false;
        }
        if (pay) {
            this.send.InitInfo();
            switch (SmsUi._state) {
                case 200: {
                    buytype = 200;
                    if (this.send.koonskyPayCenter((Displayable)this, "\u5f00\u8d77\u5173\u5361", "1", 2, this.left, this.right)) {
                        pay = false;
                        SmsUi._state = 180;
                        break;
                    }
                    pay = false;
                    SmsUi._state = 280;
                    break;
                }
                case 0: {
                    buytype = 0;
                    if (this.send.koonskyPayCenter((Displayable)this, "\u4ece\u672c\u5173\u590d\u6d3b", "1", 2, this.left, this.right)) {
                        smsUi.setCurSend(0);
                        pay = false;
                        SmsUi._state = 180;
                        break;
                    }
                    pay = false;
                    SmsUi._state = 280;
                }
            }
        }
    }

    static {
        _safeTimeTick = 0;
        _image = new Image[4];
        _keyBuff = new int[3];
        _keyHead = 0;
        _keyRear = 0;
        data = new byte[7];
        _canRewrite = true;
        menu_pos = new int[][]{{24, 30}, {24, 70}, {24, 110}, {24, 150}, {84, 30}, {84, 70}, {84, 110}};
        menu_index = new int[]{0, 2, 4, 1, 3, 5, 6};
        menu_text_index = new int[]{7, 8, 9, 12, 13, 19, 11};
        _scc = 0;
        title = new String[][]{{"\u59ec\u65e0\u547d\u66b4\u6253\u5415\u79c0\u624d", "\u767d\u5c55\u5802\u75db\u5931\u4f5f\u6e58\u7389"}, {"\u62db\u6551\u5175\u9a91\u732a\u514b\u9669\u963b", "\u83ab\u5c0f\u8d1d\u91cd\u8fd4\u4e03\u4fa0\u9547"}, {"\u767d\u5c55\u5802\u7acb\u8a93\u6551\u4f73\u4eba", "\u8861\u5c71\u6d3e\u4e0a\u9635\u7236\u5b50\u5175"}, {"\u4f5f\u6e58\u7389\u8499\u96be\u7ec8\u83b7\u6551", "\u767d\u5c55\u5802\u62b1\u5f97\u7f8e\u4eba\u5f52"}, {"\u674e\u5927\u5634\u6025\u4e2d\u751f\u5999\u8ba1", "\u4e4c\u9e21\u7cbe\u4f20\u4e66\u63a2\u654c\u60c5"}, {"\u59ec\u65e0\u547d\u518d\u6253\u5415\u79c0\u624d", "\u4e03\u4fa0\u9547\u4e0a\u6f14\u73cd\u73e0\u6e2f"}, {"\u4e89\u9ad8\u4e0b\u76d7\u5723\u6597\u76d7\u795e", "\u767d\u5c55\u5802\u5bf9\u51b3\u59ec\u65e0\u547d"}, {"\u62a2\u7b54\u9898\u5206\u51fa\u771f\u9ad8\u4e0b", "\u53cc\u795e\u76d7\u5e38\u8bc6\u62fc\u8f93\u8d62"}, {"\u767d\u5c55\u5802\u4e49\u5b88\u4e03\u4fa0\u9547", "\u4f17\u532a\u8d3c\u60e8\u906d\u706b\u70ae\u8f70"}, {"\u59ec\u65e0\u547d\u6539\u884c\u62a5\u5929\u6c14", "\u767d\u5c55\u5802\u52c7\u6dcb\u91d1\u94b1\u96e8"}};
        menuurl = "http://go.i139.cn/push/g_sina1.do";
        menuur2 = "http://go.i139.cn/push/g_sina2.do";
        pay = false;
        buytype = -1;
        payres = 380;
        buylevel = false;
        buylife = false;
    }
}

