/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import javax.microedition.lcdui.Graphics;
import tjge.Actor;
import tjge.Animation;
import tjge.EnemyThing;
import tjge.Function;
import tjge.MainActor;
import tjge.Platform;
import tjge.Scene;

public class Hen
extends MainActor
implements Platform {
    private static final int C_ACT_HEN_FLYING = 0;
    private static final int C_ACT_HEN_ATTACK = 1;
    private static final int C_ACT_HEN_HURT = 2;
    private static final int C_ACT_HEN_FALL_DOWN = 3;
    private static final int C_ACT_HEN_DIE = 4;
    private static final int C_ACT_HEN_HURT_BLACK = 5;
    private static final int FLY_SPEED = 6;
    private int _patrolDistanceX;
    private int _patrolDistanceY;
    private boolean _hedBeenStanded;
    public boolean _egged;

    public Hen(int n, Animation animation) {
        super(n, animation);
        this._ownKind = 1;
    }

    protected boolean init(byte[] byArray) {
        super.init(byArray);
        if (this._id == 0) {
            this._hp = this.C_TOTAL_HP = 40;
            this._gravity = 0;
            this._gs._fixedMove = true;
        } else {
            this._gravity = 3000;
            this._ownKind = 2;
            this._patrolDistanceX = byArray[7];
            this._patrolDistanceX <<= 13;
            this._patrolDistanceY = byArray[8];
            this._patrolDistanceY <<= 13;
            this._hp = 400;
        }
        return true;
    }

    public void step() {
        if (this._id == 0) {
            if (this._hp > 0) {
                int n = (this._y + this._vy >> 10) + this._t;
                int n2 = (this._y + this._vy >> 10) + this._b;
                int n3 = (this._gs._camy >> 10) + 70;
                int n4 = (this._gs._camy >> 10) + 320;
                if (n < n3) {
                    this._y = (n3 - this._t << 10) - this._vy;
                } else if (n2 > n4) {
                    this._y = (n4 - this._b << 10) - this._vy;
                }
            }
            super.step();
        } else {
            this.stepHen();
        }
    }

    private void stepHen() {
        this.nextFrame();
        this._dx = this._vx;
        this._dy = this._vy;
        this._vx += this._ax;
        if (this._ax > 0 && this._vx > this._fx) {
            this._vx = this._fx;
        }
        if (this._ax < 0 && this._vx < -this._fx) {
            this._vx = -this._fx;
        }
        this._vy += this._ay;
        if (this._ay > 0 && this._vy > this._fy) {
            this._vy = this._fy;
        }
        if (this._ay < 0 && this._vy < -this._fy) {
            this._vy = -this._fy;
        }
        this._x += this._dx;
        this._y += this._dy;
    }

    public void ai() {
        if (this._id == 0) {
            this.keyHandler();
            this.actionHandler();
        } else {
            switch (this._action) {
                case 0: {
                    if (!this._hedBeenStanded || this._egged) break;
                    this.changeAction(2 | this._flipFlag);
                    break;
                }
                case 1: {
                    if (!this.isActionEnd()) break;
                    this.bornEgg();
                    this._egged = true;
                    this.changeAction(0 | this._flipFlag);
                    break;
                }
                case 2: {
                    if (!this.isActionEnd()) break;
                    if (this._hedBeenStanded) {
                        this.changeAction(1 | this._flipFlag);
                        break;
                    }
                    if (this._hp <= 0) {
                        this._vx = 0;
                        this._vy = 3000;
                        this.changeAction(3 | this._flipFlag);
                        break;
                    }
                    this.changeAction(0 | this._flipFlag);
                    break;
                }
                case 3: {
                    if (!this.checkGround()) break;
                    this.changeAction(4 | this._flipFlag);
                    break;
                }
                case 4: {
                    if (!this.isActionEnd()) break;
                    this.disLife();
                    break;
                }
                case 5: {
                    if (!this.isActionEnd()) break;
                    if (this._hp <= 0) {
                        this._vx = 0;
                        this._vy = 3000;
                        this.changeAction(3 | this._flipFlag);
                        break;
                    }
                    this.changeAction(0 | this._flipFlag);
                }
            }
        }
    }

    private void bornEgg() {
        EnemyThing enemyThing = (EnemyThing)this._scene.fetchActorFromPool(21, -1);
        if (enemyThing != null) {
            if (this._isFlip) {
                enemyThing.init(9, 0, this._x + 10240, this._y + 6000, this);
            } else {
                enemyThing.init(9, 0, this._x - 10240, this._y + 6000, this);
            }
        }
    }

    private void actionHandler() {
        switch (this._action) {
            case 1: {
                if (!this.isActionEnd()) break;
                this.bornEgg();
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 2: 
            case 5: {
                if (!this.isActionEnd()) break;
                if (this._hp <= 0) {
                    this.changeAction(3 | this._flipFlag);
                    break;
                }
                this.changeAction(0 | this._flipFlag);
                break;
            }
            case 3: {
                if (!this.checkGround()) break;
                this.changeAction(4 | this._flipFlag);
                break;
            }
            case 4: {
                if (!this.isActionEnd()) break;
                this._scene.gameLoseLife();
            }
        }
    }

    private void checkHurtDrop() {
        if (this._hp <= 0) {
            this._vx = 0;
            this._vy = 6000;
            this._gs._fixedMove = false;
        } else {
            this._vy = 0;
        }
    }

    protected void keyHandler() {
        if (this._action != 0) {
            return;
        }
        int n = this._gs.getCurKey();
        if (n == 4) {
            this._vy = -6144 + this._gravity;
        } else if (n == 8) {
            this._vy = 6144;
        } else {
            this._vx = 5120;
            this._vy = 0;
        }
    }

    public boolean notify(Actor actor) {
        if (this._action == 5 || this._action == 2 || this._hp <= 0) {
            return false;
        }
        if (actor._type == 16) {
            this._hp -= Actor.C_HURT_HP[actor.getHurtMode()];
            this.changeAction(5);
            this.checkHurtDrop();
            return true;
        }
        if (actor._type == 31 || actor._type == 6 || actor._type == 7 || actor._type == 29) {
            this._hp -= Actor.C_HURT_HP[12];
            this.changeAction(2);
            this.checkHurtDrop();
        } else if (actor._type == 10) {
            this.changeAction(2);
            this.checkHurtDrop();
            return true;
        }
        return false;
    }

    public int getYDirLocation(int n) {
        return this._gs._camy;
    }

    public void paintInfo(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        int n = 5;
        int n2 = 4;
        int n3 = this._hp * 111 / this.C_TOTAL_HP;
        int n4 = 3;
        Scene._panel.draw(graphics, n - 3, n2 - 3, 44);
        if (this._hp > 0) {
            Function.drawEffectLightBar(graphics, n, n2, n3, n4, MainActor.HpColors);
        }
    }

    public boolean onFloor(Actor actor) {
        int n = this._l;
        int n2 = this._r;
        int n3 = this._t;
        int n4 = this._b;
        int n5 = actor._x + actor._dx >> 10;
        int n6 = (actor._y + actor._dy >> 10) + actor._b;
        return n5 >= (n += this._x >> 10) && n5 <= (n2 += this._x >> 10) && n6 >= (n3 += this._y >> 10) && n6 <= (n4 += this._y >> 10);
    }

    public boolean isFloatPlatform() {
        return false;
    }

    public void notifyFloatPlatform(Actor actor) {
        this._hedBeenStanded = true;
    }

    public int getID() {
        return this._id;
    }

    public void releasePlatForm() {
        this._egged = false;
        this._hedBeenStanded = false;
        this.changeAction(2 | this._flipFlag);
    }

    public void getParameter(int[] nArray) {
        nArray[3] = 0;
        nArray[5] = 0;
        nArray[1] = this._y + this._t * 1024 / 2;
        nArray[2] = nArray[2] + this._vx;
        nArray[3] = nArray[3] + this._vy;
    }

    public boolean isDrop() {
        return false;
    }

    public boolean isBoard() {
        return false;
    }

    public int getFashion() {
        return -1;
    }

    public int getVX() {
        return this._vx;
    }

    public int getVY() {
        return this._vy;
    }

    protected void collideLeftWall() {
        if (this._hp <= 0) {
            return;
        }
        this._hp = 0;
        this.changeAction(2 | this._flipFlag);
        this.checkHurtDrop();
    }

    protected void collideRightWall() {
        if (this._hp <= 0) {
            return;
        }
        this._hp = 0;
        this.changeAction(2 | this._flipFlag);
        this.checkHurtDrop();
    }
}

