/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import tjge.Actor;
import tjge.Animation;
import tjge.BaiZhanTang;
import tjge.Platform;

abstract class Human
extends Actor {
    protected static final int AT_MIDDLE = 0;
    protected static final int AT_LEFT_WALL = 1;
    protected static final int AT_RIGHT_WALL = 2;
    public int _hp;
    public Platform _platform;
    protected int _position;
    public int _mass = 50;
    protected int _turns;
    protected int[] _turn;
    protected boolean _isTurnMode;

    protected Human(int n, Animation animation) {
        super(n, animation);
    }

    protected boolean init(byte[] byArray) {
        this._platform = null;
        return super.init(byArray);
    }

    public void step() {
        this.nextFrame();
        this._dx = this._vx;
        this._dy = this._vy;
        this._vx += this._ax;
        if (this._ax > 0 && this._vx > this._fx) {
            this._vx = this._fx;
        }
        if (this._ax < 0 && this._vx < -this._fx) {
            this._vx = -this._fx;
        }
        this._vy += this._ay;
        if (this._ay > 0 && this._vy > this._fy) {
            this._vy = this._fy;
        }
        if (this._ay < 0 && this._vy < -this._fy) {
            this._vy = -this._fy;
        }
        if (this.checkLeftWall()) {
            this.collideLeftWall();
        }
        if (this.checkRightWall()) {
            this.collideRightWall();
        }
        if (this.checkGround()) {
            this.onGround();
            this.onLand();
        } else if (this.checkPlatform()) {
            this.onPlatform();
            this.onLand();
        } else if (this._onPasspath) {
            this.onPasspath();
            this._dx = this._vx;
            this._dy = this._vy;
        } else if (this.checkCeiling()) {
            this.onDrop();
        } else {
            this.onFall();
        }
        this._x += this._dx;
        this._y += this._dy;
    }

    protected void onGround() {
    }

    protected void collideLeftWall() {
    }

    protected void collideRightWall() {
    }

    protected void onLand() {
    }

    protected void onFall() {
    }

    protected void onDrop() {
    }

    protected void onPasspath() {
    }

    protected boolean checkPlatform() {
        if (this._dy < 0) {
            if (this._platform != null) {
                this._platform.releasePlatForm();
                this._platform = null;
            }
            return false;
        }
        int[] nArray = new int[]{0};
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Platform platform;
            Actor actor = actorArray[n];
            if (actor._active && actor != this && actor.isPlatform() && (platform = (Platform)((Object)actor)).onFloor(this)) {
                if (this._platform != null && platform.getID() != this._platform.getID()) {
                    this._platform.releasePlatForm();
                }
                platform.notifyFloatPlatform(this);
                this._platform = platform;
                return true;
            }
            ++n;
        }
        if (this._platform != null) {
            this._platform.releasePlatForm();
            this._platform = null;
        }
        return false;
    }

    protected void onPlatform() {
        int[] nArray = new int[]{this._x, this._y, this._dx, this._dy, this._vx, this._vy, this._ax, this._ay};
        this._platform.getParameter(nArray);
        this._x = nArray[0];
        this._y = nArray[1];
        this._dx = nArray[2];
        this._dy = nArray[3];
        this._vy = nArray[5];
        this._onGround = true;
    }

    protected boolean triggerToEnemy() {
        int[] nArray = new int[]{0};
        boolean bl = false;
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Actor actor = actorArray[n];
            if (actor._active && actor != this && (this._relation & actor._ownKind) != 0 && (actor._x <= this._x || !this._isFlip) && (actor._x >= this._x || this._isFlip) && this.collide(actor)) {
                bl = true;
                if (actor.notify(this)) {
                    this.process(actor);
                }
            }
            ++n;
        }
        return bl;
    }

    protected final void checkCollideMainActor() {
        Actor actor = this._scene.getFocusActor();
        if (actor._type == 0 && this.collideAction(actor, 0 | this._flipFlag)) {
            byte by = this._anim._l[0];
            byte by2 = this._anim._r[0];
            byte by3 = this._anim._t[0];
            byte by4 = this._anim._b[0];
            if ((this._curAction & Integer.MIN_VALUE) != 0) {
                by = -by2;
                by2 = -by;
            }
            if ((this._curAction & 0x40000000) != 0) {
                by3 = -by4;
                by4 = -by3;
            }
            BaiZhanTang baiZhanTang = (BaiZhanTang)actor;
            baiZhanTang.collideEnemy(this, by, by3, by2, by4);
        }
    }

    public void disActive() {
        if (this._platform != null) {
            this._platform.releasePlatForm();
        }
        super.disActive();
    }
}

