/*
 * Decompiled with CFR 0.152.
 */
package tjge;

import javax.microedition.lcdui.Graphics;
import tjge.Actor;
import tjge.Animation;
import tjge.BaiZhanTang;
import tjge.BridgeBoard;
import tjge.EnemyMind;
import tjge.Function;
import tjge.MainActor;
import tjge.Scene;
import tjge.SptSet;

public final class MainFriend
extends MainActor {
    private static final int C_ACT_GUOFURONG_JINK_OUT = 0;
    private static final int C_ACT_GUOFURONG_JINK_IN = 1;
    private static final int C_ACT_GUOFURONG_ATTACK = 2;
    private static final int C_STATE_GUOFURONG_OUT = 0;
    private static final int C_STATE_GUOFURONG_ATTACK = 1;
    private static final int C_STATE_GUOFURONG_BACK = 2;
    private static final int C_STATE_GUOFURONG_FIAL = 3;
    private static final int C_GUOFURONG_VX = 12288;
    private int _superAttackXpos;
    private static final int C_ACT_LIDAZUI_JINK_OUT = 0;
    private static final int C_ACT_LIDAZUI_JINK_IN = 1;
    private static final int C_ACT_LIDAZUI_ATTACK = 2;
    private static final int C_ACT_LIDAZUI_FAIL = 3;
    private static final int C_STATE_LIDAZUI_OUT = 0;
    private static final int C_STATE_LIDAZUI_ATTACK = 1;
    private static final int C_STATE_LIDAZUI_BACK = 2;
    private static final int C_STATE_LIDAZUI_FIAL = 3;
    private static final int C_LIDAZUI_VX = 14336;
    private static final int C_LIDAZUI_VY = 14336;
    private boolean _isSuperAttackSuccess;
    private static final int C_ACT_MOXIAOBEI_WAIT = 0;
    private static final int C_ACT_MOXIAOBEI_RUN = 1;
    private static final int C_ACT_MOXIAOBEI_JUMP = 2;
    private static final int C_ACT_MOXIAOBEI_JUMP_TOP = 3;
    private static final int C_ACT_MOXIAOBEI_JUMP_DOWN = 4;
    public static final int C_MOXIAOBEI_RUN_VX = 8192;
    public static final int C_MOXIAOBEI_JUMP_VX = 8192;
    public static final int C_MOXIAOBEI_LEFT_VX = 5120;
    public static final int C_MOXIAOBEI_RIGHT_VX = 10240;
    public static final int C_MOXIAOBEI_BACK_VX = 8192;
    public static final int C_MOXIAOBEI_BACK_VY = -5120;
    public static final int C_MOXIAOBEI_JUMP_VY = -12288;
    public static final int C_MOXIAOBEI_MODE_CALL = 0;
    public static final int C_MOXIAOBEI_MODE_CHASE = 1;
    public static final int C_MOXIAOBEI_MODE_WAIT = 3;
    private static int _followPigCnt;
    private int _followTicks;
    private int _followPigBornXpos;
    private int _followPigBornYpos;
    private int _jumpVx;
    private int _mode;
    boolean _onBack;
    private static final int C_SCRIPT_PASS_LEVEL = 0;

    public MainFriend(int n, Animation animation) {
        super(n, animation);
        switch (this._type) {
            case 2: {
                this._relation = 6;
                break;
            }
            case 3: {
                this._relation = 2;
                break;
            }
            case 4: {
                this._boff = 10;
                this._relation = 3;
                this._onBack = false;
            }
        }
    }

    protected boolean init(byte[] byArray) {
        super.init(byArray);
        this._hp = this.C_TOTAL_HP = 10;
        this._mode = byArray[7];
        this._ownKind = 1;
        this._visible = true;
        return true;
    }

    public void step() {
        if (this._type == 4 && (this._x >> 10) + 80 > this._bk.getMapWidth()) {
            this.changeAction(0);
            this._vx = 0;
        }
        super.step();
    }

    public void ai() {
        if (this._type == 2) {
            this.ai_guofurong();
        } else if (this._type == 3) {
            this.ai_lidazui();
        } else if (this._type == 4) {
            this.ai_moxiaobei();
        }
    }

    private void ai_guofurong() {
        switch (this._state) {
            case 0: {
                int n = Math.abs(this._x - this._superAttackXpos);
                int n2 = Math.abs(this._vx);
                if (n >= n2) break;
                this._x = this._superAttackXpos;
                this._vx = 0;
                this.guofurong_fire();
                break;
            }
            case 1: {
                if (this.isActionEnd()) {
                    this.guofurong_back();
                    break;
                }
                this.triggerFeedback();
                break;
            }
            case 2: {
                if (this._visible) break;
                this.changeAction(0);
                this.disLife();
                break;
            }
            case 3: {
                if (!this.isActionEnd()) break;
                this.guofurong_back();
            }
        }
    }

    private void ai_lidazui() {
        if (this._onGround && !this._gs.isVibrateCamera()) {
            this._gs.vibrateCamera();
        }
        switch (this._state) {
            case 0: {
                this.checkBoard();
                if (this._isSuperAttackSuccess) {
                    this.lidazui_fire();
                    break;
                }
                if (!this._onGround) break;
                this.lidazui_fail();
                break;
            }
            case 1: {
                this.triggerFeedback();
                this.checkBoard();
                if (!this._onGround || !this.isActionEnd()) break;
                Function.playSound(2, 1);
                this.lidazui_back();
                break;
            }
            case 2: {
                if (!this._visible) {
                    this.disLife();
                    break;
                }
                this._vy = -14336;
                break;
            }
            case 3: {
                if (!this.isActionEnd()) break;
                this.lidazui_back();
            }
        }
    }

    private void checkBoard() {
        int[] nArray = new int[]{0};
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Actor actor = actorArray[n];
            if (actor._active && actor._type == 27 && this.collide(actor)) {
                BridgeBoard bridgeBoard = (BridgeBoard)actor;
                bridgeBoard.openTheDoor();
                return;
            }
            ++n;
        }
    }

    private void ai_moxiaobei() {
        this.moxiaobei_actHandler();
        if (this._mode == 0) {
            this.triggerFeedback();
            if (this._isFlip) {
                if (this._x > this._gs._camx) {
                    this.fetchFollowPig();
                } else if (!this._visible) {
                    this.disLife();
                }
            } else if (this._x < this._gs._camx + this._gs._camw) {
                this.fetchFollowPig();
            } else if (!this._visible) {
                this.disLife();
            }
        } else {
            if (this._mode == 3) {
                return;
            }
            if (this.canPressKey()) {
                this.moxiaobei_keyHandler();
            }
        }
    }

    private void moxiaobei_keyHandler() {
        if (!this._onGround) {
            return;
        }
        int n = this._gs.getCurKey();
        if (this._mode == 1 && this._onGround) {
            if (n == 4 || n == 128) {
                this._vx = 8192;
                this._vy = -12288;
                this._jumpVx = this._vx;
                this.changeAction(2 | this._flipFlag);
                this._loopAction = false;
            } else if (this._action == 1) {
                this._vx = n == 1 ? 5120 : (n == 2 ? 10240 : 8192);
                if (n == 8) {
                    int n2 = 345;
                }
            }
        }
    }

    private void moxiaobei_actHandler() {
        this.triggerFeedback();
        if (this._action == 2) {
            if (this.isActionEnd()) {
                this.changeAction(3 | this._flipFlag);
                this._loopAction = false;
            }
            this._vx = this._jumpVx;
        } else if (this._action == 3) {
            if (this._vy > 0) {
                this.changeAction(4 | this._flipFlag);
                this._loopAction = false;
            }
            this._vx = this._jumpVx;
        } else if (this._action == 4) {
            this._vx = this._jumpVx;
        }
    }

    private void fetchFollowPig() {
        if (++this._followTicks % 4 != 0) {
            return;
        }
        EnemyMind enemyMind = (EnemyMind)this._scene.fetchActorFromPool(5, -1);
        if (enemyMind != null) {
            enemyMind.initPig(1 | this._flipFlag, this._followPigBornXpos, this._followPigBornYpos, this, ++_followPigCnt);
        }
    }

    public int getFollowPigCnt() {
        return _followPigCnt;
    }

    private void guofurong_fire() {
        this._state = 1;
        Function.playSound(2, 1);
        this.changeAction(2 | this._flipFlag);
    }

    private void guofurong_back() {
        this._state = 2;
        this._vx = this._isFlip ? 12288 : -12288;
        this.changeAction(1 | this._flipFlag);
    }

    private void lidazui_fire() {
        this._state = 1;
        this.changeAction(2 | this._flipFlag);
    }

    private void lidazui_fail() {
        this._state = 3;
        this.changeAction(3 | this._flipFlag);
    }

    private void lidazui_back() {
        this._state = 2;
        this._vy = -14336;
        this._vx = this._isFlip ? 14336 : -14336;
        this.changeAction(1 | this._flipFlag);
    }

    protected boolean agreeAndHelp() {
        switch (this._type) {
            case 2: {
                return this.return_GuofurongHelp();
            }
            case 3: {
                return this.return_LidazuiHelp();
            }
            case 4: {
                return this.return_MoxiaobeiHelp();
            }
        }
        return false;
    }

    private boolean return_GuofurongHelp() {
        int n;
        int n2;
        BaiZhanTang baiZhanTang = (BaiZhanTang)this._scene.getFocusActor();
        int n3 = this._gs._camx - 16384;
        int n4 = this._gs._camx + this._gs._camw + 16384;
        int n5 = baiZhanTang._y;
        int n6 = 0 | baiZhanTang._flipFlag;
        if (baiZhanTang._isFlip) {
            n2 = n4;
            n = -12288;
        } else {
            n2 = n3;
            n = 12288;
        }
        this._superAttackXpos = this.getTarget();
        this.init(0, n6, n2, n5, n, 0);
        return true;
    }

    private boolean return_LidazuiHelp() {
        int n;
        int n2;
        BaiZhanTang baiZhanTang = (BaiZhanTang)this._scene.getFocusActor();
        int n3 = baiZhanTang._x >> 10;
        int n4 = (this._gs._camy >> 10) - 6;
        if (baiZhanTang._isFlip) {
            n2 = n3 - 20;
            n = 1;
        } else {
            n2 = n3 + 20;
            n = -1;
        }
        while (n2 != n3) {
            int n5 = this._bk.getPhyBlock(n2, n4);
            if (n5 == 0) break;
            if (n5 == 10) break;
            n2 += n;
        }
        if (n2 != n3) {
            int n6 = 0 | baiZhanTang._flipFlag;
            this.init(0, n6, n2 <<= 10, n4 <<= 10, 0, 14336);
            this._isSuperAttackSuccess = false;
            return true;
        }
        this.disLife();
        return false;
    }

    private boolean return_MoxiaobeiHelp() {
        int n;
        int n2;
        BaiZhanTang baiZhanTang = (BaiZhanTang)this._scene.getFocusActor();
        int n3 = this._gs._camx - 40960;
        int n4 = this._gs._camx + this._gs._camw + 40960;
        int n5 = 1;
        if (baiZhanTang._isFlip) {
            n2 = n3;
            n = 8192;
        } else {
            n2 = n4;
            n = -8192;
            n5 |= Integer.MIN_VALUE;
        }
        int n6 = this.getTarget();
        if (n6 >= 0) {
            this.init(0, n5, n2, n6, n, 0);
            this._gs.lockCamera();
            this._followTicks = 0;
            _followPigCnt = 0;
            this._followPigBornXpos = n2;
            this._followPigBornYpos = n6;
            this._mode = 0;
            return true;
        }
        this.disLife();
        return true;
    }

    private int getTarget() {
        switch (this._type) {
            case 2: {
                return this.guofurong_getTarget();
            }
            case 4: {
                return this.moxiaobei_getTarget();
            }
        }
        return 0;
    }

    private int moxiaobei_getTarget() {
        BaiZhanTang baiZhanTang = (BaiZhanTang)this._scene.getFocusActor();
        int n = (this._gs._camx >> 10) - 40;
        int n2 = (this._gs._camx + this._gs._camw >> 10) + 40;
        int n3 = baiZhanTang._isFlip ? n : n2;
        int n4 = this._gs._camy >> 10;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this._bk.getMapWidth()) {
            n3 = this._bk.getMapWidth() - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > this._bk.getMapHeight()) {
            n4 = this._bk.getMapHeight() - 1;
        }
        int n5 = n3;
        int n6 = n4;
        int n7 = n3;
        int n8 = n4 + 320;
        int[] nArray = new int[]{1, 0};
        if (this.checkLineSolid(n5, n6, n7, n8, 0, 1, nArray)) {
            return nArray[0] << 10;
        }
        return -1;
    }

    private int guofurong_getTarget() {
        int n;
        int n2;
        int n3;
        BaiZhanTang baiZhanTang = (BaiZhanTang)this._scene.getFocusActor();
        int n4 = baiZhanTang._x >> 10;
        int n5 = n3 = (baiZhanTang._y >> 10) + 2;
        if (baiZhanTang._isFlip) {
            n2 = n4 - 16;
            n = 1;
        } else {
            n2 = n4 + 16;
            n = -1;
        }
        int[] nArray = new int[]{1, 0};
        if (!this.checkLineSolid(n2, n5, n4, n3, n, 0, nArray)) {
            nArray[0] = n4;
        }
        return nArray[0] << 10;
    }

    protected boolean checkLeftWall() {
        if (this._type == 4) {
            return super.checkLeftWall();
        }
        return false;
    }

    protected boolean checkRightWall() {
        if (this._type == 4) {
            return super.checkRightWall();
        }
        return false;
    }

    protected boolean checkGround() {
        if (this._type == 2) {
            return false;
        }
        return super.checkGround();
    }

    protected boolean checkCeiling() {
        return false;
    }

    protected void collideLeftWall() {
        if (this._mode == 3) {
            return;
        }
        if (this._type == 4 && this._onGround) {
            this.changeAction(Integer.MIN_VALUE);
        }
    }

    protected void collideRightWall() {
        if (this._mode == 3) {
            return;
        }
        if (this._type == 4 && this._onGround) {
            if (this._mode == 1) {
                this._hp -= 2;
                if (this._hp <= 0) {
                    this._scene.gameLoseLife();
                    return;
                }
                this._onBack = true;
                this._jumpVx = this._vx = -8192;
                this._dx = this._vx;
                this._dy = this._vy = -5120;
                return;
            }
            if (this._mode == 0) {
                this.disLife();
            }
        }
    }

    protected void onLand() {
        if (this._type == 2) {
            this.guofurong_onLand();
        } else if (this._type == 3) {
            this.lidazui_onLand();
        } else {
            this.moxiaobei_onLand();
        }
    }

    protected void onFall() {
        if (this._type == 2) {
            this.guofurong_onFall();
        } else if (this._type == 3) {
            this.lidazui_onFall();
        } else {
            this.moxiaobei_onFall();
        }
    }

    private void moxiaobei_onLand() {
        this._onBack = false;
        if (this._onPreGround) {
            return;
        }
        if (this._mode == 1) {
            int n = this._vx = this._isFlip ? -8192 : 8192;
            if (this._action != 1) {
                this.changeAction(1 | this._flipFlag);
                this._loopAction = true;
            }
        }
    }

    private void moxiaobei_onFall() {
        if (this._mode == 1) {
            if (!this._visible) {
                this._scene.gameLoseLife();
            } else if (this._onPreGround) {
                this.changeAction(2 | this._flipFlag);
                this._loopAction = false;
            }
            if (this._onWater) {
                this.produceSpray();
            }
        }
    }

    private void lidazui_onLand() {
        this._vy = 0;
        this._ay = 0;
    }

    private void lidazui_onFall() {
        this._ay = 0;
    }

    private void guofurong_onLand() {
        this._vy = 0;
        this._ay = 0;
    }

    private void guofurong_onFall() {
        this._vy = 0;
        this._ay = 0;
    }

    public void paintInfo(Graphics graphics) {
        Scene._panel.draw(graphics, 0, 0, 0);
        MainActor.paintFace(graphics, 31, 49, 30);
        graphics.setClip(0, 0, 240, 320);
        int n = 67;
        int n2 = 12;
        int n3 = this._hp * 128 / this.C_TOTAL_HP;
        int n4 = 3;
        Function.drawEffectLightBar(graphics, n, n2, n3, n4, MainActor.HpColors);
        SptSet sptSet = SptSet.getSptSet(10);
        sptSet.draw(graphics, 115, 25, 2);
        sptSet.draw(graphics, 133, 30, 6);
        Function.drawNumber(graphics, 163, 28, MainActor._moneyNum, true, false);
    }

    public boolean process(Actor actor) {
        if (this._state == 0) {
            this._isSuperAttackSuccess = true;
        }
        return true;
    }

    public int getHurtMode() {
        switch (this._type) {
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                Function.playSound(2, 1);
                if (this._action == 4 && this._vy > 0) {
                    return 7;
                }
                return 8;
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean issolid(int n) {
        if (n == 1) return true;
        if (n == 2) return true;
        if (n != 5) return false;
        return true;
    }

    protected boolean isupsolid(int n) {
        return n == 1;
    }

    protected void startScriptActorMove(int n, int n2) {
        int n3 = this._x >> 10;
        if (n3 < n) {
            this._vx = 8192;
            this.changeAction(1);
        } else {
            this._vx = -8192;
            this.changeAction(-2147483647);
            this._loopAction = true;
        }
    }

    protected boolean endScriptActorMove(int n, int n2) {
        int n3 = this._x >> 10;
        int n4 = Math.abs(n3 - n);
        if (n4 < 8) {
            this._x = n << 10;
            this._vx = 0;
            this.changeAction(0 | this._flipFlag);
            return true;
        }
        return false;
    }

    protected void startScriptCallFunction(int n, int n2, int n3) {
        if (n == 0) {
            this._scene.gamePassLevel();
        }
    }

    public void stop() {
        this._vx = 0;
        this.changeAction(0 | this._flipFlag);
    }
}

