/*
 * Decompiled with CFR 0.152.
 */
package movilib;

import com.movilenio.game.Kernel;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;
    public Image image;
    public static final int CHR_SIZE = 6;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int WIDTH = 2;
    public static final int HEIGHT = 3;
    public static final int OFFSET_Y = 4;
    public static final int ADVANCE = 5;
    public byte[] chr;
    public short[] chrIndex;
    public int ind_tilde;
    public int ind_dieresis;
    public int ind_tilde_inv;
    public int ind_circunflejo;
    public int ind_rabito;
    public int fontHeight;

    public BitmapFont(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string));
            dataInputStream.readByte();
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            Kernel.readStreamData(dataInputStream, byArray, 0, n);
            this.image = Image.createImage((byte[])byArray, (int)0, (int)n);
            int n2 = (dataInputStream.readByte() & 0xFF) + 1;
            this.chr = new byte[n2 * 6];
            this.chrIndex = new short[256];
            this.fontHeight = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = i * 6;
                int n4 = dataInputStream.readByte() & 0xFF;
                this.chr[n3 + 0] = dataInputStream.readByte();
                this.chr[n3 + 1] = dataInputStream.readByte();
                this.chr[n3 + 2] = dataInputStream.readByte();
                this.chr[n3 + 3] = dataInputStream.readByte();
                if (this.chr[n3 + 3] > this.fontHeight) {
                    this.fontHeight = this.chr[n3 + 3];
                }
                this.chr[n3 + 4] = dataInputStream.readByte();
                this.chr[n3 + 5] = dataInputStream.readByte();
                this.chrIndex[n4] = (short)n3;
            }
            dataInputStream.close();
            this.ind_tilde = this.chrIndex[180];
            this.ind_dieresis = this.chrIndex[168];
            this.ind_tilde_inv = this.chrIndex[96];
            this.ind_circunflejo = this.chrIndex[94];
            this.ind_rabito = this.chrIndex[126];
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getAdvance(char c) {
        return this.chr[this.chrIndex[c & 0xFF] + 5];
    }

    public int getWidth(char c) {
        return this.chr[this.chrIndex[c & 0xFF] + 2];
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public int stringWidth(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = string.length(); i != 0; --i) {
            short s = this.chrIndex[string.charAt(n2) & 0xFF];
            if (s != this.ind_tilde) {
                n += i > 1 ? this.chr[s + 5] : this.chr[s + 2];
            }
            ++n2;
        }
        return n;
    }

    public void drawChar(Graphics graphics, char c, int n, int n2, int n3) {
        if ((n3 & 0xF) != 0) {
            n -= (this.getAdvance(c) >> 1) * (n3 & 0xF);
        }
        if ((n3 & 0xF0) != 0) {
            n2 -= (this.fontHeight >> 1) * (n3 >> 4 & 0xF);
        }
        short s = this.chrIndex[c];
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.clipRect(n, n2 + this.chr[s + 4], (int)this.chr[s + 2], (int)this.chr[s + 3]);
        graphics.drawImage(this.image, n - this.chr[s + 0], n2 + this.chr[s + 4] - this.chr[s + 1], 0);
        graphics.setClip(n4, n5, n6, n7);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = 0;
        if ((n3 & 0xF) != 0) {
            n -= (this.stringWidth(string) >> 1) * (n3 & 0xF);
        }
        if ((n3 & 0xF0) != 0) {
            n2 -= (this.fontHeight >> 1) * (n3 >> 4 & 0xF);
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = 0;
        for (int i = string.length(); i != 0; --i) {
            char c = string.charAt(n9);
            switch (c) {
                case '\u00b4': {
                    n4 = this.ind_tilde;
                    break;
                }
                case '`': {
                    n4 = this.ind_tilde_inv;
                    break;
                }
                case '^': {
                    n4 = this.ind_circunflejo;
                    break;
                }
                case '\u00a8': {
                    n4 = this.ind_dieresis;
                    break;
                }
                case '~': {
                    n4 = this.ind_rabito;
                    break;
                }
                default: {
                    short s = this.chrIndex[c];
                    graphics.setClip(n5, n6, n7, n8);
                    graphics.clipRect(n, n2 + this.chr[s + 4], (int)this.chr[s + 2], (int)this.chr[s + 3]);
                    graphics.drawImage(this.image, n - this.chr[s + 0], n2 + this.chr[s + 4] - this.chr[s + 1], 0);
                    if (n4 != 0) {
                        int n10 = n + this.chr[s + 5] - this.chr[n4 + 5];
                        int n11 = n2 + this.chr[n4 + 4];
                        graphics.setClip(n5, n6, n7, n8);
                        graphics.clipRect(n10, n11, (int)this.chr[n4 + 2], (int)this.chr[n4 + 3]);
                        graphics.drawImage(this.image, n10 - this.chr[n4 + 0], n11 - this.chr[n4 + 1], 0);
                        n4 = 0;
                    }
                    n += this.chr[s + 5];
                }
            }
            ++n9;
        }
        graphics.setClip(n5, n6, n7, n8);
    }
}

