/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Bullet
extends MySprite {
    private int iDamageLevel;

    public int getDamageLevel() {
        return this.iDamageLevel;
    }

    public void levelInit() {
        this.iState = 0;
    }

    public void toRun(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        this.iState = 1;
        this.iDirection = n;
        this.iSide = n2;
        this.iSpeed = n3;
        this.setPosition(n4, n5);
        this.bDestroyRock = bl;
        this.iDamageLevel = n6;
    }

    public void setPosition(int n, int n2) {
        switch (this.iDirection) {
            case 1: {
                this.x = n + 7;
                this.y = n2 + 2;
                break;
            }
            case 2: {
                this.x = n + 7;
                this.y = n2 + 12;
                break;
            }
            case 3: {
                this.x = n + 2;
                this.y = n2 + 7;
                break;
            }
            case 4: {
                this.x = n + 12;
                this.y = n2 + 7;
            }
        }
    }

    public void sceneUpdate() {
        switch (this.iState) {
            case 1: {
                this.move();
                this.checkCollides();
                if (this.iSpeed <= 1 || this.iState != 1) break;
                this.move();
                this.checkCollides();
                break;
            }
            case 2: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.toWait();
                break;
            }
            case 3: {
                --this.iTime;
                if (this.iTime > 0) break;
                this.iState = 0;
            }
        }
    }

    public void move() {
        this.x += this.iDirection / 3 * (this.iDirection / 4 * 2 - 1) * 4;
        this.y += (1 - this.iDirection / 3) * (this.iDirection / 2 * 2 - 1) * 4;
    }

    public void toExplode() {
        this.iState = 2;
        this.iTime = 2;
    }

    public void toWait() {
        this.iState = 3;
        this.iTime = (2 - this.iSpeed) * 4;
    }

    public void checkCollides() {
        if (this.x > 206 || this.x < 0 || this.y > 206 || this.y < 0) {
            this.toExplode();
            return;
        }
        int n = 0;
        int n2 = 0;
        switch (this.iDirection) {
            case 1: {
                n = (this.x - 3) / 4;
                n2 = (this.y - 2) / 4;
                break;
            }
            case 2: {
                n = (this.x - 3) / 4;
                n2 = this.y / 4;
                break;
            }
            case 3: {
                n = (this.x - 2) / 4;
                n2 = (this.y - 3) / 4;
                break;
            }
            case 4: {
                n = this.x / 4;
                n2 = (this.y - 3) / 4;
            }
        }
        if (tlmap[0][n2][n] != 0 || tlmap[0][n2 + this.iDirection / 3][n + (1 - this.iDirection / 3)] != 0) {
            if (this.iDamageLevel < 2) {
                this.toExplode();
                if (!this.bDestroyRock) {
                    this.clearLayerMap(0, n2, n, this.iDirection, 1, 4);
                } else {
                    this.clearLayerMap(0, n2, n, this.iDirection, 2, 4);
                }
            } else {
                this.clearLayerMap(0, n2, n, this.iDirection, 1, 4);
            }
        }
        switch (this.iDirection) {
            case 1: {
                n = (this.x - 7) / 8;
                n2 = (this.y - 6) / 8;
                break;
            }
            case 2: {
                n = (this.x - 7) / 8;
                n2 = this.y / 8;
                break;
            }
            case 3: {
                n = (this.x - 6) / 8;
                n2 = (this.y - 7) / 8;
                break;
            }
            case 4: {
                n = this.x / 8;
                n2 = (this.y - 7) / 8;
            }
        }
        if (tlmap[1][n2][n] != 0 || tlmap[1][n2 + this.iDirection / 3][n + (1 - this.iDirection / 3)] != 0) {
            if (this.iDamageLevel < 4) {
                if (this.iDamageLevel < 2) {
                    if (this.bDestroyRock) {
                        this.clearLayerMap(1, n2, n, this.iDirection, 1, 2);
                    }
                } else {
                    this.clearLayerMap(1, n2, n, this.iDirection, this.iDamageLevel - 1, 2);
                }
                this.toExplode();
            } else {
                this.clearLayerMap(1, n2, n, this.iDirection, 1, 2);
            }
        }
        for (int i = 0; i < 2; ++i) {
            if (this.x + i < 96 || this.x + i >= 112 || this.y + (i + 2) / 2 < 192 || bFlagDestroyed) continue;
            this.toExplode();
            bFlagDestroyed = true;
            tc.flagToExplode();
        }
        if (tc.ifBulletCollidesTank(this) && this.iDamageLevel < 5) {
            this.toExplode();
        }
        if (tc.ifBulletCollidesBullet(this) && this.iDamageLevel < 2) {
            this.toExplode();
        }
    }

    public void clearLayerMap(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 / 2 + 1;
        int n8 = (1 - n4 / 3) * (n4 * 2 - 3);
        int n9 = n4 / 3 * (n4 * 2 - 7);
        int n10 = n4 / 3;
        int n11 = 1 - n4 / 3;
        for (int i = 0; i < n5; ++i) {
            for (int j = 1 - n6 / 2; j < n7; ++j) {
                Bullet.tlmap[n][n2 + n10 * j + n8 * i][n3 + n11 * j + n9 * i] = 0;
            }
        }
        Bullet.mapReset(n);
    }

    public boolean ifCollidesBullet(Bullet bullet) {
        if (this.iState == 1) {
            int n = bullet.getSide();
            int n2 = bullet.getX();
            int n3 = bullet.getY();
            int n4 = this.getMinusAbs(n, this.iSide);
            int n5 = this.getMinusAbs(n2, this.x);
            int n6 = this.getMinusAbs(n3, this.y);
            if (n4 > 0 && (n5 == 0 && n6 == 2 || n5 == 2 && n6 == 0 || n5 == 1 && n6 == 1)) {
                if (this.iDamageLevel < 2) {
                    this.toExplode();
                }
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics graphics) {
        switch (this.iState) {
            case 1: {
                if (this.iDamageLevel < 2) {
                    graphics.setColor(255, 255, 255);
                    graphics.fillRect(this.x, this.y, 2, 2);
                    break;
                }
                graphics.setColor(255, 255, 255);
                graphics.fillRect(this.x - 1, this.y, 4, 2);
                graphics.fillRect(this.x, this.y - 1, 2, 4);
                break;
            }
            case 2: {
                if (this.iTime <= 0) break;
                Bullet.drawBulletExplode(graphics, this.x - 7, this.y - 7);
            }
        }
    }
}

