/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.views;

import com.downjoy.j2me.smspack.util.RmsUtil;
import com.downjoy.j2me.smspack.util.SMSPackInfoReader;
import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import com.downjoy.j2me.smspack.util.TextAjust;
import com.downjoy.j2me.smspack.views.PayedCallback;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class SMSPayCanvas
extends Canvas
implements Runnable {
    private static final int CHINA_MOBILE_TYPE = 0;
    private static final int CHINA_UNICOM_TYPE = 1;
    private static final int CHINA_TELECOM_TYPE = 2;
    private static int srcWidth = 240;
    private static int srcHeight = 320;
    private int[][] BUTTON_BOX = new int[4][4];
    private static final String[] platformName = new String[]{"Nokia", "Motorokr", "Motorola", "SonyEricsson", "Samsung", "j2me", "SunMicrosystems_wtk", "MX6", "MotoA668"};
    private String currPlatform = null;
    private static final int LEFT_SOFT_CODE = -6;
    private static final int RIGHT_SOFT_CODE = -7;
    private static final int LEFT_SOFT_CODE_MOTO1 = -21;
    private static final int RIGHT_SOFT_CODE_MOTO1 = -22;
    private static final int LEFT_SOFT_CODE_MOTO2 = 21;
    private static final int RIGHT_SOFT_CODE_MOTO2 = 22;
    private static final int LEFT_SOFT_CODE_PHILIPS = -202;
    private static final int RIGHT_SOFT_CODE_PHILIPS = -203;
    private SMSPackInfoVO smsPackInfo;
    private String stringItem = null;
    private MIDlet midlet = null;
    private Displayable gameDisplayable;
    private int topIndex = 0;
    private int bootomIndex = 0;
    private String leftCommand = "\u70b9\u64ad";
    private String rigthCommand = "\u8fd4\u56de";
    private String cpId = null;
    private String gameId = null;
    private String actionId = null;
    private String eqpId = null;
    private int fee = 0;
    private String product = null;
    private String cpMemo = null;
    private String cpTel = null;
    private String title = "\u8ba2\u8d2d";
    private PayedCallback payedCallback = null;
    private int text_move = -1;

    public SMSPayCanvas(MIDlet mIDlet, Displayable displayable, String string, String string2, String string3, String string4, int n2, String string5, String string6, String string7) {
        this.setFullScreenMode(true);
        try {
            this.midlet = mIDlet;
            this.gameDisplayable = displayable;
            this.cpId = string;
            this.gameId = string2;
            if (string3 == null || string3.length() == 0) {
                string3 = "00";
            }
            if (string4 == null || string4.length() == 0) {
                string4 = "000";
            }
            this.actionId = string3;
            this.eqpId = string4;
            this.fee = n2;
            this.product = string5;
            this.cpMemo = string6;
            this.cpTel = string7;
            this.loadSpecKey(mIDlet);
            srcWidth = this.getWidth();
            srcHeight = this.getHeight();
            this.setButtonBox();
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void sizeChanged(int n2, int n3) {
        super.sizeChanged(n2, n3);
        srcWidth = this.getWidth();
        srcHeight = this.getHeight();
        this.setButtonBox();
    }

    private void setButtonBox() {
        Font font = Font.getFont((int)0, (int)1, (int)0);
        int n2 = font.getHeight() + 4;
        int n3 = TextAjust.getStringWidth("\u70b9\u64ad", font) + 4;
        this.BUTTON_BOX[0][0] = 2;
        this.BUTTON_BOX[0][1] = srcHeight - n2;
        this.BUTTON_BOX[0][2] = n3;
        this.BUTTON_BOX[0][3] = srcHeight;
        this.BUTTON_BOX[1][0] = srcWidth - n3;
        this.BUTTON_BOX[1][1] = srcHeight - n2;
        this.BUTTON_BOX[1][2] = srcWidth;
        this.BUTTON_BOX[1][3] = srcHeight;
        this.BUTTON_BOX[2][0] = srcWidth / 2 - (n3 *= 2);
        this.BUTTON_BOX[2][1] = srcHeight - n2;
        this.BUTTON_BOX[2][2] = srcWidth / 2;
        this.BUTTON_BOX[2][3] = srcHeight;
        this.BUTTON_BOX[3][0] = srcWidth / 2;
        this.BUTTON_BOX[3][1] = srcHeight - n2;
        this.BUTTON_BOX[3][2] = srcWidth / 2 + n3;
        this.BUTTON_BOX[3][3] = srcHeight;
    }

    private void loadSpecKey(MIDlet mIDlet) {
        int n2 = 0;
        String string = null;
        try {
            string = mIDlet.getAppProperty("Platform");
            if (string == null) {
                string = System.getProperty("microedition.platform");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            string = string.toLowerCase();
            String string2 = null;
            n2 = 0;
            while (n2 < platformName.length) {
                string2 = platformName[n2].toLowerCase();
                if (string.length() >= string2.length() && string.startsWith(string2)) break;
                ++n2;
            }
            this.currPlatform = string2;
        }
    }

    private void init() {
        this.leftCommand = "\u70b9\u64ad";
        this.rigthCommand = "\u8fd4\u56de";
        this.loadPayInfo();
    }

    private void loadPayInfo() {
        this.smsPackInfo = RmsUtil.loadFromRecordStore(this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
        if (this.smsPackInfo != null && this.smsPackInfo.isNeedConfirm()) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (calendar.getTime().getTime() > this.smsPackInfo.getLastSendFreeTime()) {
                this.smsPackInfo.setLastSendFreeTime(0L);
                if (this.smsPackInfo != null && this.smsPackInfo.getSendedCnt() % 2 != 0) {
                    this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() - 1);
                }
            }
        }
        try {
            if (this.smsPackInfo == null || this.smsPackInfo != null && this.smsPackInfo.getPayedMoney() >= this.fee) {
                this.smsPackInfo = SMSPackInfoReader.getSMSPackInfo(this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.leftCommand = "";
            this.outputInfo(exception.toString());
            return;
        }
        this.showInfo();
    }

    private void showInfo() {
        if (this.smsPackInfo.getSendedCnt() == 0) {
            this.showPayInfo();
        } else {
            this.showPayInfo2(false);
        }
    }

    private void showPayInfo() {
        if (this.smsPackInfo == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.cpMemo);
        stringBuffer.append("\n\u60a8\u9700\u53d1\u9001");
        if (!this.smsPackInfo.isNeedConfirm() && this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
            stringBuffer.append("1\u6761\u514d\u8d39\u77ed\u4fe1\u548c");
        }
        stringBuffer.append(this.smsPackInfo.getFeeSMSCnt()).append("\u6761\u6536\u8d39\u77ed\u4fe1(");
        stringBuffer.append(this.smsPackInfo.getFeeSMSUnitPrice()).append("\u5143/\u6761)\uff0c\u5408\u8ba1").append(this.fee).append("\u5143");
        stringBuffer.append("\uff0c\u4e0d\u542b\u901a\u4fe1\u8d39\u3002");
        stringBuffer.append("\u5ba2\u670d\u7535\u8bdd\uff1a").append(this.cpTel).append("\n  ");
        stringBuffer.append(this.smsPackInfo.getFeeSMSTitle());
        this.outputInfo(stringBuffer.toString());
    }

    private void showPayInfo2(boolean bl) {
        if (this.smsPackInfo.isNeedConfirm()) {
            String string;
            if (bl) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if ((string = this.smsPackInfo.getFeeSMSNum()).startsWith("10658008")) {
                string = "10658008";
            }
            if (this.smsPackInfo.getSendedCnt() % 2 == 0) {
                int n2 = this.smsPackInfo.getFeeSMSCnt() * 2;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u5df2\u7ecf\u53d1\u9001\u4e86" + this.smsPackInfo.getSendedCnt() / 2 + "\u6761\u6536\u8d39\u77ed\u4fe1\uff0c\u8fd8\u9700\u53d1\u9001" + (n2 - this.smsPackInfo.getSendedCnt()) / 2 + "\u6761\u6536\u8d39\u77ed\u4fe1");
                stringBuffer.append("\u3002\n").append(this.smsPackInfo.getFeeSMSTitle());
                this.outputInfo(stringBuffer.toString());
            } else {
                this.outputInfo("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u518d\u6b21\u70b9\u64ad\u5373\u540c\u610f\u5411" + string + "\u53d1\u9001\u77ed\u4fe1\u4ee5\u786e\u8ba4\u8d2d\u4e70" + this.product + ",\u6b64\u6761\u77ed\u4fe1\u4e3a\uff1a" + this.smsPackInfo.getFeeSMSUnitPrice() + "\u5143\uff0c\u4e0d\u542b\u901a\u4fe1\u8d39\uff0c\u8bf7\u5728\u9875\u9762\u5b8c\u6210\u8d2d\u4e70\uff0c\u8fd4\u56de\u5219\u4e0d\u6263\u8d39\u3002\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
            }
        } else {
            int n3 = this.smsPackInfo.getFeeSMSCnt();
            if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u5df2\u7ecf\u53d1\u9001\u4e86" + this.smsPackInfo.getSendedCnt() + "\u6761\u77ed\u4fe1\uff0c\u8fd8\u9700\u53d1\u9001" + (n3 - this.smsPackInfo.getSendedCnt()) + "\u6761\u77ed\u4fe1");
            if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
                stringBuffer.append(",\u7b2c\u4e00\u6761\u514d\u8d39\u77ed\u4fe1\u662f\u7528\u4e8e\u63a5\u6536\u514d\u8d39\u6e38\u620f\u4fe1\u606f\u7684");
            }
            stringBuffer.append("\u3002\n").append(this.smsPackInfo.getFeeSMSTitle());
            this.outputInfo(stringBuffer.toString());
        }
    }

    private void payWithSMS() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.smsPackInfo.getFreeSMSNum() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && (this.smsPackInfo.getLastSendFreeTime() == 0L || this.smsPackInfo.isNeedConfirm() && this.smsPackInfo.getSendedCnt() % 2 == 0)) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFreeSMSNum(), this.smsPackInfo.getFreeSMSContent())) {
                this.smsPackInfo.setLastSendFreeTime(System.currentTimeMillis());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
                this.showPayInfo2(true);
                this.leftCommand = "\u70b9\u64ad";
                this.rigthCommand = "\u8fd4\u56de";
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
            this.repaint();
            return;
        }
        if (this.smsPackInfo.getPayedMoney() < this.fee) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFeeSMSNum(), this.smsPackInfo.getFeeSMSContent())) {
                this.smsPackInfo.setPayedMoney(this.smsPackInfo.getPayedMoney() + this.smsPackInfo.getFeeSMSUnitPrice());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
                this.rigthCommand = "\u8fd4\u56de";
                if (this.smsPackInfo.getPayedMoney() == this.fee) {
                    this.leftCommand = "";
                    this.outputInfo("\u611f\u8c22\u60a8\u8d2d\u4e70" + this.product + "\uff0c\u8d39\u7528\u4e3a" + this.fee + "\u5143,\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
                } else {
                    this.leftCommand = "\u70b9\u64ad";
                    this.showPayInfo2(false);
                }
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
        }
    }

    private boolean sendSMS(String string, String string2) {
        boolean bl = true;
        return bl;
    }

    private int getPhoneNetworkType() {
        String string = System.getProperty("wireless.messaging.sms.smsc");
        if (string != null) {
            if (string.startsWith("138") || string.startsWith("+138") || string.startsWith("+86138")) {
                return 0;
            }
            if (string.startsWith("+86130") || string.startsWith("0086130") || string.startsWith("130") || string.startsWith("+130")) {
                return 1;
            }
        }
        return 0;
    }

    private void outputInfo(String string) {
        this.topIndex = 0;
        this.stringItem = string;
        this.repaint();
    }

    private void callback() {
        if (this.payedCallback != null) {
            this.payedCallback.callback(this.smsPackInfo.getPayedMoney() >= this.fee);
        }
    }

    private int convertKey(int n2) {
        if ("Motorola".equals(this.currPlatform)) {
            switch (n2) {
                case -21: 
                case 21: {
                    return -6;
                }
                case -22: 
                case 22: {
                    return -7;
                }
                case -6: {
                    return 56;
                }
            }
        }
        return n2;
    }

    protected void keyPressed(int n2) {
        n2 = this.convertKey(n2);
        switch (n2) {
            case -202: 
            case -21: 
            case -6: 
            case 21: {
                this.doCommandLeft();
                break;
            }
            case -203: 
            case -22: 
            case -7: 
            case 22: {
                this.doCommandRight();
                break;
            }
            case 50: {
                this.doCommandUp();
                break;
            }
            case 56: {
                this.doCommandDown();
                break;
            }
            default: {
                System.out.println(n2);
            }
        }
        int n3 = this.getGameAction(n2);
        switch (n3) {
            case 1: {
                this.doCommandUp();
                return;
            }
            case 6: {
                this.doCommandDown();
                return;
            }
        }
    }

    private boolean touch_button(int n2, int n3, int n4) {
        return n2 > this.BUTTON_BOX[n4][0] && n2 < this.BUTTON_BOX[n4][2] && n3 > this.BUTTON_BOX[n4][1] && n3 < this.BUTTON_BOX[n4][3];
    }

    protected void pointerPressed(int n2, int n3) {
        if (this.touch_button(n2, n3, 0)) {
            this.doCommandLeft();
        } else if (this.touch_button(n2, n3, 1)) {
            this.doCommandRight();
        } else if (this.touch_button(n2, n3, 2)) {
            if (this.text_move == 0 || this.text_move == 1) {
                this.doCommandUp();
            }
        } else if (this.touch_button(n2, n3, 3) && (this.text_move == 0 || this.text_move == 2)) {
            this.doCommandDown();
        }
    }

    protected void keyRepeated(int n2) {
        super.keyRepeated(n2);
        this.keyPressed(n2);
    }

    public void doCommandUp() {
        --this.topIndex;
        if (this.topIndex <= 0) {
            this.topIndex = 0;
        }
        this.repaint();
    }

    public void doCommandDown() {
        if (this.bootomIndex > 0) {
            ++this.topIndex;
        }
        this.repaint();
    }

    public void doCommandLeft() {
        if ("\u70b9\u64ad".equals(this.leftCommand) && this.smsPackInfo.getFeeSMSCnt() > 0) {
            this.leftCommand = "";
            this.rigthCommand = "";
            this.payWithSMS();
        } else if ("\u786e\u5b9a".equals(this.leftCommand)) {
            this.leftCommand = "\u70b9\u64ad";
            this.rigthCommand = "\u8fd4\u56de";
            this.showInfo();
        }
    }

    public void doCommandRight() {
        if ("\u8fd4\u56de".equals(this.rigthCommand)) {
            if (this.smsPackInfo.getPayedMoney() < this.fee) {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u9000\u51fa";
                this.outputInfo("\u60a8\u8fd8\u672a\u5b8c\u6210\u4ed8\u8d39\uff0c\u5efa\u8bae\u60a8\u7ee7\u7eed\u4ed8\u8d39\u3002");
            } else {
                this.callback();
                Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
            }
        } else if ("\u9000\u51fa".equals(this.rigthCommand)) {
            this.callback();
            Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
        }
    }

    public void paint(Graphics graphics) {
        Font font = Font.getDefaultFont();
        font = Font.getFont((int)0, (int)1, (int)0);
        graphics.setColor(4423868);
        graphics.fillRect(0, 0, srcWidth, srcHeight);
        int n2 = 30;
        graphics.setColor(255, 102, 0);
        graphics.fillRect(0, 0, srcWidth, n2);
        graphics.setColor(0xFFFFFF);
        int n3 = 2;
        int n4 = (n2 - font.getHeight()) / 2;
        graphics.drawString(this.title, n3, n4, 0);
        graphics.setFont(font);
        int n5 = font.getHeight() + 8;
        n3 = 5;
        n4 = n2 + 5;
        int[] nArray = TextAjust.ajustDrawString(graphics, this.stringItem, font, srcWidth - 10, srcHeight - n5 - 10, this.topIndex, n3, n4, 5);
        this.bootomIndex = nArray[1];
        graphics.setColor(255, 102, 0);
        n3 = 0;
        n4 = srcHeight - n5;
        graphics.fillRect(n3, n4, srcWidth, n5);
        graphics.setColor(0xFFFFFF);
        n3 = 2;
        n4 = srcHeight - (n5 + font.getHeight()) / 2;
        graphics.drawString(this.leftCommand, n3, n4, 0);
        n3 = srcWidth - TextAjust.getStringWidth(this.rigthCommand, font) - n3 - 2;
        graphics.drawString(this.rigthCommand, n3, n4, 0);
        int n6 = srcHeight - n5 / 2;
        this.text_move = -1;
        if (this.topIndex > 0 && this.bootomIndex > 0) {
            this.text_move = 0;
            int n7 = n6 + 5;
            graphics.fillTriangle(srcWidth / 2 - 10 - 3, n7, srcWidth / 2 - 10 + 3, n7, srcWidth / 2 - 10, n7 - 11);
            int n8 = n6 - 5;
            graphics.fillTriangle(srcWidth / 2 + 10 - 3, n8, srcWidth / 2 + 10 + 3, n8, srcWidth / 2 + 10, n8 + 11);
        } else if (this.topIndex > 0) {
            this.text_move = 1;
            graphics.fillTriangle(srcWidth / 2 - 10 - 3, n6 += 5, srcWidth / 2 - 10 + 3, n6, srcWidth / 2 - 10, n6 - 11);
        } else if (this.bootomIndex > 0) {
            this.text_move = 2;
            graphics.fillTriangle(srcWidth / 2 + 10 - 3, n6 -= 5, srcWidth / 2 + 10 + 3, n6, srcWidth / 2 + 10, n6 + 11);
        }
    }

    public PayedCallback getPayedCallback() {
        return this.payedCallback;
    }

    public void setPayedCallback(PayedCallback payedCallback) {
        this.payedCallback = payedCallback;
    }
}

