/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwaEX;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.cwaEX.CWADebug;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWAActor;
import CWA2DAPI.cwabase2d.CWACamera;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAMap;
import game.GameNpc;
import game.GamePlayer;
import game.GameWorld;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CWAWorld
implements CWAGlobal {
    CWAMap map;
    Vector actorTop;
    Vector actor = new Vector();
    Vector actorDown;
    CWACamera camera;

    public CWAWorld() {
        this.actorTop = new Vector();
        this.actorDown = new Vector();
    }

    public void setMap(CWAMap map) {
        this.map = map;
    }

    public void addActor(CWAActor actor) {
        switch (actor.layer) {
            case 0: {
                this.actorTop.addElement(actor);
                break;
            }
            case 1: {
                this.actor.addElement(actor);
                break;
            }
            case 2: {
                this.actorDown.addElement(actor);
            }
        }
    }

    public void removeActor(CWAActor actor) {
        switch (actor.layer) {
            case 0: {
                this.actorTop.removeElement(actor);
                break;
            }
            case 1: {
                this.actor.removeElement(actor);
                break;
            }
            case 2: {
                this.actorDown.removeElement(actor);
            }
        }
    }

    public void changeActorLayer(CWAActor actor, int desLayer) {
        this.removeActor(actor);
        switch (desLayer) {
            case 0: {
                this.actorTop.addElement(actor);
                break;
            }
            case 1: {
                this.actor.addElement(actor);
                break;
            }
            case 2: {
                this.actorDown.addElement(actor);
            }
        }
    }

    public void setCamera(CWACamera camera) {
        this.camera = camera;
    }

    public void clear() {
        this.map = null;
        this.camera = null;
        this.actor.removeAllElements();
        this.actorTop.removeAllElements();
        this.actorDown.removeAllElements();
    }

    public void update() {
        int i;
        this.camera.update();
        this.map.setScreen(this.camera.actorX, this.camera.actorY);
        this.map.update();
        for (i = 0; i < this.actorTop.size(); ++i) {
            ((CWASprActor)this.actorTop.elementAt(i)).updateAction();
        }
        for (i = 0; i < this.actor.size(); ++i) {
            for (int j = 0; j < this.actor.size() - i - 1; ++j) {
                CWAActor cwaA = (CWAActor)this.actor.elementAt(j);
                CWAActor cwaB = (CWAActor)this.actor.elementAt(j + 1);
                if (cwaA.actorY <= cwaB.actorY) continue;
                CWAActor temp = cwaA;
                this.actor.setElementAt(cwaB, j);
                this.actor.setElementAt(temp, j + 1);
            }
        }
        for (i = 0; i < this.actor.size(); ++i) {
            CWASprActor cwaSpr = (CWASprActor)this.actor.elementAt(i);
            cwaSpr.updateAction();
            if (!(cwaSpr instanceof GameNpc)) continue;
            if (((GameNpc)cwaSpr).bqSprite != null && ((GameNpc)cwaSpr).bqSprite.isAction()) {
                ((GameNpc)cwaSpr).bqSprite.updateAction();
                continue;
            }
            if (((GameNpc)cwaSpr).tipSprite == null || !((GameNpc)cwaSpr).tipSprite.isAction()) continue;
            ((GameNpc)cwaSpr).tipSprite.updateAction();
        }
        for (i = 0; i < this.actorDown.size(); ++i) {
            CWASprActor cwaSpr = (CWASprActor)this.actorDown.elementAt(i);
            cwaSpr.updateAction();
        }
    }

    public void render(Graphics g, int type) {
        this.map.drawMap(g, 1, type);
        this.map.drawMap(g, 2, type);
        for (int i = 0; i < this.actorDown.size(); ++i) {
            if (!((CWASprActor)this.actorDown.elementAt(i)).isScreen()) continue;
            ((CWASprActor)this.actorDown.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
        }
        int debug = 0;
        try {
            int i;
            if (GameWorld.getInstance().gameplayer.pokRidePet[2] == 2) {
                debug = 1;
                for (i = 0; i < this.actor.size(); ++i) {
                    debug = 2;
                    debug = 2;
                    if (((CWASprActor)this.actor.elementAt(i)).isScreen()) {
                        if ((CWASprActor)this.actor.elementAt(i) instanceof GamePlayer) continue;
                        debug = 3;
                        ((CWASprActor)this.actor.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                    }
                    if ((CWASprActor)this.actor.elementAt(i) instanceof GameNpc && ((GameNpc)this.actor.elementAt((int)i)).npcType == 14) {
                        debug = 4;
                        ((GameNpc)this.actor.elementAt(i)).renderLaser(g, this.map.leftTopX, this.map.leftTopY);
                    }
                    debug = 501;
                    if (!((CWASprActor)this.actor.elementAt(i) instanceof GameNpc)) continue;
                    if (((GameNpc)this.actor.elementAt((int)i)).bqSprite != null && ((GameNpc)this.actor.elementAt((int)i)).bqSprite.isVisible()) {
                        debug = 5;
                        ((GameNpc)this.actor.elementAt((int)i)).bqSprite.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                        continue;
                    }
                    if (((GameNpc)this.actor.elementAt((int)i)).tipSprite == null || !((GameNpc)this.actor.elementAt((int)i)).tipSprite.isVisible()) continue;
                    debug = 6;
                    ((GameNpc)this.actor.elementAt((int)i)).tipSprite.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                }
                debug = 7;
                byte tile = CWAMap.getInstance().getMapTile(0, GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY);
                debug = 8;
                if (tile != 1 && GameWorld.getInstance().gameplayer.shadowActor != null && GameWorld.getInstance().gameplayer.isVisible()) {
                    debug = 9;
                    GameWorld.getInstance().gameplayer.shadowActor.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                }
                debug = 10;
                GameWorld.getInstance().gameplayer.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
            } else {
                for (i = 0; i < this.actor.size(); ++i) {
                    debug = 110;
                    debug = 11;
                    if (((CWASprActor)this.actor.elementAt(i)).isScreen()) {
                        debug = 12;
                        if (((CWASprActor)this.actor.elementAt((int)i)).shadowActor != null && ((CWASprActor)this.actor.elementAt(i)).isVisible()) {
                            debug = 13;
                            ((CWASprActor)this.actor.elementAt((int)i)).shadowActor.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                        }
                        debug = 14;
                        ((CWASprActor)this.actor.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                    }
                    if ((CWASprActor)this.actor.elementAt(i) instanceof GameNpc && ((GameNpc)this.actor.elementAt((int)i)).npcType == 14) {
                        debug = 15;
                        ((GameNpc)this.actor.elementAt(i)).renderLaser(g, this.map.leftTopX, this.map.leftTopY);
                    }
                    debug = 16;
                    if (!((CWASprActor)this.actor.elementAt(i) instanceof GameNpc) || !((GameNpc)this.actor.elementAt(i)).isScreen()) continue;
                    debug = 17;
                    if (((GameNpc)this.actor.elementAt((int)i)).bqSprite != null && ((GameNpc)this.actor.elementAt((int)i)).bqSprite.isVisible()) {
                        debug = 18;
                        ((GameNpc)this.actor.elementAt((int)i)).bqSprite.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                        continue;
                    }
                    if (((GameNpc)this.actor.elementAt((int)i)).tipSprite == null || !((GameNpc)this.actor.elementAt((int)i)).tipSprite.isVisible()) continue;
                    debug = 19;
                    ((GameNpc)this.actor.elementAt((int)i)).tipSprite.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
                }
            }
        }
        catch (Exception e) {
            CWADebug.setErrorMsg(e, "" + debug);
        }
        this.map.drawMap(g, 3, type);
        for (int i = 0; i < this.actorTop.size(); ++i) {
            CWASprActor cwaSpr = (CWASprActor)this.actorTop.elementAt(i);
            if (!cwaSpr.isScreen()) continue;
            cwaSpr.drawSprite(g, this.map.leftTopX, this.map.leftTopY);
        }
    }

    public void renderMap(Graphics g) {
        int i;
        GameWorld.getInstance().backRender(g, 0, 0, CWACommon.getWidth(), CWACommon.getHeight());
        this.map.drawMap(g, 1, 1);
        this.map.drawMap(g, 2, 1);
        for (i = 0; i < this.actorDown.size(); ++i) {
            if (!((CWASprActor)this.actorDown.elementAt(i)).isScreen() || !(this.actorDown.elementAt(i) instanceof GameNpc) || ((GameNpc)this.actorDown.elementAt((int)i)).npcType != 0) continue;
            ((CWASprActor)this.actorDown.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
        }
        for (i = 0; i < this.actor.size(); ++i) {
            if (!((CWASprActor)this.actor.elementAt(i)).isScreen() || !(this.actor.elementAt(i) instanceof GameNpc) || ((GameNpc)this.actor.elementAt((int)i)).npcType != 0) continue;
            ((CWASprActor)this.actor.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
        }
        this.map.drawMap(g, 3, 1);
        for (i = 0; i < this.actorTop.size(); ++i) {
            if (!((CWASprActor)this.actorTop.elementAt(i)).isScreen() || !(this.actorTop.elementAt(i) instanceof GameNpc) || ((GameNpc)this.actorTop.elementAt((int)i)).npcType != 0) continue;
            ((CWASprActor)this.actorTop.elementAt(i)).drawSprite(g, this.map.leftTopX, this.map.leftTopY);
        }
        for (i = 0; i < CWACommon.getWidth() / CWADataManager.bk.getWidth(); ++i) {
            for (int j = 0; j < CWACommon.getHeight() / CWADataManager.bk.getHeight(); ++j) {
                g.drawImage(CWADataManager.bk, i * CWADataManager.bk.getWidth(), j * CWADataManager.bk.getHeight(), 20);
            }
        }
    }
}

