/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import CWA2DAPI.CWATools;
import CWA2DAPI.cwabase2d.CWASprite;

public class CWAActor {
    public short[] baseProp;
    public short[] curProp;
    protected boolean isAction;
    protected boolean isVisible;
    protected boolean isScreen;
    protected byte roleState;
    protected byte preRoleState;
    public int actorX;
    public int actorY;
    public int actorH;
    public int preX;
    public int preY;
    public int preH;
    public byte preFaceDir;
    public byte faceDir;
    public byte afterDir;
    public CWAActor target;
    public int targetX;
    public int targetY;
    public int layer;
    private short stepLenth = (short)10;
    private int[][] followInfo;
    private boolean isFollow = false;
    private boolean changeAction = false;

    public void setProp(byte type, short prop) {
        this.baseProp[type] = prop;
    }

    public void setCurProp(byte type, short prop) {
        this.curProp[type] = prop;
    }

    public void addCurProp(byte type, short prop) {
        byte by = type;
        this.curProp[by] = (short)(this.curProp[by] + prop);
    }

    public short getProp(byte type) {
        return this.baseProp[type];
    }

    public short getCurProp(byte type) {
        return this.curProp[type];
    }

    public void resetCurProp() {
        for (byte i = 0; i < this.baseProp.length; i = (byte)(i + 1)) {
            this.setCurProp(i, this.getProp(i));
        }
    }

    public void setRoleState(byte rolestate) {
        this.roleState = rolestate;
    }

    public byte getRoleState() {
        return this.roleState;
    }

    public void setAction(boolean action) {
        this.isAction = action;
    }

    public boolean isAction() {
        return this.isAction;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setScreen(boolean screen) {
        this.isScreen = screen;
    }

    public boolean isScreen() {
        return this.isScreen;
    }

    public void setPositionX(int x) {
        this.actorX = x;
    }

    public void setPositionY(int y) {
        this.actorY = y;
    }

    public void setPosition(int x, int y) {
        this.actorX = x;
        this.actorY = y;
    }

    public void setPrePosition(int x, int y) {
        this.preX = x;
        this.preY = y;
    }

    public void setPosition(int x, int y, int h) {
        this.actorX = x;
        this.actorY = y;
        this.actorH = h;
    }

    public void setActorDir(byte dir) {
        this.faceDir = dir;
    }

    public void setPreActorDir(byte dir) {
        this.preFaceDir = dir;
    }

    public int getActorX() {
        return this.actorX;
    }

    public int getActorY() {
        return this.actorY;
    }

    public int getActorDir() {
        return this.faceDir;
    }

    public void moveX(int speed) {
        this.actorX += speed;
    }

    public void moveY(int speed) {
        this.actorY += speed;
    }

    public void moveH(int speed) {
        this.actorH += speed;
    }

    public void move(int speedX, int speedY) {
        this.actorX += speedX;
        this.actorY += speedY;
    }

    public void move(int speedX, int speedY, int speedH) {
        this.actorX += speedX;
        this.actorY += speedY;
        this.actorH += speedH;
    }

    public boolean movePoint(int speed, int x, int y) {
        if (this.actorX == x && this.actorY == y) {
            return true;
        }
        int len = CWATools.stance(this.actorX, this.actorY, x, y);
        if (len < speed) {
            this.actorX = x;
            this.actorY = y;
        } else {
            this.moveX((x - this.actorX) * speed / len);
            this.moveY((y - this.actorY) * speed / len);
        }
        return false;
    }

    public void followTarget(CWASprite targetSprite, CWASprite followSprite) {
        if (!this.isFollow) {
            return;
        }
        if (this.target.roleState == 0) {
            return;
        }
        this.followInfo[0][0] = this.target.actorX;
        this.followInfo[0][1] = this.target.actorY;
        this.followInfo[0][2] = targetSprite.action;
        this.followInfo[0][3] = this.target.faceDir;
        for (int i = this.stepLenth; i > 0; --i) {
            this.followInfo[i][0] = this.followInfo[i - 1][0];
            this.followInfo[i][1] = this.followInfo[i - 1][1];
            this.followInfo[i][2] = this.followInfo[i - 1][2];
            this.followInfo[i][3] = this.followInfo[i - 1][3];
            if (i % this.stepLenth != 0) continue;
            this.setPosition(this.followInfo[i][0], this.followInfo[i][1]);
            if (this.followInfo[i][3] == 3) {
                followSprite.setAction((byte)this.followInfo[i][2], (byte)1, false);
            } else {
                followSprite.setAction((byte)this.followInfo[i][2], (byte)this.followInfo[i][3], false);
            }
            this.setActorDir((byte)this.followInfo[i][3]);
        }
    }

    public void followTarget(CWASprite targetSprite) {
        if (!this.isFollow) {
            return;
        }
        this.followInfo[0][0] = this.target.actorX;
        this.followInfo[0][1] = this.target.actorY;
        this.followInfo[0][2] = targetSprite.action;
        this.followInfo[0][3] = this.target.faceDir;
        for (int i = this.stepLenth; i > 0; --i) {
            this.followInfo[i][0] = this.followInfo[i - 1][0];
            this.followInfo[i][1] = this.followInfo[i - 1][1];
            this.followInfo[i][2] = this.followInfo[i - 1][2];
            this.followInfo[i][3] = this.followInfo[i - 1][3];
            if (i % this.stepLenth != 0) continue;
            this.setPosition(this.followInfo[i][0], this.followInfo[i][1]);
            this.setActorDir((byte)this.followInfo[i][3]);
        }
    }

    public void setFollowOn(byte action) {
        int i;
        this.isFollow = true;
        this.followInfo = new int[this.stepLenth + 1][4];
        for (i = 0; i < this.stepLenth + 1; ++i) {
            this.followInfo[i][0] = this.target.actorX;
            this.followInfo[i][1] = this.target.actorY;
            this.followInfo[i][3] = this.target.faceDir;
        }
        if (action >= 0) {
            for (i = 0; i < this.stepLenth + 1; ++i) {
                this.followInfo[i][2] = action;
            }
            this.changeAction = true;
        } else {
            this.changeAction = false;
        }
        switch (this.target.faceDir) {
            case 1: {
                int[] nArray = this.followInfo[10];
                nArray[0] = nArray[0] - this.stepLenth;
                break;
            }
            case 3: {
                int[] nArray = this.followInfo[10];
                nArray[0] = nArray[0] + this.stepLenth;
                break;
            }
            case 2: {
                int[] nArray = this.followInfo[10];
                nArray[1] = nArray[1] + this.stepLenth;
                break;
            }
            case 0: {
                int[] nArray = this.followInfo[10];
                nArray[1] = nArray[1] - this.stepLenth;
            }
        }
        this.setPosition(this.followInfo[10][0], this.followInfo[10][1]);
    }

    public void setFollowOff() {
        this.isFollow = false;
        this.followInfo = null;
    }

    public boolean isFollow() {
        return this.isFollow;
    }

    public void setTarget(CWAActor target) {
        this.target = target;
    }

    public void setTarget(int targetX, int targetY) {
        this.targetX = targetX;
        this.targetY = targetY;
    }
}

