/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAImageUtil;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAImageManager;
import game.GameEvent;
import game.GameWorld;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CWAMap
implements CWAGlobal {
    private static CWAMap _map;
    public static final int[] transform2;
    private static final int[] transforms;
    private int _screenW = -1;
    private int _screenH = -1;
    private short _mapWidth = (short)-1;
    private short _mapHeight = (short)-1;
    private short _tileWidth = (short)-1;
    private short _tileHeight = (short)-1;
    private int _mapId = -1;
    private int _preMapId = -1;
    private byte _modId = (byte)-1;
    private byte _preModId = (byte)-1;
    private Image[] _mapImg = null;
    public int leftTopX;
    public int leftTopY;
    public int tleftTopX;
    public int tleftTopY;
    public int mapW;
    public int mapH;
    protected int startX;
    protected int startY;
    protected int endX;
    protected int endY;
    protected int numX;
    protected int numY;
    private byte layerCount;
    private short[][] modData;
    public short[][][] mapData;
    protected byte[] mapLayerType = null;
    public byte type;
    public static Image mapBuffer;
    public static Graphics mg;
    public static Image mapBuffer1;
    public static Graphics mg1;
    private Image[] mapImg = null;
    boolean firstDraw = true;

    public static CWAMap getInstance() {
        if (_map == null) {
            _map = new CWAMap();
        }
        return _map;
    }

    public CWAMap() {
        this._screenH = CWACommon.getHeight();
        this._screenW = CWACommon.getWidth();
    }

    public void clear() {
        int i;
        if (this._mapImg != null) {
            for (i = 0; i < this._mapImg.length; ++i) {
                this._mapImg[i] = null;
            }
            this._mapImg = null;
        }
        for (i = 0; i < CWADataManager.modImageIndex[this._modId].length; ++i) {
            CWAImageManager.releaseImg(CWADataManager.modImageIndex[this._modId][i]);
        }
        mapBuffer = null;
        mg = null;
        mapBuffer1 = null;
        mg1 = null;
        this.release();
    }

    public void release() {
        this.mapData = null;
        this.mapLayerType = null;
        this.modData = null;
    }

    public void initMap(int mapId) {
        this._preMapId = this._mapId;
        this._mapId = mapId;
        this._loadMap();
        if (mapBuffer == null) {
            mapBuffer = Image.createImage((int)this._screenW, (int)this._screenH);
            mg = mapBuffer.getGraphics();
        }
        if (mapBuffer1 == null) {
            mapBuffer1 = Image.createImage((int)this._screenW, (int)this._screenH);
            mg1 = mapBuffer1.getGraphics();
        }
        this.firstDraw = true;
    }

    private void _loadMap() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/data/map/map_" + this._mapId + ".mid");
            DataInputStream dis = new DataInputStream(is);
            byte dataType = dis.readByte();
            this._preModId = this._modId;
            this._modId = dis.readByte();
            this._loadMod();
            this._mapWidth = dataType == 1 ? (short)dis.readByte() : dis.readShort();
            this._mapHeight = dataType == 1 ? (short)dis.readByte() : dis.readShort();
            this._tileHeight = this._tileWidth = (short)dis.readByte();
            this.mapW = this._mapWidth * this._tileWidth;
            this.mapH = this._mapHeight * this._tileHeight;
            this.layerCount = dis.readByte();
            this.mapLayerType = new byte[this.layerCount];
            this.mapData = new short[this.layerCount][][];
            for (int i = 0; i < this.layerCount; ++i) {
                byte layerId = dis.readByte();
                this.mapLayerType[i] = dis.readByte();
                int sliceNum = dis.readShort();
                if (this.mapLayerType[layerId] == 0 || this.mapLayerType[layerId] == 1) {
                    this.mapData[layerId] = new short[this._mapWidth][this._mapHeight];
                    for (int k = 0; k < this._mapWidth; ++k) {
                        for (int m = 0; m < this._mapHeight; ++m) {
                            this.mapData[layerId][k][m] = -1;
                        }
                    }
                } else {
                    this.mapData[layerId] = new short[sliceNum][4];
                }
                for (int j = 0; j < sliceNum; ++j) {
                    short y;
                    short x;
                    if (dataType == 1) {
                        x = dis.readByte();
                        y = dis.readByte();
                    } else {
                        x = dis.readShort();
                        y = dis.readShort();
                    }
                    short id = dis.readShort();
                    if (this.mapLayerType[i] == 1) {
                        this.mapData[i][x][y] = id;
                        continue;
                    }
                    if (this.mapLayerType[layerId] == 0) {
                        this.mapData[i][x][y] = (short)(id & 0xFFF);
                        continue;
                    }
                    this.mapData[i][j][1] = x;
                    this.mapData[i][j][2] = y;
                    this.mapData[i][j][0] = (short)(id & 0xFFF);
                    this.mapData[i][j][3] = (short)((id & 0x7000) >> 12);
                }
            }
            dis.close();
            is = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void _loadMod() {
        int i;
        if (this._mapImg != null) {
            if (GameEvent.isReCall != 0) {
                for (i = 0; i < this._mapImg.length; ++i) {
                    if (this._mapImg[i] == null) continue;
                    this._mapImg[i] = null;
                }
                this._mapImg = null;
            } else {
                for (i = 0; i < this._mapImg.length; ++i) {
                    for (int j = 0; j < CWADataManager.modImageIndex[this._modId].length; ++j) {
                        if (CWADataManager.modImageIndex[this._preModId][i] != CWADataManager.modImageIndex[this._modId][j]) continue;
                        CWAImageManager.removeImg(CWADataManager.modImageIndex[this._preModId][i]);
                        this._mapImg[i] = null;
                        break;
                    }
                    if (this._mapImg[i] == null) continue;
                    CWAImageManager.releaseImg(CWADataManager.modImageIndex[this._preModId][i]);
                    this._mapImg[i] = null;
                }
                this._mapImg = null;
            }
        }
        this._mapImg = new Image[CWADataManager.modImageIndex[this._modId].length];
        for (i = 0; i < this._mapImg.length; ++i) {
            this._mapImg[i] = GameEvent.isReCall == 1 ? CWAImageUtil.blackWhite(CWAImageManager.getImg(CWADataManager.modImageIndex[this._modId][i])) : CWAImageManager.getImg(CWADataManager.modImageIndex[this._modId][i]);
        }
        try {
            InputStream is = "".getClass().getResourceAsStream("/data/mod/mod_" + this._modId + ".mid");
            DataInputStream br = new DataInputStream(is);
            int sliceNum = br.readShort();
            this.modData = new short[sliceNum][5];
            for (int i2 = 0; i2 < sliceNum; ++i2) {
                this.modData[i2][0] = br.readByte();
                this.modData[i2][1] = br.readShort();
                this.modData[i2][2] = br.readShort();
                this.modData[i2][3] = br.readShort();
                this.modData[i2][4] = br.readShort();
            }
            br.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reCallImage() {
        int i;
        for (i = 0; i < this._mapImg.length; ++i) {
            if (GameEvent.isReCall == 1) {
                this._mapImg[i] = CWAImageUtil.blackWhite(CWAImageManager.getImg(CWADataManager.modImageIndex[this._modId][i]));
                continue;
            }
            CWAImageManager.releaseImg(CWADataManager.modImageIndex[this._modId][i]);
        }
        if (GameEvent.isReCall == 0) {
            for (i = 0; i < this._mapImg.length; ++i) {
                this._mapImg[i] = CWAImageManager.getImg(CWADataManager.modImageIndex[this._modId][i]);
            }
        }
    }

    private long getNum(byte[] b) {
        long rtn = 0L;
        int len = b.length;
        block5: for (int i = 0; i < len; ++i) {
            switch (len) {
                case 1: {
                    rtn = (byte)(b[i] << (len - i - 1) * 8);
                    continue block5;
                }
                case 2: {
                    rtn = (short)(rtn + (long)(b[i] << (len - i - 1) * 8));
                    continue block5;
                }
                case 4: {
                    rtn = (int)(rtn + (long)(b[i] << (len - i - 1) * 8));
                }
            }
        }
        return rtn;
    }

    public void update() {
        if (this._tileWidth == 0) {
            return;
        }
        this.startY = this.leftTopY / this._tileHeight;
        this.startX = this.leftTopX / this._tileWidth;
        this.endY = (this.leftTopY + this._screenH) / this._tileHeight;
        if ((this.leftTopY + this._screenH) % this._tileHeight != 0) {
            ++this.endY;
        }
        if (this.endY > this._mapHeight) {
            this.endY = this._mapHeight;
        }
        this.endX = (this.leftTopX + this._screenW) / this._tileWidth;
        if ((this.leftTopX + this._screenW) % this._tileWidth != 0) {
            ++this.endX;
        }
        if (this.endX > this._mapWidth) {
            this.endX = this._mapWidth;
        }
        this.numY = this._screenH / this._tileHeight + 1;
        this.numX = this._screenW / this._tileWidth + 1;
        if (this.startY + this.numY >= this._mapHeight) {
            this.numY = this._mapHeight - 1 - this.startY;
        }
        if (this.numX + this.startX >= this._mapWidth) {
            this.numX = this._mapWidth - 1 - this.startX;
        }
    }

    public void drawOther(Graphics g, int layer) {
        if (this.firstDraw) {
            int x_min = this.leftTopX / this._tileWidth < 0 ? 0 : this.leftTopX / this._tileWidth;
            int y_min = this.leftTopY / this._tileHeight < 0 ? 0 : this.leftTopY / this._tileHeight;
            int x_max = (this.leftTopX + this._screenW) / this._tileWidth + 1 > this._mapWidth ? this._mapWidth : (this.leftTopX + this._screenW) / this._tileWidth + 1;
            int y_max = (this.leftTopY + this._screenH) / this._tileHeight + 1 > this._mapHeight ? this._mapHeight : (this.leftTopY + this._screenH) / this._tileHeight + 1;
            GameWorld.getInstance().backRender(mg, 0, 0, this._screenW, this._screenH);
            switch (this.mapLayerType[layer]) {
                case 0: {
                    this.drawLayerColl(mg, layer, x_min, y_min, x_max, y_max);
                    break;
                }
                case 1: {
                    this.drawLayerGrid(mg, layer, x_min, y_min, x_max, y_max);
                }
            }
            this.firstDraw = false;
        } else if (this.tleftTopX != this.leftTopX || this.tleftTopY != this.leftTopY) {
            int ex = 0;
            int ey = 0;
            if (this.leftTopX > this.tleftTopX) {
                ex = this.tleftTopX - this.leftTopX;
            } else if (this.leftTopX < this.tleftTopX) {
                ex = this.tleftTopX - this.leftTopX;
            }
            if (this.leftTopY > this.tleftTopY) {
                ey = this.tleftTopY - this.leftTopY;
            } else if (this.leftTopY < this.tleftTopY) {
                ey = this.tleftTopY - this.leftTopY;
            }
            mg1.drawImage(mapBuffer, ex, ey, 20);
            int minX = 0;
            int minY = 0;
            int maxX = 0;
            int maxY = 0;
            if (this.leftTopX > this.tleftTopX) {
                minX = (this.tleftTopX + this._screenW) / this._tileWidth;
                this.drawUpdate(mg1, layer, minX, this.startY, this.endX, this.endY);
            } else if (this.leftTopX < this.tleftTopX) {
                maxX = this.tleftTopX / this._tileWidth + 1;
                this.drawUpdate(mg1, layer, this.startX, this.startY, maxX, this.endY);
            }
            if (this.leftTopY > this.tleftTopY) {
                minY = (this.tleftTopY + this._screenH) / this._tileHeight;
                this.drawUpdate(mg1, layer, this.startX, minY, this.endX, this.endY);
            } else if (this.leftTopY < this.tleftTopY) {
                maxY = this.tleftTopY / this._tileHeight + 1;
                this.drawUpdate(mg1, layer, this.startX, this.startY, this.endX, maxY);
            }
            mg.drawImage(mapBuffer1, 0, 0, 20);
        }
        g.drawImage(mapBuffer, 0, 0, 20);
        this.tleftTopX = this.leftTopX;
        this.tleftTopY = this.leftTopY;
    }

    public void drawUpdate(Graphics g, int layer, int minX, int minY, int maxX, int maxY) {
        GameWorld.getInstance().backRender(g, minX, minY, maxX, maxY);
        switch (this.mapLayerType[layer]) {
            case 0: {
                this.drawLayerColl(g, layer, minX, minY, maxX, maxY);
                break;
            }
            case 1: {
                this.drawLayerGrid(g, layer, minX, minY, maxX, maxY);
            }
        }
    }

    public void drawMap(Graphics g, int layer, int type) {
        block0 : switch (type) {
            case 1: {
                switch (this.mapLayerType[layer]) {
                    case 0: 
                    case 1: {
                        this.drawOther(g, layer);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.drawLayerTile(g, layer);
                    }
                }
                break;
            }
            case 2: {
                switch (this.mapLayerType[layer]) {
                    case 0: {
                        this.drawLayerColl(g, layer, 0, 0, this._screenW / this._tileWidth, this._screenH / this._tileWidth);
                        break block0;
                    }
                    case 1: {
                        this.drawLayerGrid(g, layer, 0, 0, this._screenW / this._tileWidth, this._screenH / this._tileWidth);
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.drawLayerTile(g, layer);
                    }
                }
            }
        }
    }

    public void drawLayerColl(Graphics g, int layer, int minX, int minY, int maxX, int maxY) {
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                short sliceId = this.mapData[layer][x][y];
                if (sliceId == -1) continue;
                g.drawRegion(this._mapImg[0], (int)this.modData[sliceId][1], (int)this.modData[sliceId][2], (int)this.modData[sliceId][3], (int)this.modData[sliceId][4], 0, x * this._tileWidth - this.leftTopX, y * this._tileHeight - this.leftTopY, 20);
            }
        }
    }

    public void drawLayerGrid(Graphics g, int layer, int minX, int minY, int maxX, int maxY) {
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                short id = this.mapData[layer][x][y];
                if (id == -1) continue;
                short sliceId = (short)(id & 0xFFF);
                short trans = (short)transforms[(id & 0x7000) >> 12];
                g.drawRegion(this._mapImg[this.modData[sliceId][0]], (int)this.modData[sliceId][1], (int)this.modData[sliceId][2], (int)this.modData[sliceId][3], (int)this.modData[sliceId][4], (int)trans, x * this._tileWidth - this.leftTopX, y * this._tileHeight - this.leftTopY, 20);
            }
        }
    }

    public void drawLayerTile(Graphics g, int layer) {
        for (int i = 0; i < this.mapData[layer].length; ++i) {
            if (this.mapData[layer][i][2] < 0 || !CWATools.isCollide(this.mapData[layer][i][1], this.mapData[layer][i][2], this.modData[this.mapData[layer][i][0]][3], this.modData[this.mapData[layer][i][0]][4], this.startX, this.startY, this.numX + 1, this.numY + 1, this.mapData[layer][i][3])) continue;
            g.drawRegion(this._mapImg[this.modData[this.mapData[layer][i][0]][0]], (int)this.modData[this.mapData[layer][i][0]][1], (int)this.modData[this.mapData[layer][i][0]][2], (int)this.modData[this.mapData[layer][i][0]][3], (int)this.modData[this.mapData[layer][i][0]][4], transforms[this.mapData[layer][i][3]], (this.mapData[layer][i][1] - this.startX) * this._tileWidth - this.leftTopX % this._tileWidth, (this.mapData[layer][i][2] - this.startY) * this._tileHeight - this.leftTopY % this._tileHeight, 20);
        }
    }

    public final void setScreen(int x, int y) {
        this.leftTopX = x - this._screenW / 2;
        this.leftTopY = y - this._screenH / 2;
        if (this.leftTopX + this._screenW >= this._mapWidth * this._tileWidth) {
            this.leftTopX = this._mapWidth * this._tileWidth - this._screenW;
        }
        if (this.leftTopX <= 0) {
            this.leftTopX = 0;
        }
        if (this.leftTopY + this._screenH >= this._mapHeight * this._tileHeight) {
            this.leftTopY = this._mapHeight * this._tileHeight - this._screenH;
        }
        if (this.leftTopY <= 0) {
            this.leftTopY = 0;
        }
    }

    public byte getMapTile(int layer, int x, int y) {
        if (this.mapData == null || this.mapData[layer] == null) {
            return -1;
        }
        int tempX = x / this._tileWidth;
        int tempY = y / this._tileHeight;
        if (this.isMapBorder(x, y)) {
            return 1;
        }
        if (tempY < 0) {
            tempY = 0;
        }
        if (tempX < 0) {
            tempX = 0;
        }
        if (tempX > this._mapWidth) {
            tempX = this._mapWidth;
        }
        if (tempY > this._mapHeight) {
            tempY = this._mapHeight;
        }
        return (byte)this.mapData[layer][tempX][tempY];
    }

    public boolean isMapBorder(int x, int y) {
        return x <= 0 || x >= this.mapW || y <= 0 || y >= this.mapH;
    }

    public int getLayer(int layer) {
        return this.mapLayerType[layer];
    }

    static {
        transform2 = new int[]{0, 270, 180, 90, 8192, 8462, 8372, 8282};
        transforms = new int[]{0, 5, 3, 6, 2, 4, 1, 7};
    }
}

