/*
 * Decompiled with CFR 0.152.
 */
package CWA2DAPI.cwabase2d;

import CWA2DAPI.CWAGlobal;
import CWA2DAPI.cwaEX.CWAImageUtil;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAImageManager;
import CWA2DAPI.cwabase2d.CWASpDataManager;
import CWA2DAPI.cwabase2d.CWASpriteStruct;
import game.GameEvent;
import game.GameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CWASprite
implements CWAGlobal {
    public static final int[] TRANSTODG_1 = new int[]{0, 5, 3, 6, 2, 4, 1, 7};
    public static final int[] TRANSTODG_R_1 = new int[]{2, 4, 1, 7, 0, 5, 3, 6};
    public static final int[] TRANSTODG_DR_1 = new int[]{3, 6, 0, 5, 1, 7, 2, 4};
    public static final int[] TRANSTODG_D_1 = new int[]{1, 7, 2, 4, 3, 6, 0, 5};
    public static final int[] TRANSTODG = new int[]{0, 270, 180, 90, 8192, 8462, 8372, 8282};
    public static final int[] TRANSTODG_R = new int[]{8192, 8462, 8372, 8282, 0, 270, 180, 90};
    public static final int[] TRANSTODG_DR = new int[]{180, 90, 0, 270, 8372, 8282, 8192, 8462};
    public static final int[] TRANSTODG_D = new int[]{8372, 8282, 8192, 8462, 180, 90, 0, 270};
    private Image[] img;
    private CWASpriteStruct sprData;
    private int[] imgIndex;
    public int sprIndex;
    private int delay;
    private int delayPos;
    private int delayPosCount;
    private byte animeMode;
    protected int curFrame;
    protected int maxFrame;
    protected byte action;
    private boolean isIgnore = true;

    public boolean initSprite(int index, boolean isSpeed) {
        try {
            this.imgIndex = new int[CWADataManager.objectSpriteIndex[index].length - 1];
            this.img = new Image[CWADataManager.objectSpriteIndex[index].length - 1];
            for (int i = 0; i < this.img.length; ++i) {
                this.imgIndex[i] = CWADataManager.objectSpriteIndex[index][1 + i];
                this.img[i] = CWAImageManager.getImg(this.imgIndex[i]);
            }
            this.sprIndex = index;
            this.sprData = CWASpDataManager.getSpriteData(CWADataManager.objectSpriteIndex[index][0], this.img);
            this.sprData.isSpeedSprint = isSpeed;
            this.setCurFrame(0);
        }
        catch (Exception e) {
            System.out.println(" initSprite == " + index + " e = " + e);
        }
        return true;
    }

    public void removeSprite(int where) {
        if (this.imgIndex != null) {
            for (int i = 0; i < this.imgIndex.length; ++i) {
                if (this.img != null) {
                    this.img[i] = null;
                }
                CWAImageManager.removeImg(this.imgIndex[i]);
            }
        }
        this.imgIndex = null;
        if (this.sprIndex != 257) {
            this.sprData = null;
            CWASpDataManager.removeSpriteData(this.sprIndex);
        }
    }

    public void releaseSprite(int where) {
        if (this.imgIndex == null) {
            return;
        }
        for (int i = 0; i < this.imgIndex.length; ++i) {
            if (this.img != null) {
                this.img[i] = null;
            }
            CWAImageManager.releaseImg(this.imgIndex[i]);
        }
        this.imgIndex = null;
        this.sprData = null;
        CWASpDataManager.releaseSpriteData(this.sprIndex);
    }

    public void changeSprite(int index, boolean isRelease) {
        this.sprData = null;
        if (isRelease) {
            CWASpDataManager.releaseSpriteData(this.sprIndex);
        } else {
            CWASpDataManager.removeSpriteData(this.sprIndex);
        }
        this.sprIndex = index;
        this.sprData = CWASpDataManager.getSpriteData(CWADataManager.objectSpriteIndex[index][0], this.img);
    }

    public void changeImage(int pos, int index, boolean isRelease) {
        this.img[pos] = null;
        if (isRelease) {
            CWAImageManager.releaseImg(this.imgIndex[pos]);
        } else {
            CWAImageManager.removeImg(this.imgIndex[pos]);
        }
        this.imgIndex[pos] = index;
        this.img[pos] = CWAImageManager.getImg(this.imgIndex[pos]);
    }

    public void reCallImage() {
        if (GameEvent.isReCall == 1) {
            for (int i = 0; i < this.img.length; ++i) {
                this.img[i] = CWAImageUtil.blackWhite(CWAImageManager.getImg(this.imgIndex[i]));
            }
        }
    }

    public void reCallImg() {
        for (int i = 0; i < this.img.length; ++i) {
            if (GameEvent.isReCall == 1) {
                this.img[i] = CWAImageUtil.blackWhite(CWAImageManager.getImg(this.imgIndex[i]));
                continue;
            }
            this.releaseSprite(1);
        }
        if (GameEvent.isReCall == 0) {
            this.initSprite(this.sprIndex, false);
        } else if (GameEvent.isReCall == 1) {
            // empty if block
        }
    }

    public void aphaSprite(int change) {
        for (int i = 0; i < this.img.length; ++i) {
            if (change == 1) {
                this.img[i] = CWAImageUtil.transparent(CWAImageManager.getImg(this.imgIndex[i]), 100);
                continue;
            }
            this.releaseSprite(2);
        }
        if (change == 0) {
            this.initSprite(this.sprIndex, false);
        }
    }

    public boolean setAction(byte action, byte animeMode, boolean reset) {
        if (this.action != action || reset) {
            this.action = action;
            this.setCurFrame(0);
        } else {
            this.action = action;
        }
        this.animeMode = animeMode;
        return true;
    }

    public void setAction(byte action, byte animeMode) {
        this.action = action;
        this.animeMode = animeMode;
    }

    public void setAnimeMode(byte animeMode) {
        this.animeMode = animeMode;
    }

    public void setCurFrame(int frame) {
        this.curFrame = frame;
        if (this.sprData.actions == null) {
            return;
        }
        if (this.sprData.isSpeedSprint) {
            this.delay = this.sprData.actions[this.action][this.curFrame * 4];
            this.maxFrame = this.sprData.actions[this.action].length / 4;
        } else {
            this.delay = this.sprData.actions[this.action][this.curFrame * 2];
            this.maxFrame = this.sprData.actions[this.action].length / 2;
        }
        this.delayPosCount = this.delayPos;
        if (this.delay > 0) {
            --this.delay;
        } else if (this.delayPosCount > 0) {
            --this.delayPosCount;
        }
    }

    public void setdelayPos(int pos) {
        this.delayPos = pos;
        this.delayPosCount = pos;
    }

    public boolean updateAction() {
        if (this.delay > 0) {
            --this.delay;
        } else if (this.delayPosCount > 0) {
            --this.delayPosCount;
        } else {
            ++this.curFrame;
            if (this.curFrame >= this.maxFrame) {
                if (this.animeMode >= 0) {
                    this.setAction(this.animeMode, (byte)-1, true);
                } else if (this.animeMode == -2) {
                    --this.curFrame;
                    this.setCurFrame(this.curFrame);
                } else if (this.animeMode == -1) {
                    this.setCurFrame(0);
                }
                return true;
            }
            this.setCurFrame(this.curFrame);
        }
        return false;
    }

    public boolean isEndFrame() {
        return this.curFrame >= this.maxFrame - 1;
    }

    public int delay() {
        return this.delay;
    }

    public boolean isEnddelay() {
        return this.delay == 0;
    }

    public boolean isCheckFrame(int frame) {
        return this.curFrame == frame;
    }

    public byte getAction() {
        return this.action;
    }

    public int getCurFrame() {
        return this.curFrame;
    }

    public int[] getActionImgWH(int action, byte trans) {
        int[] Rect = null;
        if (action >= 0 && action < this.sprData.actions.length) {
            Rect = this.getFrameImgWH(this.sprData.actions[action][1], trans);
            int left = Rect[0];
            int right = Rect[0] + Rect[2];
            int top = Rect[1];
            int bottom = Rect[1] + Rect[3];
            if (this.sprData.isSpeedSprint) {
                for (int i = 1; i != this.sprData.actions[action].length / 4; ++i) {
                    Rect = this.getFrameImgWH(this.sprData.actions[action][i * 4 + 1], trans);
                    if (Rect == null) continue;
                    if (left > Rect[0]) {
                        left = Rect[0];
                    }
                    if (right < Rect[0] + Rect[2]) {
                        right = Rect[0] + Rect[2];
                    }
                    if (top > Rect[1]) {
                        top = Rect[1];
                    }
                    if (bottom >= Rect[1] + Rect[3]) continue;
                    bottom = Rect[1] + Rect[3];
                }
            } else {
                for (int i = 1; i != this.sprData.actions[action].length / 2; ++i) {
                    Rect = this.getFrameImgWH(this.sprData.actions[action][i * 2 + 1], trans);
                    if (Rect == null) continue;
                    if (left > Rect[0]) {
                        left = Rect[0];
                    }
                    if (right < Rect[0] + Rect[2]) {
                        right = Rect[0] + Rect[2];
                    }
                    if (top > Rect[1]) {
                        top = Rect[1];
                    }
                    if (bottom >= Rect[1] + Rect[3]) continue;
                    bottom = Rect[1] + Rect[3];
                }
            }
            return new int[]{left, top, right - left, bottom - top};
        }
        return null;
    }

    public int[] getFrameImgWH(int frame, byte trans) {
        int i;
        if (this.sprData.frames[frame].length <= 0) {
            return null;
        }
        short modId = this.sprData.frames[frame][0];
        int x = this.sprData.frames[frame][1];
        int y = this.sprData.frames[frame][2];
        for (int i2 = 0; i2 < this.sprData.frames[frame].length; i2 += 4) {
            modId = this.sprData.frames[frame][i2];
            if (this.sprData.frames[frame][i2 + 1] < x) {
                x = this.sprData.frames[frame][i2 + 1];
            }
            if (this.sprData.frames[frame][i2 + 2] >= y) continue;
            y = this.sprData.frames[frame][i2 + 2];
        }
        int[] wh = new int[2];
        wh = this.getModuleWH(0, modId, frame, x, y, wh);
        int w = wh[0];
        int h = wh[1];
        for (i = 0; i < this.sprData.frames[frame].length; i += 4) {
            modId = this.sprData.frames[frame][i];
            if ((wh = this.getModuleWH(i, modId, frame, x, y, wh))[0] > w) {
                w = wh[0];
            }
            if (wh[1] <= h) continue;
            h = wh[1];
        }
        switch (trans) {
            case 4: {
                modId = this.sprData.frames[frame][0];
                y = this.sprData.frames[frame][3] % 2 == 1 ? -this.sprData.frames[frame][2] - this.sprData.modules[modId * 5 + 3] : -this.sprData.frames[frame][2] - this.sprData.modules[modId * 5 + 4];
                for (i = 0; i < this.sprData.frames[frame].length; i += 4) {
                    modId = this.sprData.frames[frame][i];
                    if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                        if (-this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 3] >= y) continue;
                        y = -this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 3];
                        continue;
                    }
                    if (-this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 4] >= y) continue;
                    y = -this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 4];
                }
                break;
            }
            case 1: {
                modId = this.sprData.frames[frame][0];
                x = this.sprData.frames[frame][3] % 2 == 1 ? -this.sprData.frames[frame][1] - this.sprData.modules[modId * 5 + 4] : -this.sprData.frames[frame][1] - this.sprData.modules[modId * 5 + 3];
                for (i = 0; i < this.sprData.frames[frame].length; i += 4) {
                    modId = this.sprData.frames[frame][i];
                    if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                        if (-this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 4] >= x) continue;
                        x = -this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 4];
                        continue;
                    }
                    if (-this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 3] >= x) continue;
                    x = -this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 3];
                }
                break;
            }
            case 3: {
                modId = this.sprData.frames[frame][0];
                if (this.sprData.frames[frame][3] % 2 == 1) {
                    x = -this.sprData.frames[frame][1] - this.sprData.modules[modId * 5 + 4];
                    y = -this.sprData.frames[frame][2] - this.sprData.modules[modId * 5 + 3];
                } else {
                    x = -this.sprData.frames[frame][1] - this.sprData.modules[modId * 5 + 3];
                    y = -this.sprData.frames[frame][2] - this.sprData.modules[modId * 5 + 4];
                }
                for (i = 0; i < this.sprData.frames[frame].length; i += 4) {
                    modId = this.sprData.frames[frame][i];
                    if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                        if (-this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 4] < x) {
                            x = -this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 4];
                        }
                        if (-this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 3] >= y) continue;
                        y = -this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 3];
                        continue;
                    }
                    if (-this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 3] < x) {
                        x = -this.sprData.frames[frame][i + 1] - this.sprData.modules[modId * 5 + 3];
                    }
                    if (-this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 4] >= y) continue;
                    y = -this.sprData.frames[frame][i + 2] - this.sprData.modules[modId * 5 + 4];
                }
                break;
            }
        }
        return new int[]{x, y, w, h};
    }

    private int[] getModuleWH(int index, int modId, int frame, int x, int y, int[] wh) {
        if (this.sprData.frames[frame][index + 3] % 2 == 1) {
            wh[1] = this.sprData.frames[frame][index + 2] - y + this.sprData.modules[modId * 5 + 3];
            wh[0] = this.sprData.frames[frame][index + 1] - x + this.sprData.modules[modId * 5 + 4];
        } else {
            wh[0] = this.sprData.frames[frame][index + 1] - x + this.sprData.modules[modId * 5 + 3];
            wh[1] = this.sprData.frames[frame][index + 2] - y + this.sprData.modules[modId * 5 + 4];
        }
        return wh;
    }

    public void drawSprite(Graphics g, int x, int y, byte trans) {
        try {
            if (this.sprData == null) {
                GameManager.getInstance().step = 2;
                return;
            }
            if (this.sprData.actions == null) {
                GameManager.getInstance().step = 3;
                return;
            }
            if (this.sprData.isSpeedSprint) {
                this.drawFrame(g, this.sprData.actions[this.action][this.curFrame * 4 + 1], x, y, trans, 20, true);
            } else {
                this.drawFrame(g, this.sprData.actions[this.action][this.curFrame * 2 + 1], x, y, trans, 20, true);
            }
        }
        catch (Exception e) {
            System.out.println(" sprite " + this.sprIndex + " ex = " + e + " action = " + this.action + " ");
        }
    }

    public void drawFrame(Graphics g, int frame, int x, int y, byte trans, int anchor, boolean isFlag) {
        int index = 0;
        try {
            if (this.sprData == null) {
                GameManager.getInstance().step = 6;
                return;
            }
            if (this.sprData.frames == null) {
                GameManager.getInstance().step = 7;
                return;
            }
            if (this.sprData.frames[frame].length <= 0) {
                return;
            }
            switch (trans) {
                case 0: {
                    for (int i = 0; i < this.sprData.frames[frame].length; i += 4) {
                        index = i;
                        this.drawModule(g, this.sprData.frames[frame][i], x + this.sprData.frames[frame][i + 1], y + this.sprData.frames[frame][i + 2], this.isIgnore ? TRANSTODG_1[this.sprData.frames[frame][i + 3]] : TRANSTODG[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.sprData.frames[frame].length; i += 4) {
                        index = i;
                        if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                            this.drawModule(g, this.sprData.frames[frame][i], x - this.sprData.frames[frame][i + 1] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 4], y + this.sprData.frames[frame][i + 2], this.isIgnore ? TRANSTODG_R_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_R[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                            continue;
                        }
                        this.drawModule(g, this.sprData.frames[frame][i], x - this.sprData.frames[frame][i + 1] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 3], y + this.sprData.frames[frame][i + 2], this.isIgnore ? TRANSTODG_R_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_R[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.sprData.frames[frame].length; i += 4) {
                        index = i;
                        if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                            this.drawModule(g, this.sprData.frames[frame][i], x - this.sprData.frames[frame][i + 1] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 4], y - this.sprData.frames[frame][i + 2] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 3], this.isIgnore ? TRANSTODG_DR_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_DR[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                            continue;
                        }
                        this.drawModule(g, this.sprData.frames[frame][i], x - this.sprData.frames[frame][i + 1] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 3], y - this.sprData.frames[frame][i + 2] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 4], this.isIgnore ? TRANSTODG_DR_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_DR[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < this.sprData.frames[frame].length; i += 4) {
                        index = i;
                        if (this.sprData.frames[frame][i + 3] % 2 == 1) {
                            this.drawModule(g, this.sprData.frames[frame][i], x + this.sprData.frames[frame][i + 1], y - this.sprData.frames[frame][i + 2] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 3], this.isIgnore ? TRANSTODG_D_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_D[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                            continue;
                        }
                        this.drawModule(g, this.sprData.frames[frame][i], x + this.sprData.frames[frame][i + 1], y - this.sprData.frames[frame][i + 2] - this.sprData.modules[this.sprData.frames[frame][i] * 5 + 4], this.isIgnore ? TRANSTODG_D_1[this.sprData.frames[frame][i + 3]] : TRANSTODG_D[this.sprData.frames[frame][i + 3]], anchor, isFlag);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(" sprindex = " + this.sprIndex + " action = " + this.action + " frame = " + frame + " index = " + index + " e = " + e.toString());
        }
    }

    public void drawModule(Graphics g, int modid, int x, int y, int trans, int anchor, boolean isflag) {
        g.drawRegion(this.img[this.sprData.modules[modid * 5]], (int)this.sprData.modules[modid * 5 + 1], (int)this.sprData.modules[modid * 5 + 2], (int)this.sprData.modules[modid * 5 + 3], (int)this.sprData.modules[modid * 5 + 4], trans, x, y, anchor);
    }

    public boolean isAttData() {
        return this.sprData.attData == null;
    }

    public short[] getAttData() {
        if (this.sprData.attData == null) {
            return null;
        }
        if (this.sprData.isSpeedSprint) {
            return this.sprData.attData[this.sprData.actions[this.action][this.curFrame * 4 + 1]];
        }
        return this.sprData.attData[this.sprData.actions[this.action][this.curFrame * 2 + 1]];
    }

    public short[] getbeattData() {
        if (this.sprData.beattData == null) {
            return null;
        }
        if (this.sprData.isSpeedSprint) {
            return this.sprData.beattData[this.sprData.actions[this.action][this.curFrame * 4 + 1]];
        }
        return this.sprData.beattData[this.sprData.actions[this.action][this.curFrame * 2 + 1]];
    }
}

