/*
 * Decompiled with CFR 0.152.
 */
package CWAUI;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CWAUIFonts {
    private Graphics g;
    private byte font_size = (byte)12;
    private byte[] ascIndex = null;
    private byte[] ascData = null;
    private short[] hzkIndex = null;
    private byte[] hzkData = null;
    private int ascSize = 0;
    private int hzkSize = 0;
    private static char[] bits = new char[]{'\u0080', '@', ' ', '\u0010', '\b', '\u0004', '\u0002', '\u0001'};

    public CWAUIFonts(int fontSize) {
        this.font_size = (byte)fontSize;
        this.initFonts(this.font_size);
    }

    private void initFonts(int fontsSize) {
        switch (fontsSize) {
            case 12: {
                this.ascSize = 12;
                this.hzkSize = 24;
                break;
            }
            case 16: {
                this.ascSize = 16;
                this.hzkSize = 32;
            }
        }
    }

    public void LoadFonts(String path) {
        try {
            InputStream is = CWAUIFonts.getInputStream(path);
            DataInputStream dis = new DataInputStream(is);
            this.ascIndex = CWAUIFonts.getByteArray(is);
            dis.readShort();
            this.ascData = new byte[this.ascIndex.length * this.ascSize];
            is.read(this.ascData);
            this.hzkIndex = CWAUIFonts.getShortArray(is);
            dis.readShort();
            this.hzkData = new byte[this.hzkIndex.length * this.hzkSize];
            is.read(this.hzkData);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void drawString(String str, int x, int y, int anchor, int color, Graphics g1) {
        int len = str.length();
        int fontx = x;
        int fonty = y;
        if ((anchor & 8) == 8) {
            fontx = x - this.stringLength(str);
        } else if ((anchor & 1) == 1) {
            fontx = x - (this.stringLength(str) >> 1);
        }
        if ((anchor & 0x20) == 32) {
            fonty = y - this.stringHeight();
        } else if ((anchor & 2) == 2) {
            fonty = y - (this.stringHeight() >> 1);
        }
        this.g = g1;
        this.g.setColor(color);
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            int p;
            char c = str.charAt(i);
            if (c < '\u0080') {
                p = this.getFontDataOffset(c, this.ascIndex, this.ascSize);
                if (p != -1) {
                    this.drawFont(this.ascData, p, this.font_size, fontx + offset, fonty, 0);
                }
                offset += this.font_size >> 1;
                continue;
            }
            p = this.getFontDataOffset(c, this.hzkIndex, this.hzkSize);
            if (p != -1) {
                this.drawFont(this.hzkData, p, this.font_size, fontx + offset, fonty, 1);
            }
            offset += this.font_size;
        }
    }

    private void drawPoint(int x, int y) {
        this.g.drawLine(x, y, x, y);
    }

    private void drawFont(byte[] hzkData, int offset, int fontSize, int x, int y, int fontType) {
        int n = fontType == 0 ? (fontSize >> 1) + 7 >> 3 : fontSize + 7 >> 3;
        for (int j = 0; j < fontSize; ++j) {
            for (int i = 0; i < n; ++i) {
                char c = (char)(hzkData[offset + j * n + i] + 128);
                for (int k = 0; k < 8; ++k) {
                    if ((c & 128 >> k) == 0) continue;
                    this.drawPoint(x + i * 8 + k, y + j);
                }
            }
        }
    }

    private int getFontDataOffset(char ch, byte[] idx, int idx_size) {
        int startIndex = 0;
        int stopIndex = idx.length - 1;
        int middle = startIndex + stopIndex >> 1;
        while (idx[middle] != ch && startIndex < stopIndex) {
            if (ch < idx[middle]) {
                stopIndex = middle - 1;
            } else if (ch > idx[middle]) {
                startIndex = middle + 1;
            }
            middle = startIndex + stopIndex >> 1;
        }
        return idx[middle] != ch ? -1 : middle * idx_size;
    }

    private int getFontDataOffset(char ch, short[] idx, int idx_size) {
        int startIndex = 0;
        int stopIndex = idx.length - 1;
        int middle = startIndex + stopIndex >> 1;
        int index = idx[middle] + 32768;
        while (index != ch && startIndex < stopIndex) {
            if (ch < index) {
                stopIndex = middle - 1;
            } else if (ch > index) {
                startIndex = middle + 1;
            }
            middle = startIndex + stopIndex >> 1;
            index = idx[middle] + 32768;
        }
        return index != ch ? -1 : middle * idx_size;
    }

    public int stringLength(String s) {
        int w = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < '\u0080') {
                w += this.font_size >> 1;
                continue;
            }
            w += this.font_size;
        }
        return w;
    }

    public int stringHeight() {
        return this.font_size;
    }

    public int substringWidth(String s, int beginIndex, int length) {
        return this.stringLength(s.substring(beginIndex, beginIndex + length));
    }

    public int getFontSize() {
        return this.font_size;
    }

    public static byte[] getByteArray(InputStream is) {
        short t = 0;
        byte[] rtn = null;
        try {
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t >= 0) {
                rtn = new byte[t];
            }
            for (int j = 0; j < rtn.length; ++j) {
                rtn[j] = dis.readByte();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }

    public static short[] getShortArray(InputStream is) {
        short t = 0;
        short[] rtn = null;
        try {
            DataInputStream dis = new DataInputStream(is);
            t = dis.readShort();
            if (t >= 0) {
                rtn = new short[t];
            }
            for (int j = 0; j < rtn.length; ++j) {
                rtn[j] = dis.readShort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtn;
    }

    private static InputStream getInputStream(String fileName) {
        try {
            return "".getClass().getResourceAsStream(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

