/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ldys;

import com.zy.ldys.PublicTools;

public class BillingObject {
    private String billingID = null;
    private int totleMoney = 0;
    private int payedMoney = 0;

    protected BillingObject(String billingID, int totleMoney, int payedMoney) {
        this.billingID = billingID;
        this.totleMoney = totleMoney;
        this.payedMoney = payedMoney;
    }

    protected BillingObject() {
    }

    protected String getBillingID() {
        return this.billingID;
    }

    protected void setBillingID(String billingID) {
        this.billingID = billingID;
    }

    protected int getPayedMoney() {
        return this.payedMoney;
    }

    protected void setPayedMoney(int payedMoney) {
        this.payedMoney = payedMoney;
    }

    protected int getTotleMoney() {
        return this.totleMoney;
    }

    protected void setTotleMoney(int totleMoney) {
        this.totleMoney = totleMoney;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.billingID != null ? this.billingID.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (this.getBillingID() != null && o != null && o.getClass().getName().equals(this.getClass().getName())) {
            BillingObject bo = (BillingObject)o;
            return this.getBillingID().equals(bo.getBillingID());
        }
        return false;
    }

    protected void copyData(BillingObject source) {
        this.setBillingID(source.getBillingID());
        this.setTotleMoney(source.getTotleMoney());
        this.setPayedMoney(source.getPayedMoney());
    }

    protected byte[] getFormatByteArrayDataByFields() {
        byte[] billingIdData = PublicTools.formatStringToByteArrayDataPage(this.billingID);
        byte[] totleMoneyData = PublicTools.formatIntToByteArrayDataPage(this.totleMoney);
        byte[] payedMoneyData = PublicTools.formatIntToByteArrayDataPage(this.payedMoney);
        byte[] formatBillingObjectData = PublicTools.formatByteArray2ToByteArray1(new byte[][]{billingIdData, totleMoneyData, payedMoneyData});
        return formatBillingObjectData;
    }

    protected void setFieldsByFormatByteArrayData(byte[] data) {
        byte[][] formatBillingObjectData = PublicTools.formatByteArray1ToByteArray2(data);
        byte[] billingIdData = formatBillingObjectData[0];
        byte[] totleMoneyData = formatBillingObjectData[1];
        byte[] payedMoneyData = formatBillingObjectData[2];
        this.setBillingID(PublicTools.formatByteArrayDataPageToString(billingIdData));
        this.setTotleMoney(PublicTools.formatByteArrayDataPageToInt(totleMoneyData));
        this.setPayedMoney(PublicTools.formatByteArrayDataPageToInt(payedMoneyData));
    }
}

