/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ldys;

import com.zy.ldys.BillingObject;
import com.zy.ldys.PublicTools;
import java.util.Enumeration;
import java.util.Vector;

class BillingObjectManager {
    private static final String RECORD_STORE_NAME = "bill";
    private static final int RECORD_ID = 1;
    private static final byte[] defaultData = new byte[]{66};
    private Vector v = new Vector();
    private static BillingObjectManager instence = null;

    BillingObjectManager() {
    }

    static BillingObjectManager getInstence() {
        if (instence == null) {
            instence = new BillingObjectManager();
            PublicTools.createRecordStore(RECORD_STORE_NAME);
            if (!PublicTools.checkRecordIdHas(RECORD_STORE_NAME, 1)) {
                PublicTools.createRecord(RECORD_STORE_NAME, defaultData);
            }
        }
        return instence;
    }

    protected BillingObject getBillingObjectById(String billingId) {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            BillingObject one = (BillingObject)e.nextElement();
            if (!one.getBillingID().equals(billingId)) continue;
            return one;
        }
        return null;
    }

    protected void setBillingObject(BillingObject bo) {
        if (bo != null && bo.getPayedMoney() >= bo.getTotleMoney()) {
            this.v.removeElement(bo);
            return;
        }
        if (this.v.contains(bo)) {
            BillingObject one = this.getBillingObjectById(bo.getBillingID());
            one.copyData(bo);
        } else {
            this.v.addElement(bo);
        }
    }

    protected void saveBilling() {
        if (this.v.isEmpty()) {
            PublicTools.saveRecord(RECORD_STORE_NAME, 1, defaultData);
            return;
        }
        Enumeration e = this.v.elements();
        Vector<byte[]> vData = new Vector<byte[]>();
        while (e.hasMoreElements()) {
            BillingObject oneBo = (BillingObject)e.nextElement();
            byte[] oneBoFormatData = oneBo.getFormatByteArrayDataByFields();
            vData.addElement(oneBoFormatData);
        }
        byte[] allBillingObjectData = PublicTools.formatVectorToByteArray1(vData);
        PublicTools.saveRecord(RECORD_STORE_NAME, 1, allBillingObjectData);
    }

    protected void loadBilling() {
        try {
            byte[] allBillingObjectData = PublicTools.loadRecord(RECORD_STORE_NAME, 1);
            if (allBillingObjectData.length == 1) {
                return;
            }
            Vector vData = PublicTools.formatByteArray1ToVector(allBillingObjectData);
            Vector<BillingObject> vBillingObject = new Vector<BillingObject>(vData.size());
            Enumeration eData = vData.elements();
            while (eData.hasMoreElements()) {
                BillingObject oneBo = new BillingObject();
                byte[] oneData = (byte[])eData.nextElement();
                oneBo.setFieldsByFormatByteArrayData(oneData);
                vBillingObject.addElement(oneBo);
            }
            this.v.removeAllElements();
            this.v = null;
            this.v = vBillingObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

