/*
 * Decompiled with CFR 0.152.
 */
package com.zy.ui;

import com.zy.ui.AbstractScollPanel;
import com.zy.ui.ActionListener;
import com.zy.ui.Label;
import com.zy.ui.PageNumberBar;
import com.zy.ui.Panel;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class PageScollPanel
extends AbstractScollPanel {
    private int pageNumber = 1;
    private int currentPageIndex = 0;
    private PageNumberBar pnbi = null;
    protected boolean pageNumberBarView = true;

    public PageScollPanel(String title, String text, int width, int height, int titleColor, int titleBackColor, int textColor, int backColor, boolean viewBackColor, boolean viewPageNumberBar) {
        super(title, text, width, height, titleColor, titleBackColor, textColor, backColor, viewBackColor);
        this.setPageNumberBarView(viewPageNumberBar);
        this.font = Font.getDefaultFont();
        this.init();
    }

    public PageScollPanel(String text, int width, int height, int textColor, int backColor, boolean viewBackColor, boolean viewPageNumberBar) {
        super(text, width, height, textColor, backColor, viewBackColor);
        this.setPageNumberBarView(viewPageNumberBar);
        this.font = Font.getDefaultFont();
        this.init();
    }

    public PageScollPanel(String text, int width, int height, int textColor) {
        super(text, width, height, textColor);
        this.setPageNumberBarView(false);
        this.font = Font.getDefaultFont();
        this.init();
    }

    public void setFont(Font font) {
        this.font = font;
        this.onePageTotleLine();
    }

    private void init() {
        this.initPageNumberBar();
        this.onePageTotleLine();
    }

    private void setPageNumber() {
        if (this.pnbi != null) {
            this.pnbi.setXYRelativeParent(this.getWidth() - this.pnbi.getWidth() >> 1, this.getHeight() - this.pnbi.getHeight() - 1);
            this.pnbi.setMaxPageNumber(this.pageNumber);
            this.pnbi.canGetFocus(false);
        }
    }

    private void initPageNumberBar() {
        this.pnbi = new PageNumberBar(this.textColor, this.getBackColor(), false);
        if (this.pageNumberBarView) {
            this.append(this.pnbi);
        }
    }

    private void reset() {
        this.pageNumber();
        if (this.pnbi != null) {
            this.pnbi.setMaxPageNumber(this.pageNumber);
            this.pnbi.setXYRelativeParent(this.getWidth() - this.pnbi.getWidth() >> 1, this.getHeight() - this.pnbi.getHeight() - 1);
            if (this.currentPageIndex > this.pageNumber - 1) {
                this.currentPageIndex = this.pageNumber - 1;
            }
        }
    }

    private void pageNumber() {
        if (this.allPageTotleLine == 0 || this.onePageTotleLine == 0) {
            this.pageNumber = 1;
            return;
        }
        if (this.allPageTotleLine <= this.onePageTotleLine) {
            this.pageNumber = 1;
        } else if (this.allPageTotleLine > this.onePageTotleLine) {
            int tempShang = this.allPageTotleLine / this.onePageTotleLine;
            int tempYu = this.allPageTotleLine % this.onePageTotleLine;
            this.pageNumber = tempYu == 0 ? tempShang : tempShang + 1;
        }
    }

    public void setPageNumberBarView(boolean show) {
        this.pageNumberBarView = show;
    }

    protected void onePageTotleLine() {
        this.onePageTotleLine = this.scollPanelTextAreaHeight() / this.font.getHeight();
        this.pageNumber();
        this.setPageNumber();
    }

    protected int scollPanelTextAreaHeight() {
        int tempHeight = this.getHeight();
        if (this.titleView) {
            tempHeight -= this.titleLabel.getHeight();
        }
        if (this.pageNumberBarView) {
            tempHeight -= this.pnbi.getHeight() - 1;
        }
        if (this.softLeftButton != null || this.softRightButton != null) {
            tempHeight -= (this.softLeftButton == null ? this.softRightButton.getHeight() : this.softLeftButton.getHeight()) - 1;
        }
        return tempHeight;
    }

    public void draw(Graphics g) {
        int startIndex;
        super.draw(g);
        PageScollPanel.saveOldColor(g);
        g.setColor(this.textColor);
        int tempTextY = this.yAbstractScreen;
        if (this.titleView) {
            tempTextY += this.titleLabel.getHeight();
        }
        int i = startIndex = this.currentPageIndex * this.onePageTotleLine;
        int j = 0;
        while (i < this.allPageTotleLine && i < startIndex + this.onePageTotleLine) {
            int textTempX = this.xAbstractScreen + (this.getWidth() - this.font.stringWidth(this.allLineString[i]) >> 1) + 1;
            g.drawString(this.allLineString[i], textTempX, tempTextY + j * this.font.getHeight() + 1, 20);
            ++i;
            ++j;
        }
        PageScollPanel.loadOldColor(g);
    }

    public boolean pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        if (this.pnbi != null) {
            if (x > this.pnbi.getXAbstractScreen() && x < this.pnbi.getXAbstractScreen() + (this.pnbi.getWidth() >> 1) && y > this.pnbi.getYAbstractScreen() && y < this.pnbi.getYAbstractScreen() + this.pnbi.getHeight()) {
                this.pagePre();
                this.setFocus(true);
                return true;
            }
            if (x > this.pnbi.getXAbstractScreen() + (this.pnbi.getWidth() >> 1) && x < this.pnbi.getXAbstractScreen() + this.pnbi.getWidth() && y > this.pnbi.getYAbstractScreen() && y < this.pnbi.getYAbstractScreen() + this.pnbi.getHeight()) {
                this.pageNext();
                this.setFocus(true);
                return true;
            }
        }
        if (this.checkPointerInMine(x, y)) {
            this.setFocus(true);
            return true;
        }
        this.setFocus(false);
        return false;
    }

    public boolean keyPressed(int key) {
        super.keyPressed(key);
        if (this.pnbi != null) {
            if (key == 16384 || key == 16) {
                this.pagePre();
                this.setFocus(true);
                return true;
            }
            if (key == 32768 || key == 64) {
                this.pageNext();
                this.setFocus(true);
                return true;
            }
        }
        if (this.checkKeyInMine(key)) {
            this.setFocus(true);
            return true;
        }
        this.setFocus(false);
        return false;
    }

    public void pageNext() {
        int tempPage = this.currentPageIndex;
        if (++tempPage < this.pageNumber) {
            this.currentPageIndex = tempPage;
            if (this.pnbi != null) {
                this.pnbi.pageNext();
            }
            this.updateButton();
        }
    }

    public void pagePre() {
        int tempPage = this.currentPageIndex;
        if (--tempPage >= 0) {
            this.currentPageIndex = tempPage;
            if (this.pnbi != null) {
                this.pnbi.pagePre();
            }
            this.updateButton();
        }
    }

    private void updateButton() {
        if (this.isLast()) {
            if (this.softLeftButton != null) {
                this.softLeftButton.setText(this.softLeftMaxButtonText);
            }
        } else if (this.softLeftButton != null) {
            this.softLeftButton.setText(this.softLeftNotMaxButtonText);
        }
        if (this.isFirst()) {
            if (this.softRightButton != null) {
                this.softRightButton.setText(this.softRightFirstButtonText);
                this.softRightButton.setXRelativeParent(this.getWidth() - this.softRightButton.getWidth() - 1);
            }
        } else if (this.softRightButton != null) {
            this.softRightButton.setText(this.softRightNotFirstButtonText);
            this.softRightButton.setXRelativeParent(this.getWidth() - this.softRightButton.getWidth() - 1);
        }
    }

    public String toString() {
        return "PageScollPanel";
    }

    public int getCurrentPage() {
        if (this.pnbi != null) {
            return this.pnbi.getCurrentPage();
        }
        return -1;
    }

    public int getMaxPage() {
        if (this.pnbi != null) {
            return this.pnbi.getMaxPage();
        }
        return -1;
    }

    public boolean isLast() {
        if (this.pnbi != null) {
            return this.pnbi.isMaxPage();
        }
        return false;
    }

    public boolean isFirst() {
        if (this.pnbi != null) {
            return this.pnbi.isFirstPage();
        }
        return false;
    }

    public void addSoftLeftButton(String notMaxButtonText, String maxButtonText, final ActionListener al) {
        this.softLeftButton = null;
        this.softLeftNotMaxButtonText = notMaxButtonText;
        this.softLeftMaxButtonText = maxButtonText;
        if (notMaxButtonText == null && maxButtonText == null) {
            return;
        }
        this.softLeftButton = new Label(null, 0xFFFFFF, 255, true);
        this.softLeftButton.setKey(131072);
        this.append(this.softLeftButton);
        this.onePageTotleLine();
        if (this.isLast()) {
            this.softLeftButton.setText(maxButtonText);
        } else {
            this.softLeftButton.setText(notMaxButtonText);
        }
        this.softLeftButton.setYRelativeParent(this.getHeight() - 1 - this.softLeftButton.getHeight());
        if (notMaxButtonText == null && maxButtonText == null) {
            return;
        }
        if (this.softLeftButton != null) {
            this.softLeftButton.addActionListener(new ActionListener(){

                public void doAction(Panel pl) {
                    if (pl != null) {
                        if (PageScollPanel.this.isLast()) {
                            if (al != null) {
                                al.doAction(pl);
                            }
                        } else {
                            PageScollPanel.this.pageNext();
                        }
                    }
                }
            });
        }
    }

    public void addSoftRightButton(String notFirstButtonText, String firstButtonText, final ActionListener al) {
        this.softRightButton = null;
        this.softRightNotFirstButtonText = notFirstButtonText;
        this.softRightFirstButtonText = firstButtonText;
        if (notFirstButtonText == null && firstButtonText == null) {
            return;
        }
        this.softRightButton = new Label(null, 0xFFFFFF, 255, true);
        this.softRightButton.setKey(262144);
        this.append(this.softRightButton);
        this.onePageTotleLine();
        if (this.isFirst()) {
            this.softRightButton.setText(firstButtonText);
        } else {
            this.softRightButton.setText(notFirstButtonText);
        }
        this.softRightButton.setXYRelativeParent(this.getWidth() - this.softRightButton.getWidth() - 1, this.getHeight() - 1 - this.softRightButton.getHeight());
        if (notFirstButtonText == null && firstButtonText == null) {
            return;
        }
        if (this.softRightButton != null) {
            this.softRightButton.addActionListener(new ActionListener(){

                public void doAction(Panel pl) {
                    if (pl != null) {
                        if (PageScollPanel.this.isFirst()) {
                            if (al != null) {
                                al.doAction(pl);
                            }
                        } else {
                            PageScollPanel.this.pagePre();
                        }
                    }
                }
            });
        }
    }
}

