/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWAEffect2D;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWAUI.CWAUIManager;
import game.GameManager;
import game.GamePet;
import game.GamePlayer;
import game.GameUI;
import game.GameWorld;
import game.MainCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameBattle
extends CWACommon
implements CWAGlobal {
    private final byte[] PET_MAX = new byte[]{2, 4};
    private final byte SKILL_MAX = (byte)5;
    public final byte BATTLE_SINGLE;
    public final byte BATTLE_DOUBLE;
    private final byte SKILL_HARM;
    private final byte SKILL_BENEFIT;
    private final byte ENEMY_BORN;
    private final byte ENEMY_DEAD;
    private final byte EFFECT_MAX = (byte)7;
    private final byte BUF_EFFECT_MAX = (byte)4;
    private static GameBattle _gamebattle;
    private static GamePlayer gamePlayer;
    private byte ballState = 0;
    public int playMode;
    public byte battleType;
    public byte carMode;
    public Image battleBackGround;
    private int[][] enemy;
    public GamePet[] gamePet;
    public byte[] rank;
    public byte[] petPos;
    public byte[] pokPet;
    private byte[] enemyIndex;
    public byte changePos = 0;
    public GamePet actorPet;
    private Vector vPet;
    public byte petNext;
    private boolean roundOver;
    public static Vector battlePet;
    public static Vector battleExp;
    private boolean cActor;
    public boolean isSelect;
    public boolean calTarget;
    public boolean battleResult;
    public boolean hurtOver;
    protected byte fucMenuIndex;
    private byte itemIndex;
    private byte petIndex;
    private byte targetIndex;
    private byte[] cCount;
    private byte[] pCount;
    private byte delay;
    private int petCount;
    private CWAEffect2D effect;
    private byte effectIndex = 0;
    private byte curEffectIndex = 0;
    private byte effectState = 0;
    private byte spEffectIndex = 0;
    private boolean isSpEffect;
    private boolean isfirst;
    private byte[] effectList;
    private int[] harmValue;
    private boolean isAddHp;
    private byte bufListIndex;
    private byte curBufListIndex;
    private byte bufIndex;
    private byte[] bufList;
    private byte[][] bufDebufEffect;
    private byte[] bufDebufType;
    private byte[] bufDebufListIndex;
    private byte[][] bufDebufSkip = new byte[][]{{3, 5, 13}, {0, 1, 2, 3, 8, 9, 10}};
    private CWASprActor ballActor;
    public boolean seizeFlag;
    public static byte ballId;
    private CWASprActor[] selectActor;
    public static short[][] pos;
    public static short[][][] intoCartoon;
    public static byte[][] effects;
    public static short[][] spEffect;
    public static byte[][] bufEffects;
    public static byte[][] debufEffects;
    public static byte[][] bufDebufIndex;
    byte numType = 0;
    public static final byte NORMAL_BLOOD = 0;
    public static final byte CRIT_BLOOD = 1;
    public static final byte ADD_BLOOD = 2;
    int imgX;
    int imgY;
    int imgW;
    int imgH;
    int imgIndex;
    int imgDir;
    String imgStr = null;
    static Image[] numImg;
    public static short[][] bloodPos;
    public Vector vNumArray = new Vector();
    public Vector vNumStr = new Vector();
    Vector bufV = new Vector();
    Vector debufV = new Vector();
    int bufNameId;
    int debufNameId;
    public int movePos = 0;
    boolean isCal = false;
    int preHp = 0;
    byte[] enemyQu = new byte[]{10, 11, 12, 13, 15};
    byte[] awardParty = new byte[]{10, 12, 13, 14, 15, 16};
    byte[] expReduce = new byte[]{105, 100, 80, 60, 40, 20, 5};
    public static final byte LEVEL_GAP = 6;
    public static final byte MUL_TIME = 15;

    public static GameBattle getInstance() {
        if (_gamebattle == null) {
            _gamebattle = new GameBattle();
        }
        return _gamebattle;
    }

    public GameBattle() {
        this.BATTLE_SINGLE = 0;
        this.BATTLE_DOUBLE = 1;
        this.SKILL_HARM = 0;
        this.SKILL_BENEFIT = 1;
        this.ENEMY_BORN = 0;
        this.ENEMY_DEAD = 1;
        if (this.vPet == null) {
            this.vPet = new Vector();
        }
        if (battlePet == null) {
            battlePet = new Vector();
        }
        if (battleExp == null) {
            battleExp = new Vector();
        }
    }

    public void release() {
        int i;
        this.vPet.removeAllElements();
        for (i = 0; i < this.pokPet.length; ++i) {
            this.getPokPet(i).removeAllDebuf();
            this.getPokPet(i).removeAllbuf();
            this.getPokPet((int)i).battleProp = 0;
            this.getPokPet(i).setBattle(false);
            this.getPokPet((int)i).vTarget.removeAllElements();
            this.getPokPet((int)i).pTarget.removeAllElements();
            this.getPokPet(i).setPreHp(this.getPokPet(i).getCurProp((byte)1));
        }
        battlePet.removeAllElements();
        battleExp.removeAllElements();
        for (i = 0; i < this.gamePet.length; ++i) {
            if (this.gamePet[i] == null) continue;
            this.gamePet[i].stop();
            this.gamePet[i] = null;
        }
        for (i = 0; i < numImg.length; ++i) {
            if (numImg[i] == null) continue;
            GameBattle.numImg[i] = null;
        }
        numImg = null;
        if (this.ballActor != null) {
            this.ballActor.sprite.releaseSprite(3);
            this.ballActor = null;
        }
        if (this.selectActor != null) {
            for (i = 0; i < this.selectActor.length; ++i) {
                this.selectActor[i].sprite.releaseSprite(4);
                this.selectActor[i] = null;
            }
            this.selectActor = null;
        }
        this.enemyIndex = null;
        this.petNext = 0;
        this.petCount = 0;
        this.actorPet = null;
        this.roundOver = false;
        this.cActor = false;
        this.effect = null;
        this.gamePet = null;
        this.battleBackGround = null;
        this.rank = null;
        this.petPos = null;
        this.cCount = null;
        this.pCount = null;
        this.bufList = null;
        this.effectList = null;
        bufEffects = null;
        debufEffects = null;
        GameWorld.eggHatch = 0;
        this.clearBattleData();
        this._gui.clearBattle();
    }

    private void loadBattleData() {
        try {
            InputStream is = CWATools.getInputStream("/data/script/pos.mid");
            pos = CWATools.getShort2DArray(is);
            is = CWATools.getInputStream("/data/script/cpos.mid");
            intoCartoon = new short[3][][];
            for (int i = 0; i < 3; ++i) {
                GameBattle.intoCartoon[i] = CWATools.getShort2DArray(is);
            }
            is = CWATools.getInputStream("/data/script/effect.mid");
            effects = CWATools.getByte2DArray(is);
            is = CWATools.getInputStream("/data/script/speffect.mid");
            spEffect = CWATools.getShort2DArray(is);
            is = CWATools.getInputStream("/data/script/blood.mid");
            bloodPos = CWATools.getShort2DArray(is);
            is = CWATools.getInputStream("/data/script/bufDebuf.mid");
            bufEffects = CWATools.getByte2DArray(is);
            debufEffects = CWATools.getByte2DArray(is);
            bufDebufIndex = CWATools.getByte2DArray(is);
            is.close();
            is = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void clearBattleData() {
        pos = null;
        intoCartoon = null;
        effects = null;
        spEffect = null;
        bloodPos = null;
        bufEffects = null;
        debufEffects = null;
        bufDebufIndex = null;
    }

    public boolean init() {
        int i;
        int i2;
        this.loading();
        this.enemyIndex = new byte[2];
        gamePlayer = GamePlayer.getInstance();
        this.pokPet = new byte[GameBattle.gamePlayer.pokPetSize];
        int livePet = 0;
        for (i2 = 0; i2 < GameBattle.gamePlayer.pokPetSize; ++i2) {
            this.pokPet[i2] = (byte)i2;
            if (this.getPokPet(i2) != null && this.getPokPet(i2).canBattle()) {
                ++livePet;
            }
            this.getPokPet(i2).setPreExp(this.getPokPet(i2).getExp());
        }
        this.gamePet = livePet == 1 && this.playMode == 1 ? new GamePet[3] : new GamePet[this.PET_MAX[this.playMode]];
        this.loadBattleData();
        this.carMode = this.playMode == 0 ? (this.battleType == 1 ? (byte)2 : (byte)0) : (byte)1;
        this.selectActor = new CWASprActor[this.gamePet.length + 2];
        for (i2 = 0; i2 < this.selectActor.length; ++i2) {
            this.selectActor[i2] = new CWASprActor();
            this.selectActor[i2].initSprite(294, false);
            if (i2 == this.gamePet.length + 1) {
                this.selectActor[i2].setAction((byte)2, (byte)-1, false);
                if (this.playMode != 0) continue;
                this.selectActor[i2].start();
                continue;
            }
            if (i2 == this.gamePet.length) {
                this.selectActor[i2].setAction((byte)1, (byte)-1, false);
                this.selectActor[i2].start();
                this.selectActor[i2].setVisible(false);
                continue;
            }
            this.selectActor[i2].setAction((byte)0, (byte)-1, false);
            this.selectActor[i2].setPosition(intoCartoon[this.carMode][i2][2], intoCartoon[this.carMode][i2][3]);
            this.selectActor[i2].start();
        }
        this.cCount = new byte[this.gamePet.length];
        this.pCount = new byte[this.gamePet.length];
        this.initRank(this.gamePet.length);
        int petNum = 0;
        block10: for (i = 0; i < this.gamePet.length; ++i) {
            if (this.playMode == 0) {
                if (i > 0) {
                    while (!this.getPokPet(this.pokPet[petNum]).canBattle()) {
                        ++petNum;
                    }
                    this.initActorPet(i, petNum);
                    battlePet.addElement(this.getPokPet(this.pokPet[petNum]));
                    this.changePet(0, petNum);
                    continue;
                }
                switch (this.battleType) {
                    case 0: 
                    case 1: {
                        this.initEnemyPet(i);
                        break;
                    }
                    case 2: {
                        this.initEnemyPet(i);
                    }
                }
                continue;
            }
            if (i > 1) {
                while (!this.getPokPet(this.pokPet[petNum]).canBattle()) {
                    ++petNum;
                }
                this.initActorPet(i, petNum);
                battlePet.addElement(this.getPokPet(this.pokPet[petNum]));
                this.changePet(i - 2, petNum);
                ++petNum;
                continue;
            }
            switch (this.battleType) {
                case 0: 
                case 1: {
                    this.initEnemyPet(i);
                    continue block10;
                }
                case 2: {
                    this.initEnemyPet(i);
                }
            }
        }
        this.petAgileSort();
        numImg = new Image[3];
        for (i = 0; i < numImg.length; ++i) {
            GameBattle.numImg[i] = CWATools.createImage("/data/tex/", "blood_" + i);
        }
        for (i = 0; i < GameBattle.gamePlayer.pokPetSize; ++i) {
            GameBattle.gamePlayer.pokPet[i].battleHp = GameBattle.gamePlayer.pokPet[i].getCurProp((byte)1);
        }
        this.setState((byte)0);
        this.loadOver();
        return true;
    }

    public void initActorPet() {
        int i;
        int livePet = 0;
        for (int i2 = 0; i2 < GameBattle.gamePlayer.pokPetSize; ++i2) {
            if (this.getPokPet(i2) != null && this.getPokPet(i2).canBattle()) {
                ++livePet;
            }
            this.getPokPet(i2).setPreExp(this.getPokPet(i2).getExp());
        }
        GamePet[] tempPet = null;
        tempPet = this.playMode == 0 ? new GamePet[1] : new GamePet[2];
        for (i = 0; i < this.gamePet.length; i = (int)((byte)(i + 1))) {
            if (this.gamePet[i].getActorEnemy() != 1) continue;
            tempPet[i] = this.gamePet[i];
        }
        this.gamePet = livePet == 1 && this.playMode == 1 ? new GamePet[3] : new GamePet[this.PET_MAX[this.playMode]];
        this.selectActor = new CWASprActor[this.gamePet.length + 2];
        for (i = 0; i < this.selectActor.length; ++i) {
            this.selectActor[i] = new CWASprActor();
            this.selectActor[i].initSprite(294, false);
            if (i == this.gamePet.length + 1) {
                this.selectActor[i].setAction((byte)2, (byte)-1, false);
                if (this.playMode != 0) continue;
                this.selectActor[i].start();
                continue;
            }
            if (i == this.gamePet.length) {
                this.selectActor[i].setAction((byte)1, (byte)-1, false);
                this.selectActor[i].start();
                this.selectActor[i].setVisible(false);
                continue;
            }
            this.selectActor[i].setAction((byte)0, (byte)-1, false);
            this.selectActor[i].setPosition(intoCartoon[this.carMode][i][2], intoCartoon[this.carMode][i][3]);
            this.selectActor[i].start();
        }
        this.cCount = new byte[this.gamePet.length];
        this.pCount = new byte[this.gamePet.length];
        this.petCount = 0;
        this.initRank(this.gamePet.length);
        int petNum = 0;
        for (int i3 = 0; i3 < this.gamePet.length; ++i3) {
            if (this.playMode == 0) {
                if (i3 > 0) {
                    while (!this.getPokPet(this.pokPet[petNum]).canBattle()) {
                        ++petNum;
                    }
                    this.initActorPet(i3, petNum);
                    battlePet.addElement(this.getPokPet(this.pokPet[petNum]));
                    this.changePet(0, petNum);
                    continue;
                }
                this.gamePet[i3] = tempPet[i3];
                continue;
            }
            if (i3 > 1) {
                while (!this.getPokPet(this.pokPet[petNum]).canBattle()) {
                    ++petNum;
                }
                this.initActorPet(i3, petNum);
                battlePet.addElement(this.getPokPet(this.pokPet[petNum]));
                this.changePet(i3 - 2, petNum);
                ++petNum;
                continue;
            }
            this.gamePet[i3] = tempPet[i3];
        }
        this.petAgileSort();
    }

    public void initBaneUi() {
        if (this.playMode == 1) {
            int tempPetNext = 0;
            while (((GamePet)this.vPet.elementAt(tempPetNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(tempPetNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(tempPetNext)).canBattle()) {
                ++tempPetNext;
            }
            if (this.gamePet[0].canBattle()) {
                this._gui.setBattleBane(this.gamePet[this.petPos[tempPetNext]], this.gamePet[0]);
            } else {
                this._gui.setBattleBane(this.gamePet[this.petPos[tempPetNext]], this.gamePet[1]);
            }
        }
    }

    public void initUI() {
        this._gui = GameUI.getInstance();
        this._gui.setGame(this);
        this._ui = CWAUIManager.getInstance();
        if (this.playMode == 0) {
            this._gui.initBattle(this.gamePet[1], this.gamePet[0]);
        } else {
            this._gui.initBattle(this.gamePet[2], this.gamePet[0]);
        }
    }

    public void initActorPet(int i, int pokIndex) {
        this.gamePet[i] = this.getPokPet(this.pokPet[pokIndex]);
        this.gamePet[i].setBattle(true);
        this.gamePet[i].setActorEmemy(0);
        this.gamePet[i].setActorDir((byte)0);
        this.gamePet[i].setPosition(intoCartoon[this.carMode][i][0], intoCartoon[this.carMode][i][1]);
        this.gamePet[i].start();
    }

    public void initEnemyPet(int i) {
        this.gamePet[i] = new GamePet();
        this.gamePet[i].init(this.enemy[this.enemyIndex[0]][0], this.enemy[this.enemyIndex[0]][1], (short)-1, (byte)2, (short)this.enemy[this.enemyIndex[0]][2], (byte)-1);
        this.gamePet[i].setActorEmemy(1);
        this.gamePet[i].setActorDir((byte)1);
        this.gamePet[i].setPosition(intoCartoon[this.carMode][i][0], intoCartoon[this.carMode][i][1]);
        short petDep = CWADataManager.DataBase[0][this.enemy[this.enemyIndex[0]][0]][1];
        this.gamePet[i].learnSkill((byte)(petDep * 10));
        this.gamePet[i].getRandSkill();
        this.gamePet[i].start();
        gamePlayer.setPokPetMapValue((byte)this.gamePet[i].getPetData((byte)1), this.gamePet[i].getPetId(), (byte)1);
        this.enemyIndex[0] = (byte)(this.enemyIndex[0] + 1);
    }

    public void initEffect() {
        this.curEffectIndex = this.effectIndex;
        this.effectList = effects[this.actorPet.curSkillId];
        short x = 0;
        short y = 0;
        short petId = 0;
        short spId = 0;
        short spState = 0;
        short faceDir = 0;
        if (this.effectList[this.curEffectIndex * 7 + 1] == 1) {
            this.effect = new CWAEffect2D();
            if (this.effectList[this.curEffectIndex * 7] == 0) {
                x = (short)((GamePet)this.actorPet.target).getActorX();
                y = (short)((GamePet)this.actorPet.target).getActorY();
                petId = (short)((GamePet)this.actorPet.target).getPetId();
                spId = CWADataManager.DataBase[0][petId][17];
                spState = ((GamePet)this.actorPet.target).getState();
                faceDir = ((GamePet)this.actorPet.target).faceDir;
            } else {
                x = (short)this.actorPet.getActorX();
                y = (short)this.actorPet.getActorY();
                petId = (short)this.actorPet.getPetId();
                spId = CWADataManager.DataBase[0][petId][17];
                spState = this.actorPet.getState();
                faceDir = this.actorPet.faceDir;
            }
            short[] tempData = spEffect[this.effectList[this.curEffectIndex * 7 + 2]];
            short[] data = new short[tempData.length + 5];
            System.arraycopy(tempData, 1, data, 6, tempData.length - 1);
            short[] data1 = new short[]{tempData[0], x, y, spId, spState, faceDir};
            System.arraycopy(data1, 0, data, 0, data1.length);
            this.effect.init(data);
            this.effect.setScreen(true);
        } else if (this.effectList[this.curEffectIndex * 7] == 0) {
            ((GamePet)this.actorPet.target).initEffect(this.effectList[this.curEffectIndex * 7 + 2], this.effectList[this.curEffectIndex * 7 + 3]);
        } else {
            this.actorPet.initEffect(this.effectList[this.curEffectIndex * 7 + 2], this.effectList[this.curEffectIndex * 7 + 3]);
        }
        this.effectIndex = (byte)(this.effectIndex + 1);
    }

    public boolean skipBufEffect(GamePet pet) {
        if (!this.bufOver(pet)) {
            for (int i = 0; i < this.bufDebufSkip[this.bufDebufType[this.bufIndex * 2]].length; ++i) {
                if (this.bufDebufSkip[this.bufDebufType[this.bufIndex * 2]][i] != this.bufDebufType[this.bufIndex * 2 + 1]) continue;
                return false;
            }
            if (this.bufDebufType[this.bufIndex * 2] == 0) {
                pet.bufVal(this.bufDebufType[this.bufIndex * 2 + 1]);
                pet.bufUpdate(this.bufDebufType[this.bufIndex * 2 + 1], this.bufDebufListIndex[this.bufIndex]);
            } else if (this.bufDebufType[this.bufIndex * 2] == 1) {
                pet.debufVal(this.bufDebufType[this.bufIndex * 2 + 1]);
                pet.debufUpdate(this.bufDebufType[this.bufIndex * 2 + 1], this.bufDebufListIndex[this.bufIndex]);
            }
            if (pet.getActorEnemy() == 0) {
                this._gui.setMyBattleUI(pet, false, 1);
                this._gui.setMyBufDebufIcon(pet, 0);
            } else {
                this._gui.setEnemyBattleUI(pet, this.isCal);
                this._gui.setBufDebufIcon(pet, 0);
            }
            this.bufIndex = (byte)(this.bufIndex + 1);
            return this.skipBufEffect(pet);
        }
        return true;
    }

    public void initBufEffect(int where) {
        GamePet pet = (GamePet)this.vPet.elementAt(this.petNext);
        this.curBufListIndex = this.bufListIndex;
        this.bufList = this.bufDebufEffect[this.bufIndex];
        short x = 0;
        short y = 0;
        short petId = 0;
        short spId = 0;
        short spState = 0;
        short faceDir = 0;
        if (this.bufList[this.curBufListIndex * 4] == 1) {
            this.effect = new CWAEffect2D();
            x = (short)pet.getActorX();
            y = (short)pet.getActorY();
            petId = (short)pet.getPetId();
            spId = CWADataManager.DataBase[0][petId][17];
            spState = pet.getState();
            faceDir = pet.faceDir;
            short[] tempData = spEffect[this.bufList[this.curBufListIndex * 4 + 1]];
            short[] data = new short[tempData.length + 5];
            System.arraycopy(tempData, 1, data, 6, tempData.length - 1);
            short[] data1 = new short[]{tempData[0], x, y, spId, spState, faceDir};
            System.arraycopy(data1, 0, data, 0, data1.length);
            this.effect.init(data);
            this.effect.setScreen(true);
        } else {
            pet.initEffect(this.bufList[this.curBufListIndex * 4 + 1], this.bufList[this.curBufListIndex * 4 + 2]);
        }
        this.bufListIndex = (byte)(this.bufListIndex + 1);
    }

    public void enemyBuf(GamePet pet, boolean over) {
        if (!pet.canBattle()) {
            pet.removeAllDebuf();
            pet.removeAllbuf();
            this._gui.setBufDebufIcon(pet, 12);
            this.calExp(pet);
            this.enemyIndex[1] = (byte)(this.enemyIndex[1] + 1);
        }
        if (this.enemyIndex[1] >= this.enemy.length) {
            this.addExp();
            this.setState((byte)8);
        } else if (!pet.canBattle()) {
            for (int j = 0; j < this.gamePet.length; ++j) {
                if (!this.gamePet[j].findBuf(11) || !this.gamePet[this.gamePet[j].bufArr[11][1]].equals(pet)) continue;
                this.gamePet[j].removeBuf(11);
            }
            if (this.enemyIndex[0] < this.enemy.length) {
                this.initEnemyPet(this.petPos[this.petNext]);
                this.changePos = this.petPos[this.petNext];
                this.setState((byte)15);
            } else {
                this.petNext = (byte)(this.petNext + 1);
                this.roundOver();
            }
        } else if (over) {
            this.setState((byte)2);
        }
    }

    public void actorBuf(GamePet pet, boolean over) {
        int i = 0;
        for (i = 0; i < this.pokPet.length && !this.getPokPet(this.pokPet[i]).canBattle(); ++i) {
        }
        if (i >= this.pokPet.length) {
            this.setState((byte)9);
        } else if (!pet.canBattle()) {
            for (int j = 0; j < this.gamePet.length; ++j) {
                if (!this.gamePet[j].findBuf(11) || !this.gamePet[this.gamePet[j].bufArr[11][1]].equals(pet)) continue;
                this.gamePet[j].removeBuf(11);
            }
            pet.removeAllDebuf();
            pet.removeAllbuf();
            this._gui.setMyBufDebufIcon(pet, 12);
            battlePet.removeElement(pet);
            battleExp.removeElement(pet);
            pet.addExp = 0;
            pet.setBattle(false);
            pet.battleProp = 0;
            if (this.isHavePet()) {
                this.changePos = this.petPos[this.petNext];
                this.setState((byte)5);
            } else {
                this.petNext = (byte)(this.petNext + 1);
                this.roundOver();
            }
        } else if (over) {
            if (pet.findDebuf(9)) {
                this.setState((byte)2);
            } else {
                this.setState((byte)20);
            }
        }
    }

    public boolean bufOver(GamePet pet) {
        if (this.bufIndex >= this.bufDebufEffect.length) {
            this.bufIndex = 0;
            this.bufListIndex = 0;
            this.curBufListIndex = 0;
            this.bufDebufEffect = null;
            this.bufDebufType = null;
            this.bufDebufListIndex = null;
            this.effect = null;
            if (this.gamestate == 12) {
                this.enemyBuf(pet, true);
            } else if (this.gamestate == 13) {
                this.actorBuf(pet, true);
            }
            return true;
        }
        return false;
    }

    public void bufChange(GamePet pet) {
        this.bufIndex = (byte)(this.bufIndex + 1);
        if (!this.bufOver(pet)) {
            if (this.skipBufEffect(pet)) {
                return;
            }
            this.bufListIndex = 0;
            this.curBufListIndex = 0;
            this.initBufEffect(0);
            if (this.gamestate == 12) {
                if (this.isChangePet(pet) == 2) {
                    this.bufIndex = 0;
                    this.bufDebufEffect = null;
                    this.bufDebufType = null;
                    this.bufDebufListIndex = null;
                }
                this.enemyBuf(pet, false);
            } else if (this.gamestate == 13) {
                if (this.isChangePet(pet) == 1) {
                    this.bufIndex = 0;
                    this.bufDebufEffect = null;
                    this.bufDebufType = null;
                    this.bufDebufListIndex = null;
                }
                this.actorBuf(pet, false);
            }
        }
    }

    public boolean bufResult(GamePet pet) {
        boolean bufr = false;
        int preHp = pet.getPreHp();
        int addHp = 0;
        if (!this.isCal) {
            if (this.bufDebufType[this.bufIndex * 2] == 0) {
                addHp = pet.bufVal(this.bufDebufType[this.bufIndex * 2 + 1]);
                pet.bufUpdate(this.bufDebufType[this.bufIndex * 2 + 1], this.bufDebufListIndex[this.bufIndex]);
            } else if (this.bufDebufType[this.bufIndex * 2] == 1) {
                pet.debufVal(this.bufDebufType[this.bufIndex * 2 + 1]);
                pet.debufUpdate(this.bufDebufType[this.bufIndex * 2 + 1], this.bufDebufListIndex[this.bufIndex]);
            }
            if (pet.getCurProp((byte)1) < preHp) {
                this.setNumIndex("" + (pet.getCurProp((byte)1) - preHp), (byte)0, 0, pet.getActorEnemy(), pet.getActorX(), pet.getActorY(), 9, 12);
            }
            if (addHp > 0) {
                this.setNumIndex("+" + addHp, (byte)0, 2, pet.getActorEnemy(), pet.getActorX(), pet.getActorY(), 9, 12);
            }
            this.isCal = true;
            this._gui.bufIndex = 0;
            if (pet.getActorEnemy() == 0) {
                this._gui.setMyBufDebufIcon(pet, 4);
            } else {
                this._gui.setBufDebufIcon(pet, 4);
            }
        }
        boolean fn = this.floatNum();
        if (pet.getActorEnemy() == 0) {
            if (preHp < pet.getCurProp((byte)1)) {
                if (this._gui.setMyBattleUI(pet, true, 2) && fn) {
                    this.isCal = false;
                    bufr = true;
                    this.bufChange(pet);
                }
            } else if (this._gui.setMyBattleUI(pet, false, 3) && fn) {
                this.isCal = false;
                bufr = true;
                this.bufChange(pet);
            }
        } else if (preHp < pet.getCurProp((byte)1)) {
            if (this._gui.setEnemyBattleUI(pet, true) && fn) {
                this.isCal = false;
                bufr = true;
                this.bufChange(pet);
            }
        } else if (this._gui.setEnemyBattleUI(pet, false) && fn) {
            this.isCal = false;
            bufr = true;
            this.bufChange(pet);
        }
        return bufr;
    }

    public void updateBufeffect() {
        GamePet pet = (GamePet)this.vPet.elementAt(this.petNext);
        if (pet.effect != null) {
            if (pet.effect.isAction()) {
                if (pet.effect.isEndFrame()) {
                    pet.effect.stop();
                    pet.effect = null;
                    if (this.bufListIndex > this.bufList.length / 4 - 1) {
                        if (this.effect == null) {
                            this.battleResult = true;
                        }
                    } else {
                        this.initBufEffect(1);
                        if (pet.effect != null) {
                            pet.effect.start();
                        }
                    }
                } else if (this.bufList[this.curBufListIndex * 4 + 3] != -1 && pet.effect.isCheckFrame(this.bufList[this.curBufListIndex * 4 + 3]) && this.bufListIndex < this.bufList.length / 4) {
                    this.initBufEffect(3);
                }
            } else {
                pet.effect.start();
            }
        }
        if (this.effect != null && !this.effect.isAction()) {
            this.effect.start();
            pet.setVisible(false);
        }
        if (this.effect != null && this.effect.isAction() && !this.effect.update()) {
            this.effect = null;
            pet.setVisible(true);
            if (this.bufListIndex > this.bufList.length / 4 - 1) {
                this.battleResult = true;
            } else {
                this.initBufEffect(2);
            }
        }
        if (this.battleResult && this.bufResult(pet)) {
            this.battleResult = false;
        }
    }

    public void initRank(int len) {
        this.rank = new byte[len];
        this.petPos = new byte[len];
        for (int i = 0; i < this.rank.length; ++i) {
            this.rank[i] = (byte)i;
        }
    }

    public void setBallState(byte ballState) {
        switch (ballState) {
            case 0: {
                this.ballActor.setAction(ballState, (byte)0, true);
                break;
            }
            case 1: {
                this.gamePet[0].setVisible(false);
                short spId = CWADataManager.DataBase[0][((GamePet)this.actorPet.target).getPetId()][17];
                short[] data = new short[]{8, (short)((GamePet)this.actorPet.target).getActorX(), (short)((GamePet)this.actorPet.target).getActorY(), spId, 0, ((GamePet)this.actorPet.target).faceDir, 0, 9, 1, 3, 0, 10, 0, 0, 7, 0, -10, 4, 0, -20};
                this.effect = new CWAEffect2D();
                this.effect.init(data);
                this.effect.setScreen(true);
                this.effect.start();
                this.ballActor.setAction(ballState, (byte)-2, true);
                break;
            }
            case 2: {
                this.ballActor.setAction(ballState, (byte)0, true);
                break;
            }
            case 3: {
                this.ballActor.setAction(ballState, (byte)-2, true);
                break;
            }
            case 4: {
                short spId1 = CWADataManager.DataBase[0][((GamePet)this.actorPet.target).getPetId()][17];
                short[] data1 = new short[]{8, (short)((GamePet)this.actorPet.target).getActorX(), (short)((GamePet)this.actorPet.target).getActorY(), spId1, 0, ((GamePet)this.actorPet.target).faceDir, 0, 8, 1, 4, 1, 4, 0, -20, 6, 0, -12, 8, 0, -4, 10, 0, 0};
                this.effect = new CWAEffect2D();
                this.effect.init(data1);
                this.effect.setScreen(true);
                this.effect.start();
                this.ballActor.setAction((byte)1, (byte)-2, true);
            }
        }
        this.ballState = ballState;
    }

    public void setSelectBackPos(int index, boolean flag) {
        this.selectActor[this.gamePet.length + 1].setVisible(flag);
        this.selectActor[this.gamePet.length + 1].setPosition(pos[this.playMode][index * 4 + 2], pos[this.playMode][index * 4 + 3]);
    }

    public void setBackPos(int index, boolean flag) {
        this.selectActor[this.gamePet.length].setVisible(flag);
        this.selectActor[this.gamePet.length].setPosition(pos[this.playMode][index * 4 + 2], pos[this.playMode][index * 4 + 3]);
    }

    public void setState(byte state) {
        this.prestate = this.gamestate;
        this.gamestate = state;
        switch (state) {
            case 0: {
                this.petNext = 0;
                while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0) {
                    this.petNext = (byte)(this.petNext + 1);
                }
                break;
            }
            case 15: {
                this._gui._ui_index_0 = 0;
                this.cActor = true;
                this.petCount = this.changePos;
                this.pCount[this.petCount] = 0;
                this.vPet.setElementAt(this.gamePet[this.changePos], this.rank[this.changePos]);
                this.gamePet[this.changePos].cActor = true;
                this.setBackPos(this.changePos, false);
                this.petNext = (byte)(this.petNext + 1);
                break;
            }
            case 20: {
                this.actorPet = (GamePet)this.vPet.elementAt(this.petNext);
                for (int i = 0; i < this.gamePet.length; ++i) {
                    if (this.gamePet[i].getActorEnemy() != 1 || !this.gamePet[i].canBattle()) continue;
                    this._gui.setEnemyBattleUI(this.gamePet[i], false);
                    this._gui.setBufDebufIcon(this.gamePet[i], 0);
                }
                this.setBackPos(this.petPos[this.petNext], true);
                this._gui.initBattleSelect(this.actorPet);
                if (this.gamePet[0].canBattle()) {
                    this._gui.setBattleBane(this.actorPet, this.gamePet[0]);
                    break;
                }
                this._gui.setBattleBane(this.actorPet, this.gamePet[1]);
                break;
            }
            case 1: {
                if (this.petNext >= this.vPet.size()) {
                    this.petNext = 0;
                }
                this.actorPet = (GamePet)this.vPet.elementAt(this.petNext);
                while (this.actorPet.cActor || !this.actorPet.canBattle()) {
                    this.petNext = (byte)(this.petNext + 1);
                    if (this.actorPet.cActor) {
                        this.actorPet.cActor = false;
                    }
                    if (this.petNext >= this.vPet.size()) {
                        this.roundOver = true;
                        this.petNext = 0;
                        break;
                    }
                    this.actorPet = (GamePet)this.vPet.elementAt(this.petNext);
                }
                if (!this.actorPet.findDebuf(2) || this.actorPet.getActorEnemy() != 0) break;
                boolean skill = false;
                for (int i = 0; i < this.actorPet.skillPro.length; ++i) {
                    if (this.actorPet.skillPro[i] == 0) continue;
                    skill = true;
                }
                if (skill) break;
                this._gui.taskTips("\u6ca1\u7cbe\u529b,\u65e0\u6cd5\u6218\u6597");
                this.petNext = (byte)(this.petNext + 1);
                if (this.petNext < this.vPet.size()) break;
                this.roundOver = true;
                this.petNext = 0;
                break;
            }
            case 12: 
            case 13: {
                int i;
                if (this.actorPet.getActorEnemy() == 0) {
                    this._gui.setMyBattleUI(this.actorPet, false, 4);
                    this._gui.setMyBufDebufIcon(this.actorPet, 0);
                } else {
                    this._gui.setEnemyBattleUI(this.actorPet, false);
                    this._gui.setBufDebufIcon(this.actorPet, 0);
                }
                GamePet pet = (GamePet)this.vPet.elementAt(this.petNext);
                if (pet.findBuf(13) || pet.findBuf(14)) {
                    pet.removeAllDebuf();
                }
                this.bufDebufEffect = new byte[pet.getBufDebufNum(0) + pet.getBufDebufNum(1)][];
                this.bufDebufType = new byte[this.bufDebufEffect.length * 2];
                this.bufDebufListIndex = new byte[this.bufDebufEffect.length];
                int index = 0;
                for (i = 0; i < 3; ++i) {
                    if (pet.bufType[0][i] == -1) continue;
                    this.bufDebufListIndex[index] = (byte)i;
                    this.bufDebufEffect[index] = bufEffects[bufDebufIndex[0][pet.bufType[0][i]]];
                    this.bufDebufType[index * 2] = 0;
                    this.bufDebufType[index * 2 + 1] = pet.bufType[0][i];
                    ++index;
                }
                for (i = 0; i < 3; ++i) {
                    if (pet.bufType[1][i] == -1) continue;
                    this.bufDebufListIndex[index] = (byte)i;
                    this.bufDebufEffect[index] = debufEffects[bufDebufIndex[1][pet.bufType[1][i]]];
                    this.bufDebufType[index * 2] = 1;
                    this.bufDebufType[index * 2 + 1] = pet.bufType[1][i];
                    ++index;
                }
                this.bufListIndex = 0;
                this.curBufListIndex = 0;
                if (this.skipBufEffect(pet)) break;
                this.initBufEffect(4);
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                if (this.actorPet.getActorEnemy() == 0) {
                    this._gui.setMyBattleUI(this.actorPet, false, 5);
                    this._gui.setMyBufDebufIcon(this.actorPet, 0);
                } else {
                    this._gui.setEnemyBattleUI(this.actorPet, false);
                    this._gui.setBufDebufIcon(this.actorPet, 0);
                }
                if (((GamePet)this.actorPet.target).getActorEnemy() == 1) {
                    this._gui.setEnemyBattleUI((GamePet)this.actorPet.target, false);
                    this._gui.setBufDebufIcon((GamePet)this.actorPet.target, 0);
                } else {
                    this._gui.setMyBattleUI((GamePet)this.actorPet.target, false, 6);
                    this._gui.setMyBufDebufIcon((GamePet)this.actorPet.target, 0);
                }
                this.calTarget = false;
                this.battleResult = false;
                this.initEffect();
                if (this.canHarm()) {
                    this.harmValue = this.actorPet.calHarm((GamePet)this.actorPet.target);
                }
                switch (this.actorPet.curSkillId) {
                    case 52: 
                    case 58: {
                        int rand = CWATools.getRandom(100);
                        if (rand <= 30) {
                            this.isAddHp = true;
                            break;
                        }
                        this.isAddHp = false;
                        break;
                    }
                    default: {
                        this.isAddHp = true;
                    }
                }
                if (this.effectList[this.curEffectIndex * 7] == 0) {
                    this.actorPet.setState((byte)1, (byte)0, true);
                    break;
                }
                this.actorPet.setState((byte)0, (byte)0, true);
                break;
            }
            case 3: {
                this._gui.initBattleSkill((GamePet)this.vPet.elementAt(this.petNext));
                break;
            }
            case 4: {
                this._gui.initBattleItem();
                break;
            }
            case 6: {
                this.targetIndex = 0;
                this._gui.setEnemyBattleUI((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), false);
                this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
                this._gui.setBufDebufIcon((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), 0);
                this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), true);
                break;
            }
            case 16: {
                this._gui._ui_index_2 = 0;
                this._gui.useItem = false;
                this._gui.initCheckPet();
                break;
            }
            case 5: {
                this._gui._ui_index_2 = 0;
                this._gui.initCheckPet();
                this.petIndex = 0;
                break;
            }
            case 17: {
                this.actorPet.setTarget(this.gamePet[0]);
                if (this.ballActor == null) {
                    this.ballActor = new CWASprActor();
                    this.ballActor.initSprite(269, false);
                }
                this.ballActor.setPosition(this.actorPet.getActorX(), this.actorPet.getActorY());
                this.ballActor.start();
                this.setBallState((byte)0);
                this.seizeFlag = false;
                int rate = this.calSeizeRate(ballId, 0);
                this.seizeFlag = CWATools.getRandom(100) < rate;
                if (teachId == 0 && teachStep == 5) {
                    this.seizeFlag = false;
                }
                this._gui._ui_layer = 0;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                this.actorPet.setTarget(this.gamePet[0]);
                this._gui.initPetBall();
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                GameWorld.getInstance()._event.eventBattleResult = 0;
                int addHp = 0;
                for (int i = 0; i < battlePet.size(); ++i) {
                    addHp = ((GamePet)GameBattle.battlePet.elementAt((int)i)).battleHp - ((GamePet)battlePet.elementAt(i)).getCurProp((byte)1);
                    addHp = isSMSCheck ? addHp % 20 / 100 : addHp % 50 / 100;
                    if (addHp <= 0) continue;
                    ((GamePet)battlePet.elementAt(i)).addHp(addHp);
                    ((GamePet)battlePet.elementAt(i)).setPreHp(((GamePet)battlePet.elementAt(i)).getCurProp((byte)1));
                }
                this.selectActor[0].setPosition(pos[0][6], pos[0][7]);
                this._gui.initBattleWin(pos[0][4], pos[0][5]);
                break;
            }
            case 22: {
                this._gui.initLevelUp();
                break;
            }
            case 9: {
                this.battleLose();
                break;
            }
            case 11: {
                this._gui.initShopBuy(4, (byte)0);
                break;
            }
            case 14: {
                break;
            }
            case 23: {
                this._gui.initLearnSkill();
                break;
            }
            case 24: {
                this._gui.initBattleRevive();
                break;
            }
            case 102: {
                this._gui.initSmsGold();
                break;
            }
            case 104: {
                this._gui.initSmsBadge();
                break;
            }
            case 101: {
                this._gui.initSmsBall();
            }
        }
    }

    public void update() {
        if (!this.onListen) {
            return;
        }
        this.getKey();
        switch (this.gamestate) {
            case 0: {
                this.delay = (byte)(this.delay + 1);
                this.cCount[this.petCount] = this.pCount[this.petCount];
                this.gamePet[this.petCount].setPosition(intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4], intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4 + 1]);
                this.selectActor[this.petCount].setPosition(intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4 + 2], intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4 + 3]);
                if (this.playMode == 1 && this.pCount[this.petCount] > intoCartoon[this.carMode][this.petCount].length / 4 - 3 && this.petCount % 2 == 0 && this.pCount.length > this.petCount + 1) {
                    int n = this.petCount + 1;
                    this.pCount[n] = (byte)(this.pCount[n] + 1);
                    this.cCount[this.petCount + 1] = this.pCount[this.petCount + 1];
                    this.gamePet[this.petCount + 1].setPosition(intoCartoon[this.carMode][this.petCount + 1][this.pCount[this.petCount + 1] * 4], intoCartoon[this.carMode][this.petCount + 1][this.pCount[this.petCount + 1] * 4 + 1]);
                    this.selectActor[this.petCount + 1].setPosition(intoCartoon[this.carMode][this.petCount + 1][this.pCount[this.petCount + 1] * 4 + 2], intoCartoon[this.carMode][this.petCount + 1][this.pCount[this.petCount + 1] * 4 + 3]);
                }
                if (this.playMode == 0) {
                    this._gui.setBattleBane(this.gamePet[1], this.gamePet[0], this.gamePet[this.petCount], this.pCount[this.petCount] + 1, intoCartoon[this.carMode][this.petCount].length / 4);
                }
                if (this.delay > 1) {
                    int n = this.petCount;
                    this.pCount[n] = (byte)(this.pCount[n] + 1);
                    this.delay = 0;
                }
                if (this.pCount[this.petCount] <= intoCartoon[this.carMode][this.petCount].length / 4 - 1) break;
                this.pCount[this.petCount] = (byte)(intoCartoon[this.carMode][this.petCount].length / 4 - 1);
                this.cCount[this.petCount] = this.pCount[this.petCount];
                ++this.petCount;
                if (this.petCount <= this.gamePet.length - 1) break;
                this.petCount = this.gamePet.length - 1;
                this.setState((byte)20);
                break;
            }
            case 15: {
                if (this.playMode == 0) {
                    this._gui.BattleBaneChange(this.gamePet[1], this.gamePet[0], this.gamePet[this.petCount], this.pCount[this.petCount] + 1, intoCartoon[this.carMode][this.petCount].length / 4);
                }
                if (this.delay >= 1) {
                    int n = this.petCount;
                    this.pCount[n] = (byte)(this.pCount[n] + 1);
                    this.delay = 0;
                } else {
                    this.delay = (byte)(this.delay + 1);
                    if (this.pCount[this.petCount] > intoCartoon[this.carMode][this.petCount].length / 4 - 3) {
                        this.cCount[this.petCount] = this.pCount[this.petCount];
                    }
                    this.gamePet[this.petCount].setPosition(intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4], intoCartoon[this.carMode][this.petCount][this.pCount[this.petCount] * 4 + 1]);
                }
                if (this.pCount[this.petCount] <= intoCartoon[this.carMode][this.petCount].length / 4 - 1) break;
                this.cCount[this.petCount] = this.pCount[this.petCount] = (byte)(intoCartoon[this.carMode][this.petCount].length / 4 - 1);
                boolean canShow = true;
                if (this.isSelect) {
                    while (!(this.petNext >= this.vPet.size() || ((GamePet)this.vPet.elementAt(this.petNext)).canBattle() && ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0)) {
                        this.petNext = (byte)(this.petNext + 1);
                    }
                    if (this.petNext >= this.vPet.size()) {
                        this.petNext = 0;
                        this.setState((byte)1);
                    } else if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
                        this.setState((byte)13);
                    } else {
                        canShow = false;
                        this.setState((byte)20);
                    }
                    this.isSelect = false;
                } else {
                    int random;
                    boolean canNext;
                    if (this.playMode == 0) {
                        this.petNext = (byte)this.vPet.size();
                    }
                    if (this.petNext >= this.vPet.size()) {
                        for (int i = 0; i < this.gamePet.length; ++i) {
                            this.gamePet[i].cActor = false;
                        }
                        if (this.cActor) {
                            this.petAgileSort();
                            this.cActor = false;
                        }
                        if (this.prestate == 12 || this.prestate == 13) {
                            this.petNext = 0;
                            while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(this.petNext)).canBattle()) {
                                this.petNext = (byte)(this.petNext + 1);
                            }
                            if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
                                this.setState((byte)13);
                            } else {
                                canShow = false;
                                this.setState((byte)20);
                            }
                        } else {
                            canNext = false;
                            if (this.actorPet.findBuf(12) && this.actorPet.value[12] == 2) {
                                this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                                if (!((GamePet)this.actorPet.target).canBattle()) {
                                    canNext = true;
                                    this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                                } else {
                                    this.petNext = (byte)(this.petNext - 1);
                                    this.setState((byte)2);
                                }
                            } else {
                                random = CWATools.getRandom(100);
                                if ((this.actorPet.curSkillId == 63 || this.actorPet.curSkillId == 69) && random <= CWADataManager.DataBase[1][this.actorPet.curSkillId][8]) {
                                    if (!((GamePet)this.actorPet.target).canBattle()) {
                                        canNext = true;
                                    } else {
                                        this.petNext = (byte)(this.petNext - 1);
                                        this.setState((byte)2);
                                    }
                                } else {
                                    canNext = true;
                                }
                            }
                            if (canNext) {
                                this.petNext = 0;
                                while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(this.petNext)).canBattle()) {
                                    this.petNext = (byte)(this.petNext + 1);
                                }
                                if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
                                    this.setState((byte)13);
                                } else {
                                    canShow = false;
                                    this.setState((byte)20);
                                }
                            }
                        }
                    } else if (this.prestate == 13 || this.prestate == 12) {
                        this.setState((byte)1);
                    } else {
                        canNext = false;
                        if (this.actorPet.findBuf(12) && this.actorPet.value[12] == 2) {
                            this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                            if (!((GamePet)this.actorPet.target).canBattle()) {
                                this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                                canNext = true;
                            } else {
                                this.petNext = (byte)(this.petNext - 1);
                                this.setState((byte)2);
                            }
                        } else {
                            random = CWATools.getRandom(100);
                            if ((this.actorPet.curSkillId == 63 || this.actorPet.curSkillId == 69) && random <= CWADataManager.DataBase[1][this.actorPet.curSkillId][8]) {
                                if (!((GamePet)this.actorPet.target).canBattle()) {
                                    canNext = true;
                                } else {
                                    this.petNext = (byte)(this.petNext - 1);
                                    this.setState((byte)2);
                                }
                            } else {
                                canNext = true;
                            }
                        }
                        if (canNext) {
                            this.setState((byte)1);
                        }
                    }
                }
                if (!canShow) break;
                this.initBaneUi();
                if (this.gamePet[this.changePos].getActorEnemy() == 0) {
                    this._gui.setMyBattleUI(this.gamePet[this.changePos], false, 6);
                    this._gui.setMyBufDebufIcon(this.gamePet[this.changePos], 0);
                    break;
                }
                this._gui.setEnemyBattleUI(this.gamePet[this.changePos], false);
                this._gui.setBufDebufIcon(this.gamePet[this.changePos], 0);
                break;
            }
            case 1: {
                if (this._gui.isCloseTaskTips()) {
                    if (this.actorPet.getActorEnemy() == 1 && this.battleType == 0 && (this.actorPet.getPetId() == 33 || this.actorPet.getPetId() == 59) && this.actorPet.getCurProp((byte)1) < this.actorPet.getProp((byte)1)) {
                        this.setState((byte)10);
                        return;
                    }
                    if (this.roundOver) {
                        if (this.cActor) {
                            this.petAgileSort();
                            this.petNext = 0;
                            this.cActor = false;
                        }
                        this.petNext = 0;
                        while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(this.petNext)).canBattle()) {
                            this.petNext = (byte)(this.petNext + 1);
                        }
                        if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
                            this.setState((byte)13);
                        } else {
                            this.setState((byte)20);
                        }
                        this.roundOver = false;
                    } else if (this.actorPet.getActorEnemy() == 1) {
                        if (this.bufDebuf(this.actorPet)) {
                            this.setState((byte)12);
                        } else {
                            this.setState((byte)2);
                        }
                    } else {
                        this.setState((byte)2);
                    }
                }
                this._gui.updateTaskTip();
                this.selectActor[this.gamePet.length].updateAction();
                break;
            }
            case 20: {
                this.selectActor[this.gamePet.length].updateAction();
                this._gui.updateBattleSelect(this.actorPet);
                break;
            }
            case 12: 
            case 13: {
                this.updateBufeffect();
                break;
            }
            case 2: {
                int rd;
                if (this.actorPet.getActorEnemy() == 1) {
                    byte skId = (byte)this.getRandSkill(this.actorPet);
                    if (this.actorPet.findDebuf(9)) {
                        this.selectTarget(this.actorPet);
                    } else {
                        int rd2;
                        boolean canUseKill = true;
                        if (this.actorPet.getSkillPro(skId, (byte)9) == 0 && this.actorPet.findDebuf(8) && (rd2 = CWATools.getRandom(100)) > CWADataManager.getDataBase((byte)1, skId, (byte)8)) {
                            this.selectTarget(this.actorPet);
                            canUseKill = false;
                        }
                        if (canUseKill) {
                            this.selectTarget(skId);
                        }
                    }
                    int rand = CWATools.getRandom(this.actorPet.vTarget.size());
                    GamePet targetPet = (GamePet)this.actorPet.vTarget.elementAt(rand);
                    this.actorPet.hurtPos = Byte.parseByte((String)this.actorPet.pTarget.elementAt(rand));
                    this._gui.setBattleBane(this.actorPet, targetPet);
                    this.actorPet.useSkill(skId, targetPet);
                    this.setState((byte)7);
                    break;
                }
                if (this.actorPet.findDebuf(9)) {
                    this.selectTarget(this.actorPet);
                    int rand = CWATools.getRandom(this.actorPet.vTarget.size());
                    GamePet targetPet = (GamePet)this.actorPet.vTarget.elementAt(rand);
                    this.actorPet.hurtPos = Byte.parseByte((String)this.actorPet.pTarget.elementAt(rand));
                    byte skId = (byte)this.getRandSkill(this.actorPet);
                    this.actorPet.useSkill(skId, targetPet);
                    this._gui.setBattleBane(this.actorPet, targetPet);
                    this.setState((byte)7);
                    break;
                }
                boolean canUseKill = true;
                if (this.actorPet.getSkillPro(this.actorPet.getUseSkillId(), (byte)9) == 0 && this.actorPet.findDebuf(8) && (rd = CWATools.getRandom(100)) > CWADataManager.getDataBase((byte)1, this.actorPet.getUseSkillId(), (byte)8)) {
                    this.selectTarget(this.actorPet);
                    canUseKill = false;
                }
                if (canUseKill) {
                    if ((GamePet)this.actorPet.target != null && !((GamePet)this.actorPet.target).canBattle()) {
                        for (int i = 0; i < this.actorPet.vTarget.size(); ++i) {
                            if (!((GamePet)this.actorPet.vTarget.elementAt(i)).canBattle()) continue;
                            this.actorPet.hurtPos = Byte.parseByte((String)this.actorPet.pTarget.elementAt(i));
                            this.actorPet.useSkill(this.actorPet.getUseSkillId(), (GamePet)this.actorPet.vTarget.elementAt(i));
                        }
                    } else {
                        this.actorPet.useSkill(this.actorPet.getUseSkillId(), (GamePet)this.actorPet.target);
                    }
                }
                this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.target);
                this.setState((byte)7);
                break;
            }
            case 7: {
                if (this.actorPet.effect != null) {
                    if (this.actorPet.getState() == 0) {
                        if (this.actorPet.effect.isAction()) {
                            if (this.actorPet.effect.isEndFrame()) {
                                this.actorPet.effect.stop();
                                this.actorPet.effect = null;
                                if (this.effectIndex > this.effectList.length / 7 - 1 || this.skipSkillEffect()) {
                                    this.battleResult = true;
                                    this.hurtOver = true;
                                } else {
                                    this.initEffect();
                                    if (this.actorPet.effect != null) {
                                        this.actorPet.effect.start();
                                    }
                                    if (this.effect != null) {
                                        this.isSpEffect = true;
                                    }
                                }
                            } else if (this.effectList[this.curEffectIndex * 7 + 4] != -1 && this.actorPet.effect.isCheckFrame(this.effectList[this.curEffectIndex * 7 + 4])) {
                                this.actorPet.effect.stop();
                                if (this.effectIndex < this.effectList.length / 7 - 1 || this.skipSkillEffect()) {
                                    this.initEffect();
                                    if (this.effect != null) {
                                        this.isSpEffect = true;
                                    }
                                }
                            } else if (this.effectList[this.curEffectIndex * 7 + 5] != -1 && this.actorPet.effect.isCheckFrame(this.effectList[this.curEffectIndex * 7 + 5])) {
                                this.actorPet.setState(this.effectList[this.curEffectIndex * 7 + 6], (byte)0, true);
                            }
                        } else {
                            this.isfirst = false;
                            this.actorPet.effect.start();
                        }
                    } else if (this.actorPet.getState() == 1 && this.actorPet.isEndFrame()) {
                        this.actorPet.setState((byte)0, (byte)0, true);
                    }
                } else if (((GamePet)this.actorPet.target).effect != null) {
                    if (((GamePet)this.actorPet.target).effect.isAction()) {
                        if (((GamePet)this.actorPet.target).effect.isEndFrame()) {
                            ((GamePet)this.actorPet.target).effect.stop();
                            if (this.effectIndex > this.effectList.length / 7 - 1 || this.skipSkillEffect()) {
                                ((GamePet)this.actorPet.target).setState((byte)2, (byte)0, true);
                            } else if (this.effectList[this.effectIndex * 7] == 1) {
                                ((GamePet)this.actorPet.target).setState((byte)2, (byte)0, true);
                            } else {
                                this.effectState = 0;
                                ((GamePet)this.actorPet.target).effect = null;
                                this.initEffect();
                                if (((GamePet)this.actorPet.target).effect != null) {
                                    ((GamePet)this.actorPet.target).effect.start();
                                }
                                if (this.effect != null) {
                                    this.isSpEffect = true;
                                }
                            }
                        } else {
                            if (this.effectList[this.curEffectIndex * 7 + 5] != -1) {
                                this.effectState = this.curEffectIndex;
                            }
                            if (this.effectList[this.effectState * 7 + 5] != -1 && ((GamePet)this.actorPet.target).effect.isCheckFrame(this.effectList[this.effectState * 7 + 5])) {
                                ((GamePet)this.actorPet.target).setState(this.effectList[this.effectState * 7 + 6], (byte)0, true);
                                this.effectState = 0;
                            }
                            if (this.effectList[this.curEffectIndex * 7 + 4] != -1 && ((GamePet)this.actorPet.target).effect.isCheckFrame(this.effectList[this.curEffectIndex * 7 + 4])) {
                                this.initEffect();
                                if (this.effect != null) {
                                    this.isSpEffect = true;
                                }
                            }
                        }
                    } else if (this.actorPet.getState() == 1 && this.actorPet.isEndFrame() || this.isfirst) {
                        this.actorPet.setState((byte)0, (byte)0, true);
                        ((GamePet)this.actorPet.target).effect.start();
                        this.isfirst = false;
                    } else if (((GamePet)this.actorPet.target).getState() == 2 && ((GamePet)this.actorPet.target).isEndFrame()) {
                        this.calTarget = true;
                        ((GamePet)this.actorPet.target).effect = null;
                        if (this.effectIndex > this.effectList.length / 7 - 1 || this.skipSkillEffect()) {
                            this.battleResult = true;
                        } else {
                            this.initEffect();
                            if (this.effect != null) {
                                this.isSpEffect = true;
                            }
                        }
                    }
                }
                if (this.effect != null && !this.effect.isAction() && (this.actorPet.getState() == 1 && this.actorPet.isEndFrame() || this.isSpEffect || this.actorPet.getState() == 0)) {
                    if (this.curEffectIndex == 0) {
                        this.isfirst = true;
                    }
                    this.actorPet.setState((byte)0, (byte)0, true);
                    this.effect.start();
                    this.spEffectIndex = this.curEffectIndex;
                    if (this.effectList[this.curEffectIndex * 7] == 0) {
                        ((GamePet)this.actorPet.target).setVisible(false);
                    } else {
                        this.actorPet.setVisible(false);
                    }
                }
                if (this.effect != null && this.effect.isAction() && !this.effect.update()) {
                    this.effect = null;
                    this.isSpEffect = false;
                    if (this.effectList[this.spEffectIndex * 7] == 0) {
                        ((GamePet)this.actorPet.target).setVisible(true);
                    } else {
                        this.actorPet.setVisible(true);
                    }
                    if (((GamePet)this.actorPet.target).effect == null && this.actorPet.effect == null) {
                        if (this.effectIndex > this.effectList.length / 7 - 1 || this.skipSkillEffect()) {
                            if (this.effectList[this.curEffectIndex * 7] == 0) {
                                this.calTarget = true;
                            }
                            this.hurtOver = true;
                            this.battleResult = true;
                        } else {
                            if (this.effectList[this.effectIndex * 7] == 1) {
                                this.calTarget = true;
                            }
                            this.initEffect();
                            if (this.effect != null) {
                                this.isSpEffect = true;
                            }
                        }
                    }
                    this.spEffectIndex = 0;
                }
                if (this.calTarget) {
                    this.hurtOver = false;
                    if (this.calTarget()) {
                        if (!((GamePet)this.actorPet.target).canBattle()) {
                            if (this.targetMove((GamePet)this.actorPet.target, true)) {
                                this.hurtOver = true;
                                this.calTarget = false;
                            }
                        } else {
                            this.hurtOver = true;
                            this.calTarget = false;
                        }
                    }
                }
                if (!this.hurtOver || !this.battleResult || !this.battleResult()) break;
                this.hurtOver = false;
                this.battleResult = false;
                break;
            }
            case 3: {
                this._gui.updateBattleSkill((GamePet)this.vPet.elementAt(this.petNext));
                break;
            }
            case 4: {
                this._gui.updateBattleItem();
                break;
            }
            case 17: {
                if (this._gui._ui_layer == 0) {
                    if (this.ballState == 0 && this.ballActor.isEndFrame()) {
                        this.setBallState((byte)1);
                    } else if (this.ballState == 1 && this.ballActor.isEndFrame()) {
                        if (!this.effect.update()) {
                            this.setBallState((byte)2);
                        }
                    } else if (this.ballState == 2 && this.ballActor.isEndFrame()) {
                        if (this.seizeFlag) {
                            this.setBallState((byte)3);
                        } else {
                            this.setBallState((byte)4);
                        }
                    } else if (this.ballState == 3 && this.ballActor.isEndFrame()) {
                        byte temp = gamePlayer.canAddPet();
                        if (temp == 0) {
                            this._gui._ui_layer = 1;
                            this._gui.boxItemTips("\u6210\u529f\u6355\u83b7#2" + CWACommon.STR(CWADataManager.DataBase[0][((GamePet)this.actorPet.target).getPetId()][0]));
                            gamePlayer.addPokPet(((GamePet)this.actorPet.target).getBaseData());
                        } else if (temp == 1) {
                            this._gui._ui_layer = 2;
                            this._gui.boxItemTips("\u6210\u529f\u6355\u83b7#2" + CWACommon.STR(CWADataManager.DataBase[0][((GamePet)this.actorPet.target).getPetId()][0]));
                            gamePlayer.addBankPet(((GamePet)this.actorPet.target).getBaseData());
                        } else {
                            this._gui._ui_layer = 1;
                            this._gui.boxItemTips("\u6ca1\u6709\u7a7a\u95f4\uff0c\u6b64\u5ba0\u5df2\u653e\u751f");
                        }
                    } else if (this.ballState == 4 && this.ballActor.isEndFrame() && !this.effect.update()) {
                        this.effect = null;
                        this.gamePet[0].setVisible(true);
                        this.ballActor.stop();
                        this.actorPet.cActor = true;
                        if (this.seizeFlag) {
                            this._gui.boxItemTips("\u80cc\u5305\u548c\u94f6\u884c\u5df2\u6ee1");
                            this._gui._ui_layer = 3;
                        } else {
                            this.petNext = (byte)(this.petNext + 1);
                            this.setState((byte)1);
                        }
                    }
                    this.ballActor.updateAction();
                    break;
                }
                if (this._gui.isCloseItemTips()) {
                    if (this._gui._ui_layer == 3) {
                        this._gui._ui_layer = 0;
                        this.actorPet.cActor = true;
                        this.petNext = (byte)(this.petNext + 1);
                        this.setState((byte)1);
                    } else if (this._gui._ui_layer == 2) {
                        this._gui.boxItemTips("\u5ba0\u7269\u80cc\u5305\u5df2\u6ee1,\u5df2\u653e\u5165\u94f6\u884c");
                        this._gui._ui_layer = 4;
                    } else if (this._gui._ui_layer == 4 || this._gui._ui_layer == 1) {
                        this._gui._ui_layer = 0;
                        GameWorld.getInstance()._event.eventBattleResult = (byte)-1;
                        this.updateTeach();
                        GameManager.getInstance().setState((byte)10);
                    }
                }
                this._gui.updateOpenBox();
                break;
            }
            case 16: {
                this._gui.updateBattlePetItem();
                break;
            }
            case 5: {
                this._gui.updateCheckPet();
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                if (!this.isKeyDown(786432)) break;
                this.setState((byte)18);
                break;
            }
            case 6: {
                if (this.isKeyDown(4100)) {
                    if (this.playMode == 1) {
                        this.targetIndex = (byte)(this.targetIndex - 1);
                        if (this.targetIndex <= 0) {
                            this.targetIndex = 0;
                        }
                        this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), true);
                        this._gui.setEnemyBattleUI((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), false);
                        this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
                        this._gui.setBufDebufIcon((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), 0);
                    }
                } else if (this.isKeyDown(8448)) {
                    if (this.playMode == 1) {
                        this.targetIndex = (byte)(this.targetIndex + 1);
                        if (this.targetIndex >= this.actorPet.vTarget.size() - 1) {
                            this.targetIndex = (byte)(this.actorPet.vTarget.size() - 1);
                        }
                        this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), true);
                        this._gui.setEnemyBattleUI((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), false);
                        this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
                        this._gui.setBufDebufIcon((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), 0);
                    }
                } else if (this.isKeyDown(16400)) {
                    if (this.playMode == 1) {
                        this.targetIndex = (byte)(this.targetIndex - 1);
                        if (this.targetIndex <= 0) {
                            this.targetIndex = 0;
                        }
                        this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), true);
                        this._gui.setEnemyBattleUI((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), false);
                        this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
                        this._gui.setBufDebufIcon((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), 0);
                    }
                } else if (this.isKeyDown(32832)) {
                    if (this.playMode == 1) {
                        this.targetIndex = (byte)(this.targetIndex + 1);
                        if (this.targetIndex >= this.actorPet.vTarget.size() - 1) {
                            this.targetIndex = (byte)(this.actorPet.vTarget.size() - 1);
                        }
                        this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), true);
                        this._gui.setEnemyBattleUI((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), false);
                        this._gui.setBattleBane(this.actorPet, (GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
                        this._gui.setBufDebufIcon((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex), 0);
                    }
                } else if (this.isKeyDown(196640)) {
                    this.selectTarget();
                } else if (this.isKeyDown(786432)) {
                    this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), false);
                    this.setState((byte)3);
                }
                this.selectActor[this.gamePet.length].updateAction();
                this.selectActor[this.gamePet.length + 1].updateAction();
                break;
            }
            case 21: {
                this._gui.updatePetBall();
                break;
            }
            case 10: {
                if (!this._gui.msgSwitch() && this.targetMove(this.actorPet, false)) {
                    this._gui.taskTips(GameBattle.STR(CWADataManager.DataBase[0][this.actorPet.getPetId()][0]) + "\u9003\u8dd1\u4e86");
                }
                if (!this._gui.updateTaskTip()) break;
                GameManager.getInstance().setState((byte)10);
                break;
            }
            case 8: {
                this._gui.updateBattleWin();
                break;
            }
            case 22: {
                this._gui.updateLevelUp();
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                this._gui.updateShopBuy((byte)4, (byte)0);
                break;
            }
            case 14: {
                break;
            }
            case 23: {
                this._gui.updateLearnSkill();
                break;
            }
            case 24: {
                this._gui.updateBattleRevive();
                break;
            }
            case 101: 
            case 102: 
            case 104: {
                this._gui.updateSms();
            }
        }
        for (int i = 0; i < this.gamePet.length; ++i) {
            this.gamePet[i].update();
        }
        this._ui.update();
    }

    public void petRender(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int i = 0; i < this.gamePet.length; ++i) {
            this.gamePet[i].render(g);
        }
    }

    public void petBackRender(Graphics g, boolean select, int x, int y) {
        for (int i = 0; i < this.gamePet.length; ++i) {
            this.selectActor[i].drawSprite(g, x, y);
        }
        if (select) {
            this.selectActor[this.gamePet.length].drawSprite(g, 0, 0);
            if (this.playMode == 1) {
                this.selectActor[this.gamePet.length + 1].drawSprite(g, 0, 0);
            }
        }
    }

    public void setNumIndex(String str, byte numType, int index, int dir, int x, int y, int w, int h) {
        this.imgStr = str;
        this.imgX = x;
        this.imgY = y;
        this.numType = numType;
        this.imgIndex = index;
        this.imgDir = dir;
        this.imgW = w;
        this.imgH = h;
        this.vNumStr.addElement(this.imgStr);
        this.vNumArray.addElement(new int[]{numType, this.imgIndex, this.imgDir, -1, this.imgW, this.imgH});
    }

    public void setNumStr(String str) {
        this.imgStr = str;
    }

    public void floatRender(Graphics g) {
        int offY = 30;
        int offX = 30;
        block4: for (int i = 0; i < this.vNumArray.size(); ++i) {
            int[] vna = (int[])this.vNumArray.elementAt(i);
            String str = (String)this.vNumStr.elementAt(i);
            switch (vna[0]) {
                case 0: {
                    if (vna[2] == 0) {
                        this.drawNum(g, numImg[vna[1]], str, this.imgX + bloodPos[vna[0]][vna[3] * 2] + offX, this.imgY + bloodPos[vna[0]][vna[3] * 2 + 1] - offY, vna[4], vna[5], 1);
                        continue block4;
                    }
                    this.drawNum(g, numImg[vna[1]], str, this.imgX - bloodPos[vna[0]][vna[3] * 2] - offX, this.imgY + bloodPos[vna[0]][vna[3] * 2 + 1] - offY, vna[4], vna[5], 1);
                    continue block4;
                }
                case 1: {
                    if (vna[2] == 0) {
                        CWATools.drawStringBorder(g, str, 16704699, this.imgX - 10, this.imgY + bloodPos[vna[0]][vna[3] * 2 + 1] - offY, 17, 17, this._ui.fonts, 2);
                        continue block4;
                    }
                    CWATools.drawStringBorder(g, str, 16704699, this.imgX + 10, this.imgY + bloodPos[vna[0]][vna[3] * 2 + 1] - offY, 17, 17, this._ui.fonts, 2);
                }
            }
        }
    }

    public void render(Graphics g) {
        if (!this.onListen) {
            return;
        }
        if (this.battleBackGround != null) {
            g.drawImage(this.battleBackGround, 0, 0, 20);
        } else {
            g.setColor(0);
            g.fillRect(0, 0, (int)CWACommon.getWidth(), (int)CWACommon.getHeight());
        }
        switch (this.gamestate) {
            case 0: {
                this.petBackRender(g, false, 0, 0);
                this.petRender(g);
                break;
            }
            case 12: 
            case 13: {
                this.petBackRender(g, false, 0, 0);
                if (this.effect != null) {
                    this.effect.render(g, 0, 0);
                }
                this.petRender(g);
                this.floatRender(g);
                break;
            }
            case 1: 
            case 10: {
                this.petBackRender(g, false, 0, 0);
                this.petRender(g);
                break;
            }
            case 20: {
                this.petBackRender(g, true, 0, 0);
                this.petRender(g);
                break;
            }
            case 2: {
                this.petBackRender(g, false, 0, 0);
                this.petRender(g);
                break;
            }
            case 7: {
                this.petBackRender(g, false, 0, 0);
                if (this.effect != null) {
                    this.effect.render(g, 0, 0);
                }
                this.petRender(g);
                this.floatRender(g);
                break;
            }
            case 15: {
                this.petBackRender(g, false, 0, 0);
                this.petRender(g);
                break;
            }
            case 3: {
                g.setColor(0xFFFFFF);
                break;
            }
            case 4: {
                g.setColor(0xFFFFFF);
                break;
            }
            case 5: {
                g.setColor(0xFFFFFF);
                g.drawString(GameBattle.STR(CWADataManager.DataBase[0][this.getPokPet(this.pokPet[this.petIndex]).getPetId()][0]), GameBattle.getWidth() >> 1, 200, 17);
                break;
            }
            case 17: {
                this.petBackRender(g, false, 0, 0);
                this.petRender(g);
                if (this.effect != null && this.effect.isAction((byte)8)) {
                    this.effect.render(g, 0, 0);
                    this.ballActor.drawSprite(g, 0, 0);
                    break;
                }
                this.ballActor.drawSprite(g, 0, 0);
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                break;
            }
            case 6: {
                if (this.playMode == 1) {
                    this.petBackRender(g, true, 0, 0);
                } else {
                    this.petBackRender(g, false, 0, 0);
                }
                this.petRender(g);
                break;
            }
            case 8: {
                this.selectActor[0].drawSprite(g, 0, 0);
                if (this._gui.expIndex >= battleExp.size()) break;
                ((GamePet)battleExp.elementAt(this._gui.expIndex)).render(g);
                break;
            }
        }
        this._ui.draw(g);
    }

    public void nextActivePet() {
        this.petNext = (byte)(this.petNext + 1);
        if (this.petNext < this.vPet.size()) {
            while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(this.petNext)).canBattle()) {
                this.petNext = (byte)(this.petNext + 1);
                if (this.petNext < this.vPet.size()) continue;
            }
        }
        if (this.petNext >= this.vPet.size()) {
            this.setState((byte)1);
        } else if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
            this.setState((byte)13);
        } else {
            this.setState((byte)20);
        }
    }

    public void roundOver() {
        if (this.petNext >= this.vPet.size()) {
            if (this.cActor) {
                this.petAgileSort();
                this.cActor = false;
            }
            for (int i = 0; i < this.vPet.size(); ++i) {
                ((GamePet)this.vPet.elementAt((int)i)).cActor = false;
            }
            this.petNext = 0;
            while (((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() != 0 || ((GamePet)this.vPet.elementAt(this.petNext)).getActorEnemy() == 0 && !((GamePet)this.vPet.elementAt(this.petNext)).canBattle()) {
                this.petNext = (byte)(this.petNext + 1);
            }
            if (this.bufDebuf((GamePet)this.vPet.elementAt(this.petNext))) {
                this.setState((byte)13);
            } else {
                this.setState((byte)20);
            }
        } else {
            this.setState((byte)1);
        }
    }

    public boolean battleResult() {
        if (this.calAttack()) {
            this.effectIndex = 0;
            this.curEffectIndex = 0;
            int result = -1;
            int i = 0;
            for (i = 0; i < this.pokPet.length && !this.getPokPet(this.pokPet[i]).canBattle(); ++i) {
            }
            if (((GamePet)this.actorPet.target).getActorEnemy() == 1 && !((GamePet)this.actorPet.target).canBattle() || this.actorPet.getActorEnemy() == 1 && !this.actorPet.canBattle()) {
                ((GamePet)this.actorPet.target).removeAllDebuf();
                ((GamePet)this.actorPet.target).removeAllbuf();
                this._gui.setBufDebufIcon((GamePet)this.actorPet.target, 12);
                this.calExp((GamePet)this.actorPet.target);
                this.enemyIndex[1] = (byte)(this.enemyIndex[1] + 1);
            } else if (((GamePet)this.actorPet.target).getActorEnemy() == 0 && !((GamePet)this.actorPet.target).canBattle() || this.actorPet.getActorEnemy() == 0 && !this.actorPet.canBattle()) {
                ((GamePet)this.actorPet.target).removeAllDebuf();
                ((GamePet)this.actorPet.target).removeAllbuf();
                this._gui.setMyBufDebufIcon((GamePet)this.actorPet.target, 12);
                battlePet.removeElement((GamePet)this.actorPet.target);
                battleExp.removeElement((GamePet)this.actorPet.target);
                ((GamePet)this.actorPet.target).addExp = 0;
                ((GamePet)this.actorPet.target).setBattle(false);
                ((GamePet)this.actorPet.target).battleProp = 0;
            }
            result = i >= this.pokPet.length ? 2 : (this.enemyIndex[1] >= this.enemy.length ? 1 : 0);
            switch (result) {
                case 0: {
                    boolean next = false;
                    if (!((GamePet)this.actorPet.target).canBattle() || !this.actorPet.canBattle()) {
                        for (int j = 0; j < this.gamePet.length; ++j) {
                            if (!this.gamePet[j].findBuf(11) || !this.gamePet[this.gamePet[j].bufArr[11][1]].equals((GamePet)this.actorPet.target)) continue;
                            this.gamePet[j].removeBuf(11);
                        }
                        if (((GamePet)this.actorPet.target).getActorEnemy() == 1 && !((GamePet)this.actorPet.target).canBattle() || this.actorPet.getActorEnemy() == 1 && !this.actorPet.canBattle()) {
                            if (this.enemyIndex[0] < this.enemy.length) {
                                this.changePos = this.actorPet.getActorEnemy() == 1 && !this.actorPet.canBattle() ? this.petPos[this.petNext] : this.actorPet.hurtPos;
                                this.initEnemyPet(this.changePos);
                                this.setState((byte)15);
                            } else {
                                next = true;
                            }
                        } else if (this.isHavePet()) {
                            this.changePos = this.actorPet.getActorEnemy() == 0 && !this.actorPet.canBattle() ? this.petPos[this.petNext] : this.actorPet.hurtPos;
                            this.setState((byte)5);
                        } else {
                            next = true;
                        }
                    } else {
                        next = true;
                    }
                    if (!next) break;
                    if (this.actorPet.findBuf(12) && this.actorPet.value[12] == 2) {
                        this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                        if (!((GamePet)this.actorPet.target).canBattle()) {
                            this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                            this.petNext = (byte)(this.petNext + 1);
                            this.roundOver();
                            break;
                        }
                        this.setState((byte)2);
                        break;
                    }
                    int random = CWATools.getRandom(100);
                    if ((this.actorPet.curSkillId == 63 || this.actorPet.curSkillId == 69) && random <= CWADataManager.DataBase[1][this.actorPet.curSkillId][8]) {
                        if (!((GamePet)this.actorPet.target).canBattle()) {
                            this.actorPet.value[12] = (short)(this.actorPet.value[12] - 1);
                            this.petNext = (byte)(this.petNext + 1);
                            this.roundOver();
                            break;
                        }
                        this.setState((byte)2);
                        break;
                    }
                    this.petNext = (byte)(this.petNext + 1);
                    this.roundOver();
                    break;
                }
                case 1: {
                    this.addExp();
                    this.setState((byte)8);
                    break;
                }
                case 2: {
                    this.setState((byte)9);
                }
            }
            if (gamePlayer.getPokBadgeValue((byte)5, (byte)0) == 2 && gamePlayer.getPokBadgeValue((byte)5, (byte)1) == 1) {
                for (int j = 0; j < this.gamePet.length; ++j) {
                    if (this.gamePet[i].getActorEnemy() != 0 || !this.gamePet[i].canBattle()) continue;
                    this.gamePet[i].chCurProp();
                }
            }
            return true;
        }
        return false;
    }

    public void battleLose() {
        if (GameWorld.getInstance()._event.eventSms) {
            this.setState((byte)24);
        } else {
            for (int i = 0; i < GameBattle.gamePlayer.pokPetSize; ++i) {
                GameBattle.gamePlayer.pokPet[i].addHp(1);
                GameBattle.gamePlayer.pokPet[i].setPreHp(1);
                GameBattle.gamePlayer.pokPet[i].start();
            }
            GameManager.getInstance().setState((byte)10);
        }
        GameWorld.getInstance()._event.eventBattleResult = 1;
        GameWorld.getInstance()._event.eventSms = true;
    }

    public boolean bufDebuf(GamePet target) {
        return target.getBufDebufNum(0) > 0 || target.getBufDebufNum(1) > 0;
    }

    public boolean canHarm() {
        return this.actorPet.getActorEnemy() != ((GamePet)this.actorPet.target).getActorEnemy() || this.actorPet.findDebuf(8);
    }

    public int getRandSkill(GamePet actor) {
        byte id = actor.curSkill[0];
        int[] rand = new int[]{50, 20, 15, 10, 5, 5, 5, 5, 5, 5};
        int rd = CWATools.getRandom(100);
        for (int i = 0; i < actor.curSkill.length; ++i) {
            if (actor.curSkill[i] == -1 || actor.skillPro[i] <= 0 || rd >= rand[i]) continue;
            id = actor.curSkill[i];
        }
        return id;
    }

    public void selectTarget(byte skId) {
        this.actorPet.vTarget.removeAllElements();
        this.actorPet.pTarget.removeAllElements();
        switch (this.actorPet.getSkillPro(skId, (byte)9)) {
            case 1: {
                for (int i = 0; i < this.gamePet.length; ++i) {
                    if (this.gamePet[i].getActorEnemy() != this.actorPet.getActorEnemy() || !this.gamePet[i].canBattle()) continue;
                    this.actorPet.vTarget.addElement(this.gamePet[i]);
                    this.actorPet.pTarget.addElement("" + i);
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.gamePet.length; ++i) {
                    if (this.gamePet[i].getActorEnemy() == this.actorPet.getActorEnemy() || !this.gamePet[i].canBattle()) continue;
                    this.actorPet.vTarget.addElement(this.gamePet[i]);
                    this.actorPet.pTarget.addElement("" + i);
                }
                break;
            }
        }
    }

    public void selectTarget(GamePet actorPet) {
        actorPet.vTarget.removeAllElements();
        actorPet.pTarget.removeAllElements();
        for (int i = 0; i < this.gamePet.length; ++i) {
            if (!this.gamePet[i].canBattle() || this.gamePet[i].equals(actorPet)) continue;
            actorPet.vTarget.addElement(this.gamePet[i]);
            actorPet.pTarget.addElement("" + i);
        }
    }

    public void selectTarget() {
        this.actorPet.setTarget((GamePet)this.actorPet.vTarget.elementAt(this.targetIndex));
        this.actorPet.hurtPos = Byte.parseByte((String)this.actorPet.pTarget.elementAt(this.targetIndex));
        this.actorPet.setUseSkillId(((GamePet)this.vPet.elementAt((int)this.petNext)).curSkill[this._gui.skillIndex]);
        this.setSelectBackPos(Integer.parseInt((String)this.actorPet.pTarget.elementAt(this.targetIndex)), false);
        this.nextActivePet();
    }

    public int isChangePet(GamePet pet) {
        if (!pet.canBattle()) {
            if (pet.getActorEnemy() == 0) {
                if (this.isHavePet()) {
                    return 1;
                }
            } else if (this.enemyIndex[0] < this.enemy.length) {
                return 2;
            }
        }
        return 0;
    }

    public boolean isHavePet() {
        if (MainCanvas.yy) {
            return false;
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < GameBattle.gamePlayer.pokPetSize; ++i) {
            if (!this.getPokPet(i).canBattle() || this.getPokPet(i).isBattle()) continue;
            ++n;
        }
        if (n >= 1) {
            return true;
        }
        return bl;
    }

    public void changePet(int index, int petIndex) {
        byte tempPet = this.pokPet[petIndex];
        this.pokPet[petIndex] = this.pokPet[index];
        this.pokPet[index] = tempPet;
    }

    public int changePet(int petIndex) {
        int i;
        if (!this.getPokPet(this.pokPet[petIndex]).canBattle()) {
            return 0;
        }
        if (this.getPokPet(this.pokPet[petIndex]).isBattle()) {
            return 1;
        }
        byte tempPet = this.pokPet[petIndex];
        for (i = petIndex - 1; i >= 0; --i) {
            this.pokPet[i + 1] = this.pokPet[i];
        }
        this.pokPet[0] = tempPet;
        i = 0;
        for (i = 0; i < battlePet.size() && !battlePet.elementAt(i).equals(this.getPokPet(this.pokPet[0])); ++i) {
        }
        if (i >= battlePet.size()) {
            battlePet.addElement(this.getPokPet(this.pokPet[0]));
        }
        this.getPokPet((int)this.pokPet[0]).cActor = true;
        this.getPokPet(this.pokPet[0]).setBattle(true);
        this.actorPet.setBattle(false);
        this.actorPet.battleProp = 0;
        for (int j = 0; j < this.gamePet.length; ++j) {
            if (!this.gamePet[j].findBuf(11) || !this.gamePet[this.gamePet[j].bufArr[11][1]].equals(this.actorPet)) continue;
            this.gamePet[j].removeBuf(11);
        }
        return -1;
    }

    public void petAgileSort() {
        int i;
        this.vPet.removeAllElements();
        byte temp = 0;
        int flag = -1;
        for (i = 0; i < this.rank.length - 1; ++i) {
            for (int j = i + 1; j < this.rank.length; ++j) {
                if (this.gamePet[i].getProp((byte)4) >= this.gamePet[j].getProp((byte)4)) continue;
                temp = this.rank[i];
                this.rank[i] = this.rank[j];
                this.rank[j] = temp;
            }
        }
        for (i = 0; i < this.rank.length; ++i) {
            if (!this.gamePet[i].isAdornItem((byte)7)) continue;
            flag = i;
            this.rank[i] = 0;
            break;
        }
        if (flag != -1) {
            int i2;
            int index = 1;
            int[] trank = new int[this.rank.length - 1];
            for (i2 = 0; i2 < this.rank.length; ++i2) {
                if (i2 == flag) continue;
                trank[index - 1] = i2;
                this.rank[i2] = (byte)index;
                ++index;
            }
            for (i2 = 0; i2 < trank.length - 1; ++i2) {
                for (int j = i2 + 1; j < trank.length; ++j) {
                    if (this.gamePet[trank[i2]].getProp((byte)4) >= this.gamePet[trank[j]].getProp((byte)4)) continue;
                    temp = this.rank[trank[i2]];
                    this.rank[trank[i2]] = this.rank[trank[j]];
                    this.rank[trank[j]] = temp;
                }
            }
        }
        for (i = 0; i < this.rank.length; ++i) {
            this.petPos[this.rank[i]] = (byte)i;
        }
        for (i = 0; i < this.petPos.length; ++i) {
            this.vPet.addElement(this.gamePet[this.petPos[i]]);
        }
    }

    public void calChange() {
        if (this.actorPet.isAdornItem((byte)10) && ((GamePet)this.actorPet.target).getCurProp((byte)1) <= CWADataManager.DataBase[3][10][5]) {
            ((GamePet)this.actorPet.target).setCurProp((byte)1, CWADataManager.DataBase[3][10][5]);
        }
        if (((GamePet)this.actorPet.target).getCurProp((byte)1) <= 0) {
            ((GamePet)this.actorPet.target).setState((byte)3, (byte)-2, true);
        } else {
            ((GamePet)this.actorPet.target).setState((byte)0, (byte)0, true);
        }
    }

    public boolean targetMove(GamePet pet, boolean isBattle) {
        if (this.battleType == 0 && isBattle) {
            if (pet.spEffect != null && !pet.spEffect.isAction()) {
                return true;
            }
        } else {
            int x = pet.getActorX();
            this.movePos = pet.getActorEnemy() == 0 ? (this.movePos -= 10) : (this.movePos += 10);
            x += this.movePos;
            if (Math.abs(this.movePos) >= 100) {
                pet.stop();
                this.movePos = 0;
                return true;
            }
            pet.setPosition(x, pet.getActorY());
        }
        return false;
    }

    public boolean floatNum() {
        int i;
        for (i = 0; i < this.vNumArray.size(); ++i) {
            int[] vna = (int[])this.vNumArray.elementAt(i);
            vna[3] = vna[3] + 1;
            if (vna[3] < bloodPos[vna[0]].length / 2) continue;
            this.vNumArray.removeElementAt(i);
            this.vNumStr.removeElementAt(i);
            --i;
        }
        return i <= 0;
    }

    public boolean skipSkillEffect() {
        if (this.harmValue != null) {
            if (this.harmValue[2] != -1) {
                return false;
            }
            return this.effectList[this.effectList.length - 1] == this.effectIndex;
        }
        return !this.isAddHp;
    }

    public void setLiveUi() {
        for (int i = 0; i < this.gamePet.length; ++i) {
            if (this.gamePet[i].getActorEnemy() == 1) {
                if (!this.gamePet[i].canBattle()) continue;
                this._gui.setEnemyBattleUI(this.gamePet[i], false);
                this._gui.setBufDebufIcon(this.gamePet[i], 0);
                continue;
            }
            if (!this.gamePet[i].canBattle()) continue;
            this._gui.setMyBattleUI(this.gamePet[i], false, 13);
            this._gui.setMyBufDebufIcon(this.gamePet[i], 0);
        }
    }

    public boolean calTarget() {
        if (CWADataManager.DataBase[1][this.actorPet.curSkillId][3] == 0) {
            this._gui.bufIndex = 0;
            if (((GamePet)this.actorPet.target).getActorEnemy() == 0) {
                this._gui.setMyBufDebufIcon((GamePet)this.actorPet.target, 1);
            } else {
                this._gui.setBufDebufIcon((GamePet)this.actorPet.target, 1);
            }
            ((GamePet)this.actorPet.target).setState((byte)0, (byte)0, true);
            return true;
        }
        if (((GamePet)this.actorPet.target).getState() == 3) {
            return true;
        }
        if (!this.isCal) {
            int hitRate = 0;
            int actorLevel = this.actorPet.getLevel();
            if (this.actorPet.getActorEnemy() == 0 && gamePlayer.getPokBadgeValue((byte)4, (byte)0) == 2 && gamePlayer.getPokBadgeValue((byte)4, (byte)1) == 1) {
                actorLevel += CWADataManager.DataBase[2][4][6];
            }
            hitRate = this.actorPet.findBuf(4) ? (((GamePet)this.actorPet.target).getLevel() - (actorLevel - this.actorPet.debufArr[4][1])) * 2 : (((GamePet)this.actorPet.target).getLevel() - actorLevel) * 2;
            if (this.actorPet.isAdornItem((byte)9)) {
                hitRate = 0;
            }
            if (hitRate <= 0) {
                hitRate = 0;
            } else if (hitRate >= 20) {
                hitRate = 20;
            }
            int rand = CWATools.getRandom(100);
            if (rand >= hitRate) {
                ((GamePet)this.actorPet.target).hurt(this.harmValue[0]);
                if (this.actorPet.isAdornItem((byte)10) && ((GamePet)this.actorPet.target).getCurProp((byte)1) <= CWADataManager.DataBase[3][10][5]) {
                    ((GamePet)this.actorPet.target).setCurProp((byte)1, CWADataManager.DataBase[3][10][5]);
                }
                if (this.harmValue[1] == 1) {
                    this.setNumIndex("-" + this.harmValue[0], (byte)0, 1, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 15, 19);
                } else {
                    this.setNumIndex("-" + this.harmValue[0], (byte)0, 0, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 9, 12);
                }
                if (this.harmValue[2] != -1) {
                    this.setNumIndex(CWACommon.STR(CWADataManager.DataBase[7][this.harmValue[2]][0]), (byte)1, 0, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 9, 12);
                }
            } else {
                this.setNumIndex("\u95ea\u907f", (byte)1, 0, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 9, 12);
            }
            this.isCal = true;
            this._gui.bufIndex = 0;
            if (((GamePet)this.actorPet.target).getActorEnemy() == 0) {
                this._gui.setMyBufDebufIcon((GamePet)this.actorPet.target, 1);
            } else {
                this._gui.setBufDebufIcon((GamePet)this.actorPet.target, 1);
            }
        }
        boolean fn = this.floatNum();
        if (((GamePet)this.actorPet.target).getActorEnemy() == 0) {
            if (this._gui.setMyBattleUI((GamePet)this.actorPet.target, false, 7) && fn) {
                this.calChange();
                this.isCal = false;
                return true;
            }
        } else if (this._gui.setEnemyBattleUI((GamePet)this.actorPet.target, false) && fn) {
            this.calChange();
            this.isCal = false;
            return true;
        }
        return false;
    }

    public boolean setAttackUI(GamePet pet, boolean fn, int preHp) {
        if (pet.getActorEnemy() == 0) {
            if (preHp < pet.getCurProp((byte)1)) {
                if (this._gui.setMyBattleUI(pet, true, 8) && fn) {
                    this.isCal = false;
                    return true;
                }
            } else if (this._gui.setMyBattleUI(pet, false, 9) && fn) {
                this.isCal = false;
                return true;
            }
        } else if (preHp < pet.getCurProp((byte)1)) {
            if (this._gui.setEnemyBattleUI(pet, true) && fn) {
                this.isCal = false;
                return true;
            }
        } else if (this._gui.setEnemyBattleUI(pet, false) && fn) {
            this.isCal = false;
            return true;
        }
        return false;
    }

    public boolean calAttack() {
        if (!this.isCal) {
            short addHp = 0;
            this.preHp = CWADataManager.DataBase[1][this.actorPet.curSkillId][9] == 0 ? this.actorPet.getPreHp() : ((GamePet)this.actorPet.target).getPreHp();
            byte skillId = this.actorPet.curSkillId;
            switch (skillId) {
                case 11: 
                case 17: {
                    addHp = (short)(this.actorPet.getAttack() * CWADataManager.DataBase[1][skillId][8] / 100);
                    this.actorPet.setPreHp(this.actorPet.getCurProp((byte)1));
                    if (addHp <= 0) {
                        addHp = 1;
                    }
                    this.actorPet.addHp(addHp);
                    break;
                }
                case 21: 
                case 27: 
                case 42: 
                case 48: 
                case 62: 
                case 68: {
                    this.actorPet.addBuf((byte)CWADataManager.DataBase[1][skillId][7], -1, skillId);
                    break;
                }
                case 52: 
                case 58: {
                    if (this.isAddHp) {
                        addHp = (short)(this.harmValue[0] * CWADataManager.DataBase[1][skillId][8] / 100);
                        this.actorPet.setPreHp(this.actorPet.getCurProp((byte)1));
                        this.actorPet.addHp(this.harmValue[0] * CWADataManager.DataBase[1][skillId][8] / 100);
                    }
                }
                case 64: {
                    this.actorPet.addBuf((byte)CWADataManager.DataBase[1][skillId][7], this.actorPet.hurtPos, skillId);
                    break;
                }
                default: {
                    if (CWADataManager.DataBase[1][skillId][6] != 1) break;
                    addHp = (short)((GamePet)this.actorPet.target).addBuf((byte)CWADataManager.DataBase[1][skillId][7], -1, skillId);
                }
            }
            byte buf = (byte)CWADataManager.DataBase[1][skillId][6];
            if (CWADataManager.DataBase[1][this.actorPet.curSkillId][9] == 0) {
                int harm;
                int rand;
                if (this.actorPet.isAdornItem((byte)8) && (rand = CWATools.getRandom(100)) <= CWADataManager.DataBase[3][8][5]) {
                    this.actorPet.setPreHp(this.actorPet.getCurProp((byte)1));
                    this.actorPet.addHp((short)(this.harmValue[0] * CWADataManager.DataBase[3][8][6] / 100));
                }
                if (((GamePet)this.actorPet.target).findBuf(2)) {
                    harm = this.harmValue[0] * ((GamePet)this.actorPet.target).bufArr[2][2] / 100;
                    this.actorPet.hurt(harm);
                }
                if (((GamePet)this.actorPet.target).findBuf(5) && (harm = this.actorPet.value[5]) > 0) {
                    this.actorPet.hurt(harm);
                    this.actorPet.value[5] = 0;
                }
                if (this.actorPet.getCurProp((byte)1) < this.preHp) {
                    this.setNumIndex("" + (this.actorPet.getCurProp((byte)1) - this.preHp), (byte)0, 0, this.actorPet.getActorEnemy(), this.actorPet.getActorX(), this.actorPet.getActorY(), 9, 12);
                } else if (addHp > 0) {
                    this.setNumIndex("+" + addHp, (byte)0, 2, this.actorPet.getActorEnemy(), this.actorPet.getActorX(), this.actorPet.getActorY(), 9, 12);
                }
            } else if (addHp > 0) {
                this.setNumIndex("+" + addHp, (byte)0, 2, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 9, 12);
            }
            if (buf == 1) {
                short bufId = CWADataManager.DataBase[1][skillId][7];
                switch (skillId) {
                    case 21: 
                    case 27: 
                    case 42: 
                    case 48: 
                    case 62: 
                    case 64: 
                    case 68: {
                        this.setNumIndex(CWACommon.STR(CWADataManager.DataBase[6][bufId][0]), (byte)1, 2, this.actorPet.getActorEnemy(), this.actorPet.getActorX(), this.actorPet.getActorY(), 9, 12);
                        break;
                    }
                    default: {
                        this.setNumIndex(CWACommon.STR(CWADataManager.DataBase[6][bufId][0]), (byte)1, 2, ((GamePet)this.actorPet.target).getActorEnemy(), ((GamePet)this.actorPet.target).getActorX(), ((GamePet)this.actorPet.target).getActorY(), 9, 12);
                    }
                }
            }
            if (CWADataManager.DataBase[1][this.actorPet.curSkillId][9] == 0) {
                this._gui.bufIndex = 0;
                if (this.actorPet.getActorEnemy() == 0) {
                    this._gui.setMyBufDebufIcon(this.actorPet, 2);
                } else {
                    this._gui.setBufDebufIcon(this.actorPet, 2);
                }
            } else {
                this._gui.bufIndex = 0;
                if (((GamePet)this.actorPet.target).getActorEnemy() == 0) {
                    this._gui.setMyBufDebufIcon((GamePet)this.actorPet.target, 3);
                } else {
                    this._gui.setBufDebufIcon((GamePet)this.actorPet.target, 3);
                }
            }
            this.isCal = true;
        }
        boolean fn = this.floatNum();
        if (((GamePet)this.actorPet.target).getActorEnemy() != this.actorPet.getActorEnemy() || this.actorPet.findDebuf(9)) {
            return this.setAttackUI(this.actorPet, fn, this.preHp);
        }
        return this.setAttackUI((GamePet)this.actorPet.target, fn, this.preHp);
    }

    public void addExp() {
        int i;
        for (i = 0; i < battleExp.size(); ++i) {
            if (((GamePet)battleExp.elementAt(i)).canBattle()) {
                ((GamePet)battleExp.elementAt(i)).addExp(((GamePet)GameBattle.battleExp.elementAt((int)i)).addExp);
                ((GamePet)GameBattle.battleExp.elementAt((int)i)).addExp = 0;
                ((GamePet)battleExp.elementAt(i)).setBattle(false);
                continue;
            }
            battleExp.removeElementAt(i);
            --i;
        }
        if (gamePlayer.getPokBadgeValue((byte)0, (byte)0) == 2 && gamePlayer.getPokBadgeValue((byte)0, (byte)1) == 1) {
            for (i = 0; i < GameBattle.gamePlayer.pokPetSize; ++i) {
                if (!GameBattle.gamePlayer.pokPet[i].canBattle()) continue;
                GameBattle.gamePlayer.pokPet[i].setPreHp(GameBattle.gamePlayer.pokPet[i].getCurProp((byte)1) + CWADataManager.DataBase[0][GameBattle.gamePlayer.pokPet[i].getPetId()][5] * CWADataManager.DataBase[2][0][6] / 100);
                GameBattle.gamePlayer.pokPet[i].addHp(CWADataManager.DataBase[0][GameBattle.gamePlayer.pokPet[i].getPetId()][5] * CWADataManager.DataBase[2][0][6] / 100);
            }
        }
    }

    public void calExp(GamePet target) {
        int i;
        int enemyLevel = target.getLevel();
        int enemyExp = (2 * enemyLevel * enemyLevel + 50) * this.enemyQu[target.getProp((byte)0) - 1] / 10 + 400;
        int shareNum = battlePet.size();
        int[] temp = new int[shareNum];
        GamePet pet = null;
        byte reduceExp = 0;
        int tempExp = 0;
        for (i = 0; i < shareNum; ++i) {
            pet = (GamePet)battlePet.elementAt(i);
            if (pet.getLevel() - enemyLevel >= 6) {
                reduceExp = this.expReduce[6];
            } else if (pet.getLevel() - enemyLevel >= 1) {
                reduceExp = this.expReduce[pet.getLevel() - enemyLevel];
            } else if (pet.getLevel() == enemyLevel) {
                reduceExp = this.expReduce[1];
            } else if (pet.getLevel() < enemyLevel) {
                reduceExp = this.expReduce[0];
            }
            tempExp = enemyExp / shareNum * this.awardParty[shareNum - 1] * reduceExp / 1000;
            if (pet.isAdornItem((byte)5)) {
                tempExp = tempExp * (CWADataManager.DataBase[3][5][5] + 100) / 100;
            }
            pet.addExp += tempExp;
            temp[i] = tempExp;
            if (battleExp.contains(pet)) continue;
            battleExp.addElement(pet);
        }
        for (i = 0; i < GameBattle.gamePlayer.pokPetSize; ++i) {
            if (!this.getPokPet(i).canBattle() || battlePet.contains(this.getPokPet(i))) continue;
            if (gamePlayer.getPokBadgeValue((byte)7, (byte)0) == 2) {
                if (pet.getLevel() - enemyLevel >= 6) {
                    reduceExp = this.expReduce[6];
                } else if (pet.getLevel() - enemyLevel >= 1) {
                    reduceExp = this.expReduce[pet.getLevel() - enemyLevel];
                } else if (pet.getLevel() == enemyLevel) {
                    reduceExp = this.expReduce[1];
                } else if (pet.getLevel() < enemyLevel) {
                    reduceExp = this.expReduce[0];
                }
                tempExp = enemyExp / shareNum * this.awardParty[shareNum - 1] * reduceExp / 3000;
                this.getPokPet((int)i).addExp += tempExp;
                this.getPokPet(i).start();
                if (battleExp.contains(this.getPokPet(i))) continue;
                battleExp.addElement(this.getPokPet(i));
                continue;
            }
            if (!this.getPokPet(i).isAdornItem((byte)6)) continue;
            if (pet.getLevel() - enemyLevel >= 6) {
                reduceExp = this.expReduce[6];
            } else if (pet.getLevel() - enemyLevel >= 1) {
                reduceExp = this.expReduce[pet.getLevel() - enemyLevel];
            } else if (pet.getLevel() == enemyLevel) {
                reduceExp = this.expReduce[1];
            } else if (pet.getLevel() < enemyLevel) {
                reduceExp = this.expReduce[0];
            }
            tempExp = enemyExp / shareNum * this.awardParty[shareNum - 1] * reduceExp / 1000;
            this.getPokPet((int)i).addExp += tempExp;
            this.getPokPet(i).start();
            if (battleExp.contains(this.getPokPet(i))) continue;
            battleExp.addElement(this.getPokPet(i));
        }
        GamePet tempPet = null;
        for (int j = 0; j < battlePet.size(); ++j) {
            tempPet = (GamePet)battlePet.elementAt(j);
            if (tempPet.isBattle()) continue;
            battlePet.removeElement(tempPet);
        }
        if (gamePlayer.isUserPokSpecial(0)) {
            if (GameBattle.gamePlayer.hatchPetNum == 0) {
                if (pet.getLevel() >= 30 && ++GameWorld.eggExp >= 10) {
                    GameWorld.eggExp = 10;
                }
            } else if (pet.getLevel() >= 40 && ++GameWorld.eggExp >= 30) {
                GameWorld.eggExp = 30;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int calSeizeRate(int n, int n2) {
        void var4_18;
        byte by;
        byte[] byArray;
        void var4_13;
        void var4_8;
        short s;
        if (n == 0) {
            return 100;
        }
        int n3 = 0;
        if (((GamePet)this.actorPet.target).findBuf(1)) {
            n3 = 1;
        }
        if (((GamePet)this.actorPet.target).findBuf(2)) {
            n3 = 2;
        }
        if (((GamePet)this.actorPet.target).findBuf(10)) {
            n3 = 3;
        }
        if (this.actorPet.isAdornItem((byte)11)) {
            n3 = 4;
        }
        int by2 = 1;
        short s2 = ((GamePet)this.actorPet.target).getCurProp((byte)1);
        if (s2 <= (s = ((GamePet)this.actorPet.target).getProp((byte)1)) * 15 / 100) {
            int n4 = by2 * 85;
        } else if (s2 <= s * 50 / 100) {
            int n5 = by2 * 45;
        } else if (s2 <= s) {
            int n6 = by2 * 20;
        }
        void var4_10 = var4_8 * CWADataManager.DataBase[4][n][6];
        var4_10 = var4_10 / 100;
        int[] nArray = new int[]{110, 100, 95, 80, 70};
        void var4_11 = var4_10 * nArray[((GamePet)this.actorPet.target).getProp((byte)0) - 1] / 100;
        int[] nArray2 = new int[]{10, 11, 12, 12, 12};
        void var4_12 = var4_11 * nArray2[n3] / 10;
        if (this.actorPet.isAdornItem((byte)11)) {
            var4_13 = var4_12 * (100 + CWADataManager.DataBase[3][11][5]) / 100;
        }
        int[] nArray3 = new int[]{1000, 500, 1, 1000};
        void var4_14 = var4_13 * nArray3[CWADataManager.DataBase[0][((GamePet)this.actorPet.target).getPetId()][22]] / 1000;
        if (((GamePet)this.actorPet.target).getLevel() >= 20 && var4_14 >= (byArray = new byte[]{0, 15, 35, 65})[n]) {
            by = byArray[n];
        }
        if (by >= 100) {
            int n7 = 100;
        } else if (by <= 0) {
            boolean bl = true;
        }
        return (int)(var4_18 * false + 100);
    }

    public GamePet getPokPet(int petIndex) {
        if (petIndex > this.pokPet.length - 1) {
            return null;
        }
        return GameBattle.gamePlayer.pokPet[petIndex];
    }

    public GamePet getBattlePokPet(int petIndex) {
        if (petIndex > this.pokPet.length - 1) {
            return null;
        }
        return GameBattle.gamePlayer.pokPet[this.pokPet[petIndex]];
    }

    public void setEnemy(int[][] data) {
        this.enemy = data;
    }

    public int getEnemyNum() {
        return this.enemy.length;
    }

    public int getEnemyId(int en) {
        return this.enemy[en][0];
    }

    public void updateTeach() {
        switch (teachId) {
            case 0: {
                if (teachStep == 0) {
                    if (this.actorPet == null) break;
                    int leftHp = this.gamePet[0].getProp((byte)1) * 50 / 100;
                    if (this.gamePet[0].getCurProp((byte)1) > leftHp) break;
                    GameBattle.setTeachKey(0, 1);
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u5f25\u52d2\u5154\u5154\u5df2\u7ecf\u53d7\u4f24\uff0c\u5feb\u4f7f\u7528#2\u5c01\u5370\u7403#1\u8fdb\u884c\u6355\u83b7\u5427");
                    break;
                }
                if (teachStep == 1) {
                    if (!this._gui.isCloseTaskTips()) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui._ui_index_0 = 1;
                    GameBattle.setTeachKey(2, 1);
                    GameBattle.setTeachKey(1, 1);
                    this._gui.initBattleSelect();
                    this._gui.taskTips("\u8bf7\u6309#25\u952e");
                    break;
                }
                if (teachStep == 3) {
                    teachStep = (byte)(teachStep + 1);
                    GameBattle.setTeachKey(2, 0);
                    GameBattle.setTeachKey(1, 1);
                    this._gui.taskTips("\u8bf7\u9009\u62e9\u5c01\u5370\u7403");
                    break;
                }
                if (teachStep == 5) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u592a\u53ef\u60dc\u4e86\uff0c\u7528\u66f4\u597d\u7684#2\u5fc5\u4e2d\u7403#1\u8bd5\u8bd5");
                    break;
                }
                if (teachStep == 6) {
                    if (!this._gui.isCloseTaskTips()) break;
                    GameBattle.setTeachKey(1, 0);
                    this._gui._ui_index_0 = 1;
                    this._gui.initBattleSelect();
                    this._gui._ui_index_1 = 0;
                    teachStep = (byte)(teachStep + 1);
                    this.setState((byte)21);
                    break;
                }
                if (teachStep != 8) break;
                GameBattle.setTeachKey(1, -1);
                GameBattle.setTeachKey(0, 0);
                teachId = (byte)-1;
                teachStep = 0;
                break;
            }
            case 2: {
                if (teachStep == 0) {
                    GameBattle.setTeachKey(0, 0);
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8d76\u7d27\u9009\u62e9#2\u5fc5\u4e2d\u7403#1\u8fdb\u884c\u6355\u5ba0\u5427");
                    break;
                }
                if (teachStep != 2) break;
                if (this.actorPet != null) {
                    int leftHp = this.gamePet[0].getProp((byte)1) * 50 / 100 + 2;
                    if (this.gamePet[0].getCurProp((byte)1) <= leftHp) {
                        teachStep = (byte)(teachStep - 1);
                        this._gui.taskTips("\u9009\u62e9#2\u5fc5\u4e2d\u7403#1\u8fdb\u884c\u6355\u5ba0\u5427");
                    }
                }
                if (gamePlayer.getPokPetMapValue((byte)1, 29) != 2) break;
                teachId = (byte)-1;
                teachStep = 0;
                break;
            }
            case 5: {
                if (teachStep != 0) break;
                this._gui._ui_index_0 = 1;
                teachStep = (byte)(teachStep + 1);
                this._gui.initBattleSelect();
                this._gui.taskTips("\u8d76\u7d27\u9009\u62e9#2\u5fc5\u4e2d\u7403#1\u8fdb\u884c\u6355\u5ba0\u5427");
            }
        }
    }

    public void keyTeach() {
        switch (teachId) {
            case 0: {
                if (teachStep != 2 && teachStep != 4 && teachStep != 7) break;
                teachStep = (byte)(teachStep + 1);
                break;
            }
            case 5: {
                if (teachStep == 1) {
                    teachStep = (byte)(teachStep + 1);
                    GameBattle.setTeachKey(1, 0);
                    GameBattle.setTeachKey(0, 1);
                    break;
                }
                if (teachStep != 2) break;
                GameBattle.setTeachKey(0, 0);
                teachId = (byte)-1;
                teachStep = 0;
            }
        }
    }

    static {
        ballId = 0;
    }
}

