/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWADebug;
import CWA2DAPI.cwaEX.CWAImageARGB;
import CWA2DAPI.cwaEX.CWAScreenChange;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAImageManager;
import CWA2DAPI.cwabase2d.CWAMap;
import CWA2DAPI.cwabase2d.CWASpDataManager;
import CWAUI.CWAUIManager;
import game.GameBattle;
import game.GameMenu;
import game.GamePlayer;
import game.GameUI;
import game.GameWorld;
import game.MainCanvas;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class GameManager
extends CWACommon
implements CWAGlobal {
    private static GameManager _mgr = null;
    private byte _gameState;
    private byte _preState;
    private int _GMCount;
    private Image _img;
    public CWACommon game;
    public static byte loadState;
    public static int loadCount;
    public static int loadAdd;
    public static int curCanCount;
    private static final int loadMax = 148;
    private static Timer _timer;
    private static TimerTask _task;
    private String[] tipStr = new String[]{"\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot", "\u4efb\u52a1BUG\u4fee\u590dby-onihot"};
    private String[] wharfTip = new String[]{"\u8239\u8d8a\u884c\u8d8a\u8fdc", "\u5212\u554a\u5212\u554a\u3002\u3002", "\u8239\u79bb\u76ee\u7684\u5730\u8d8a\u6765\u8d8a\u8fd1", "\u5c0f\u8239\u98de\u901f\u884c\u9a76\u4e2d\u3002\u3002"};
    public long begainTime = 0L;
    public long curTime = 0L;
    public long endTime = 0L;
    public long totalGTime = 0L;
    public long curGTime = 0L;
    public long startGTime = 0L;
    boolean isStop = false;
    CWAImageARGB imgArgb = null;
    public int step = 0;
    String tip = "";
    public byte volume = 0;
    private Player _theme;
    private VolumeControl _volumeControl;
    private static String musicStr;

    public static GameManager getInstance() {
        if (_mgr == null) {
            _mgr = new GameManager();
            musicStr = "0";
        }
        return _mgr;
    }

    public void onListen(boolean b) {
        if (b) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void start() {
        this.startGTime = System.currentTimeMillis();
        this.setState((byte)3);
        super.onListen(true);
    }

    public void stop() {
        this.setState((byte)1);
        super.onListen(false);
    }

    public void setState(byte state) {
        if (state >= 24) {
            return;
        }
        this._preState = this._gameState;
        switch (this._gameState) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 16: {
                break;
            }
            case 15: {
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                GameWorld.loadCount = 0;
            }
            case 22: 
            case 23: {
                loadState = 0;
                loadCount = 0;
                break;
            }
            case 10: {
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 3: {
                CWAScreenChange.getInstance().screenType = -1;
            }
        }
        this._gameState = state;
        switch (state) {
            case 21: {
                CWAScreenChange.getInstance().init(0, 18);
                CWAScreenChange.getInstance().setMenuCartoon();
                break;
            }
            case 6: {
                this._img = CWATools.createImage("/data/img/", "img_831");
            }
            case 3: {
                CWAScreenChange.getInstance().init(0, 19);
                break;
            }
            case 15: {
                this._img = CWATools.loadNormalImg("/data/logo/", "qq");
                break;
            }
            case 12: 
            case 22: {
                this.setloadover(false);
                loadCount = 0;
                break;
            }
            case 23: {
                this.setloadover(false);
                loadCount = 0;
                int index1 = CWATools.getRandom(this.wharfTip.length);
                this.tip = this.wharfTip[index1];
                break;
            }
            case 9: {
                this.setloadover(false);
                loadCount = 0;
                int index = CWATools.getRandom(this.tipStr.length);
                this.tip = this.tipStr[index];
                break;
            }
            case 11: {
                GameWorld.getInstance()._gui.flash = true;
                break;
            }
            case 2: {
                if (GameWorld.getInstance().gameplayer == null) break;
                GameWorld.getInstance().gameplayer.gamePause();
            }
        }
        this._GMCount = 0;
    }

    public void setPreState(byte state) {
        this._preState = state;
    }

    public byte getPreState() {
        return this._preState;
    }

    public byte getState() {
        return this._gameState;
    }

    public void pause() {
        if (this._gameState == 9 || this._gameState == 22 || this._gameState == 23) {
            this.closeMusic();
            this.isStop = true;
            this.clearKey();
        } else if (this._gameState != 2) {
            this.closeMusic();
            this.isStop = true;
            this.setState((byte)2);
            this.clearKey();
        }
    }

    public void pauseStop() {
        if (this._gameState != 2) {
            this.setState((byte)2);
        }
    }

    public void resume() {
        this.startMusic("0");
        this.setState(this._preState);
        this.isStop = false;
        this.clearKey();
    }

    public boolean init() {
        this.loading();
        this._gui = GameUI.getInstance();
        this._ui = CWAUIManager.getInstance();
        this._gui.setGame(this);
        CWAImageManager.init(50000);
        CWASpDataManager.init(1000);
        CWADataManager.init();
        GameManager.setBackColor(0);
        GameManager.getFontSmall();
        Image img = CWATools.createImage("/data/img/", "img_22");
        int[] argb = CWATools.getPixels(img);
        this.imgArgb = new CWAImageARGB();
        this.imgArgb.init(argb, img.getWidth(), img.getHeight());
        img = null;
        GameWorld.getInstance().loadRms();
        this.loadOver();
        return true;
    }

    public void release() {
        if (this.game != null) {
            this.game.release();
            this.game = null;
        }
    }

    public void update() {
        if (!this.onListen) {
            return;
        }
        this.getKey();
        switch (this._gameState) {
            case 3: {
                if (!this.loadover()) {
                    this.init();
                }
                if (!CWAScreenChange.getInstance().isScreenOver || !this.loadover()) break;
                this.setState((byte)6);
                break;
            }
            case 2: {
                if (!this.isKeyDown(262144)) break;
                this.resume();
                break;
            }
            case 4: {
                if (this.isKeyDown(131072)) {
                    this.stop();
                    break;
                }
                if (!this.isKeyDown(262144)) break;
                this.resume();
                break;
            }
            case 16: {
                ++this._GMCount;
                if (this._GMCount < 10) break;
                this._img = null;
                this.setState((byte)6);
                break;
            }
            case 15: {
                ++this._GMCount;
                if (this._GMCount < 10) break;
                this._GMCount = 0;
                this._img = null;
                this._img = CWATools.loadNormalImg("/data/logo/", "cwalogo");
                this.setState((byte)16);
                break;
            }
            case 6: {
                if (this.isKeyDown(131072)) {
                    this.setVolume(2);
                    this.startMusic(musicStr);
                    this.setState((byte)21);
                    break;
                }
                if (!this.isKeyDown(262144)) break;
                this.setVolume(0);
                this.setState((byte)21);
                break;
            }
            case 21: {
                CWAScreenChange.getInstance().update();
                if (CWAScreenChange.getInstance().screenMenu != -1 && (!this.isKeyDown(65568) || !GameMenu.isHaveSms)) break;
                CWAScreenChange.getInstance().screenMenu = -1;
                CWAScreenChange.getInstance().screenOpen = -1;
                CWAScreenChange.getInstance().countOpen = 0;
                CWAScreenChange.getInstance().screenType = -1;
                this._img = null;
                this.imgArgb.release();
                this.imgArgb = null;
                this.setState((byte)7);
                break;
            }
            case 9: 
            case 22: 
            case 23: {
                this.release();
                this.game = GameWorld.getInstance();
                if (this.game.init()) {
                    GameWorld.loadCount = 0;
                    GamePlayer.stepSand = false;
                    this.setState((byte)11);
                    if (this.isStop) {
                        this.pauseStop();
                    }
                    this.setListener(this.game);
                    break;
                }
                this.stop();
                break;
            }
            case 10: {
                this.release();
                this.game = GameWorld.getInstance();
                ((GameWorld)this.game).reback();
                this.setListener(this.game);
                this.setState((byte)11);
                break;
            }
            case 7: {
                this.release();
                this.game = GameMenu.getInstance();
                if (this.game.init()) {
                    this.setListener(this.game);
                    this.setState((byte)8);
                    break;
                }
                this.stop();
                break;
            }
            case 12: {
                if (!this.loadover()) {
                    this.game = null;
                    this.game = GameBattle.getInstance();
                    if (this.game.init()) {
                        this.setListener(this.game);
                        if (((GameBattle)this.game).battleType == 0) {
                            CWAScreenChange.getInstance().init(-2013265920, 6);
                        } else if (((GameBattle)this.game).battleType == 2) {
                            CWAScreenChange.getInstance().init(-2013265920, 8);
                        } else if (((GameBattle)this.game).battleType == 1) {
                            CWAScreenChange.getInstance().init(-2013265920, 7);
                        }
                    } else {
                        this.stop();
                    }
                }
                if (this.loadover()) {
                    CWAScreenChange.getInstance().update();
                    GamePlayer.stepSand = false;
                }
                if (!CWAScreenChange.getInstance().isScreenOver) break;
                ((GameBattle)this.game).initUI();
                this.setState((byte)13);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 20: {
                if (this.game == null) break;
                this.game.update();
            }
        }
        if (GameWorld.getInstance().sceneId == 3 && GameWorld.getInstance().roomId == 7 && this.endTime == 0L && this.begainTime != 0L) {
            this.curTime = System.currentTimeMillis();
        }
        this.curGTime = System.currentTimeMillis();
    }

    public void render(Graphics g) {
        if (!this.onListen) {
            return;
        }
        g.setFont(GameManager.getFontSmall());
        switch (this._gameState) {
            case 3: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
                CWAScreenChange.getInstance().render(g);
                break;
            }
            case 2: {
                g.setColor(0);
                g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
                g.setColor(0xFFFFFF);
                g.drawString("\u6e38\u620f\u6682\u505c", GameManager.getWidth() >> 1, (int)GameManager.getHalfHeight(), 33);
                g.drawString("\u8fd4\u56de", GameManager.getWidth() - 2, GameManager.getHeight() - 2, 40);
                break;
            }
            case 4: {
                break;
            }
            case 15: {
                g.setColor(16750080);
                g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
                g.setColor(0xFFFFFF);
                g.setFont(GameManager.getFontSmall());
                if (this._img == null) break;
                g.drawImage(this._img, (int)GameManager.getHalfWidth(), (int)GameManager.getHalfHeight(), 3);
                break;
            }
            case 16: {
                g.setColor(GameManager.getBackColor());
                g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
                if (this._img == null) break;
                g.drawImage(this._img, (GameManager.getWidth() - this._img.getWidth()) / 2, (GameManager.getHeight() - this._img.getHeight()) / 2, 20);
                break;
            }
            case 6: {
                g.setColor(0);
                g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
                g.setFont(GameManager.getFontSmall());
                g.setColor(0xFFFFFF);
                g.drawString(GameManager.STR(8), GameManager.getWidth() >> 1, GameManager.getHalfHeight() - 12, 17);
                g.drawString(GameManager.STR(4), 2, GameManager.getHeight() - 2, 36);
                g.drawString(GameManager.STR(5), GameManager.getWidth() - 2, GameManager.getHeight() - 2, 40);
                g.setColor(16739328);
                g.drawString(GameManager.STR(9), GameManager.getWidth() >> 1, GameManager.getHalfHeight() + 12, 17);
                break;
            }
            case 21: {
                g.drawImage(this._img, 0, 0, 20);
                for (int i = 0; i < GameManager.getWidth() / 10; ++i) {
                    g.drawRGB(this.imgArgb.argb, 0, this.imgArgb.w, i * 10 + 0, 0, this.imgArgb.w, this.imgArgb.h, true);
                }
                CWAScreenChange.getInstance().render(g);
                break;
            }
            case 7: {
                break;
            }
            case 12: {
                GameWorld.getInstance().world.render(g, 1);
                if (!this.loadover()) break;
                CWAScreenChange.getInstance().render(g);
                GamePlayer.stepSand = false;
                break;
            }
            case 9: {
                this.loadingRender(g);
                break;
            }
            case 23: {
                this.wharfRender(g);
                break;
            }
            case 10: {
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 20: {
                if (this.game == null) break;
                this.game.render(g);
            }
        }
    }

    public void loadingRender(Graphics g) {
        if (GamePlayer.stepSand) {
            g.setColor(0);
            g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
            if (loadCount % 4 == 3) {
                GamePlayer.getInstance().setAction((byte)1, (byte)-1, false);
            } else {
                GamePlayer.getInstance().setAction((byte)(loadCount % 4), (byte)-1, false);
            }
            GamePlayer.getInstance().setActorDir((byte)(loadCount % 4));
            GamePlayer.getInstance().drawSprite(g, CWAMap.getInstance().leftTopX, CWAMap.getInstance().leftTopY - loadCount);
        } else {
            g.setColor(0);
            g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
        }
        if (loadCount < 148) {
            loadCount += loadAdd;
        }
        if (loadCount > 148) {
            loadCount = 148;
        }
        if (!GamePlayer.stepSand) {
            g.setColor(0);
            g.fillRect(45, GameManager.getHeight() - 48, 150, 5);
            g.setColor(7877410);
            g.fillRect(46, GameManager.getHeight() - 47, 148, 3);
            g.setColor(16707204);
            g.fillRect(46, GameManager.getHeight() - 47, loadCount, 3);
            g.setColor(0xFFFFFF);
            g.drawString(this.tip, GameManager.getWidth() >> 1, GameManager.getHeight() - 70, 17);
        }
    }

    public void eventRender(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
        g.setColor(0xFFFFFF);
        g.drawString("\u5267\u60c5\u4e2d..", GameManager.getWidth() >> 1, GameManager.getHeight() >> 1, 17);
    }

    public void wharfRender(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, (int)GameManager.getWidth(), (int)GameManager.getHeight());
        g.setColor(0xFFFFFF);
        g.drawString(this.tip, GameManager.getWidth() >> 1, GameManager.getHeight() >> 1, 17);
    }

    public void setVolume(int v) {
        this.volume = (byte)v;
    }

    public void startMusic(String szName) {
        musicStr = szName;
        if (this.volume == 0) {
            return;
        }
        try {
            if (this._theme != null) {
                if (this.isStoped()) {
                    this._theme.start();
                }
            } else {
                InputStream is = GameManager.getInstance().getClass().getResourceAsStream("/data/sound/" + szName + ".mid");
                this._theme = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                this._theme.realize();
                this._volumeControl = (VolumeControl)this._theme.getControl("VolumeControl");
                this._volumeControl.setLevel(this.volume * 30);
                this._theme.prefetch();
                this._theme.setLoopCount(-1);
                this._theme.start();
                is.close();
                is = null;
            }
        }
        catch (MediaException e) {
            CWADebug.setErrorMsg(e, "startMusic");
        }
        catch (Exception e) {
            CWADebug.setErrorMsg(e, "/data/sound" + szName + ".mid");
        }
    }

    public void closeMusic() {
        if (this._theme == null) {
            return;
        }
        this._theme.deallocate();
        this._theme.close();
        this._theme = null;
    }

    private boolean isStoped() {
        try {
            this._theme.prefetch();
            if (this._theme.getState() == 300) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void stopMusic() {
        try {
            if (this._theme == null) {
                return;
            }
            this._theme.stop();
        }
        catch (MediaException e) {
            CWADebug.setErrorMsg(e, "stopMusic");
        }
    }

    public void setVolume() {
        if (this._volumeControl != null) {
            this._volumeControl.setLevel(this.volume * 30);
        }
    }

    public void addVolume() {
        this.volume = (byte)(this.volume + 1);
        if (this.volume > 3) {
            this.volume = (byte)3;
        }
        if (this.volume > 0) {
            this.setVolume();
            this.startMusic(musicStr);
        }
    }

    public void reduceVolume() {
        this.volume = (byte)(this.volume - 1);
        if (this.volume < 0) {
            this.volume = 0;
        }
        if (this.volume == 0) {
            this.closeMusic();
        } else {
            this.setVolume();
        }
    }

    static {
        loadCount = 0;
        loadAdd = 10;
        curCanCount = 0;
        musicStr = null;
    }

    public class LoadingTask
    extends TimerTask {
        public void run() {
            MainCanvas.getInstance().repaint();
        }
    }
}

