/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWAUI.CWAUIManager;
import game.GameEvent;
import game.GameManager;
import game.GamePlayer;
import game.GameUI;
import game.GameWorld;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameMenu
extends CWACommon
implements CWAGlobal {
    private static GameMenu _gamemenu;
    public static int[] menuStr;
    public static int menuIndex;
    private byte layer = 0;
    private byte count = 0;
    private Image startImg;
    private Image menuImg;
    byte starNum = (byte)10;
    int[][] randomArray = new int[this.starNum][5];
    int[] wh = new int[]{28, 3, 21, 22, 50, 5, 17, 17};
    byte w = (byte)30;
    byte h = (byte)30;
    boolean over = false;
    int index = 0;
    int[] star = new int[this.starNum];
    byte alphaType = (byte)3;
    int[] color = new int[]{3958719, 3958719, 3958719, 7248110, 7248110, 9943031};

    public static GameMenu getInstance() {
        if (_gamemenu == null) {
            _gamemenu = new GameMenu();
        }
        return _gamemenu;
    }

    public boolean init() {
        this._gui = GameUI.getInstance();
        this._ui = CWAUIManager.getInstance();
        this._gui.setGame(this);
        menuIndex = 0;
        menuStr = isHaveSms ? new int[]{504, 503, 505, 506, 508} : new int[]{503, 505, 506, 508};
        if (this.startImg == null) {
            this.startImg = CWATools.createImage("/data/img/", "img_833");
        }
        this.createStar();
        this.setState((byte)0);
        return true;
    }

    public void updateStar() {
        if (this.over) {
            ++this.index;
            if (this.index >= 100) {
                for (int i = 0; i < this.star.length; ++i) {
                    this.star[i] = 0;
                }
                this.index = 0;
                this.createStar();
                this.over = false;
            }
        }
    }

    public void createStar() {
        for (int i = 0; i < this.starNum; ++i) {
            this.randomArray[i][0] = -CWATools.getRandom(this.w);
            this.randomArray[i][1] = GameMenu.getHeight() + CWATools.getRandom(this.h);
            this.randomArray[i][2] = CWATools.getRandom(2);
            this.randomArray[i][3] = CWATools.getRandom(1, 5);
            this.randomArray[i][4] = CWATools.getRandom(3, 5);
        }
    }

    public void drawStar(Graphics g) {
        int i;
        if (this.over) {
            return;
        }
        for (i = 0; i < this.starNum; ++i) {
            g.drawRegion(this.startImg, this.wh[this.randomArray[i][2] * 4], this.wh[this.randomArray[i][2] * 4 + 1], this.wh[this.randomArray[i][2] * 4 + 2], this.wh[this.randomArray[i][2] * 4 + 3], 0, this.randomArray[i][0], this.randomArray[i][1], 20);
            int[] nArray = this.randomArray[i];
            nArray[0] = nArray[0] + this.randomArray[i][3];
            int[] nArray2 = this.randomArray[i];
            nArray2[1] = nArray2[1] - this.randomArray[i][4];
            if (this.randomArray[i][0] <= GameMenu.getWidth() && this.randomArray[i][1] >= 0) continue;
            int n = i;
            this.star[n] = this.star[n] + 1;
        }
        i = 0;
        for (i = 0; i < this.star.length && this.star[i] > 0; ++i) {
        }
        if (i >= this.star.length) {
            this.over = true;
        }
    }

    public void newGame() {
        GameWorld.isLearn = false;
        GameWorld.haveLearn = 0;
        GameEvent.isfrash = true;
        GameWorld.isPlayer = false;
        GameWorld.getInstance().sceneId = 0;
        GameWorld.getInstance().roomId = 0;
        if (GameWorld.getInstance()._event != null) {
            GameWorld.getInstance()._event.delete();
        }
        if (GameWorld.getInstance().gameplayer != null) {
            GameWorld.getInstance().gameplayer.delete();
        }
        if (GameWorld.getInstance()._gui != null) {
            GameWorld.getInstance()._gui.delete();
        }
        this.layer = 0;
        GamePlayer.getInstance().isInit = false;
        isHaveSms = false;
        GameManager.getInstance().setState((byte)9);
    }

    public void updateMenu() {
        if (this.layer == 0 && this.isKeyDown(16400)) {
            if (--menuIndex < 0) {
                menuIndex = menuStr.length - 1;
            }
        } else if (this.layer == 0 && this.isKeyDown(32832)) {
            if (++menuIndex > menuStr.length - 1) {
                menuIndex = 0;
            }
        } else if (this.isKeyDown(196640)) {
            if (isHaveSms) {
                switch (menuIndex) {
                    case 0: {
                        this.closeMenu();
                        GameManager.getInstance().setState((byte)9);
                        break;
                    }
                    case 1: {
                        this.setState((byte)4);
                        break;
                    }
                    case 2: {
                        this.setState((byte)1);
                        break;
                    }
                    case 3: {
                        this.setState((byte)2);
                        break;
                    }
                    case 4: {
                        this.setState((byte)3);
                    }
                }
            } else {
                switch (menuIndex) {
                    case 0: {
                        if (this.layer == 0) {
                            if (CWATools.checkIsSimulate()) {
                                this.layer = 1;
                                this._gui.boxItemTips("\u8bf7\u5728\u624b\u673a\u4e0a\u8fd0\u884c\u6e38\u620f");
                                break;
                            }
                            this.closeMenu();
                            this.newGame();
                            break;
                        }
                        if (this.layer != 1) break;
                        this.layer = 0;
                        this._gui.closeItemTips();
                        break;
                    }
                    case 1: {
                        this.setState((byte)1);
                        break;
                    }
                    case 2: {
                        this.setState((byte)2);
                        break;
                    }
                    case 3: {
                        this.setState((byte)3);
                    }
                }
            }
        }
        if (this._gui.updateOpenBox()) {
            this.layer = 0;
        }
    }

    public void closeMenu() {
        this._ui.close("/data/ui/menu.ui");
    }

    public void update() {
        if (!this.onListen) {
            return;
        }
        this.getKey();
        switch (this.gamestate) {
            case 0: {
                this.updateMenu();
                this.updateStar();
                break;
            }
            case 1: {
                this._gui.updateMenuSetting();
                break;
            }
            case 2: {
                this._gui.updateMenuHelp();
                break;
            }
            case 3: {
                if (this.isKeyDown(131072)) {
                    GameManager.getInstance().setState((byte)1);
                    break;
                }
                if (!this.isKeyDown(262144)) break;
                this.setState((byte)0);
                break;
            }
            case 4: {
                if (this.isKeyDown(131104)) {
                    GameWorld.getInstance().deleteRms();
                    this.newGame();
                    break;
                }
                if (!this.isKeyDown(262144)) break;
                this.setState((byte)0);
                this._ui.close("/data/ui/msgtip.ui");
            }
        }
        this._ui.update();
    }

    public void drawBack(Graphics g) {
        for (int i = 0; i < GameMenu.getHeight() / 20; ++i) {
            if (i % 2 == 0) {
                g.setColor(10440998);
            } else {
                g.setColor(12082732);
            }
            g.fillRect(0, i * 20, (int)GameMenu.getWidth(), 20);
        }
    }

    public void drawWord(Graphics g, String str, int x, int y, int align) {
        g.setColor(this.color[this.count]);
        g.drawString(str, x, y - 1, align);
        g.drawString(str, x, y + 1, align);
        g.drawString(str, x - 1, y, align);
        g.drawString(str, x + 1, y, align);
        g.setColor(0xFFFFFF);
        g.drawString(str, x, y, align);
        this.count = (byte)(this.count + 1);
        if (this.count >= 6) {
            this.count = 0;
        }
    }

    public void render(Graphics g) {
        switch (this.gamestate) {
            case 1: 
            case 2: {
                this.drawBack(g);
            }
        }
        this._ui.draw(g);
        if (this.gamestate == 0) {
            this.drawWord(g, GameMenu.STR(menuStr[menuIndex]), (GameMenu.getWidth() - GameMenu.getFontSmall().stringWidth(GameMenu.STR(menuStr[menuIndex]))) / 2, GameMenu.getHeight() - 20, 36);
            this.drawStar(g);
        } else if (this.gamestate == 3) {
            g.setColor(0);
            g.fillRect(0, 0, (int)GameMenu.getWidth(), (int)GameMenu.getHeight());
            g.setColor(0xFFFFFF);
            g.drawString("\u662f\u5426\u9000\u51fa\u6e38\u620f?", (int)GameMenu.getHalfWidth(), GameMenu.getHalfHeight() - 10, 17);
            g.drawString("\u662f", 2, (int)GameMenu.getHeight(), 36);
            g.drawString("\u5426", GameMenu.getWidth() - 2, (int)GameMenu.getHeight(), 40);
        }
    }

    public void release() {
        this.startImg = null;
        this.menuImg = null;
        this._ui.release();
    }

    public void setState(byte state) {
        this.gamestate = state;
        switch (state) {
            case 2: {
                this._gui.initMenuHelp();
                this.closeMenu();
                break;
            }
            case 1: {
                this._gui.initMenuSetting();
                this.closeMenu();
                break;
            }
            case 0: {
                this._gui.initMenuStatic();
                this._gui.closeMenuCartoon();
                break;
            }
            case 4: {
                this._gui.initMsgTip();
                this._gui.setMsgTip("\u662f\u5426\u6e05\u5b58\u6863,\u91cd\u65b0\u6e38\u620f?");
            }
        }
    }

    static {
        menuStr = null;
    }
}

