/*
 * Decompiled with CFR 0.152.
 */
package game;

import CWA2DAPI.CWACommon;
import CWA2DAPI.CWAGlobal;
import CWA2DAPI.CWATools;
import CWA2DAPI.cwaEX.CWADebug;
import CWA2DAPI.cwaEX.CWAEffect2D;
import CWA2DAPI.cwaEX.CWAScreenChange;
import CWA2DAPI.cwaEX.CWASprActor;
import CWA2DAPI.cwaEX.CWAWorld;
import CWA2DAPI.cwabase2d.CWACamera;
import CWA2DAPI.cwabase2d.CWADataManager;
import CWA2DAPI.cwabase2d.CWAImageManager;
import CWA2DAPI.cwabase2d.CWAMap;
import CWA2DAPI.cwabase2d.CWARms;
import CWAUI.CWAUIManager;
import game.GameBattle;
import game.GameDialog;
import game.GameEvent;
import game.GameManager;
import game.GameNpc;
import game.GamePlayer;
import game.GameUI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameWorld
extends CWACommon
implements CWAGlobal {
    private static GameWorld _gameworld;
    public CWAMap map;
    public CWACamera camera;
    public CWAWorld world;
    public GamePlayer gameplayer;
    public GameNpc[] npc;
    public GameDialog gameDialog = GameDialog.getInstance();
    public Vector doorNpc = new Vector();
    public int mapId;
    public int sceneId = 0;
    public int roomId = 0;
    public int count = 0;
    public short playerX = (short)128;
    public short playerY = (short)256;
    public int doorId = -1;
    public String mapName = "\u539f\u6728";
    public static int[] mapIndex;
    public static Image backImg;
    public static Image goldImg;
    public static Image doorImg;
    public static CWAEffect2D effect;
    public static CWARms[] petRms;
    public static byte npcItemIndex;
    public static byte[][][] npcObject;
    public static short[][][] npcPos;
    public static boolean[][] saveFlag;
    public static String[] npcName;
    public static final int AREADATA = 4;
    public static short[][] petArea;
    public static Vector mapGround;
    public static Vector mapWall;
    public static Vector mapWater;
    public static Vector mapSand;
    public CWASprActor followSp = null;
    public CWASprActor befollowSp = null;
    public CWASprActor bqSprActor = null;
    public static int eggExp;
    public static byte eggHatch;
    public static byte headIndex;
    public static byte headPos;
    public static final byte HEAD_ACTOR = 0;
    public static final byte HEAD_GIRL = 1;
    public static final byte HEAD_BOOS = 2;
    public static short collNpc;
    public static short collBattleNpc;
    public static byte faceDir;
    public static boolean isPlayer;
    public static int npcId;
    public static int cameraX;
    public static int cameraY;
    public static int cameraW;
    public static int cameraH;
    public static byte[] miniMap;
    private int[] actorH = new int[]{21, 35, 50, 0, 45};
    private int[] boss = new int[]{9, 0, 20, 3, 9, 1, 17, 1, 9, 2, 9, 4, 9, 6, 86, 5, 9, 6, 58, 6, 9, 5, 21, 2, 9, 4, 3, 0};
    public short[] post = new short[]{1, 5, 0, 616, 3, 6, 0, 617, 4, 0, 0, 618, 5, 2, 0, 619, 6, 0, 1, 620};
    public static boolean isLearn;
    public static Vector VectorlvUp;
    public static Vector VectorIndex;
    public static byte haveLearn;
    public static Vector vectorEvole;
    public static byte tipEvole;
    public static boolean worldRun;
    protected static boolean isEvoleTip;
    public static byte[] evoleData;
    public Image[] countDownImg;
    public GameEvent _event;
    public static String[] dialog;
    byte[][] tempHavePet = null;
    short[][] pdata = null;
    static int loadCount;
    private int[] data = null;
    int bug = 0;
    String evoleStr = "\u9664\u4e86\u8fdb\u5316\uff0c\u5ba0\u7269\u8fd8\u53ef\u4ee5\u5f02\u5316\uff0c\u5f02\u5316\u4e4b\u540e\u5ba0\u7269\u5c06\u66f4\u5177\u653b\u51fb\u6027\u3002\u53e6\u5916\u6bcf\u4e2a\u4e3b\u57ce\u7684\u8054\u76df\u8bad\u7ec3\u5e08\u4e5f\u4f1a\u63d0\u4f9b\u8fdb\u5316\u548c\u5f02\u5316\u670d\u52a1\u7684\uff0c\u4f60\u53ef\u4ee5\u5e38\u53bb\u770b\u770b\u3002";
    private final int OLD_W;
    private final int OLD_H;
    public final int RECT_W;
    public final int RECT_H;
    private final byte WHLEN = (byte)2;
    private final byte DATALEN = (byte)7;
    private byte miniMapId;
    private byte roadIndex;
    private byte boatIndex;
    private byte miniMapIndex;
    private int miniMapX;
    private int miniMapY;
    private int tempMapX;
    private int tempMapY;
    private boolean openMiniMap = false;
    private CWASprActor miniActor = null;
    private CWASprActor[] miniArrow = null;
    private int speed = 8;
    private int[] roadData = new int[]{2, 1, 73, 158, 3, 3, 216, 165, 4, 5, 161, 338, 5, 3, 111, 385, 5, 5, 112, 124, 6, 1, 140, 100, 7, 2, 48, 58};
    private int[] boatData = new int[]{1, 5, 265, 113, 3, 6, 281, 192, 4, 0, 24, 144, 5, 2, 88, 175, 6, 0, 55, 190};
    private int[] miniColor = new int[]{16735795, 5708544, 5693667, 28273, 7796622, 1924393, 16774529, 7760896, 3291479, 10268671, 2038828, 13341951, 4443391, 0xFFFFFF, 1862959, 13886935};
    private int[][] miniMapData = new int[][]{{0, 0, 1, 0, 386, 5, 5, 5, 0, 1, 1, 387, 5, 5, 0, 5, 1, 2, 388, 5, 5, 0, 10, 1, 3, 389, 5, 5, 5, 10, 1, 4, 390, 5, 5, 10, 10, 1, 5, 391, 5, 5, 10, 15, 1, 6, 392, 5, 5, 10, 20, -1, -1, 518, 5, 5}, {0, 0, -1, -1, 517, 5, 5, 0, 5, 2, 0, 393, 5, 5, 0, 10, 2, 1, 394, 5, 5, 0, 15, 2, 2, 395, 5, 5, 5, 10, 2, 3, 396, 5, 5, 5, 5, 2, 4, 397, 5, 5, 5, 15, 2, 5, 398, 5, 5, 5, 20, 2, 6, 399, 5, 5, 5, 25, 2, 7, 400, 5, 5}, {15, 0, -1, -1, 518, 5, 5, 15, 5, 3, 0, 401, 5, 5, 15, 10, 3, 1, 402, 5, 5, 10, 10, 3, 2, 403, 5, 5, 10, 15, 3, 3, 404, 5, 5, 5, 15, 3, 4, 405, 5, 5, 0, 15, 3, 5, 406, 5, 5, 15, 15, 3, 6, 407, 5, 5, 15, 20, 3, 7, 408, 5, 5}, {0, 15, 4, 0, 409, 5, 5, 5, 15, 4, 1, 410, 5, 5, 10, 15, 4, 5, 414, 5, 5, 10, 20, 4, 6, 415, 5, 5, 15, 20, 4, 7, 416, 5, 5, 20, 20, 4, 8, 417, 5, 5, 15, 15, 4, 9, 418, 5, 5, 20, 15, 4, 10, 419, 5, 5, 15, 10, 4, 11, 420, 5, 5, 15, 5, 4, 12, 421, 5, 5, 0, 10, 4, 2, 411, 5, 5, 5, 10, 4, 3, 412, 5, 5, 10, 10, 4, 4, 413, 5, 5, 15, 0, -1, -1, 524, 5, 5}, {10, 5, 5, 0, 422, 5, 5, 5, 5, 5, 1, 423, 5, 5, 0, 5, 5, 2, 424, 5, 5, 5, 0, 5, 3, 425, 5, 5, 15, 5, 5, 4, 426, 5, 5, 20, 5, 5, 5, 427, 5, 5, 18, 0, 5, 6, 428, 5, 5, 10, 10, -1, -1, 522, 5, 5}, {0, 5, 6, 0, 429, 5, 5, 0, 0, 6, 1, 430, 5, 5}, {5, 15, 7, 0, 431, 5, 5, 5, 10, 7, 1, 432, 5, 5, 5, 5, 7, 2, 433, 5, 5, 0, 5, 7, 3, 434, 5, 5, 0, 0, 7, 4, 435, 5, 5, 0, 10, 7, 5, 436, 5, 5, 0, 15, 7, 6, 437, 5, 5, 10, 5, 7, 7, 438, 5, 5, 10, 0, 7, 8, 439, 5, 5, 15, 0, 7, 9, 440, 5, 5, 15, 5, 7, 10, 441, 5, 5, 10, 10, 7, 11, 442, 5, 5, 10, 15, 7, 12, 443, 5, 5}, {5, 10, 8, 0, 444, 5, 5, 5, 15, 8, 1, 445, 5, 5, 0, 15, 8, 2, 446, 5, 5, 0, 10, 8, 3, 447, 5, 5, 0, 5, 8, 4, 448, 5, 5, 5, 5, 8, 5, 449, 5, 5, 5, 0, 8, 6, 450, 5, 5}};
    public int[] miniMapWH = new int[]{3, 5, 2, 6, 4, 5, 5, 5, 5, 3, 1, 2, 4, 4, 2, 4};
    public static byte battleArea;
    boolean isShow = false;
    private boolean[] exchange = new boolean[]{false, false, false, false, false, false, false};
    private byte[] exchangeNum = new byte[]{10, 15, 20, 30, 40, 50, 100};
    private byte startTip;
    private byte endTip;
    private boolean canExchange = false;

    public static GameWorld getInstance() {
        if (_gameworld == null) {
            _gameworld = new GameWorld();
        }
        return _gameworld;
    }

    public GameWorld() {
        this.OLD_W = 5;
        this.OLD_H = 5;
        this.RECT_W = 16;
        this.RECT_H = 8;
        this.map = CWAMap.getInstance();
        this.camera = CWACamera.getInstance();
        this.world = new CWAWorld();
    }

    public boolean havePetEnemy() {
        return petArea[mapIndex[this.sceneId] + this.roomId][2] != -1;
    }

    public void initPetArea() {
        int i;
        if (petArea == null) {
            try {
                InputStream is = CWATools.getInputStream("/data/script/petArea.mid");
                petArea = CWATools.getShort2DArray(is);
                is.close();
                is = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (!this.havePetEnemy()) {
            return;
        }
        int[] tempArea = new int[petArea[mapIndex[this.sceneId] + this.roomId].length - 5];
        for (i = 0; i < tempArea.length; ++i) {
            tempArea[i] = petArea[mapIndex[this.sceneId] + this.roomId][5 + i];
        }
        block9: for (i = 0; i < tempArea.length / 4; ++i) {
            int[] temp = new int[4];
            switch (tempArea[i * 4 + 1]) {
                case 0: {
                    System.arraycopy(tempArea, i * 4, temp, 0, temp.length);
                    mapGround.addElement(temp);
                    continue block9;
                }
                case 1: {
                    System.arraycopy(tempArea, i * 4, temp, 0, temp.length);
                    mapWall.addElement(temp);
                    continue block9;
                }
                case 2: {
                    System.arraycopy(tempArea, i * 4, temp, 0, temp.length);
                    mapWater.addElement(temp);
                    continue block9;
                }
                case 4: {
                    System.arraycopy(tempArea, i * 4, temp, 0, temp.length);
                    mapSand.addElement(temp);
                }
            }
        }
        tempArea = null;
    }

    public void initRidePet() {
        int i;
        if (this.tempHavePet == null) {
            try {
                InputStream is = CWATools.getInputStream("/data/script/petRide.mid");
                this.tempHavePet = CWATools.getByte2DArray(is);
                is.close();
                is = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.gameplayer.pokHavePet = this.tempHavePet[mapIndex[this.sceneId] + this.roomId];
        if (this.gameplayer.rideIndex >= 0 && !this.gameplayer.canRidePet(this.gameplayer.rideIndex)) {
            this.gameplayer.downPet();
        }
        this.miniMapId = this.gameplayer.pokHavePet[4];
        this.roadIndex = (byte)-1;
        for (i = 0; i < this.roadData.length / 4; i = (int)((byte)(i + 1))) {
            if (this.sceneId != this.roadData[i * 4] || this.roomId != this.roadData[i * 4 + 1]) continue;
            this.roadIndex = (byte)i;
            break;
        }
        this.boatIndex = (byte)-1;
        for (i = 0; i < this.boatData.length / 4; i = (int)((byte)(i + 1))) {
            if (this.sceneId != this.boatData[i * 4] || this.roomId != this.boatData[i * 4 + 1]) continue;
            this.boatIndex = (byte)i;
            break;
        }
    }

    public void initBackPic() {
        backImg = null;
        try {
            if (this.pdata == null) {
                InputStream is = CWATools.getInputStream("/data/script/backPic.mid");
                this.pdata = CWATools.getShort2DArray(is);
                is.close();
                is = null;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < this.pdata.length; ++i) {
            if (this.pdata[i][0] == this.sceneId && this.pdata[i][1] == this.roomId) {
                if (this.pdata[i][2] == 0) {
                    backImg = CWATools.createImage("/data/img/", "img_" + this.pdata[i][3]);
                    break;
                }
                if (this.pdata[i][2] != 1) break;
                CWACommon.setBackColor(this.pdata[i][3] << 16 | this.pdata[i][4] << 8 | this.pdata[i][5]);
                break;
            }
            CWACommon.setBackColor(2996676);
        }
        if (goldImg == null) {
            goldImg = CWATools.createImage("/data/tex/", "gold");
        }
        if (doorImg == null) {
            doorImg = CWATools.createImage("/data/img/", "img_10023");
        }
    }

    public boolean init() {
        this.loading();
        this.initRms();
        loadCount = 0;
        this._event = GameEvent.getInstance();
        this._event.setGame(this);
        this.gameplayer = GamePlayer.getInstance();
        GameWorld.evoleData[1] = -1;
        GameWorld.evoleData[0] = -1;
        if (GameEvent.isReCall != 0) {
            CWAImageManager.clear();
        }
        if (npcObject == null) {
            npcObject = new byte[127][][];
            npcPos = new short[127][][];
            saveFlag = new boolean[127][2];
        }
        loadCount = 1;
        if (!this.gameplayer.isInit && isHaveSms) {
            this.loadScene();
            this.loadEvent();
            this.loadSMS();
        }
        loadCount = 2;
        this.initRoom(this.sceneId, this.roomId, "/data/event/");
        this.initBq();
        loadCount = 3;
        loadCount = 4;
        this.initPetArea();
        loadCount = 5;
        this.initRidePet();
        loadCount = 6;
        this.initBackPic();
        loadCount = 7;
        this.initMap();
        loadCount = 8;
        this.initNpcLaser();
        loadCount = 9;
        if (isPlayer) {
            GameEvent.isfrash = false;
            this.initPlayer();
            this.initCamera();
        } else {
            if (!this.gameplayer.isInit) {
                short[] data = new short[]{this.playerX, this.playerY, faceDir, 4, 4, 8, 40, 100, 0};
                this.gameplayer.init(data);
                this.gameplayer.test();
            }
            if (npcId == -1) {
                this.camera.setCommonCamera(cameraX, cameraY, cameraW, cameraH, true);
                this.world.setCamera(this.camera);
                this.world.update();
            } else {
                this.camera.setTargetCamera(this.npc[npcId], cameraW, cameraH, true);
                this.world.setCamera(this.camera);
                this.world.update();
            }
            this.gameplayer.setReflection(false);
            isPlayer = true;
        }
        this.addToWorld();
        loadCount = 10;
        if (this.sceneId == 3 && this.roomId == 7) {
            if (this.gameplayer.avertStep > 0) {
                this.gameplayer.avertStep = 0;
                this.gameplayer.aphaImg(0);
            }
            if (this.countDownImg == null) {
                this.countDownImg = new Image[4];
                for (int i = 0; i < this.countDownImg.length; ++i) {
                    this.countDownImg[i] = CWATools.createImage("/data/tex/", "down" + i);
                }
            }
            this.gameplayer.ridePet(0);
        }
        loadCount = 11;
        if (this.sceneId == 5 && this.roomId == 6 || this.sceneId == 4 && (this.roomId == 3 || this.roomId == 4)) {
            if (this.gameplayer.pokBadge[0][0] == 2) {
                CWAScreenChange.getInstance().initAphaArc((byte)0, this.camera.getActorX(), this.camera.getActorY() - this.actorH[this.gameplayer.rideIndex + 1], GameWorld.getWidth(), GameWorld.getHeight(), 110, 110);
            } else {
                CWAScreenChange.getInstance().initAphaArc((byte)0, this.camera.getActorX(), this.camera.getActorY() - this.actorH[this.gameplayer.rideIndex + 1], GameWorld.getWidth(), GameWorld.getHeight(), 50, 50);
            }
        } else {
            CWAScreenChange.getInstance().setAlphaType((byte)-1);
        }
        loadCount = 12;
        this._gui = GameUI.getInstance();
        this._gui.setGame(this);
        this._ui = CWAUIManager.getInstance();
        this._event.canAccept();
        loadCount = 13;
        this._event.update();
        loadCount = 14;
        worldRun = true;
        loadCount = 15;
        this.setState((byte)0);
        loadCount = 16;
        if (GameEvent.isReCall == 2) {
            GameEvent.isReCall = 0;
        }
        loadCount = 17;
        this.loadOver();
        return true;
    }

    public void addToWorld() {
        for (int i = 0; i < this.npc.length; ++i) {
            this.npc[i].checkIsScreen();
            this.world.addActor(this.npc[i]);
        }
    }

    public void initBq() {
        if (this.bqSprActor == null) {
            this.bqSprActor = new CWASprActor();
            this.bqSprActor.initSprite(259, false);
        }
    }

    public void setBq(byte action, int actorX, int actorY, CWASprActor actor) {
        if (this.bqSprActor.isAction()) {
            return;
        }
        this.bqSprActor.sprite.setAction(action, (byte)-1);
        this.bqSprActor.reCallImage();
        this.bqSprActor.layer = 0;
        this.bqSprActor.start();
        this.world.addActor(this.bqSprActor);
        this.bqSprActor.setPosition(actorX, actorY);
        this.bqSprActor.setTarget(actor);
    }

    public void removeBq(int where) {
        if (this.bqSprActor != null) {
            this.bqSprActor.stop();
            this.world.removeActor(this.bqSprActor);
        }
    }

    public void initFollow(int sprId) {
        if (this.followSp == null) {
            this.followSp = new CWASprActor();
            this.followSp.initSprite(sprId, false);
            this.followSp.reCallImage();
            this.followSp.layer = 1;
        }
    }

    public void addFollow(CWASprActor actor) {
        if (this.followSp == null) {
            return;
        }
        this.befollowSp = actor;
        this.followSp.setTarget(actor);
        this.followSp.setFollowOn(actor.getAction());
        this.followSp.start();
        this.world.addActor(this.followSp);
        if (backImg != null) {
            this.followSp.setReflection(true);
        } else {
            this.followSp.setReflection(false);
        }
    }

    public void removeFollow() {
        if (this.followSp != null) {
            this.world.removeActor(this.followSp);
            this.followSp = null;
        }
    }

    public void initRms() {
        if (petRms == null) {
            petRms = new CWARms[10];
        }
        for (int i = 0; i < petRms.length; ++i) {
            if (petRms[i] != null) continue;
            GameWorld.petRms[i] = new CWARms(CWAGlobal.RMS_STR[i], 1);
        }
    }

    public void initNewGameRms() {
        petRms = new CWARms[10];
        for (int i = 0; i < petRms.length; ++i) {
            if (i == 4) continue;
            GameWorld.petRms[i] = new CWARms(CWAGlobal.RMS_STR[i], 1);
        }
    }

    public boolean savePlayer(GamePlayer player) {
        try {
            int j;
            int j2;
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            if (this.sceneId == 9) {
                dos.writeShort(this._gui.mapRoad[this.roomId * 4 + 2]);
                dos.writeShort(this._gui.mapRoad[this.roomId * 4 + 3]);
                dos.writeByte(2);
            } else if (this.sceneId == 3 && this.roomId == 7) {
                dos.writeShort(240);
                dos.writeShort(40);
                dos.writeByte(0);
            } else {
                dos.writeShort(player.actorX);
                dos.writeShort(player.actorY);
                dos.writeByte(player.faceDir);
            }
            for (i = 0; i < player.pokBadge.length; ++i) {
                for (j2 = 0; j2 < player.pokBadge[i].length; ++j2) {
                    dos.writeByte(player.pokBadge[i][j2]);
                }
            }
            for (i = 0; i < player.pokRidePet.length; ++i) {
                dos.writeByte(player.pokRidePet[i]);
            }
            for (i = 0; i < player.pokPetMap.length; ++i) {
                for (j2 = 0; j2 < player.pokPetMap[i].length; ++j2) {
                    dos.writeByte(player.pokPetMap[i][j2]);
                }
            }
            for (i = 0; i < player.pokPetNum.length; ++i) {
                dos.writeByte(player.pokPetNum[i]);
            }
            for (i = 0; i < player.pokPetType.length; ++i) {
                for (j2 = 0; j2 < player.pokPetType[i].length; ++j2) {
                    dos.writeByte(this.gameplayer.pokPetType[i][j2]);
                }
            }
            dos.writeByte(this.gameplayer.pokPetRare);
            dos.writeByte(this.gameplayer.pokPetGodz);
            dos.writeByte(this.gameplayer.pokPetTypeNum);
            dos.writeByte(this.gameplayer.hatchPetNum);
            for (i = 0; i < this.gameplayer.hatchPet.length; ++i) {
                dos.writeByte(this.gameplayer.hatchPet[i]);
            }
            dos.writeInt(player.pokPetBank.size());
            for (i = 0; i < player.pokPetBank.size(); ++i) {
                int[] temp = (int[])player.pokPetBank.elementAt(i);
                dos.writeInt(temp.length);
                for (j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            if (!this.savePokPet()) {
                return false;
            }
            if (!this.saveConItem()) {
                return false;
            }
            if (!this.savePetBall()) {
                return false;
            }
            dos.writeInt(player.pokAmulet.size());
            for (i = 0; i < player.pokAmulet.size(); ++i) {
                int[] temp = (int[])player.pokAmulet.elementAt(i);
                dos.writeInt(temp.length);
                for (j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            dos.writeInt(player.pokMatertal.size());
            for (i = 0; i < player.pokMatertal.size(); ++i) {
                int[] temp = (int[])player.pokMatertal.elementAt(i);
                dos.writeInt(temp.length);
                for (j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            dos.writeInt(player.pokSpecial.size());
            for (i = 0; i < player.pokSpecial.size(); ++i) {
                int[] temp = (int[])player.pokSpecial.elementAt(i);
                dos.writeInt(temp.length);
                for (j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            for (i = 0; i < player.taskItem.length; ++i) {
                dos.writeBoolean(player.taskItem[i]);
            }
            if (!this.saveGold()) {
                return false;
            }
            if (VectorIndex == null) {
                VectorIndex = new Vector();
            }
            dos.writeByte(VectorIndex.size());
            for (i = 0; i < VectorIndex.size(); ++i) {
                String abc = (String)VectorIndex.elementAt(i);
                dos.writeByte(CWATools.getByte(abc));
            }
            for (i = 0; i < this.exchange.length; ++i) {
                dos.writeBoolean(this.exchange[i]);
            }
            if (this.followSp == null) {
                dos.writeByte(-1);
            } else {
                dos.writeByte(this.followSp.sprite.sprIndex);
            }
            dos.write(this.gameplayer.isReloading);
            dos.writeInt(eggExp);
            dos.writeBoolean(isEvoleTip);
            long time = GameManager.getInstance().totalGTime + GameManager.getInstance().curGTime - GameManager.getInstance().startGTime;
            dos.writeLong(time);
            dos.writeByte(this.gameplayer.rideIndex);
            petRms[0].save(bos);
            bos.close();
            dos.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean loadPlayer(GamePlayer player) {
        try {
            int i;
            int j;
            int[] temp;
            int i2;
            int j2;
            int i3;
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[0].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            this.playerX = dis.readShort();
            this.playerY = dis.readShort();
            short face = dis.readByte();
            for (i3 = 0; i3 < player.pokBadge.length; ++i3) {
                for (j2 = 0; j2 < player.pokBadge[i3].length; ++j2) {
                    player.pokBadge[i3][j2] = dis.readByte();
                }
            }
            for (i3 = 0; i3 < player.pokRidePet.length; ++i3) {
                player.pokRidePet[i3] = dis.readByte();
            }
            for (i3 = 0; i3 < player.pokPetMap.length; ++i3) {
                for (j2 = 0; j2 < player.pokPetMap[i3].length; ++j2) {
                    player.pokPetMap[i3][j2] = dis.readByte();
                }
            }
            for (i3 = 0; i3 < player.pokPetNum.length; ++i3) {
                player.pokPetNum[i3] = dis.readByte();
            }
            for (i3 = 0; i3 < player.pokPetType.length; ++i3) {
                for (j2 = 0; j2 < player.pokPetType[i3].length; ++j2) {
                    this.gameplayer.pokPetType[i3][j2] = dis.readByte();
                }
            }
            this.gameplayer.pokPetRare = dis.readByte();
            this.gameplayer.pokPetGodz = dis.readByte();
            this.gameplayer.pokPetTypeNum = dis.readByte();
            this.gameplayer.hatchPetNum = dis.readByte();
            for (i3 = 0; i3 < this.gameplayer.hatchPet.length; ++i3) {
                this.gameplayer.hatchPet[i3] = dis.readByte();
            }
            player.pokPetBank.removeAllElements();
            int len = dis.readInt();
            for (i2 = 0; i2 < len; ++i2) {
                temp = new int[dis.readInt()];
                for (j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                player.pokPetBank.addElement(temp);
            }
            this.loadPokPet();
            this.loadConItem();
            this.loadPetBall();
            len = dis.readInt();
            player.pokAmulet.removeAllElements();
            for (i2 = 0; i2 < len; ++i2) {
                temp = new int[dis.readInt()];
                for (j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                player.pokAmulet.addElement(temp);
            }
            len = dis.readInt();
            player.pokMatertal.removeAllElements();
            for (i2 = 0; i2 < len; ++i2) {
                temp = new int[dis.readInt()];
                for (j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                player.pokMatertal.addElement(temp);
            }
            len = dis.readInt();
            player.pokSpecial.removeAllElements();
            for (i2 = 0; i2 < len; ++i2) {
                temp = new int[dis.readInt()];
                for (j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                player.pokSpecial.addElement(temp);
            }
            for (i2 = 0; i2 < player.taskItem.length; ++i2) {
                player.taskItem[i2] = dis.readBoolean();
            }
            this.loadGold();
            if (VectorlvUp == null) {
                VectorlvUp = new Vector();
            }
            VectorlvUp.removeAllElements();
            len = dis.readByte();
            int[] temp2 = new int[len];
            for (i = 0; i < len; ++i) {
                temp2[i] = dis.readByte();
                if (this.gameplayer.pokPet[temp2[i]] == null) continue;
                this.gameplayer.pokPet[temp2[i]].setPreLevelProp();
                VectorlvUp.addElement(this.gameplayer.pokPet[temp2[i]]);
            }
            for (i = 0; i < this.exchange.length; ++i) {
                this.exchange[i] = dis.readBoolean();
            }
            byte spId = dis.readByte();
            if (spId != -1) {
                this.initFollow(spId);
            }
            this.gameplayer.isReloading = dis.readByte();
            eggExp = dis.readInt();
            isEvoleTip = dis.readBoolean();
            GameManager.getInstance().totalGTime += dis.readLong();
            player.rideIndex = dis.readByte();
            player.init(new short[]{this.playerX, this.playerY, face, 4, 4, 8, 40, 100, 0});
            bis.close();
            dis.close();
        }
        catch (Exception ex) {
            System.out.println(" ex = " + ex);
            return false;
        }
        return true;
    }

    public boolean saveScene() {
        try {
            int k;
            int j;
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.sceneId);
            dos.writeInt(this.roomId);
            for (i = 0; i < npcObject.length; ++i) {
                if (npcObject[i] == null) {
                    dos.writeShort(-1);
                    continue;
                }
                dos.writeShort(npcObject[i].length);
                for (j = 0; j < npcObject[i].length; ++j) {
                    if (npcObject[i][j] == null) {
                        dos.writeByte(-1);
                        continue;
                    }
                    dos.writeByte(npcObject[i][j].length);
                    for (k = 0; k < npcObject[i][j].length; ++k) {
                        dos.writeByte(npcObject[i][j][k]);
                    }
                }
            }
            for (i = 0; i < npcPos.length; ++i) {
                if (npcPos[i] == null) {
                    dos.writeShort(-1);
                    continue;
                }
                dos.writeShort(npcPos[i].length);
                for (j = 0; j < npcPos[i].length; ++j) {
                    if (npcPos[i][j] == null) {
                        dos.writeByte(-1);
                        continue;
                    }
                    dos.writeByte(npcPos[i][j].length);
                    for (k = 0; k < npcPos[i][j].length; ++k) {
                        dos.writeShort(npcPos[i][j][k]);
                    }
                }
            }
            petRms[1].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadScene() {
        try {
            int k;
            int j;
            int i;
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[1].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            this.sceneId = dis.readInt();
            this.roomId = dis.readInt();
            short temp = 0;
            byte temp1 = 0;
            for (i = 0; i < npcObject.length; ++i) {
                temp = dis.readShort();
                if (temp == -1) {
                    GameWorld.npcObject[i] = null;
                    continue;
                }
                GameWorld.npcObject[i] = new byte[temp][];
                for (j = 0; j < npcObject[i].length; ++j) {
                    temp1 = dis.readByte();
                    if (temp1 == -1) {
                        GameWorld.npcObject[i][j] = null;
                        continue;
                    }
                    GameWorld.npcObject[i][j] = new byte[temp1];
                    for (k = 0; k < npcObject[i][j].length; ++k) {
                        GameWorld.npcObject[i][j][k] = dis.readByte();
                    }
                }
            }
            for (i = 0; i < npcPos.length; ++i) {
                temp = dis.readShort();
                if (temp == -1) {
                    GameWorld.npcPos[i] = null;
                    continue;
                }
                GameWorld.npcPos[i] = new short[temp][];
                for (j = 0; j < npcPos[i].length; ++j) {
                    temp1 = dis.readByte();
                    if (temp1 == -1) {
                        GameWorld.npcPos[i][j] = null;
                        continue;
                    }
                    GameWorld.npcPos[i][j] = new short[temp1];
                    for (k = 0; k < npcPos[i][j].length; ++k) {
                        GameWorld.npcPos[i][j][k] = dis.readShort();
                    }
                }
            }
            bis.close();
            dis.close();
        }
        catch (IOException ex) {
            System.out.println(" sceneId ex = " + ex);
            return false;
        }
        return true;
    }

    public boolean saveEvent() {
        try {
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (i = 0; i < this._event.eventState.length; ++i) {
                if (this._event.eventState[i] == null) {
                    dos.writeByte(-1);
                    continue;
                }
                dos.writeByte(this._event.eventState[i].length);
                for (int j = 0; j < this._event.eventState[i].length; ++j) {
                    dos.writeByte(this._event.eventState[i][j]);
                }
            }
            dos.writeByte(GameEvent.mainQuestIndex);
            dos.writeByte(GameEvent.branchQuestIndex);
            for (i = 0; i < GameEvent.branchQuestIndex; ++i) {
                dos.writeShort(GameEvent.taskNum[i][0]);
                dos.writeShort(GameEvent.taskNum[i][1]);
            }
            int[] date = this._event.getRecordDate();
            if (date == null) {
                dos.writeByte(-1);
            } else {
                dos.writeByte(date.length);
                for (int i2 = 0; i2 < date.length; ++i2) {
                    dos.writeInt(date[i2]);
                }
                dos.writeByte(this._event.gameTimes);
            }
            petRms[2].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadEvent() {
        try {
            int i;
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[2].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            byte temp = 0;
            for (i = 0; i < this._event.eventState.length; ++i) {
                temp = dis.readByte();
                if (temp == -1) {
                    this._event.eventState[i] = null;
                    continue;
                }
                this._event.eventState[i] = new byte[temp];
                for (int j = 0; j < this._event.eventState[i].length; ++j) {
                    this._event.eventState[i][j] = dis.readByte();
                }
            }
            GameEvent.mainQuestIndex = dis.readByte();
            GameEvent.branchQuestIndex = dis.readByte();
            for (i = 0; i < GameEvent.branchQuestIndex; ++i) {
                GameEvent.taskNum[i][0] = dis.readShort();
                GameEvent.taskNum[i][1] = dis.readShort();
            }
            int len = dis.readByte();
            if (len != -1) {
                int[] date = new int[len];
                int[] tDate = new int[len];
                tDate = this._event.getDate();
                for (int i2 = 0; i2 < len; ++i2) {
                    date[i2] = dis.readInt();
                }
                this._event.setRecordDate(date);
                boolean zero = false;
                if (tDate[0] > date[0] || tDate[1] > date[1] || tDate[2] > date[2] || tDate[3] - date[3] >= 20) {
                    zero = true;
                }
                this._event.gameTimes = dis.readByte();
                if (zero) {
                    this._event.gameTimes = 0;
                }
            }
            isPlayer = true;
            bis.close();
            dis.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean saveRms() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            isHaveSms = true;
            dos.writeBoolean(isHaveSms);
            dos.writeBoolean(isPlayer);
            dos.writeBoolean(isLearn);
            dos.writeByte(haveLearn);
            petRms[3].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadRms() {
        if (petRms[3] == null) {
            GameWorld.petRms[3] = new CWARms(CWAGlobal.RMS_STR[3], 1);
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[3].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            isHaveSms = dis.readBoolean();
            isPlayer = dis.readBoolean();
            isLearn = dis.readBoolean();
            haveLearn = dis.readByte();
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            isHaveSms = false;
            return false;
        }
    }

    public boolean saveSMS() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeBoolean(isSMSCheck);
            petRms[4].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadSMS() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[4].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            isSMSCheck = dis.readBoolean();
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean saveCntSms() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < cntSms.length; ++i) {
                dos.writeByte(cntSms[i]);
            }
            petRms[5].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadCntSms() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[5].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            for (int i = 0; i < cntSms.length; ++i) {
                GameWorld.cntSms[i] = dis.readByte();
            }
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean saveGold() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.gameplayer.getGold());
            dos.writeInt(this.gameplayer.getBadge());
            petRms[6].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadGold() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[6].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            this.gameplayer.setGold(0);
            this.gameplayer.setBadge(0);
            this.gameplayer.addGold(dis.readInt());
            this.gameplayer.addBadge(dis.readInt());
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean savePetBall() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.gameplayer.pokBall.size());
            for (int i = 0; i < this.gameplayer.pokBall.size(); ++i) {
                int[] temp = (int[])this.gameplayer.pokBall.elementAt(i);
                dos.writeInt(temp.length);
                for (int j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            petRms[9].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadPetBall() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[9].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            int len = dis.readInt();
            this.gameplayer.pokBall.removeAllElements();
            for (int i = 0; i < len; ++i) {
                int[] temp = new int[dis.readInt()];
                for (int j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                this.gameplayer.pokBall.addElement(temp);
            }
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean saveConItem() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(this.gameplayer.pokConsumable.size());
            for (int i = 0; i < this.gameplayer.pokConsumable.size(); ++i) {
                int[] temp = (int[])this.gameplayer.pokConsumable.elementAt(i);
                dos.writeInt(temp.length);
                for (int j = 0; j < temp.length; ++j) {
                    dos.writeInt(temp[j]);
                }
            }
            petRms[8].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadConItem() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[8].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            int len = dis.readInt();
            this.gameplayer.pokConsumable.removeAllElements();
            for (int i = 0; i < len; ++i) {
                int[] temp = new int[dis.readInt()];
                for (int j = 0; j < temp.length; ++j) {
                    temp[j] = dis.readInt();
                }
                this.gameplayer.pokConsumable.addElement(temp);
            }
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean savePokPet() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(this.gameplayer.pokPetSize);
            for (int i = 0; i < this.gameplayer.pokPetSize; ++i) {
                int[] baseData = this.gameplayer.pokPet[i].getBaseData();
                dos.writeInt(baseData.length);
                for (int j = 0; j < baseData.length; ++j) {
                    dos.writeInt(baseData[j]);
                }
            }
            petRms[7].save(bos);
            bos.close();
            dos.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean loadPokPet() {
        try {
            int i;
            ByteArrayInputStream bis = new ByteArrayInputStream(petRms[7].getRecords(0));
            DataInputStream dis = new DataInputStream(bis);
            byte len = dis.readByte();
            for (i = 0; i < this.gameplayer.pokPetSize; ++i) {
                this.gameplayer.pokPet[i] = null;
            }
            this.gameplayer.pokPetSize = 0;
            for (i = 0; i < len; ++i) {
                int[] baseData = new int[dis.readInt()];
                for (int j = 0; j < baseData.length; ++j) {
                    baseData[j] = dis.readInt();
                }
                this.gameplayer.addPokPet(baseData);
            }
            bis.close();
            dis.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean save() {
        if (!this.savePlayer(this.gameplayer)) {
            return false;
        }
        if (!this.saveScene()) {
            return false;
        }
        if (!this.saveEvent()) {
            return false;
        }
        if (!this.saveRms()) {
            return false;
        }
        return this.saveSMS();
    }

    public boolean saveOther() {
        if (!this.saveSMS()) {
            return false;
        }
        if (!this.savePokPet()) {
            return false;
        }
        if (!this.saveGold()) {
            return false;
        }
        return this.savePetBall();
    }

    public void deleteRms() {
        for (int i = 0; i < 10; ++i) {
            if (i == 4 || petRms[i] == null) continue;
            petRms[i].delete();
            GameWorld.petRms[i] = null;
        }
        petRms = null;
    }

    public boolean reback() {
        this._event.setGame(this);
        this._gui.setGame(this);
        GameEvent.isfrash = false;
        worldRun = true;
        this.setState((byte)0);
        this._ui.close("/data/ui/battle.ui");
        return true;
    }

    public void initPlayer() {
        if (!this.gameplayer.isInit) {
            if (isHaveSms) {
                this.loadPlayer(this.gameplayer);
            } else {
                short[] data = new short[]{this.playerX, this.playerY, faceDir, 4, 4, 8, 40, 100, 0};
                this.gameplayer.init(data);
            }
        } else if (this.doorId > -1) {
            int x = this.npc[this.doorId].actorX - this.npc[this.doorId].actorX % this.gameplayer.getProp((byte)2);
            int y = this.npc[this.doorId].actorY - this.npc[this.doorId].actorY % this.gameplayer.getProp((byte)2);
            this.gameplayer.setPosition(x, y);
            this.gameplayer.shadowActor.setPosition(x, y);
            this.gameplayer.setState((byte)0, this.npc[this.doorId].playerDirection);
            if (this.npc[this.doorId].sprite.sprIndex == 222) {
                this.gameplayer.move(24);
            } else {
                this.gameplayer.move(32);
            }
        } else {
            short[] data = new short[]{this.playerX, this.playerY, faceDir, 4, 4, 8, 40, 100, 0};
            this.gameplayer.init(data);
        }
        this.world.addActor(this.gameplayer);
        this.gameplayer.openPassometer();
        this.gameplayer.start();
        this.addFollow(this.gameplayer);
        if (backImg != null) {
            this.gameplayer.setReflection(false);
        } else {
            this.gameplayer.setReflection(true);
        }
    }

    public void initNpcLaser() {
        for (int i = 0; i < this.npc.length; ++i) {
            if (this.npc[i].actorType != 0 || this.npc[i].npcType != 14) continue;
            this.npc[i].recordCountLaserArea();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initRoom(int scene, int room, String path) {
        String fileName = path + "scene_" + scene + ".mid";
        try {
            InputStream in = "".getClass().getResourceAsStream(fileName);
            DataInputStream dis = new DataInputStream(in);
            int roomsCount = dis.readShort();
            short[] _roomLength = new short[roomsCount];
            for (int s = 0; s < roomsCount; ++s) {
                _roomLength[s] = dis.readShort();
            }
            int skipCurRoom = 0;
            for (int i = 0; i < room; skipCurRoom += _roomLength[i], ++i) {
            }
            dis.skipBytes(skipCurRoom);
            int evtCount = dis.readShort();
            String[] roomStr = null;
            if (evtCount > 0) {
                roomStr = new String[evtCount];
                for (int i = 0; i < evtCount; ++i) {
                    int strLen = dis.readShort();
                    StringBuffer str = new StringBuffer();
                    for (int j = 0; j < strLen; ++j) {
                        str.append((char)(dis.read() << 8 | dis.read() & 0xFF));
                    }
                    roomStr[i] = str.toString();
                }
            }
            int strLen = dis.readByte();
            StringBuffer str = new StringBuffer();
            for (int j = 0; j < strLen; ++j) {
                str.append((char)(dis.read() << 8 | dis.read() & 0xFF));
            }
            this.mapId = dis.readShort();
            npcItemIndex = 0;
            npcName = null;
            short boxNum = dis.readShort();
            int actorCount = dis.readShort();
            boolean[] isNull = new boolean[2];
            if (npcObject[GameWorld.getMapId(this.sceneId, this.roomId)] == null) {
                GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)] = new byte[actorCount][3];
                isNull[0] = true;
            }
            if (this.sceneId == 9) {
                GameWorld.npcPos[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)] = null;
            }
            if (npcPos[GameWorld.getMapId(this.sceneId, this.roomId)] == null) {
                GameWorld.npcPos[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)] = new short[actorCount][2];
                isNull[1] = true;
            }
            if (actorCount > 0) {
                this.npc = new GameNpc[actorCount];
                int actorId = -1;
                block15: for (int k = 0; k < actorCount; ++k) {
                    try {
                        this.npc[k] = new GameNpc();
                        short[] roomActor = new short[dis.readShort()];
                        roomActor[0] = dis.readByte();
                        roomActor[1] = dis.readShort();
                        actorId = roomActor[1];
                        roomActor[2] = dis.readShort();
                        roomActor[3] = dis.readShort();
                        roomActor[4] = dis.readShort();
                        roomActor[5] = dis.readByte();
                        roomActor[6] = dis.readByte();
                        switch (roomActor[0]) {
                            case 1: {
                                roomActor[7] = dis.readByte();
                                roomActor[8] = dis.readShort();
                                roomActor[9] = dis.readShort();
                                roomActor[10] = dis.readShort();
                                if (isNull[0] && roomActor[6] == 3) {
                                    GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][0] = (byte)roomActor[2];
                                    GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][1] = (byte)roomActor[5];
                                }
                                if (roomActor[6] == 3) {
                                    roomActor[2] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][0];
                                    roomActor[5] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][1];
                                }
                                this.npc[k].init(roomActor, k);
                                continue block15;
                            }
                            case 2: {
                                roomActor[7] = dis.readShort();
                                if (roomActor[7] == 1) {
                                    roomActor[8] = dis.readByte();
                                    roomActor[9] = dis.readByte();
                                    roomActor[10] = dis.readByte();
                                    roomActor[11] = dis.readByte();
                                    roomActor[12] = dis.readByte();
                                }
                                this.npc[k].init(roomActor, k);
                                continue block15;
                            }
                            case 0: {
                                roomActor[7] = dis.readByte();
                                roomActor[8] = dis.readByte();
                                roomActor[9] = dis.readByte();
                                roomActor[10] = dis.readByte();
                                roomActor[11] = dis.readShort();
                                roomActor[12] = dis.readShort();
                                if (isNull[0]) {
                                    GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][0] = (byte)roomActor[2];
                                    GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][1] = (byte)roomActor[5];
                                } else {
                                    if (roomActor[6] != 7 && roomActor[6] != 6) {
                                        roomActor[2] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][0];
                                    }
                                    roomActor[5] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][1];
                                }
                                if (isNull[1]) {
                                    GameWorld.npcPos[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][0] = roomActor[3];
                                    GameWorld.npcPos[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][1] = roomActor[4];
                                } else {
                                    roomActor[3] = npcPos[GameWorld.getMapId(this.sceneId, this.roomId)][k][0];
                                    roomActor[4] = npcPos[GameWorld.getMapId(this.sceneId, this.roomId)][k][1];
                                }
                                if (roomActor[1] == 324) continue block15;
                                this.npc[k].init(roomActor, k);
                                if (!isNull[0]) {
                                    if (roomActor[6] != 1) break;
                                    if (roomActor[6] != 7 && roomActor[6] != 6) {
                                        roomActor[2] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][0];
                                    }
                                    this.npc[k].setActorDir(npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][2]);
                                    this.npc[k].setState((byte)roomActor[2]);
                                    continue block15;
                                }
                                GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][2] = this.npc[k].faceDir;
                                continue block15;
                            }
                            case 3: {
                                roomActor[7] = dis.readByte();
                                roomActor[8] = dis.readByte();
                                roomActor[9] = dis.readByte();
                                roomActor[10] = dis.readShort();
                                roomActor[11] = dis.readShort();
                                if (isNull[0]) {
                                    GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][k][0] = (byte)roomActor[2];
                                } else {
                                    roomActor[2] = npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][k][0];
                                }
                                this.npc[k].init(roomActor, k);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(" k = " + k + " e = " + e + " actorId = " + actorId);
                    }
                }
                int npcNumber = dis.readShort();
                npcName = new String[npcNumber];
                for (int i = 0; i < npcNumber; ++i) {
                    StringBuffer sb = new StringBuffer();
                    int nameLenth = dis.readByte();
                    for (int j = 0; j < nameLenth; ++j) {
                        sb.append((char)(dis.readByte() << 8 | dis.readByte() & 0xFF));
                    }
                    GameWorld.npcName[i] = sb.toString();
                }
            }
            this.bug = 1;
            evtCount = dis.readShort();
            this.bug = 2;
            if (evtCount > 0) {
                this._event.init(dis, this.sceneId, this.roomId, evtCount, roomStr);
            }
            dis.close();
            in.close();
            return;
        }
        catch (Exception e) {
            System.out.println(" initRoom = " + e + " bug = " + this.bug);
        }
    }

    public void initMap() {
        this.mapName = GameWorld.STR(384 + mapIndex[this.sceneId] + this.roomId);
        this.map.initMap(this.mapId);
        this.map.setScreen(0, 0);
        this.world.setMap(this.map);
    }

    public void initCamera() {
        this.camera.setTargetCamera(this.gameplayer, cameraW, cameraH, true);
        this.world.setCamera(this.camera);
        this.world.update();
    }

    public void release() {
        this.data = null;
        this.world.clear();
        this.map.clear();
        if (this.npc != null) {
            for (int i = 0; i < this.npc.length; ++i) {
                this.npc[i].release();
                this.npc[i] = null;
            }
            this.npc = null;
        }
        backImg = null;
        goldImg = null;
        petArea = null;
        this.tempHavePet = null;
        this.pdata = null;
        this.countDownImg = null;
        this.bqSprActor.sprite.releaseSprite(6);
        this.bqSprActor = null;
        this.doorNpc.removeAllElements();
        mapGround.removeAllElements();
        mapWater.removeAllElements();
        mapSand.removeAllElements();
        mapWall.removeAllElements();
        if (vectorEvole != null) {
            vectorEvole.removeAllElements();
            vectorEvole = null;
        }
        this._ui.release();
        this._event.release();
        collNpc = (short)-1;
    }

    public void setState(byte state) {
        this.prestate = this.gamestate;
        switch (state) {
            case 0: {
                this.clearTeach();
                if (!GameEvent.isfrash) {
                    if (worldRun) {
                        this._gui.initWorldRun();
                    } else {
                        this._gui.showWorldRun();
                    }
                }
                this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
                break;
            }
            case 1: {
                this._gui.shopId = 1;
                this._gui.initShop();
                break;
            }
            case 2: {
                if (collNpc != -1 && this.npc[collNpc] != null && this.npc[GameWorld.collNpc].sprite.sprIndex == 24) {
                    this._gui.initShopBuy(4, (byte)0);
                    break;
                }
                if (collNpc == -1 || this.npc[collNpc] == null || this.npc[GameWorld.collNpc].sprite.sprIndex != 20) break;
                this._gui.initShopBuy(3, (byte)2);
                break;
            }
            case 32: {
                this._gui.shopId = (byte)3;
                this._gui.initShopBuy(3, (byte)2);
                break;
            }
            case 26: {
                this._gui.shopId = (byte)2;
                this._gui.initShopBuy(4, (byte)0);
                break;
            }
            case 3: {
                this._gui.initShopSale();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this._gui.initMount();
                break;
            }
            case 6: {
                this._gui.initGameMenu();
                break;
            }
            case 7: {
                this._gui._ui_index_2 = 0;
                this._gui.initCheckPet();
                break;
            }
            case 8: {
                this._gui.initBag();
                break;
            }
            case 9: {
                this._gui.initCourse();
                break;
            }
            case 10: {
                this._gui.initQuest();
                break;
            }
            case 22: {
                this._gui.initMsgTip();
                this._gui.setMsgTip("\u662f\u5426\u4fdd\u5b58\u6e38\u620f?");
                break;
            }
            case 11: {
                this._gui.initPetMap();
                break;
            }
            case 12: {
                this._gui.initBadge();
                break;
            }
            case 13: {
                this._gui.initGameSystem();
                break;
            }
            case 14: {
                this._gui.initBodyShop();
                break;
            }
            case 16: {
                this._gui.initBankNpc();
                break;
            }
            case 15: {
                this._gui.initPetBank();
                break;
            }
            case 17: {
                this._gui.useItem = false;
            }
            case 18: 
            case 19: {
                this._gui._ui_index_2 = 0;
                this._gui.initCheckPet();
                break;
            }
            case 20: {
                this._gui.initWorldHelp();
                break;
            }
            case 21: {
                this._gui.initWorldSetting();
                break;
            }
            case 23: {
                if (this.prestate == 7) {
                    this._gui.initDialog("", this.evoleStr, -1, -1);
                    break;
                }
                if (this.npc == null) break;
                if (this.npc[GameWorld.collNpc].sprite.sprIndex == 68) {
                    this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], "\u8981\u4e58\u8239\u53bb\u54ea?", 1, -1);
                    break;
                }
                if (this.npc[GameWorld.collNpc].autoSpeak < 0) {
                    this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], "" + dialog[0], 1, -1);
                    break;
                }
                this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], "" + dialog[this.npc[GameWorld.collNpc].autoSpeak], 1, -1);
                break;
            }
            case 27: {
                this._gui.initExchange();
                break;
            }
            case 31: {
                this._gui._ui_layer = 0;
                this.canExchange = this.canExchange();
                if (this.canExchange) {
                    if (this.startTip == this.exchangeNum.length - 1) {
                        this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], GameWorld.STR(613), 1, -1);
                        break;
                    }
                    if (this.startTip == this.exchangeNum.length - 2) {
                        this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], GameWorld.STR(612), 1, -1);
                        break;
                    }
                    int[] args = new int[]{this.exchangeNum[this.startTip], this.exchangeNum[this.startTip + 1]};
                    this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], GameWorld.STR(611, args), 1, -1);
                    break;
                }
                if (this.startTip < this.exchangeNum.length) {
                    this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], GameWorld.STR(614, this.exchangeNum[this.startTip]), 1, -1);
                    break;
                }
                this._gui.initDialog(npcName[this.npc[GameWorld.collNpc].speakName], GameWorld.STR(615), 1, -1);
                break;
            }
            case 24: {
                this._gui.initTransmit();
                break;
            }
            case 29: {
                CWAScreenChange.getInstance().init(0, 2);
                break;
            }
            case 30: {
                this._gui.initBuyEgg();
                break;
            }
            case 100: {
                this._gui.initSmsCheck(0);
                break;
            }
            case 101: {
                this._gui.initSmsBall();
                break;
            }
            case 102: {
                this._gui.initSmsGold();
                break;
            }
            case 104: {
                this._gui.initSmsBadge();
                break;
            }
            case 25: {
                this._gui.initSmsLevel();
                break;
            }
            case 28: {
                byte whereWharf = -1;
                int POST_NUM = 4;
                for (whereWharf = 0; whereWharf < this.post.length / 4 && (this.post[whereWharf * 4] != this.sceneId || this.post[whereWharf * 4 + 1] != this.roomId); whereWharf = (byte)((byte)(whereWharf + 1))) {
                }
                this._gui.initWharf(whereWharf, this.post[whereWharf * 4 + 2], this.post[whereWharf * 4 + 3]);
            }
        }
        this._gui.flash = true;
        this.gamestate = state;
        this.clearKey();
    }

    public void update() {
        if (!this.onListen) {
            return;
        }
        this.getKey();
        try {
            switch (this.gamestate) {
                case 0: {
                    this.updateWorld();
                    break;
                }
                case 1: {
                    this._gui.updateShop();
                    break;
                }
                case 2: {
                    if (collNpc != -1 && this.npc[collNpc] != null && this.npc[GameWorld.collNpc].sprite.sprIndex == 24 || this._event.curState == 0) {
                        this._gui.updateShopBuy((byte)4, (byte)0);
                        break;
                    }
                    if ((collNpc == -1 || this.npc[collNpc] == null || this.npc[GameWorld.collNpc].sprite.sprIndex != 20) && this._event.curState != 1) break;
                    this._gui.updateShopBuy((byte)3, (byte)2);
                    break;
                }
                case 32: {
                    this._gui.updateShopBuy((byte)3, (byte)2);
                    break;
                }
                case 26: {
                    this._gui.updateShopBuy((byte)4, (byte)0);
                    break;
                }
                case 3: {
                    this._gui.updateShopSale();
                    break;
                }
                case 4: {
                    if (this.openMiniMap) {
                        int len;
                        if (this.miniMapX == this.tempMapX && this.miniMapY == this.tempMapY) {
                            this.openMiniMap = false;
                        }
                        if ((len = CWATools.stance(this.miniMapX, this.miniMapY, this.tempMapX, this.tempMapY)) < this.speed) {
                            this.miniMapX = this.tempMapX;
                            this.miniMapY = this.tempMapY;
                        } else {
                            this.miniMapX += (this.tempMapX - this.miniMapX) * this.speed / len;
                            this.miniMapY += (this.tempMapY - this.miniMapY) * this.speed / len;
                        }
                    }
                    if (!this.openMiniMap) {
                        if (this.isKeyHold(16400)) {
                            if (this.miniMapX < 0) {
                                this.miniMapX += this.speed;
                            }
                        } else if (this.isKeyHold(32832)) {
                            if (this.miniMapX + this.miniMapWH[this.miniMapId * 2] * 16 * 5 > GameWorld.getWidth()) {
                                this.miniMapX -= this.speed;
                            }
                        } else if (this.isKeyHold(4100)) {
                            if (this.miniMapY < 0) {
                                this.miniMapY += this.speed;
                            }
                        } else if (this.isKeyHold(8448)) {
                            if (this.miniMapY + this.miniMapWH[this.miniMapId * 2 + 1] * 8 * 5 > GameWorld.getHeight() - 30) {
                                this.miniMapY -= this.speed;
                            }
                        } else if (this.isKeyDown(262145)) {
                            GameBattle.getInstance().battleBackGround = null;
                            this.setState((byte)0);
                        }
                    }
                    this.miniActor.updateAction();
                    for (int i = 0; i < this.miniArrow.length; ++i) {
                        this.setMiniArrow(i);
                        this.miniArrow[i].updateAction();
                    }
                    break;
                }
                case 5: {
                    this._gui.updateMount();
                    break;
                }
                case 6: {
                    this._gui.updateGameMenu();
                    break;
                }
                case 7: {
                    this._gui.updateCheckPet();
                    this.updateTeach();
                    break;
                }
                case 8: {
                    this._gui.updateBag();
                    break;
                }
                case 9: {
                    this._gui.updateCourse();
                    break;
                }
                case 10: {
                    this._gui.updateQuest();
                    break;
                }
                case 22: {
                    this._gui.updateSmsSave();
                    break;
                }
                case 11: {
                    this._gui.updatePetMap();
                    break;
                }
                case 12: {
                    this._gui.updateBadge();
                    break;
                }
                case 13: {
                    this._gui.updateGameSystem();
                    break;
                }
                case 14: {
                    this._gui.updateBodyShop();
                    break;
                }
                case 16: {
                    this._gui.updateBankNpc();
                    break;
                }
                case 15: {
                    this._gui.updatePetBank();
                    break;
                }
                case 17: {
                    this._gui.updateWorldPetItem();
                    break;
                }
                case 18: {
                    this._gui.updateWorldPetEquip();
                    break;
                }
                case 19: {
                    this._gui.updateWorldPetStone();
                    break;
                }
                case 20: {
                    this._gui.updateWorldHelp();
                    break;
                }
                case 21: {
                    this._gui.updateWorldSetting();
                    break;
                }
                case 23: {
                    this.updateGameDialog();
                    break;
                }
                case 31: {
                    this.updateNpcExc();
                    break;
                }
                case 27: {
                    this._gui.updateExchange();
                    break;
                }
                case 24: {
                    this._gui.updateTransmit();
                    break;
                }
                case 28: {
                    this._gui.updateWharf();
                    break;
                }
                case 29: {
                    CWAScreenChange.getInstance().update();
                    if (!CWAScreenChange.getInstance().isScreenOver) break;
                    CWAScreenChange.getInstance().screenType = -1;
                    GameManager.getInstance().setState((byte)23);
                    break;
                }
                case 30: {
                    this._gui.updateBuyEgg();
                    break;
                }
                case 100: 
                case 101: 
                case 102: 
                case 104: {
                    this._gui.updateSms();
                    break;
                }
                case 25: {
                    this._gui.updateSmsLevel();
                }
            }
            if (this.gamestate == 0 && !this._event.isEventRun() && tipEvole == 0 && vectorEvole != null && vectorEvole.size() > 0) {
                if (this.count >= vectorEvole.size()) {
                    vectorEvole.removeAllElements();
                    this.count = 0;
                    tipEvole = 1;
                } else if (this._gui.isCloseItemTips()) {
                    int[] temp = (int[])vectorEvole.elementAt(this.count);
                    String str = "\u8fdb\u5316";
                    if (CWADataManager.DataBase[0][CWADataManager.getDataBase((byte)0, (short)temp[0], (byte)19)][2] == 3) {
                        str = "\u5f02\u5316";
                    }
                    if (!isEvoleTip && evoleData[0] != -1) {
                        if (this.count == vectorEvole.size() - 1) {
                            this._gui.initMsgWarm();
                            this._gui.setMsgWarm("\u60a8\u7684#2" + GameWorld.STR(temp[1]) + "#0\u8fbe\u5230\u53ef\u4ee5" + str + "\u7684\u6761\u4ef6\u4e86", "\u63095\u952e\u7ee7\u7eed");
                        } else {
                            this._gui.boxItemTips("#2" + GameWorld.STR(temp[1]) + "#0\u53ef\u4ee5" + str + "\u4e86");
                        }
                    } else {
                        this._gui.boxItemTips("#2" + GameWorld.STR(temp[1]) + "#0\u53ef\u4ee5" + str + "\u4e86");
                    }
                    ++this.count;
                }
            }
            this._ui.update();
            if (effect != null) {
                effect.update();
            }
        }
        catch (Exception e) {
            System.out.println(" gamestate == " + this.gamestate + " e = " + e.toString());
            CWADebug.setErrorMsg(e, " ups = " + this.gamestate);
        }
    }

    public void backRender(Graphics g, int x, int y, int w, int h) {
        g.setColor(GameWorld.getBackColor());
        int px = x * 16 - CWAMap.getInstance().leftTopX;
        int py = y * 16 - CWAMap.getInstance().leftTopY;
        g.fillRect(px, py, (w - x) * 16, (h - y) * 16);
    }

    public void renderGold(Graphics g) {
        for (int i = 0; i < this.gameplayer.getGold.size(); ++i) {
            int[] gold = (int[])this.gameplayer.getGold.elementAt(i);
            CWATools.drawStringBorder(g, "+" + gold[0], 16704699, gold[1] + 12 - this.map.leftTopX, gold[2] - gold[3] - this.map.leftTopY, 17, 17, this._ui.fonts, 2);
            g.drawImage(goldImg, gold[1] - this.map.leftTopX - 6, gold[2] - gold[3] - this.map.leftTopY, 20);
        }
    }

    public void setMiniArrow(int dir) {
        switch (dir) {
            case 0: {
                if (this.miniMapY >= 0) {
                    this.miniArrow[dir].stop();
                    break;
                }
                this.miniArrow[dir].start();
                break;
            }
            case 1: {
                if (this.miniMapY + this.miniMapWH[this.miniMapId * 2 + 1] * 8 * 5 <= GameWorld.getHeight()) {
                    this.miniArrow[dir].stop();
                    break;
                }
                this.miniArrow[dir].start();
                break;
            }
            case 2: {
                if (this.miniMapX >= 0) {
                    this.miniArrow[dir].stop();
                    break;
                }
                this.miniArrow[dir].start();
                break;
            }
            case 3: {
                if (this.miniMapX + this.miniMapWH[this.miniMapId * 2] * 16 * 5 <= GameWorld.getWidth()) {
                    this.miniArrow[dir].stop();
                    break;
                }
                this.miniArrow[dir].start();
            }
        }
    }

    public void openMiniMap() {
        byte i;
        boolean open = true;
        for (i = 0; i < miniMap.length; ++i) {
            if (miniMap[i] != this.sceneId) continue;
            open = false;
            break;
        }
        if (open) {
            for (i = 0; i < this.miniMapData[this.miniMapId].length / 7; i = (byte)((byte)(i + 1))) {
                if (this.miniMapData[this.miniMapId][i * 7 + 2] != this.sceneId || this.miniMapData[this.miniMapId][i * 7 + 3] != this.roomId) continue;
                this.miniMapIndex = i;
                break;
            }
            this.tempMapX = (GameWorld.getWidth() >> 1) - this.miniMapData[this.miniMapId][this.miniMapIndex * 7] * 16 - 40;
            this.tempMapY = (GameWorld.getHeight() >> 1) - this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 1] * 8 - 20;
            this.openMiniMap = true;
            if (this.miniActor == null) {
                this.miniActor = new CWASprActor();
                this.miniActor.initSprite(0, false);
                this.miniActor.setAction((byte)3, (byte)-1, false);
                this.miniActor.start();
            }
            if (this.miniArrow == null) {
                this.miniArrow = new CWASprActor[4];
                for (i = 0; i < this.miniArrow.length; i = (byte)(i + 1)) {
                    this.miniArrow[i] = new CWASprActor();
                    this.miniArrow[i].initSprite(223, false);
                    if (i <= 1) {
                        this.miniArrow[i].setPosition(GameWorld.getWidth() >> 1, 20 + i * (GameWorld.getHeight() - 20));
                    } else {
                        this.miniArrow[i].setPosition(10 + i % 2 * (GameWorld.getWidth() - 20), GameWorld.getHeight() >> 1);
                    }
                    this.miniArrow[i].setAction(i, (byte)-1, false);
                    this.setMiniArrow(i);
                }
            }
            GameBattle.getInstance().battleBackGround = Image.createImage((int)CWACommon.getWidth(), (int)CWACommon.getHeight());
            Graphics g = GameBattle.getInstance().battleBackGround.getGraphics();
            this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
            this.world.renderMap(g);
            this.setState((byte)4);
        } else {
            this._gui.boxItemTips("\u8be5\u533a\u57df\u6ca1\u6709\u5730\u56fe");
        }
    }

    public void renderMiniMap(Graphics g) {
        g.drawImage(GameBattle.getInstance().battleBackGround, 0, 0, 20);
        for (int j = 0; j < this.miniMapData[this.miniMapId].length / 7; ++j) {
            if (this.sceneId == this.miniMapData[this.miniMapId][j * 7 + 2] && this.roomId == this.miniMapData[this.miniMapId][j * 7 + 3]) {
                g.setColor(188, 122, 255);
            } else {
                g.setColor(this.miniColor[this.miniMapId * 2]);
            }
            g.fillRoundRect(this.miniMapX + this.miniMapData[this.miniMapId][j * 7] * 16, this.miniMapY + this.miniMapData[this.miniMapId][j * 7 + 1] * 8, this.miniMapData[this.miniMapId][j * 7 + 5] * 16, this.miniMapData[this.miniMapId][j * 7 + 6] * 8, 12, 12);
            g.setColor(0);
            g.drawRoundRect(this.miniMapX + this.miniMapData[this.miniMapId][j * 7] * 16, this.miniMapY + this.miniMapData[this.miniMapId][j * 7 + 1] * 8, this.miniMapData[this.miniMapId][j * 7 + 5] * 16, this.miniMapData[this.miniMapId][j * 7 + 6] * 8, 12, 12);
            if (j == this.miniMapIndex) {
                this.miniActor.setPosition(this.miniMapX + this.miniMapData[this.miniMapId][this.miniMapIndex * 7] * 16 + 16 * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 5] / 2, this.miniMapY + this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 1] * 8 + 8 * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 6] / 2 + 20);
                this.miniActor.drawSprite(g, 0, 0);
            }
            CWATools.drawStringBorder(g, GameWorld.STR(this.miniMapData[this.miniMapId][j * 7 + 4]), this.miniColor[this.miniMapId * 2 + 1], this.miniMapX + this.miniMapData[this.miniMapId][j * 7] * 16 + 16 * this.miniMapData[this.miniMapId][j * 7 + 5] / 2, this.miniMapY + this.miniMapData[this.miniMapId][j * 7 + 1] * 8 + 8 * this.miniMapData[this.miniMapId][j * 7 + 6] / 2 - this._ui.fonts.getFontSize() / 2, 17, 17, this._ui.fonts, -1);
        }
        int x = 0;
        int y = 0;
        g.setColor(65280);
        for (int i = 0; i < this.doorNpc.size(); ++i) {
            x = ((GameNpc)this.doorNpc.elementAt(i)).getActorX() * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 5] * 16 / CWAMap.getInstance().mapW + this.miniMapData[this.miniMapId][this.miniMapIndex * 7] * 16 + this.miniMapX;
            y = ((GameNpc)this.doorNpc.elementAt(i)).getActorY() * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 6] * 8 / CWAMap.getInstance().mapH + this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 1] * 8 + this.miniMapY;
            if (((GameNpc)this.doorNpc.elementAt(i)).getRoleState() == 0 || ((GameNpc)this.doorNpc.elementAt(i)).getRoleState() == 1) {
                g.fillRect(x, y - 2, 9, 3);
                continue;
            }
            g.fillRect(x, y - 5, 3, 9);
        }
        if (this.roadIndex != -1) {
            x = this.roadData[this.roadIndex * 4 + 2] * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 5] * 16 / CWAMap.getInstance().mapW + this.miniMapData[this.miniMapId][this.miniMapIndex * 7] * 16 + this.miniMapX;
            y = this.roadData[this.roadIndex * 4 + 3] * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 6] * 8 / CWAMap.getInstance().mapH + this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 1] * 8 + this.miniMapY;
            g.setColor(0xFF0000);
            g.fillRect(x, y, 6, 6);
        }
        if (this.boatIndex != -1) {
            x = this.boatData[this.boatIndex * 4 + 2] * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 5] * 16 / CWAMap.getInstance().mapW + this.miniMapData[this.miniMapId][this.miniMapIndex * 7] * 16 + this.miniMapX;
            y = this.boatData[this.boatIndex * 4 + 3] * this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 6] * 8 / CWAMap.getInstance().mapH + this.miniMapData[this.miniMapId][this.miniMapIndex * 7 + 1] * 8 + this.miniMapY;
            g.setColor(2758133);
            g.fillRect(x, y, 6, 6);
        }
        g.setColor(1862801);
        g.fillRect(0, GameWorld.getHeight() - 30, (int)GameWorld.getWidth(), 30);
        g.setColor(65280);
        g.fillRect(25, GameWorld.getHeight() - 22, 16, 16);
        g.drawString("\u51fa\u5165\u53e3", 45, GameWorld.getHeight() - 25, 20);
        g.setColor(2758133);
        g.fillRect(90, GameWorld.getHeight() - 22, 16, 16);
        g.drawString("\u7801\u5934", 115, GameWorld.getHeight() - 25, 20);
        g.setColor(0xFF0000);
        g.fillRect(155, GameWorld.getHeight() - 22, 16, 16);
        g.drawString("\u9053\u9986\u5165\u53e3", 175, GameWorld.getHeight() - 25, 20);
    }

    public void render(Graphics g) {
        try {
            if (this.gamestate == 4) {
                this.renderMiniMap(g);
            } else {
                if (this.gamestate == 0 || this.gamestate == 23 || this._gui.flash) {
                    this.world.render(g, 1);
                    CWAScreenChange.getInstance().drawStar(g);
                    if (this._gui.flash) {
                        this._gui.flash = false;
                    }
                }
                if (CWAScreenChange.getInstance().alphaType != -1) {
                    if (this.camera.target instanceof GamePlayer) {
                        CWAScreenChange.getInstance().setAlphaSrc(this.camera.getActorX() - CWAMap.getInstance().leftTopX, this.camera.getActorY() - CWAMap.getInstance().leftTopY - this.actorH[this.gameplayer.rideIndex + 1]);
                    } else {
                        CWAScreenChange.getInstance().setAlphaSrc(this.camera.getActorX() - CWAMap.getInstance().leftTopX, this.camera.getActorY() - CWAMap.getInstance().leftTopY - 20);
                    }
                    CWAScreenChange.getInstance().drawSquare(g, 0, 0);
                }
                this._event.drawBq(g);
                this._ui.draw(g);
                if (effect != null) {
                    effect.render(g, 0, 0);
                }
                this.renderGold(g);
                if (!this._gui.msgSwitch() && !GameWorld.isTeach()) {
                    this._event.render(g);
                }
                if (this.sceneId == 3 && this.roomId == 7 && this.gamestate == 0) {
                    if (this._event.countDown > 0) {
                        if (this.countDownImg != null) {
                            g.drawImage(this.countDownImg[this._event.countDown - 1], GameWorld.getWidth() >> 1, GameWorld.getHeight() >> 1, 3);
                        }
                    } else if (GameManager.getInstance().curTime != 0L) {
                        g.setColor(896);
                        g.setFont(GameWorld.getFontLarge());
                        g.drawString(this.getTimeFormat(GameManager.getInstance().curTime - GameManager.getInstance().begainTime)[0], 10, 40, 20);
                    }
                }
            }
        }
        catch (Exception e) {
            CWADebug.setErrorMsg(e, "res = " + this.gamestate);
        }
    }

    public void updateWorld() {
        if (!this._event.isEventRun() && this.gameplayer.getRoleState() < 5 && !this._gui.msgSwitch() && this._gui.isCloseMsgWarm()) {
            if (this.isKeyHold(4100)) {
                this.gameplayer.setState((byte)1, (byte)2);
            } else if (this.isKeyHold(8448)) {
                this.gameplayer.setState((byte)1, (byte)0);
            } else if (this.isKeyHold(16400)) {
                this.gameplayer.setState((byte)1, (byte)3);
            } else if (this.isKeyHold(32832)) {
                this.gameplayer.setState((byte)1, (byte)1);
            }
            if (this.isKeyDown(65568)) {
                if (collNpc != -1) {
                    this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
                    if (GameEvent.eventTalk) {
                        GameEvent.begainTalk = true;
                        GameEvent.eventTalk = false;
                    } else {
                        if (this.npc[GameWorld.collNpc].sprite.sprIndex <= 85) {
                            this.npc[GameWorld.collNpc].preFaceDir = this.npc[GameWorld.collNpc].faceDir;
                            switch (this.gameplayer.faceDir) {
                                case 0: {
                                    this.npc[collNpc].setActorDir((byte)2);
                                    break;
                                }
                                case 2: {
                                    this.npc[collNpc].setActorDir((byte)0);
                                    break;
                                }
                                case 3: {
                                    this.npc[collNpc].setActorDir((byte)1);
                                    break;
                                }
                                case 1: {
                                    this.npc[collNpc].setActorDir((byte)3);
                                }
                            }
                            this.npc[collNpc].setState((byte)0);
                        }
                        if (this.npc[GameWorld.collNpc].sprite.sprIndex == 17) {
                            this._gui._ui_index_4 = 0;
                            this.setState((byte)27);
                        } else {
                            this.setState((byte)23);
                        }
                    }
                    GameWorld.getInstance().removeBq(0);
                } else if ((GameNpc)this.gameplayer.target != null && ((GameNpc)this.gameplayer.target).actorType == 3) {
                    this.gameplayer.itemTarget();
                } else {
                    this.gameplayer.bombTarget();
                }
            }
            if (this.isKeyUp(61780)) {
                this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
            }
            if (this.isKeyDown(262144)) {
                this.keyTeach();
                this._gui._ui_index_1 = 0;
                this.setState((byte)6);
            } else if (this.isKeyDown(131072)) {
                this._gui._ui_index_1 = 0;
                this.setState((byte)13);
            } else if (this.isKeyDown(1)) {
                this.openMiniMap();
            } else if (this.isKeyDown(2)) {
                this._gui._ui_index_1 = 0;
                this.setState((byte)10);
            } else if (this.isKeyDown(8)) {
                this._gui._ui_index_1 = 1;
                this.setState((byte)10);
            } else if (this.isKeyDown(512)) {
                if (this.sceneId == 3 && this.roomId == 7) {
                    return;
                }
                if (this.gameplayer.rideIndex >= 0 && this._event.ride) {
                    if (this.gameplayer.canDownPet()) {
                        this.gameplayer.downPet();
                    }
                } else if (this._event.ride) {
                    this.setState((byte)5);
                }
            }
        }
        this.gameplayer.update();
        for (int i = 0; i < this.npc.length; ++i) {
            if (this.npc[i] == null) continue;
            this.npc[i].update();
        }
        if (this.followSp != null && this.followSp.isAction()) {
            this.followSp.followTarget(this.befollowSp.sprite, this.followSp.sprite);
        }
        this.gameplayer.afterDir = this.gameplayer.faceDir;
        this.world.update();
        this.checkEnemy();
        if (haveLearn == 1 && isSMSCheck) {
            this.setState((byte)25);
        }
        if (!this._event.isEventRun() && !this._gui.isCloseMsgWarm() && !isEvoleTip && evoleData[0] != -1 && this.isKeyDown(32)) {
            teachId = (byte)4;
            isEvoleTip = true;
            this._gui._ui_index_2 = 0;
            this.setState((byte)7);
            this._gui.closeMsgWarm();
        }
        if (!this._gui.msgSwitch() && eggHatch == 0 && this.canHatch()) {
            this._gui.boxItemTips("\u5ba0\u7269\u86cb\u53ef\u4ee5\u8fdb\u884c\u751f\u4ea7\u4e86");
            eggHatch = 1;
        }
        this._event.updateBq();
        this._gui.updateWorldRun();
        this.updateGetGold();
        if (!this._gui.msgSwitch()) {
            this._event.update();
            this.updateTeach();
        }
    }

    public void updateGetGold() {
        for (int i = 0; i < this.gameplayer.getGold.size(); ++i) {
            int[] gold = (int[])this.gameplayer.getGold.elementAt(i);
            gold[3] = gold[3] + 5;
            if (gold[3] <= 30) continue;
            this.gameplayer.getGold.removeElementAt(i);
            --i;
        }
    }

    public void updateGameDialog() {
        if (this._gui.updateDialog(headPos, headIndex) && this.isKeyDown(196640)) {
            if (CWATools.curPage < CWATools.maxPage()) {
                CWATools.addPage();
                this._gui.setDialog(CWATools.curPage);
            } else {
                this._gui.closeDialog();
                if (this.prestate == 7) {
                    this.setState((byte)0);
                } else {
                    if (this.npc[GameWorld.collNpc].sprite.sprIndex <= 85) {
                        this.npc[collNpc].setActorDir(this.npc[GameWorld.collNpc].preFaceDir);
                    }
                    this.npc[collNpc].setState((byte)0);
                    this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
                    if (this.npc[GameWorld.collNpc].sprite.sprIndex == 24 || this.npc[GameWorld.collNpc].sprite.sprIndex == 20) {
                        this.setState((byte)1);
                    } else if (this.npc[GameWorld.collNpc].sprite.sprIndex == 25) {
                        this.setState((byte)16);
                    } else if (this.npc[GameWorld.collNpc].sprite.sprIndex == 68) {
                        this.setState((byte)28);
                    } else {
                        if (collNpc != -1) {
                            GameWorld.getInstance().setBq((byte)13, GameWorld.getInstance().npc[GameWorld.collNpc].actorX, GameWorld.getInstance().npc[GameWorld.collNpc].actorY - 40, GameWorld.getInstance().npc[collNpc]);
                        }
                        this.setState((byte)0);
                    }
                }
            }
        }
        this.world.update();
    }

    public void updateNpcExc() {
        if (this._gui.updateDialog(headPos, headIndex) && !this._gui.msgSwitch() && this.isKeyDown(196640)) {
            if (CWATools.curPage < CWATools.maxPage()) {
                CWATools.addPage();
                this._gui.setDialog(CWATools.curPage);
            } else {
                this._gui.closeDialog();
                if (this.npc[GameWorld.collNpc].sprite.sprIndex <= 85) {
                    this.npc[collNpc].setActorDir(this.npc[GameWorld.collNpc].preFaceDir);
                }
                this.npc[collNpc].setState((byte)0);
                this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
                this._gui._ui_layer = 1;
                if (this.canExchange) {
                    this.exchange[this.startTip] = true;
                    if (this.startTip < this.exchangeNum.length - 1) {
                        this.gameplayer.addBadge(1);
                        this._gui.boxItemTips("\u83b7\u5f971\u679a\u5fbd\u7ae0");
                    } else if (this.gameplayer.getPokBadgeValue((byte)7, (byte)0) == 0) {
                        this._gui.boxItemTips("\u83b7\u5f97\u9ec4\u91d1\u52cb\u7ae0");
                        this.gameplayer.setPokBadgeValue((byte)7, (byte)0, (byte)2);
                        GameEvent.mainQuestIndex = (byte)(GameEvent.mainQuestStr.length / 2);
                    }
                }
            }
        }
        this._gui.updateOpenBox();
        if (this._gui._ui_layer == 1 && this._gui.isCloseItemTips()) {
            this._gui._ui_index_4 = 0;
            this.setState((byte)27);
        }
        this.world.update();
    }

    public boolean setEnemy() {
        byte tile = CWAMap.getInstance().getMapTile(0, GamePlayer.getInstance().actorX, GamePlayer.getInstance().actorY);
        int[] temp = null;
        battleArea = tile;
        switch (tile) {
            case 0: {
                if (mapGround.size() <= 0) {
                    return false;
                }
                temp = (int[])mapGround.elementAt(CWATools.getRandom(mapGround.size()));
                break;
            }
            case 1: {
                if (mapWall.size() <= 0) {
                    return false;
                }
                temp = (int[])mapWall.elementAt(CWATools.getRandom(mapWall.size()));
                break;
            }
            case 2: {
                if (mapWater.size() <= 0) {
                    return false;
                }
                temp = (int[])mapWater.elementAt(CWATools.getRandom(mapWater.size()));
                break;
            }
            case 4: {
                if (mapSand.size() <= 0) {
                    return false;
                }
                temp = (int[])mapSand.elementAt(CWATools.getRandom(mapSand.size()));
                break;
            }
            case 3: {
                return false;
            }
        }
        return this.setEnemy(temp);
    }

    public boolean setEnemy(int[] temp) {
        int ou = -1;
        if (temp[2] != -1) {
            ou = CWATools.getRandom(temp[2], temp[3]);
        }
        if (!this.havePetEnemy()) {
            return false;
        }
        int level = CWATools.getRandom(petArea[mapIndex[this.sceneId] + this.roomId][3], petArea[mapIndex[this.sceneId] + this.roomId][4]);
        this.gameplayer.setPokPetMapValue((byte)CWADataManager.DataBase[0][temp[0]][1], temp[0], (byte)1);
        GameBattle.getInstance().setEnemy(new int[][]{{temp[0], level, ou}});
        return true;
    }

    public void checkSignEnemy(int npcId) {
        for (int j = 0; j < (petArea[GameWorld.getMapId(this.sceneId, this.roomId)].length - 5) / 4; ++j) {
            if (npcId != petArea[GameWorld.getMapId(this.sceneId, this.roomId)][5 + j * 4 + 4]) continue;
            int[] temp = new int[4];
            System.arraycopy(petArea[GameWorld.getMapId(this.sceneId, this.roomId)], 5 + j * 4, temp, 0, temp.length);
            this.setEnemy(temp);
            this.intoBattle();
            break;
        }
    }

    public void showSignEnemy(boolean isShow) {
        if (this.isShow == isShow) {
            return;
        }
        if (!this.havePetEnemy()) {
            return;
        }
        this.isShow = isShow;
        int hideNpcId = -1;
        for (int j = 0; j < (petArea[GameWorld.getMapId(this.sceneId, this.roomId)].length - 5) / 4; ++j) {
            hideNpcId = petArea[GameWorld.getMapId(this.sceneId, this.roomId)][5 + j * 4 + 4];
            if (isShow) {
                this.npc[hideNpcId].start();
                continue;
            }
            this.npc[hideNpcId].stop();
        }
    }

    public void checkEnemy() {
        if (this.gameplayer.isBattle()) {
            if (!this.setEnemy()) {
                this.gameplayer.passometer = this.gameplayer.getPassometer();
                return;
            }
            GameEvent.eventEscape = this.sceneId != 3 || this.roomId != 7;
            this.intoBattle();
        }
    }

    public void intoBattle() {
        GameBattle gameBattle = GameBattle.getInstance();
        GameBattle.getInstance().getClass();
        gameBattle.playMode = 0;
        GameBattle.getInstance().battleType = 0;
        GameBattle.getInstance().battleBackGround = Image.createImage((int)CWACommon.getWidth(), (int)CWACommon.getHeight());
        Graphics g = GameBattle.getInstance().battleBackGround.getGraphics();
        this.world.renderMap(g);
        this.gameplayer.setState((byte)0, this.gameplayer.faceDir);
        this.gameplayer.passometer = this.gameplayer.getPassometer();
        GameManager.getInstance().setState((byte)12);
    }

    public static int getMapId(int sceneId, int roomId) {
        return mapIndex[sceneId] + roomId;
    }

    public void setNpcObject(int npcId, int saveType, byte saveValue, boolean save) {
        if (npcObject[GameWorld.getMapId(this.sceneId, this.roomId)][npcId] != null) {
            GameWorld.saveFlag[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][0] = save;
            GameWorld.npcObject[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][npcId][saveType] = saveValue;
        }
    }

    public void setNpcPos(int npcId, int saveType, int saveValue) {
        if (npcPos[GameWorld.getMapId(this.sceneId, this.roomId)][npcId] != null) {
            GameWorld.npcPos[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][npcId][saveType] = (short)saveValue;
        }
    }

    public boolean removeSpBq(int npcId) {
        for (int i = 0; i < this.boss.length / 4; ++i) {
            if (this.boss[i * 4] != this.sceneId || this.boss[i * 4 + 1] != this.roomId || npcId != this.boss[i * 4 + 2] || this.gameplayer.pokBadge[this.boss[i * 4 + 3]][0] != 2) continue;
            return true;
        }
        return false;
    }

    public boolean canHatch() {
        return this.gameplayer.hatchPetNum == 0 && eggExp >= 10 || this.gameplayer.hatchPetNum > 0 && eggExp >= 30;
    }

    private void tipExchange() {
        this.startTip = (byte)this.exchange.length;
        for (int i = 0; i < this.exchange.length; ++i) {
            if (this.exchange[i]) continue;
            this.startTip = (byte)i;
            break;
        }
        boolean change = false;
        for (int j = this.exchangeNum.length - 1; j >= 0; --j) {
            if (this.gameplayer.pokPetTypeNum < this.exchangeNum[j]) continue;
            this.endTip = (byte)j;
            change = true;
            break;
        }
        if (!change) {
            this.endTip = (byte)-1;
        }
    }

    private boolean canExchange() {
        boolean isCan = false;
        this.tipExchange();
        if (this.endTip >= this.startTip) {
            isCan = true;
        }
        return isCan;
    }

    public void updateTeach() {
        switch (teachId) {
            case 1: {
                if (teachStep == 0) {
                    GameWorld.setTeachKey(0, 1);
                    if (isSMSCheck) {
                        GameWorld.setTeachKey(1, 1);
                    } else {
                        GameWorld.setTeachKey(1, 0);
                    }
                    teachStep = (byte)(teachStep + 1);
                    this.setState((byte)6);
                    break;
                }
                if (teachStep == 1) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2\u67e5\u770b\u5ba0\u7269");
                    break;
                }
                if (teachStep == 3) {
                    GameWorld.setTeachKey(1, 0);
                    String name = GameWorld.STR(CWADataManager.DataBase[0][this.gameplayer.pokPet[CWACommon.getTeachKey(1)].getPetId()][0]);
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2" + name);
                    break;
                }
                if (teachStep == 4) {
                    if (!this._gui.isCloseTaskTips() || !CWACommon.canKeyIndex(this._gui._ui_index_1, 0)) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u6309#25\u952e");
                    break;
                }
                if (teachStep == 6) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2\u9970\u54c1");
                    break;
                }
                if (teachStep == 8) {
                    GameWorld.setTeachKey(1, 0);
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u6309#25\u952e#1\u88c5\u4e0a\u9970\u54c1");
                    break;
                }
                if (teachStep != 10) break;
                this._gui.taskTips("\u6309#2\u53f3\u8f6f\u952e#0\u8fd4\u56de");
                GameWorld.setTeachKey(1, -1);
                GameWorld.setTeachKey(0, 2);
                teachStep = (byte)(teachStep + 1);
                break;
            }
            case 3: {
                if (teachStep == 0) {
                    teachStep = (byte)(teachStep + 1);
                    GameWorld.setTeachKey(1, 0);
                    GameWorld.setTeachKey(0, 1);
                    this.setState((byte)1);
                    break;
                }
                if (teachStep == 1) {
                    if (!GameWorld.canKeyIndex(this._gui._ui_index_1, 0)) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u70b9\u51fb#2\u8d2d\u4e70");
                    break;
                }
                if (teachStep == 3) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8ba9\u6211\u4eec\u5148\u8d2d\u4e70\u4e00\u4e2a#2\u7ea2\u8272\u6d77\u87ba#1\u5427");
                    break;
                }
                if (teachStep == 4) {
                    if (!this._gui.isCloseTaskTips()) break;
                    GameWorld.setTeachKey(1, 1);
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep == 5) {
                    if (!GameWorld.canKeyIndex(this._gui._ui_index_1, 0)) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u6309#25\u952e#1\u8d2d\u4e70");
                    break;
                }
                if (teachStep != 7) break;
                this._gui.taskTips("\u8bf7\u6309#2\u53f3\u8f6f\u952e#1\u8fd4\u56de");
                GameWorld.setTeachKey(1, -1);
                GameWorld.setTeachKey(0, 2);
                teachStep = (byte)(teachStep + 1);
                break;
            }
            case 4: {
                if (teachStep == 0) {
                    GameWorld.setTeachKey(0, 1);
                    for (int i = 0; i < this.gameplayer.pokPetSize; ++i) {
                        if (this.gameplayer.pokPet[i].getLevel() != evoleData[0] || this.gameplayer.pokPet[i].getPetId() != evoleData[1]) continue;
                        GameWorld.setTeachKey(1, i);
                        break;
                    }
                    teachStep = (byte)(teachStep + 1);
                    String name = GameWorld.STR(CWADataManager.getDataBase((byte)0, (short)this.gameplayer.pokPet[CWACommon.getTeachKey(1)].getPetId(), (byte)0));
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2" + name + "#0\u8fdb\u884c\u8fdb\u5316");
                    break;
                }
                if (teachStep == 1) {
                    if (!GameWorld.canKeyIndex(this._gui._ui_index_1, 0) || !this._gui.isCloseTaskTips()) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u6309#25\u952e#0\u7ee7\u7eed");
                    break;
                }
                if (teachStep == 3) {
                    if (!GameWorld.canKeyIndex(this._gui._ui_index_2, 0)) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u6309#25\u952e#0\u8fdb\u5165\u8fdb\u5316\u754c\u9762");
                    break;
                }
                if (teachStep != 5) break;
                teachStep = (byte)(teachStep + 1);
                this._gui.taskTips("\u6309#2\u5de6\u8f6f\u952e#0\u8fdb\u5316\u5427");
                break;
            }
            case 6: {
                if (teachStep == 0) {
                    teachStep = (byte)(teachStep + 1);
                    GameWorld.setTeachKey(0, 1);
                    GameWorld.setTeachKey(1, 2);
                    this.setState((byte)6);
                    break;
                }
                if (teachStep == 1) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2\u80cc\u5305#0\u9879");
                    break;
                }
                if (teachStep == 2) {
                    if (!this._gui.isCloseTaskTips() || !GameWorld.canKeyIndex(this._gui._ui_index_1, 0)) break;
                    this._gui.taskTips("\u6309#2\u5de6\u8f6f\u952e#0\u8fdb\u5165\u9009\u9879");
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep == 4) {
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u8bf7\u4f7f\u7528#2\u52a0\u901f\u836f#0\u9053\u5177");
                    break;
                }
                if (teachStep == 5) {
                    if (!this._gui.isCloseTaskTips() || !GameWorld.canKeyIndex(this._gui.curIndex, 0)) break;
                    teachStep = (byte)(teachStep + 1);
                    this._gui.taskTips("\u6309#2\u5de6\u8f6f\u952e#0\u4f7f\u7528");
                    break;
                }
                if (teachStep == 7) {
                    teachStep = (byte)(teachStep + 1);
                    GameWorld.setTeachKey(0, 3);
                    GameWorld.setTeachKey(2, 1);
                    GameWorld.setTeachKey(1, 3);
                    this._gui.taskTips("\u8bf7\u9009\u62e9#2\u7279\u6b8a\u9053\u5177\u9879#0\u5b75\u5316\u5ba0\u7269\u86cb");
                    break;
                }
                if (teachStep == 9) {
                    if (!this._gui.isCloseTaskTips() || !GameWorld.canKeyIndex(this._gui.curIndex, 0)) break;
                    GameWorld.setTeachKey(0, 1);
                    this._gui.taskTips("\u6309#2\u5de6\u8f6f\u952e#0\u8fdb\u884c\u5b75\u5316");
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep != 11) break;
                teachStep = (byte)(teachStep + 1);
                GameWorld.setTeachKey(0, 2);
                GameWorld.setTeachKey(1, -1);
                this._gui.taskTips("\u6309#2\u53f3\u8f6f\u952e#0\u8fd4\u56de");
            }
        }
    }

    public void keyTeach() {
        switch (teachId) {
            case 1: {
                if (teachStep == 2 || teachStep == 7) {
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep == 5) {
                    GameWorld.setTeachKey(1, 2);
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep != 9) break;
                teachStep = (byte)(teachStep + 1);
                this._event.eventState[GameWorld.getMapId((int)this.sceneId, (int)this.roomId)][this._event.getCurEventId()] = 3;
                if (this._event.roomEvent == null) break;
                this._event.roomEvent[this._event.getCurEventId()].setState((byte)3);
                break;
            }
            case 3: {
                if (teachStep != 6 && teachStep != 2) break;
                teachStep = (byte)(teachStep + 1);
                break;
            }
            case 4: {
                if (teachStep == 2) {
                    GameWorld.setTeachKey(1, 5);
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep == 4) {
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep != 6) break;
                this._gui.taskTips("\u6309#2\u53f3\u8f6f\u952e#0\u8fd4\u56de");
                GameWorld.setTeachKey(1, -1);
                GameWorld.setTeachKey(0, 2);
                teachStep = (byte)(teachStep + 1);
                break;
            }
            case 6: {
                if (teachStep == 3) {
                    int[] temp = null;
                    for (int i = 0; i < this.gameplayer.pokConsumable.size() + this.gameplayer.pokBall.size(); ++i) {
                        if (i < this.gameplayer.pokBall.size()) continue;
                        if (this.gameplayer.pokConsumable.size() <= 0) break;
                        temp = (int[])this.gameplayer.pokConsumable.elementAt(i - this.gameplayer.pokBall.size());
                        if (temp[0] != 14) continue;
                        GameWorld.setTeachKey(1, i);
                        break;
                    }
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep == 6 || teachStep == 10) {
                    teachStep = (byte)(teachStep + 1);
                    break;
                }
                if (teachStep != 8 || !GameWorld.canKeyIndex(this._gui._ui_index_1, 1)) break;
                this._gui.taskTips("\u8bf7\u9009\u62e9#2\u5ba0\u7269\u86cb#0\u8fdb\u884c\u5b75\u5316");
                GameWorld.setTeachKey(2, 0);
                GameWorld.setTeachKey(1, 0);
                teachStep = (byte)(teachStep + 1);
            }
        }
    }

    protected String[] getTimeFormat(long time) {
        String[] hmTime = new String[]{"0'00\"000", "0'00\"000"};
        long ms = time % 1000L;
        long sec = (time /= 1000L) % 60L;
        long smm = (time /= 60L) % 60L;
        long hou = time / 60L;
        String sms = ms < 10L ? "00" + ms : (ms < 100L ? "0" + ms : "" + ms);
        String ss = sec < 10L ? "0" + sec + "\"" : "" + sec + "\"";
        String sm = time + "'";
        hmTime[0] = sm + ss + sms;
        String sh = hou + "'";
        sm = smm + "\"";
        ss = sec < 10L ? "0" + sec : "" + sec;
        hmTime[1] = sh + sm + ss;
        return hmTime;
    }

    static {
        mapIndex = new int[]{0, 2, 9, 17, 25, 38, 45, 47, 60, 67, 75, 90};
        backImg = null;
        goldImg = null;
        doorImg = null;
        effect = null;
        petRms = new CWARms[10];
        npcItemIndex = 0;
        npcObject = null;
        npcPos = null;
        saveFlag = null;
        mapGround = new Vector();
        mapWall = new Vector();
        mapWater = new Vector();
        mapSand = new Vector();
        eggExp = 0;
        eggHatch = 0;
        collNpc = (short)-1;
        collBattleNpc = (short)-1;
        faceDir = 0;
        isPlayer = false;
        npcId = -1;
        cameraX = 0;
        cameraY = 0;
        cameraW = GameWorld.getWidth();
        cameraH = GameWorld.getHeight();
        miniMap = new byte[]{9, 10, 11};
        isLearn = false;
        VectorlvUp = null;
        vectorEvole = null;
        tipEvole = 0;
        worldRun = false;
        isEvoleTip = false;
        evoleData = new byte[2];
        loadCount = 0;
        battleArea = (byte)-1;
    }
}

