/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.NPeer;
import java.io.DataInputStream;

public class NCommand {
    byte commandFlags;
    public static final int FLAG_RELIABLE = 1;
    public static final int FLAG_UNSEQUENCED = 2;
    static final byte FV_UNRELIABLE = 0;
    static final byte FV_RELIABLE = 1;
    static final byte FV_UNRELIBALE_UNSEQUENCED = 2;
    byte commandType;
    public static final byte CT_NONE = 0;
    public static final byte CT_ACK = 1;
    public static final byte CT_CONNECT = 2;
    public static final byte CT_VERIFYCONNECT = 3;
    public static final byte CT_DISCONNECT = 4;
    public static final byte CT_PING = 5;
    public static final byte CT_SENDRELIABLE = 6;
    public static final byte CT_SENDUNRELIABLE = 7;
    public static final byte CT_SENDUNSEQUENCED = 11;
    byte commandChannelID;
    int reliableSequenceNumber;
    int unreliableSequenceNumber;
    int unsequencedGroupNumber;
    byte[] commandPayload;
    int commandSentTime;
    byte commandSentCount;
    int ackReceivedReliableSequenceNumber;
    int ackReceivedSentTime;
    static final int HEADER_LENGTH = 12;

    public NCommand(NPeer nPeer, byte by, byte[] byArray) {
        this.commandType = by;
        this.commandFlags = 1;
        this.commandChannelID = (byte)-1;
        this.commandPayload = byArray;
        switch (by) {
            case 2: {
                this.commandPayload = new byte[32];
                this.commandPayload[0] = 0;
                this.commandPayload[1] = 0;
                this.commandPayload[2] = (byte)(nPeer.rt.localMTU >>> 8);
                this.commandPayload[3] = (byte)(nPeer.rt.localMTU >>> 0);
                this.commandPayload[4] = 0;
                this.commandPayload[5] = 0;
                this.commandPayload[6] = -128;
                this.commandPayload[7] = 0;
                this.commandPayload[11] = 1;
                this.commandPayload[15] = 0;
                this.commandPayload[19] = 0;
                this.commandPayload[22] = 19;
                this.commandPayload[23] = -120;
                this.commandPayload[27] = 2;
                this.commandPayload[31] = 2;
                break;
            }
            case 4: {
                if (nPeer.peerState == 3) break;
                this.commandFlags = (byte)2;
                break;
            }
            case 6: {
                this.commandChannelID = 0;
                break;
            }
            case 7: {
                this.commandFlags = 0;
                this.unreliableSequenceNumber = ++nPeer.outgoingUnreliableSequenceNumber;
                this.commandChannelID = 0;
                break;
            }
            case 11: {
                this.commandFlags = (byte)2;
                this.unsequencedGroupNumber = ++nPeer.outgoingUnsequencedGroupNumber;
                this.commandChannelID = 0;
                break;
            }
            case 1: {
                this.commandFlags = 0;
            }
        }
    }

    static NCommand createAck(NPeer nPeer, NCommand nCommand, int n) {
        byte[] byArray = new byte[]{(byte)(nCommand.reliableSequenceNumber >>> 24 & 0xFF), (byte)(nCommand.reliableSequenceNumber >>> 16 & 0xFF), (byte)(nCommand.reliableSequenceNumber >>> 8 & 0xFF), (byte)(nCommand.reliableSequenceNumber >>> 0 & 0xFF), (byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        NCommand nCommand2 = new NCommand(nPeer, 1, byArray);
        nCommand2.commandChannelID = nCommand.commandChannelID;
        return nCommand2;
    }

    public NCommand(NPeer nPeer, DataInputStream dataInputStream) throws Exception {
        this.commandType = dataInputStream.readByte();
        this.commandChannelID = dataInputStream.readByte();
        this.commandFlags = dataInputStream.readByte();
        dataInputStream.readByte();
        int n = dataInputStream.readInt();
        this.reliableSequenceNumber = dataInputStream.readInt();
        switch (this.commandType) {
            case 1: {
                this.ackReceivedReliableSequenceNumber = dataInputStream.readInt();
                this.ackReceivedSentTime = dataInputStream.readInt();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.commandPayload = new byte[n - 12];
                break;
            }
            case 7: {
                this.unreliableSequenceNumber = dataInputStream.readInt();
                this.commandPayload = new byte[n - 12 - 4];
                break;
            }
            case 11: {
                this.unsequencedGroupNumber = dataInputStream.readInt();
                this.commandPayload = new byte[n - 12 - 4];
                break;
            }
            case 3: {
                short s = dataInputStream.readShort();
                byte[] byArray = new byte[30];
                dataInputStream.read(byArray);
                nPeer.peerID = s;
                nPeer.peerState = (byte)3;
            }
        }
        if (this.commandPayload != null) {
            dataInputStream.read(this.commandPayload);
        }
    }

    byte[] serialize() {
        int n = this.commandPayload == null ? 0 : this.commandPayload.length;
        int n2 = 12;
        if (this.commandType == 7 || this.commandType == 11) {
            n2 += 4;
        }
        byte[] byArray = new byte[n2 + n];
        byArray[0] = this.commandType;
        byArray[1] = this.commandChannelID;
        byArray[2] = this.commandFlags;
        byArray[3] = 4;
        byArray[4] = (byte)(byArray.length >>> 24);
        byArray[5] = (byte)(byArray.length >>> 16);
        byArray[6] = (byte)(byArray.length >>> 8);
        byArray[7] = (byte)(byArray.length >>> 0);
        byArray[8] = (byte)(this.reliableSequenceNumber >>> 24 & 0xFF);
        byArray[9] = (byte)(this.reliableSequenceNumber >>> 16 & 0xFF);
        byArray[10] = (byte)(this.reliableSequenceNumber >>> 8 & 0xFF);
        byArray[11] = (byte)(this.reliableSequenceNumber >>> 0 & 0xFF);
        if (this.commandType == 7) {
            byArray[12] = (byte)(this.unreliableSequenceNumber >>> 24 & 0xFF);
            byArray[13] = (byte)(this.unreliableSequenceNumber >>> 16 & 0xFF);
            byArray[14] = (byte)(this.unreliableSequenceNumber >>> 8 & 0xFF);
            byArray[15] = (byte)(this.unreliableSequenceNumber >>> 0 & 0xFF);
        }
        if (this.commandType == 11) {
            byArray[12] = (byte)(this.unsequencedGroupNumber >>> 24 & 0xFF);
            byArray[13] = (byte)(this.unsequencedGroupNumber >>> 16 & 0xFF);
            byArray[14] = (byte)(this.unsequencedGroupNumber >>> 8 & 0xFF);
            byArray[15] = (byte)(this.unsequencedGroupNumber >>> 0 & 0xFF);
        }
        if (n > 0) {
            System.arraycopy(this.commandPayload, 0, byArray, n2, n);
        }
        return byArray;
    }

    public String toString() {
        return "NC(" + this.commandChannelID + " r/u/t:" + this.reliableSequenceNumber + "/" + this.unreliableSequenceNumber + "/" + Integer.toHexString(this.commandSentTime) + ")";
    }
}

