/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.NCommand;
import de.exitgames.neutron.client.NConnect;
import de.exitgames.neutron.client.NeutronListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;

public class NPeer {
    int incomingReliableSequenceNumber;
    NCommand[] incomingReliableCommandsRing;
    int inRelCommandsRingStart = 1;
    int inRelCommandsRingCount;
    int incomingCommandsRingSize = 10;
    int incomingUnreliableSequenceNumber;
    NCommand[] incomingUnreliableCommandsRing;
    int inUnrelCommandsRingStart = 1;
    int inUnrelCommandsRingCount;
    int queueIncomingUnreliableCommandAdded;
    int queueIncomingReliableCommandAdded;
    boolean updateRingCount;
    NCommand[] incomingSequencedCommands;
    NCommand[] outgoingReliableCommands;
    int outgoingReliableCommandsIndex;
    NCommand[] outgoingUnreliableCommands;
    int outgoingUnreliableCommandsIndex;
    NCommand[] sentReliableCommands;
    int sentReliableCommandsIndex;
    NCommand[] outgoingAcknowledgements;
    int outgoingAcknowledgementsIndex;
    int outgoingReliableFFSequenceNumber = 0;
    int outgoingReliableSequenceNumber = 0;
    int outgoingUnreliableSequenceNumber = 0;
    int windowSize = 128;
    int[] unsequencedWindow = new int[this.windowSize / 32];
    int outgoingUnsequencedGroupNumber = 0;
    int incomingUnsequencedGroupNumber = 0;
    public byte peerState;
    public static final byte PS_DISCONNECTED = 0;
    public static final byte PS_CONNECTING = 1;
    public static final byte PS_ACKNOWLEDGING_CONNECT = 2;
    public static final byte PS_CONNECTED = 3;
    public static final byte PS_DISCONNECTING = 4;
    public static final byte PS_ACKNOWLEDGING_DISCONNECT = 5;
    public static final byte PS_ZOMBIE = 6;
    boolean isJoined;
    short peerID;
    static short peerCount;
    String peerIpPort;
    byte udpHeaderCount = (byte)12;
    byte udpCommandCount;
    byte[] udpBuffer;
    int udpBufferIndex;
    int commandSize = 12;
    int challenge;
    NConnect rt;
    NeutronListener nl;
    long timeBase;
    int timeInt;
    int timeoutInt;
    int timeLastReceive;
    int timeAllowanceInt = 1000;
    int sentCountAllowance = 3;
    public int timePingInterval = 2000;
    int ENET_PEER_PACKET_LOSS_SCALE = 65536;
    int ENET_PEER_DEFAULT_ROUND_TRIP_TIME = 100;
    int ENET_PEER_PACKET_THROTTLE_INTERVAL = 5000;
    int packetsLost;
    int packetLoss;
    int packetsSent;
    int packetLossEpoch;
    int packetLossVariance;
    int packetThrottleEpoch;
    public long serverTimeOffset;
    long serverSentTime;
    long serverSentTimeBefore;
    long serverTimeOverrun;
    public int roundTripTime;
    public int roundTripTimeVariance;
    int lastRoundTripTime;
    int lowestRoundTripTime;
    int lastRoundTripTimeVariance;
    int highestRoundTripTimeVariance;
    int packetThrottleInterval;
    static final boolean DEBUG_IN_COMMANDS = false;
    static final boolean DEBUG_IN_QUEUE_COMMANDS = false;
    static final boolean DEBUG_OUT_COMMANDS = false;
    static final boolean DEBUG_ACK_COMMANDS = false;
    static final boolean DEBUG_NEW_IN_COMMANDS = false;
    static final boolean DEBUG_DISPATCH_COMMANDS = false;
    static final boolean DEBUG_RING_COUNT = false;
    public static final Byte P_CODE;
    public static final Byte P_ACTORLIST;
    public static final Byte P_ACTORNR;
    public static final byte OPC_RT_JOIN = 90;
    public static final byte OPC_RT_LEAVE = 91;
    public static final byte OPC_RT_RAISE_EV = 92;

    public NPeer(NeutronListener neutronListener) {
        this.nl = neutronListener;
        this.initNPeer();
    }

    public boolean nNetConnect(String string) {
        if (this.peerState != 0) {
            return false;
        }
        System.out.println("nNetConnect()");
        this.peerIpPort = string;
        this.initNPeer();
        this.rt = new NConnect(this, this.peerIpPort);
        if (this.rt.startConnectionThread()) {
            this.peerState = 1;
            return true;
        }
        return false;
    }

    public void nNetDisconnect() {
        this.outgoingAcknowledgementsIndex = 0;
        this.outgoingReliableCommandsIndex = 0;
        this.outgoingUnreliableCommandsIndex = 0;
        this.sentReliableCommandsIndex = 0;
        this.queueOutgoingReliableCommand(new NCommand(this, 4, null));
        this.sendOutgoingCommands();
        if (this.peerState == 3) {
            this.peerState = (byte)4;
        } else {
            this.rt.stopConnectionThread();
        }
    }

    void nNetDisconnected() {
        peerCount = (short)(peerCount - 1);
        this.initNPeer();
        this.nl.nPeerReturn((byte)0, 1025, null, (short)0);
    }

    public void send(byte by, byte[] byArray) {
        NCommand nCommand = new NCommand(this, by, byArray);
        if (nCommand.commandFlags == 1) {
            this.queueOutgoingReliableCommand(nCommand);
        } else {
            this.queueOutgoingUnreliableCommand(nCommand);
        }
    }

    public byte getPeerState() {
        return this.peerState;
    }

    public short opRaiseEvent(byte by, Hashtable hashtable) {
        if (this.peerState != 3) {
            return -1;
        }
        short s = this.rt.invocID;
        byte[] byArray = this.rt.serialiseOperation(hashtable, (byte)92);
        if (byArray != null) {
            this.send(by, byArray);
            return s;
        }
        return -1;
    }

    public short opJoin(String string, byte[] byArray) {
        if (this.peerState != 3) {
            return -1;
        }
        Hashtable<Byte, Object> hashtable = new Hashtable<Byte, Object>();
        hashtable.put(new Byte(4), string);
        hashtable.put(new Byte(3), byArray);
        short s = this.rt.invocID;
        byte[] byArray2 = this.rt.serialiseOperation(hashtable, (byte)90);
        if (byArray2 != null) {
            this.send((byte)6, byArray2);
            return s;
        }
        return -1;
    }

    public short opLeave(String string) {
        if (this.peerState != 3) {
            return -1;
        }
        Hashtable<Byte, String> hashtable = new Hashtable<Byte, String>();
        hashtable.put(new Byte(4), string);
        short s = this.rt.invocID;
        byte[] byArray = this.rt.serialiseOperation(hashtable, (byte)91);
        if (byArray != null) {
            this.send((byte)6, byArray);
            return s;
        }
        return -1;
    }

    public void service() {
        boolean bl;
        while (bl = this.dispatchIncomingCommands()) {
        }
        this.sendOutgoingCommands();
    }

    void initNPeer() {
        peerCount = (short)(peerCount + 1);
        this.peerID = (short)-1;
        this.peerState = 0;
        this.timeBase = System.currentTimeMillis();
        this.challenge = (int)this.timeBase;
        this.outgoingReliableSequenceNumber = 0;
        this.outgoingUnreliableSequenceNumber = 0;
        this.outgoingReliableFFSequenceNumber = 0;
        this.incomingReliableCommandsRing = new NCommand[this.incomingCommandsRingSize];
        this.incomingUnreliableCommandsRing = new NCommand[this.incomingCommandsRingSize];
        this.outgoingReliableCommands = new NCommand[20];
        this.outgoingUnreliableCommands = new NCommand[20];
        this.sentReliableCommands = new NCommand[20];
        this.outgoingAcknowledgements = new NCommand[20];
        this.packetsSent = 0;
        this.packetsLost = 0;
        this.packetLoss = 0;
        this.roundTripTime = this.ENET_PEER_DEFAULT_ROUND_TRIP_TIME;
        this.packetThrottleInterval = this.ENET_PEER_PACKET_THROTTLE_INTERVAL;
        this.isJoined = false;
    }

    public void sendOutgoingCommands() {
        if (this.peerState == 0) {
            return;
        }
        if (!this.rt.isRunning) {
            return;
        }
        if (this.udpBuffer == null) {
            this.udpBuffer = new byte[this.rt.localMTU];
        }
        this.udpBufferIndex = 12;
        this.udpCommandCount = 0;
        this.timeInt = (int)(System.currentTimeMillis() - this.timeBase);
        if (this.outgoingAcknowledgementsIndex > 0) {
            this.outgoingAcknowledgementsIndex = this.serializeToBuffer(this.outgoingAcknowledgements, this.outgoingAcknowledgementsIndex);
        }
        if (this.timeInt > this.timeoutInt && this.sentReliableCommandsIndex > 0) {
            System.out.println("checkTimeouts() sentReliableCommandsIndex: " + this.sentReliableCommandsIndex);
            NCommand nCommand = null;
            for (int i = 0; i < this.sentReliableCommandsIndex; ++i) {
                nCommand = this.sentReliableCommands[i];
                if (this.timeInt <= nCommand.commandSentTime + nCommand.commandSentCount * this.timeAllowanceInt) continue;
                if (nCommand.commandSentCount > this.sentCountAllowance) {
                    System.out.println("disconnect due to retry timeout");
                    this.nNetDisconnected();
                    return;
                }
                ++this.packetsLost;
                System.out.println("going to resend command: " + nCommand + " time: " + this.timeInt + " = " + this.timeInt / 1000 + " sentCount: " + nCommand.commandSentCount);
                this.removeSentReliableCommand(nCommand.reliableSequenceNumber, nCommand.commandSentTime);
                this.queueOutgoingReliableCommand(nCommand);
            }
            if (this.sentReliableCommandsIndex == 0) {
                this.timeoutInt = this.timeInt + this.timeAllowanceInt;
            }
        }
        if (this.outgoingReliableCommandsIndex > 0) {
            this.outgoingReliableCommandsIndex = this.serializeToBuffer(this.outgoingReliableCommands, this.outgoingReliableCommandsIndex);
        } else if (this.peerState == 3 && this.sentReliableCommandsIndex == 0 && this.timePingInterval > 0 && this.timeInt - this.timeLastReceive > this.timePingInterval && this.udpBufferIndex + this.commandSize < this.udpBuffer.length) {
            this.queueOutgoingReliableCommand(new NCommand(this, 5, null));
        }
        if (this.outgoingUnreliableCommandsIndex > 0) {
            this.outgoingUnreliableCommandsIndex = this.serializeToBuffer(this.outgoingUnreliableCommands, this.outgoingUnreliableCommandsIndex);
        }
        this.sendData(this.udpBuffer);
    }

    void sendData(byte[] byArray) {
        if (this.udpCommandCount <= 0) {
            return;
        }
        try {
            this.udpBuffer[0] = (byte)(this.peerID >>> 8);
            this.udpBuffer[1] = (byte)(this.peerID >>> 0);
            this.udpBuffer[2] = 0;
            this.udpBuffer[3] = this.udpCommandCount;
            this.udpBuffer[4] = (byte)(this.timeInt >>> 24);
            this.udpBuffer[5] = (byte)(this.timeInt >>> 16);
            this.udpBuffer[6] = (byte)(this.timeInt >>> 8);
            this.udpBuffer[7] = (byte)(this.timeInt >>> 0);
            this.udpBuffer[8] = (byte)(this.challenge >>> 24);
            this.udpBuffer[9] = (byte)(this.challenge >>> 16);
            this.udpBuffer[10] = (byte)(this.challenge >>> 8);
            this.udpBuffer[11] = (byte)(this.challenge >>> 0);
            this.rt.sendUdpPackage(this.udpBuffer, this.udpBufferIndex);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    int serializeToBuffer(NCommand[] nCommandArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            byte[] byArray;
            if (nCommandArray[n2] == null) {
                System.out.println("commandList[i] == null");
            }
            if (this.udpBufferIndex + (byArray = nCommandArray[n2].serialize()).length >= this.udpBuffer.length) {
                System.out.println("command does not fit. opLeave it in queue.");
                break;
            }
            System.arraycopy(byArray, 0, this.udpBuffer, this.udpBufferIndex, byArray.length);
            this.udpCommandCount = (byte)(this.udpCommandCount + 1);
            this.udpBufferIndex += byArray.length;
            ++n3;
            nCommandArray[n2].commandSentTime = this.timeInt;
            nCommandArray[n2].commandSentCount = (byte)(nCommandArray[n2].commandSentCount + 1);
            if ((nCommandArray[n2].commandFlags & 1) > 0) {
                if (this.sentReliableCommandsIndex == 0) {
                    this.timeoutInt = this.timeInt + this.timeAllowanceInt * nCommandArray[n2].commandSentCount;
                }
                this.queueSentCommand(nCommandArray[n2]);
                ++this.packetsSent;
            }
            nCommandArray[n2] = null;
        }
        if (n3 > 0 && (n -= n3) > 0) {
            System.arraycopy(nCommandArray, n3, nCommandArray, 0, n);
            for (n2 = n; n2 < nCommandArray.length; ++n2) {
                nCommandArray[n2] = null;
            }
        }
        return n;
    }

    void queueSentCommand(NCommand nCommand) {
        this.sentReliableCommands[this.sentReliableCommandsIndex++] = nCommand;
        if (this.sentReliableCommandsIndex >= this.sentReliableCommands.length) {
            System.out.println("    sentReliableCommandsIndex wrapped");
            this.sentReliableCommandsIndex = 0;
        }
    }

    void queueOutgoingReliableCommand(NCommand nCommand) {
        if (nCommand.reliableSequenceNumber == 0) {
            nCommand.reliableSequenceNumber = nCommand.commandChannelID == -1 ? ++this.outgoingReliableFFSequenceNumber : ++this.outgoingReliableSequenceNumber;
        }
        this.outgoingReliableCommands[this.outgoingReliableCommandsIndex++] = nCommand;
        if (this.outgoingReliableCommandsIndex >= this.outgoingReliableCommands.length) {
            System.out.println("    outgoingReliableCommandsIndex wrapped");
            this.outgoingReliableCommandsIndex = 0;
        }
    }

    void queueOutgoingUnreliableCommand(NCommand nCommand) {
        nCommand.reliableSequenceNumber = nCommand.commandChannelID == -1 ? this.outgoingReliableFFSequenceNumber : this.outgoingReliableSequenceNumber;
        this.outgoingUnreliableCommands[this.outgoingUnreliableCommandsIndex++] = nCommand;
        if (this.outgoingUnreliableCommandsIndex >= this.outgoingUnreliableCommands.length) {
            System.out.println("    outgoingUnreliableCommandsIndex wrapped");
            this.outgoingUnreliableCommandsIndex = 0;
        }
    }

    void queueOutgoingAcknowledgement(NCommand nCommand) {
        this.outgoingAcknowledgements[this.outgoingAcknowledgementsIndex++] = nCommand;
        if (this.outgoingAcknowledgementsIndex >= this.outgoingAcknowledgements.length) {
            System.out.println("    outgoingAcknowledgementsIndex wrapped");
            this.outgoingAcknowledgementsIndex = 0;
        }
    }

    public boolean dispatchIncomingCommands() {
        NCommand nCommand = null;
        this.updateRingCount();
        if (this.inUnrelCommandsRingCount > 0) {
            int n = 0;
            do {
                if ((nCommand = this.incomingUnreliableCommandsRing[this.inUnrelCommandsRingStart]) != null) continue;
                ++this.inUnrelCommandsRingStart;
                this.inUnrelCommandsRingStart %= this.incomingCommandsRingSize;
                ++n;
            } while (nCommand == null && n < this.incomingCommandsRingSize);
            if (nCommand != null && nCommand.unreliableSequenceNumber > 0) {
                if (nCommand.reliableSequenceNumber > this.incomingReliableSequenceNumber) {
                    nCommand = null;
                } else {
                    this.incomingUnreliableSequenceNumber = nCommand.unreliableSequenceNumber;
                    this.incomingUnreliableCommandsRing[this.inUnrelCommandsRingStart] = null;
                    ++this.inUnrelCommandsRingStart;
                    this.inUnrelCommandsRingStart %= this.incomingCommandsRingSize;
                    --this.inUnrelCommandsRingCount;
                }
            }
        }
        if (nCommand == null && this.inRelCommandsRingCount > 0) {
            do {
                nCommand = this.incomingReliableCommandsRing[this.inRelCommandsRingStart];
                if (nCommand.reliableSequenceNumber > this.incomingReliableSequenceNumber + 1) {
                    return false;
                }
                if (nCommand.reliableSequenceNumber > this.incomingReliableSequenceNumber) continue;
                nCommand = null;
                this.incomingReliableCommandsRing[this.inRelCommandsRingStart] = null;
                ++this.inRelCommandsRingStart;
                this.inRelCommandsRingStart %= this.incomingCommandsRingSize;
                --this.inRelCommandsRingCount;
            } while (nCommand == null && this.inRelCommandsRingCount > 0);
            if (nCommand == null) {
                return false;
            }
            this.incomingReliableCommandsRing[this.inRelCommandsRingStart] = null;
            --this.inRelCommandsRingCount;
            ++this.inRelCommandsRingStart;
            this.inRelCommandsRingStart %= this.incomingCommandsRingSize;
            this.incomingReliableSequenceNumber = nCommand.reliableSequenceNumber;
        }
        if (nCommand != null && nCommand.commandPayload != null) {
            System.out.println("    dispatching command: " + nCommand);
            return this.rt.deserializeNeutron(nCommand.commandPayload);
        }
        return false;
    }

    void receiveIncomingCommands() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rt.inBuff);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            short s = dataInputStream.readShort();
            byte by = dataInputStream.readByte();
            int n = dataInputStream.readByte();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            this.timeInt = (int)(System.currentTimeMillis() - this.timeBase);
            this.serverSentTime = (long)n2 & 0xFFFFFFFFL;
            if (n3 != this.challenge) {
                System.out.println("    rejected incoming. challenge does not fit: " + Integer.toHexString(this.challenge));
                return;
            }
            if (n > 1) {
                System.out.println("    commandCount: " + n);
            }
            for (int i = 0; i < n; ++i) {
                NCommand nCommand = new NCommand(this, dataInputStream);
                this.executeCommand(nCommand);
                if ((nCommand.commandFlags & 1) <= 0) continue;
                this.queueOutgoingAcknowledgement(NCommand.createAck(this, nCommand, n2));
            }
            this.inUnrelCommandsRingCount += this.queueIncomingUnreliableCommandAdded;
            this.updateRingCount = this.queueIncomingReliableCommandAdded > 0;
            this.queueIncomingUnreliableCommandAdded = 0;
            this.queueIncomingReliableCommandAdded = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void executeCommand(NCommand nCommand) {
        switch (nCommand.commandType) {
            case 1: {
                this.timeLastReceive = this.timeInt;
                this.timeInt = (int)(System.currentTimeMillis() - this.timeBase);
                int n = this.timeInt - nCommand.ackReceivedSentTime;
                if (n > 0) {
                    if (this.serverSentTime < this.serverSentTimeBefore) {
                        this.serverTimeOverrun += -1L;
                    }
                    this.serverSentTimeBefore = this.serverSentTime;
                    this.serverTimeOffset = this.serverSentTime + (long)(n >> 1) - System.currentTimeMillis() + this.serverTimeOverrun;
                    this.updateRoundTripTimeVariance(n);
                }
                NCommand nCommand2 = this.removeSentReliableCommand(nCommand.ackReceivedReliableSequenceNumber, nCommand.ackReceivedSentTime);
                if (this.peerState != 4 || nCommand2 == null || nCommand2.commandType != 4) break;
                System.out.println("   DISCONNECT COMPLETE");
                this.rt.stopConnectionThread();
                break;
            }
            case 6: {
                this.queueIncomingCommand(nCommand);
                break;
            }
            case 7: {
                this.queueIncomingCommand(nCommand);
                break;
            }
            case 11: {
                int n = nCommand.unsequencedGroupNumber;
                int n2 = n % this.windowSize;
                if (n >= this.incomingUnsequencedGroupNumber + this.windowSize) {
                    this.incomingUnsequencedGroupNumber = n - n2;
                    for (int i = 0; i < this.unsequencedWindow.length; ++i) {
                        this.unsequencedWindow[i] = 0;
                    }
                } else if (n < this.incomingUnsequencedGroupNumber || (this.unsequencedWindow[n2 / 32] & 1 << n2 % 32) != 0) {
                    return;
                }
                int n3 = n2 / 32;
                this.unsequencedWindow[n3] = this.unsequencedWindow[n3] | 1 << n2 % 32;
                this.queueIncomingCommand(nCommand);
                break;
            }
            case 3: {
                System.out.println("   CT_VERIFYCONNECT");
                this.nl.nPeerReturn((byte)0, 1024, null, (short)0);
            }
        }
    }

    void updateRingCount() {
        if (!this.updateRingCount) {
            return;
        }
        this.updateRingCount = false;
        int n = 0;
        for (int i = 0; i < this.incomingCommandsRingSize && this.incomingReliableCommandsRing[(this.inRelCommandsRingStart + i) % this.incomingCommandsRingSize] != null; ++i) {
            ++n;
        }
        this.inRelCommandsRingCount = n;
    }

    int getStartEndDiff(int n, int n2) {
        return (n2 + this.incomingCommandsRingSize - n) % this.incomingCommandsRingSize;
    }

    void queueIncomingCommand(NCommand nCommand) {
        boolean bl = false;
        boolean bl2 = false;
        if (nCommand.commandFlags == 1) {
            int n = nCommand.reliableSequenceNumber % this.incomingCommandsRingSize;
            if (nCommand.reliableSequenceNumber < this.incomingReliableSequenceNumber) {
                return;
            }
            if (nCommand.reliableSequenceNumber - this.incomingReliableSequenceNumber > this.incomingCommandsRingSize) {
                System.out.println("    not saved. buffer overflow.");
                return;
            }
            if (this.inRelCommandsRingCount > 0 && this.getStartEndDiff(this.inRelCommandsRingStart, n) < this.inRelCommandsRingCount) {
                if (this.incomingReliableCommandsRing[n].reliableSequenceNumber == nCommand.reliableSequenceNumber) {
                    System.out.println("    not saved. command already received!");
                } else {
                    System.out.println("    not saved. index falls in used range!");
                }
                return;
            }
            this.incomingReliableCommandsRing[n] = nCommand;
            ++this.queueIncomingReliableCommandAdded;
            return;
        }
        if (nCommand.commandFlags == 0) {
            int n;
            if (nCommand.reliableSequenceNumber < this.incomingReliableSequenceNumber) {
                return;
            }
            if (nCommand.unreliableSequenceNumber <= this.incomingUnreliableSequenceNumber) {
                return;
            }
            if (nCommand.unreliableSequenceNumber - this.incomingUnreliableSequenceNumber > this.incomingCommandsRingSize) {
                System.out.println("    debug: adjusting buffer!. gap is: " + (nCommand.unreliableSequenceNumber - this.incomingUnreliableSequenceNumber));
                this.incomingUnreliableSequenceNumber = nCommand.unreliableSequenceNumber - 1;
            }
            if (this.incomingUnreliableCommandsRing[n = nCommand.unreliableSequenceNumber % this.incomingCommandsRingSize] != null) {
                System.out.println("    position not null: " + this.incomingUnreliableCommandsRing[n]);
            }
            this.incomingUnreliableCommandsRing[n] = nCommand;
            ++this.queueIncomingUnreliableCommandAdded;
            return;
        }
        if (nCommand.commandFlags == 2) {
            bl2 = false;
            bl = true;
        }
    }

    NCommand removeSentReliableCommand(int n, int n2) {
        int n3;
        boolean bl = false;
        if (bl) {
            System.out.println("removeSentReliableCommand() " + n + " " + Integer.toHexString(n2));
        }
        NCommand nCommand = null;
        boolean bl2 = false;
        if (bl) {
            System.out.println("    sentReliableCommandsIndex: " + this.sentReliableCommandsIndex + " list: " + this.commandListToString(this.sentReliableCommands));
        }
        for (n3 = 0; n3 < this.sentReliableCommandsIndex; ++n3) {
            nCommand = this.sentReliableCommands[n3];
            if (nCommand.reliableSequenceNumber != n || nCommand.commandSentTime != n2) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.sentReliableCommands[n3] = null;
            --this.sentReliableCommandsIndex;
            System.arraycopy(this.sentReliableCommands, n3 + 1, this.sentReliableCommands, n3, this.sentReliableCommandsIndex);
            if (this.sentReliableCommandsIndex > 0) {
                this.sentReliableCommands[this.sentReliableCommandsIndex] = null;
                this.timeoutInt = this.sentReliableCommands[0].commandSentTime + this.sentReliableCommands[0].commandSentCount * this.timeAllowanceInt;
            }
            if (bl) {
                System.out.println("    sentReliableCommandsIndex: " + this.sentReliableCommandsIndex + " list: " + this.commandListToString(this.sentReliableCommands));
            }
            if (bl) {
                System.out.println("    removed: " + nCommand.toString() + " type: " + nCommand.commandType + " time: " + Integer.toHexString(nCommand.commandSentTime));
            }
        } else {
            if (this.peerState == 3) {
                System.out.println("ACK w/o command! sqNr: " + n + " sentTime: " + Integer.toHexString(n2));
                System.out.println("    sentReliableCommandsIndex: " + this.sentReliableCommandsIndex + " list: " + this.commandListToString(this.sentReliableCommands));
            }
            nCommand = null;
        }
        return nCommand;
    }

    void updatePacketLossVariance(int n) {
        int n2 = this.packetsLost * this.ENET_PEER_PACKET_LOSS_SCALE / this.packetsSent - this.packetLoss;
        this.packetLossVariance -= this.packetLossVariance / 4;
        if (n2 >= 0) {
            this.packetLoss += n2 / 8;
            this.packetLossVariance += n2 / 4;
        } else {
            this.packetLoss += n2 / 8;
            this.packetLossVariance -= n2 / 4;
        }
        this.packetLossEpoch = n;
        this.packetsSent = 0;
        this.packetsLost = 0;
    }

    void updateRoundTripTimeVariance(int n) {
        this.roundTripTimeVariance -= this.roundTripTimeVariance / 4;
        if (n >= this.roundTripTime) {
            this.roundTripTime += (n - this.roundTripTime) / 8;
            this.roundTripTimeVariance += (n - this.roundTripTime) / 4;
        } else {
            this.roundTripTime += (n - this.roundTripTime) / 8;
            this.roundTripTimeVariance -= (n - this.roundTripTime) / 4;
        }
        if (this.roundTripTime < this.lowestRoundTripTime) {
            this.lowestRoundTripTime = this.roundTripTime;
        }
        if (this.roundTripTimeVariance > this.highestRoundTripTimeVariance) {
            this.highestRoundTripTimeVariance = this.roundTripTimeVariance;
        }
        if (this.packetThrottleEpoch == 0 || this.timeInt - this.packetThrottleEpoch >= this.packetThrottleInterval) {
            this.lastRoundTripTime = this.lowestRoundTripTime;
            this.lastRoundTripTimeVariance = this.highestRoundTripTimeVariance;
            this.lowestRoundTripTime = this.roundTripTime;
            this.highestRoundTripTimeVariance = this.roundTripTimeVariance;
            this.packetThrottleEpoch = this.timeInt;
        }
        System.out.println("++ time: " + n + " roundTripTimeVariance: " + this.roundTripTimeVariance);
    }

    String commandListToString(NCommand[] nCommandArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nCommandArray.length; ++i) {
            stringBuffer.append(i + "=");
            stringBuffer.append(nCommandArray[i]);
            stringBuffer.append(" # ");
        }
        return stringBuffer.toString();
    }

    String byteArrayToString(byte[] byArray) {
        return "";
    }

    static {
        P_CODE = new Byte(60);
        P_ACTORLIST = new Byte(11);
        P_ACTORNR = new Byte(9);
    }
}

