/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Animation {
    public static final int MASK_FLAG = 1;
    public static final int MASK_DURATION = 47;
    public static final int MASK_FRAMEID = 1023;
    public static final byte MOVE_BIT_FLAG = 15;
    public static final byte MOVE_BIT_DURATION = 11;
    public static final byte MOVE_BIT_FRAMEID = 0;
    public static final byte BOX_COLLIDE = 1;
    public static final byte BOX_ATTACK = 2;
    private short[] attBox = new short[4];
    private short[] colBox = new short[4];
    private short frameCount;
    private short[] frameBoxIndexs;
    public short actionCount;
    public short[] actionSequenceCounts;
    public short[] actionSequenceOffset;
    private short sequenceCount;
    public short[] sequenceDatas;
    private short colBoxCount;
    private short attBoxCount;
    public short[] colBoxs;
    public short[] attBoxs;
    private ASprite aSprite = new ASprite();
    private ASpriteInstance aSpriteInstance = new ASpriteInstance();
    public static byte[] animationData = null;
    private static int[] bspriteOffset = null;
    private static int[] bspriteOffsetData = null;
    private static int[] bspritePlusOffset = null;
    private static int[] bspritePlusOffsetData = null;
    private static int animationCount = 0;
    public static final short ASC_SQUENCE_INDEX = 0;
    public static final short ASC_FRAME_DELAY = 1;

    public static void loadAnimationRes(int levelId, int type) {
        switch (type) {
            case 1: {
                Animation.readSpriteDataByHugeMomery(levelId);
                break;
            }
            case 0: {
                Animation.readSpriteDataByLowMomery(levelId);
            }
        }
    }

    private static void readSpriteDataByHugeMomery(int levelId) {
        try {
            int i;
            InputStream is = null;
            DataInputStream dis = null;
            is = "".getClass().getResourceAsStream("/animation.bin");
            dis = new DataInputStream(is);
            animationCount = dis.readShort();
            bspriteOffset = new int[animationCount + 1];
            for (i = 0; i < bspriteOffset.length; ++i) {
                Animation.bspriteOffset[i] = dis.readInt();
            }
            bspriteOffsetData = new int[dToolsData.animationDataId[levelId].length];
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                Animation.bspriteOffsetData[i] = i == 0 ? bspriteOffset[dToolsData.animationDataId[levelId][i]] : (dToolsData.animationDataId[levelId][i] - dToolsData.animationDataId[levelId][i - 1] == 1 ? 0 : bspriteOffset[dToolsData.animationDataId[levelId][i]] - bspriteOffset[dToolsData.animationDataId[levelId][i - 1] + 1]);
            }
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                if (XObject.animations[dToolsData.animationDataId[levelId][i]] != null) continue;
                Animation.readBSprite(i, dToolsData.animationDataId[levelId][i], dis);
            }
            is = "".getClass().getResourceAsStream("/animationPlus.bin");
            dis = new DataInputStream(is);
            bspritePlusOffset = new int[animationCount + 1];
            for (int j = 0; j < bspritePlusOffset.length; ++j) {
                Animation.bspritePlusOffset[j] = dis.readInt();
            }
            bspritePlusOffsetData = new int[dToolsData.animationDataId[levelId].length];
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                Animation.bspritePlusOffsetData[i] = i == 0 ? bspritePlusOffset[dToolsData.animationDataId[levelId][i]] : (dToolsData.animationDataId[levelId][i] - dToolsData.animationDataId[levelId][i - 1] == 1 ? 0 : bspritePlusOffset[dToolsData.animationDataId[levelId][i]] - bspritePlusOffset[dToolsData.animationDataId[levelId][i - 1] + 1]);
            }
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                Animation.readBSpritePlus(i, dToolsData.animationDataId[levelId][i], dis);
            }
            is.close();
            dis.close();
            is = null;
            Object var2_3 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readSpriteDataByLowMomery(int levelId) {
        try {
            int i;
            InputStream is = null;
            DataInputStream dis = null;
            animationCount = GameEngine.animationCount;
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                short animId = dToolsData.animationDataId[levelId][i];
                if (XObject.animations[animId] != null) continue;
                is = "".getClass().getResourceAsStream("/sprite/" + animId + ".lst");
                dis = new DataInputStream(is);
                animationData = new byte[dis.available()];
                dis.read(animationData);
                XObject.animations[animId] = new Animation();
                XObject.animations[animId].load();
                animationData = null;
            }
            is = "".getClass().getResourceAsStream("/animationPlus.bin");
            dis = new DataInputStream(is);
            bspritePlusOffset = new int[animationCount + 1];
            for (int j = 0; j < bspritePlusOffset.length; ++j) {
                Animation.bspritePlusOffset[j] = dis.readInt();
            }
            bspritePlusOffsetData = new int[dToolsData.animationDataId[levelId].length];
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                Animation.bspritePlusOffsetData[i] = i == 0 ? bspritePlusOffset[dToolsData.animationDataId[levelId][i]] : (dToolsData.animationDataId[levelId][i] - dToolsData.animationDataId[levelId][i - 1] == 1 ? 0 : bspritePlusOffset[dToolsData.animationDataId[levelId][i]] - bspritePlusOffset[dToolsData.animationDataId[levelId][i - 1] + 1]);
            }
            for (i = 0; i < dToolsData.animationDataId[levelId].length; ++i) {
                Animation.readBSpritePlus(i, dToolsData.animationDataId[levelId][i], dis);
            }
            dis.close();
            is.close();
            dis = null;
            is = null;
            System.gc();
            GameEngine.pause(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readBSprite(int skipIndex, int animationId, DataInputStream dis) {
        try {
            dis.skip(bspriteOffsetData[skipIndex]);
            int animationDataLength = bspriteOffset[animationId + 1] - bspriteOffset[animationId];
            animationData = new byte[animationDataLength];
            dis.read(animationData);
            XObject.animations[animationId] = new Animation();
            XObject.animations[animationId].load();
            animationData = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readBSpritePlus(int skipIndex, int animationId, DataInputStream dis) {
        try {
            int i;
            dis.skip(bspritePlusOffsetData[skipIndex]);
            XObject.animations[animationId].frameCount = dis.readShort();
            XObject.animations[animationId].frameBoxIndexs = new short[XObject.animations[animationId].frameCount << 1];
            for (i = 0; i < XObject.animations[animationId].frameBoxIndexs.length; ++i) {
                XObject.animations[animationId].frameBoxIndexs[i] = dis.readShort();
            }
            XObject.animations[animationId].actionCount = dis.readShort();
            XObject.animations[animationId].actionSequenceCounts = new short[XObject.animations[animationId].actionCount];
            for (i = 0; i < XObject.animations[animationId].actionSequenceCounts.length; ++i) {
                XObject.animations[animationId].actionSequenceCounts[i] = dis.readShort();
            }
            XObject.animations[animationId].actionSequenceOffset = new short[XObject.animations[animationId].actionCount + 1];
            for (i = 0; i < XObject.animations[animationId].actionSequenceOffset.length; ++i) {
                XObject.animations[animationId].actionSequenceOffset[i] = dis.readShort();
            }
            XObject.animations[animationId].sequenceCount = dis.readShort();
            XObject.animations[animationId].sequenceDatas = new short[XObject.animations[animationId].sequenceCount << 1];
            for (i = 0; i < XObject.animations[animationId].sequenceDatas.length; ++i) {
                XObject.animations[animationId].sequenceDatas[i] = dis.readShort();
            }
            XObject.animations[animationId].colBoxCount = dis.readShort();
            XObject.animations[animationId].attBoxCount = dis.readShort();
            XObject.animations[animationId].colBoxs = new short[XObject.animations[animationId].colBoxCount << 2];
            XObject.animations[animationId].attBoxs = new short[XObject.animations[animationId].attBoxCount << 2];
            for (i = 0; i < XObject.animations[animationId].colBoxs.length; ++i) {
                XObject.animations[animationId].colBoxs[i] = dis.readShort();
            }
            for (i = 0; i < XObject.animations[animationId].attBoxs.length; ++i) {
                XObject.animations[animationId].attBoxs[i] = dis.readShort();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        byte[] spriteTemp = animationData;
        this.aSprite.Load(spriteTemp, 0);
        this.aSpriteInstance._sprite = this.aSprite;
    }

    public void SetAnim(int id) {
        this.aSpriteInstance.SetAnim(id);
    }

    public void paint(Graphics g, float xScale, float yScale) {
        this.aSpriteInstance.PaintSprite(g, xScale, yScale);
    }

    public void paint(Graphics g) {
        this.aSpriteInstance.PaintSprite(g);
    }

    public void paint(Graphics g, int frameIndex) {
        this.aSpriteInstance.paintSprite(g, frameIndex);
    }

    public void paintFrame(Graphics g, int actionID, int actionSquenceIndex, int x, int y, int type) {
        if (actionID != this.getActionID()) {
            this.SetAnim(actionID);
        }
        this.setXY(x, y);
        if (type == 0) {
            this.paint(g);
        } else {
            this.paint(g, actionSquenceIndex);
        }
    }

    public void paintFrame(Graphics g, int actionID, int actionSquenceIndex, int x, int y, float xScale, float yScale) {
        if (actionID != this.getActionID()) {
            this.SetAnim(actionID);
        }
        this.setXY(x, y);
        this.paint(g, xScale, yScale);
    }

    public int getActionID() {
        return this.aSpriteInstance.getAnim();
    }

    public int getFrameID() {
        return this.aSpriteInstance.getFrame();
    }

    public void setFrameID(int frameID) {
        this.aSpriteInstance.setFrame(frameID);
    }

    public void updataAnim() {
        this.aSpriteInstance.UpdateSpriteAnim();
    }

    public void setXY(int x, int y) {
        this.aSpriteInstance._posX = x << 8;
        this.aSpriteInstance._posY = y << 8;
    }

    public int[] GetRect() {
        return this.aSpriteInstance.GetRect();
    }

    public boolean IsAnimEnded() {
        Object var1_1 = null;
        if (GameEngine._a0()) {
            return false;
        }
        return this.aSpriteInstance.IsAnimEnded();
    }

    public boolean IsAnimEnded(int frameIndex) {
        return this.aSpriteInstance.IsAnimEnded(frameIndex);
    }

    public int getAFramesCount(int actionId) {
        return this.aSprite.GetAFrames(actionId);
    }

    public short[] getBoxesInfo(byte type, int actionID, int actionSquenceIndex) {
        Object var4_4 = null;
        if (GameEngine._a0()) {
            return null;
        }
        int frame = this.sequenceDatas[this.actionSequenceOffset[actionID] + (actionSquenceIndex << 1)] >> 0 & 0x3FF;
        int offset = 0;
        switch (type) {
            case 1: {
                offset = (this.frameBoxIndexs[frame << 1] & 0xFF) << 2;
                System.arraycopy(this.colBoxs, offset, this.colBox, 0, 4);
                return this.colBox;
            }
            case 2: {
                offset = (this.frameBoxIndexs[(frame << 1) + 1] & 0xFF) << 2;
                System.arraycopy(this.attBoxs, offset, this.attBox, 0, 4);
                return this.attBox;
            }
        }
        return null;
    }

    public boolean isAttackFrame(int actionID, int actionSquenceIndex) {
        Object var3_3 = null;
        if (GameEngine._a1()) {
            return false;
        }
        short keyFrameInfo = this.sequenceDatas[this.actionSequenceOffset[actionID] + ((actionSquenceIndex << 1) + 1)];
        return keyFrameInfo > 0;
    }

    public int getAttackFrameHurtID(int actionID, int actionSquenceIndex) {
        short keyFrameInfo = this.sequenceDatas[this.actionSequenceOffset[actionID] + ((actionSquenceIndex << 1) + 1)];
        return keyFrameInfo & 0xF;
    }

    public int getAttackFrameSkipNum(int actionID, int actionSquenceIndex) {
        short keyFrameInfo = this.sequenceDatas[this.actionSequenceOffset[actionID] + ((actionSquenceIndex << 1) + 1)];
        return (keyFrameInfo & 0xF0) >> 4;
    }

    public int getAttackFrameMoveDistance(int actionID, int actionSquenceIndex) {
        short keyFrameInfo = this.sequenceDatas[this.actionSequenceOffset[actionID] + ((actionSquenceIndex << 1) + 1)];
        return (keyFrameInfo & 0xF00) >> 8;
    }

    public int getAttackFrameReserve(int actionID, int actionSquenceIndex) {
        short keyFrameInfo = this.sequenceDatas[this.actionSequenceOffset[actionID] + ((actionSquenceIndex << 1) + 1)];
        return (keyFrameInfo & 0xF000) >> 12;
    }

    public void updateActionSquenceController(short actionID, short[] controller) {
        this.updataAnim();
        controller[1] = (short)(controller[1] + 1);
        if (controller[1] < (this.sequenceDatas[this.actionSequenceOffset[actionID] + (controller[0] << 1)] >> 11 & 0x2F)) {
            return;
        }
        controller[1] = 0;
        controller[0] = (short)(controller[0] + 1);
        if (controller[0] > this.actionSequenceCounts[actionID] - 1) {
            controller[0] = 0;
        }
    }

    public void destroyImg() {
        this.aSprite.destroyBSpriteImg();
    }

    public void destroy() {
        this.frameBoxIndexs = null;
        this.sequenceDatas = null;
        this.actionSequenceCounts = null;
        this.colBoxs = null;
        this.attBoxs = null;
        this.aSprite.destoryBsprite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAnim(int animID) {
        if (XObject.animations[animID] != null) {
            return;
        }
        InputStream is = null;
        DataInputStream dis = null;
        try {
            animationCount = GameEngine.animationCount;
            is = "".getClass().getResourceAsStream("/sprite/" + animID + ".lst");
            dis = new DataInputStream(is);
            animationData = new byte[dis.available()];
            dis.read(animationData);
            XObject.animations[animID] = new Animation();
            XObject.animations[animID].load();
            animationData = null;
            is = "".getClass().getResourceAsStream("/animationPlus.bin");
            dis = new DataInputStream(is);
            bspritePlusOffset = new int[animationCount + 1];
            for (int j = 0; j < bspritePlusOffset.length; ++j) {
                Animation.bspritePlusOffset[j] = dis.readInt();
            }
            bspritePlusOffsetData = new int[1];
            Animation.bspritePlusOffsetData[0] = bspritePlusOffset[animID];
            Animation.readBSpritePlus(0, animID, dis);
            dis.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dis = null;
            is = null;
        }
    }
}

