/*
 * Decompiled with CFR 0.152.
 */
public class Key {
    public static final int GK_NONE = 0;
    public static final int GK_UP = 1;
    public static final int GK_DOWN = 2;
    public static final int GK_LEFT = 4;
    public static final int GK_RIGHT = 8;
    public static final int GK_NUM0 = 16;
    public static final int GK_NUM1 = 32;
    public static final int GK_NUM3 = 64;
    public static final int GK_NUM5 = 128;
    public static final int GK_NUM7 = 256;
    public static final int GK_NUM9 = 512;
    public static final int GK_STAR = 1024;
    public static final int GK_POUND = 2048;
    public static final int GK_SOFT_LEFT = 4096;
    public static final int GK_SOFT_RIGHT = 8192;
    public static final int GK_MIDDLE = 16384;
    public static final int GK_RETURN = 32768;
    public static final int GK_OK = 20480;
    public static final int GK_CANCEL = 8192;
    public static final int GK_ALL_KEY = 17279;
    public static final int GK_ALLDIR_KEY = 15;
    private static final int KEY_UP = 1;
    private static final int KEY_DOWN = 2;
    private static final int KEY_LEFT = 3;
    private static final int KEY_RIGHT = 4;
    private static final int KEY_SOFT_LEFT = 6;
    private static final int KEY_SOFT_RIGHT = 7;
    private static final int KEY_MID = 5;
    private static final int KEY_RETURN = -1;
    private static int m_keyCurrent;
    private static int m_keyPressed;
    private static int m_keyReleased;
    private static int m_keyDblPressed;
    private static String m_keyCombination;
    private static int m_lastPressed;
    private static int m_keyTick;
    private static int m_keyCombinTick;
    public static int m_fastCurrentKey;
    private static final byte GAMEKEY_QUEUE_SIZE = 6;
    private static int[] m_gkQueue;
    private static int m_queueStart;
    private static int m_queueEnd;
    private static int[] keyCombin;

    public static void InitKey() {
        m_keyCurrent = 0;
        m_keyPressed = 0;
        m_keyReleased = 0;
        m_keyDblPressed = 0;
        m_keyCombination = "";
        m_lastPressed = 0;
        m_keyTick = 0;
        m_keyCombinTick = 0;
        m_fastCurrentKey = 0;
        for (int i = 0; i < 6; ++i) {
            Key.m_gkQueue[i] = 0;
        }
        m_queueEnd = 0;
        m_queueStart = 0;
    }

    private static boolean PushQueue(int key) {
        if ((m_queueStart + 1) % 6 == m_queueEnd) {
            return false;
        }
        Key.m_gkQueue[Key.m_queueStart] = key;
        m_queueStart = (m_queueStart + 1) % 6;
        return true;
    }

    private static int PopQueue() {
        if (m_queueStart == m_queueEnd) {
            return m_fastCurrentKey;
        }
        int key = m_gkQueue[m_queueEnd];
        m_queueEnd = (m_queueEnd + 1) % 6;
        return key;
    }

    public static void UpdateKey() {
        int currentKey = Key.PopQueue();
        m_keyPressed = ~m_keyCurrent & currentKey;
        m_keyReleased = m_keyCurrent & ~currentKey;
        m_keyCurrent = currentKey;
        m_keyCombination = "";
        ++m_keyTick;
        ++m_keyCombinTick;
        Key.judgeCombinKey();
        Key.judgeDoubleKey();
    }

    private static void judgeDoubleKey() {
        if (m_keyPressed != 0) {
            if (m_lastPressed != 0 && m_keyTick < 10 && m_lastPressed == m_keyPressed) {
                m_keyDblPressed = m_keyPressed;
                m_lastPressed = 0;
            } else {
                m_keyTick = 0;
                m_keyDblPressed = 0;
                m_lastPressed = m_keyPressed;
            }
        } else if (m_keyDblPressed != 0) {
            m_keyDblPressed = 0;
        }
    }

    private static void judgeCombinKey() {
        if (keyCombin[0] == 0) {
            Key.keyCombin[0] = m_keyPressed;
            m_keyCombinTick = 0;
        } else if (keyCombin[1] == 0) {
            Key.keyCombin[1] = m_keyPressed;
        }
        if (m_keyCombinTick < 10) {
            if (keyCombin[1] != 0) {
                m_keyCombination = String.valueOf(keyCombin[0]) + String.valueOf(keyCombin[1]);
                Key.keyCombin[1] = 0;
                Key.keyCombin[0] = 0;
                m_keyCombinTick = 0;
            }
        } else {
            Key.keyCombin[1] = 0;
            Key.keyCombin[0] = 0;
            m_keyCombinTick = 0;
        }
    }

    public static boolean IsAnyKeyPressed() {
        return m_keyPressed != 0;
    }

    public static boolean IsKeyDblPressed(int gameKey) {
        return (m_keyDblPressed & gameKey) != 0;
    }

    public static boolean IsKeyCombined(int firstGameKey, int lastGameKey) {
        return m_keyCombination.equals(String.valueOf(firstGameKey) + String.valueOf(lastGameKey));
    }

    public static boolean IsKeyPressed(int gameKey) {
        if (gameKey == 0 && m_keyPressed == 0) {
            return true;
        }
        return (m_keyPressed & gameKey) != 0;
    }

    public static boolean IsKeyHold(int gameKey) {
        return (m_keyCurrent & gameKey) != 0;
    }

    public static int GetKey(int keyCode) {
        switch (keyCode) {
            case 1: 
            case 50: {
                return 1;
            }
            case 2: 
            case 56: {
                return 2;
            }
            case 3: 
            case 52: {
                return 4;
            }
            case 4: 
            case 54: {
                return 8;
            }
            case 5: 
            case 53: {
                return 16384;
            }
            case 6: {
                return 4096;
            }
            case 7: {
                return 8192;
            }
            case 48: {
                return 16;
            }
            case 49: {
                return 32;
            }
            case 51: {
                return 64;
            }
            case 57: {
                return 512;
            }
            case 55: {
                return 256;
            }
            case 35: {
                return 2048;
            }
            case 42: {
                return 1024;
            }
            case -1: {
                return 32768;
            }
        }
        return 0;
    }

    static {
        m_gkQueue = new int[6];
        keyCombin = new int[2];
    }
}

