/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private static int mapFlag = 0;
    private static final int MAP_WH_SHORT = 1;
    private static final int MAP_GOURND_SHORT = 2;
    private static final int MAP_BUILD_SHORT = 4;
    private static final int MAP_COVER_SHORT = 8;
    private static final int MAP_USE_TRANS = 16;
    private static final int MAP_GOURND_FORMAT = 32;
    private static final int MAP_BUILD_FORMAT = 64;
    private static final int MAP_COVER_FORMAT = 128;
    private static final int MAP_FLIP_FORMAT = 256;
    private static final int MAP_PHY_FORMAT = 512;
    private static final int MAP_TYPE_INTEGER_IMAGE_FORMAT = 2048;
    private static final int MAP_TYPE_INTEGER_IMAGE_PHY_FORMAT_88 = 4096;
    public static short width;
    public static short height;
    private static short widthByTile;
    private static short heightByTile;
    public static byte cellWidth;
    public static byte cellHeight;
    private static byte[] phyData;
    private static short[] bulletData;
    private static byte mapDrawStyle;
    private static final byte DRAW_STYLE_TILE = 0;
    private static final byte DRAW_STYLE_INTEGRATED = 1;
    public static final short MAP_LAYER_GROUND = 0;
    public static final short MAP_LAYER_BUILD = 1;
    public static final short MAP_LAYER_DATA = 2;
    public static final short MAP_LAYER_BULLET = 3;
    private static Image[] imgIntegratedMap;
    private static short[] imgIntegratedX;
    private static short[] imgIntegratedY;
    private static short[] imgIntegratedSrcX;
    private static short[] imgIntegratedSrcY;
    private static short[] imgIntegratedSrcWidth;
    private static short[] imgIntegratedSrcHeight;
    private static byte[] imgIntegratedFlag;
    private static final int FLAG_INTEGRATED_REGION = 8;
    private static final int FLAG_INTEGRATED_VISIBLE = 16;
    private static final int FLAG_INTEGRATED_FLIP = 32;
    private static final int FLAG_INTEGRATED_COVER = 64;
    private static byte firstCoverIndex;
    private static short[] groundData;
    private static short[] buildData;
    private static short[] coverData;
    private static byte[] transData;
    private static short[] imgGroundIndex;
    private static short[] imgBuildIndex;
    private static short[] imgCoverIndex;
    private static final int FLAG_MAP_IMAGE = 1;
    public static Image[] imgGroundMap;
    public static Image[] imgBuildMap;
    public static Image[] imgCoverMap;
    private static final int FLIP_BUILD_MIRROR = 1;
    private static final int FLIP_BUILD_MIRROR_ROT180 = 2;
    private static final int FLIP_COVER_MIRROR = 4;
    private static final int FLIP_COVER_MIRROR_ROT180 = 8;
    private static final int FLIP_GROUND_MIRROR = 16;
    private static final int FLIP_GROUND_MIRROR_ROT180 = 32;
    private static byte screenWidthByTile;
    private static byte screenHeightByTile;
    private static int topLeftX;
    private static int topLeftY;
    private static int startCol;
    private static int startRow;
    private static int endCol;
    private static int endRow;
    private static int offsetX;
    private static int offsetY;
    private static byte[][] obstruct;
    public static final byte OBSTRUCT = -1;
    public static final byte NO_OBSTRUCT = 0;
    public static byte[] preciousBoxFrameIndex;
    public static byte objPositionIndex;
    private static int[] drawObjList;
    private static int actorInScreenCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMapRes(int level) {
        FilterInputStream dis = null;
        InputStream is = null;
        try {
            is = "".getClass().getResourceAsStream("/map.bin");
            dis = new DataInputStream(is);
            byte levelCount = ((DataInputStream)dis).readByte();
            System.out.println("mapCount = " + levelCount);
            System.out.println("map offset\uff1a");
            int[] levelOffset = new int[levelCount + 1];
            for (int i = 0; i < levelOffset.length; ++i) {
                levelOffset[i] = ((DataInputStream)dis).readInt();
                System.out.print(levelOffset[i] + "   ");
            }
            System.out.println();
            dis.skip(levelOffset[level]);
            mapFlag = ((DataInputStream)dis).readInt();
            System.out.println("mapFlag = " + mapFlag);
            if ((mapFlag & 0x1000) != 0) {
                cellWidth = (byte)8;
                cellHeight = (byte)8;
            } else {
                cellWidth = (byte)16;
                cellHeight = (byte)16;
            }
            System.out.println("cellWidth = " + cellWidth);
            System.out.println("cellHeight = " + cellHeight);
            if ((mapFlag & 0x800) != 0) {
                Map.loadIntegratedFarmat((DataInputStream)dis);
            } else {
                Map.loadTileFarmat((DataInputStream)dis);
                dis.skip(levelOffset[levelCount] - levelOffset[level + 1]);
                Map.loadTileImage((DataInputStream)dis);
            }
            Map.initObstruct();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dis.close();
                is.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.gc();
        GameEngine.pause(20L);
        Map.initMap();
    }

    private static void initMap() {
        screenWidthByTile = (byte)(240 / cellWidth);
        screenHeightByTile = (byte)(320 / cellHeight);
        if (240 % cellWidth != 0) {
            screenWidthByTile = (byte)(screenWidthByTile + 1);
        }
        if (320 % cellHeight != 0) {
            screenHeightByTile = (byte)(screenHeightByTile + 1);
        }
        screenWidthByTile = (byte)(screenWidthByTile + 1);
        screenHeightByTile = (byte)(screenHeightByTile + 1);
    }

    private static void loadTileFarmat(DataInputStream dis) {
        try {
            int i;
            mapDrawStyle = 0;
            System.out.println("tile style");
            int imgGroundCount = 0;
            if ((mapFlag & 0x20) != 0) {
                int i2;
                if ((mapFlag & 2) != 0) {
                    imgGroundCount = dis.readShort();
                    imgGroundIndex = new short[imgGroundCount];
                    for (i2 = 0; i2 < imgGroundCount; ++i2) {
                        Map.imgGroundIndex[i2] = dis.readShort();
                    }
                } else {
                    imgGroundCount = dis.readByte();
                    imgGroundIndex = new short[imgGroundCount];
                    for (i2 = 0; i2 < imgGroundCount; ++i2) {
                        Map.imgGroundIndex[i2] = dis.readByte();
                    }
                }
            }
            int imgBuildCount = 0;
            if ((mapFlag & 0x40) != 0) {
                int i3;
                if ((mapFlag & 4) != 0) {
                    imgBuildCount = dis.readShort();
                    imgBuildIndex = new short[imgBuildCount];
                    for (i3 = 0; i3 < imgBuildCount; ++i3) {
                        Map.imgBuildIndex[i3] = dis.readShort();
                    }
                } else {
                    imgBuildCount = dis.readByte();
                    imgBuildIndex = new short[imgBuildCount];
                    for (i3 = 0; i3 < imgBuildCount; ++i3) {
                        Map.imgBuildIndex[i3] = dis.readByte();
                    }
                }
            }
            int imgCoverCount = 0;
            if ((mapFlag & 0x80) != 0) {
                if ((mapFlag & 8) != 0) {
                    imgCoverCount = dis.readShort();
                    imgCoverIndex = new short[imgCoverCount];
                    for (i = 0; i < imgCoverCount; ++i) {
                        Map.imgCoverIndex[i] = dis.readShort();
                    }
                } else {
                    imgCoverCount = dis.readByte();
                    imgCoverIndex = new short[imgCoverCount];
                    for (i = 0; i < imgCoverCount; ++i) {
                        Map.imgCoverIndex[i] = dis.readByte();
                    }
                }
            }
            if ((mapFlag & 1) != 0) {
                widthByTile = dis.readShort();
                heightByTile = dis.readShort();
            } else {
                widthByTile = (short)(dis.readByte() & 0xFF);
                heightByTile = (short)(dis.readByte() & 0xFF);
            }
            width = (short)(widthByTile * cellWidth);
            height = (short)(heightByTile * cellHeight);
            System.out.println("widthByTile = " + widthByTile);
            System.out.println("heightByTile = " + heightByTile);
            cellWidth = dis.readByte();
            cellHeight = dis.readByte();
            System.out.println("cellWidth = " + cellWidth);
            System.out.println("cellHeight = " + cellHeight);
            if ((mapFlag & 0x20) != 0) {
                groundData = new short[widthByTile * heightByTile];
                if ((mapFlag & 2) != 0) {
                    for (i = 0; i < groundData.length; ++i) {
                        Map.groundData[i] = dis.readShort();
                    }
                } else {
                    for (i = 0; i < groundData.length; ++i) {
                        Map.groundData[i] = dis.readByte();
                    }
                }
            }
            if ((mapFlag & 0x40) != 0) {
                buildData = new short[widthByTile * heightByTile];
                if ((mapFlag & 4) != 0) {
                    for (i = 0; i < buildData.length; ++i) {
                        Map.buildData[i] = dis.readShort();
                    }
                } else {
                    for (i = 0; i < buildData.length; ++i) {
                        Map.buildData[i] = dis.readByte();
                    }
                }
            }
            if ((mapFlag & 0x80) != 0) {
                coverData = new short[widthByTile * heightByTile];
                if ((mapFlag & 8) != 0) {
                    for (i = 0; i < coverData.length; ++i) {
                        Map.coverData[i] = dis.readShort();
                    }
                } else {
                    for (i = 0; i < coverData.length; ++i) {
                        Map.coverData[i] = dis.readByte();
                    }
                }
            }
            if ((mapFlag & 0x200) != 0) {
                phyData = new byte[widthByTile * heightByTile];
                for (i = 0; i < phyData.length; ++i) {
                    Map.phyData[i] = dis.readByte();
                }
            }
            if ((mapFlag & 0x100) != 0 && (mapFlag & 0x10) != 0) {
                transData = new byte[widthByTile * heightByTile];
                for (i = 0; i < transData.length; ++i) {
                    Map.transData[i] = dis.readByte();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadTileImage(DataInputStream dis) {
        try {
            byte imageFlag = dis.readByte();
            if ((imageFlag & 1) != 0) {
                Map.loadTileImageByBin(dis);
            } else {
                Map.loadTileImageByPNG(dis);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void loadTileImageByBin(DataInputStream dis) {
        block19: {
            try {
                int i;
                int i2;
                byte[] imgData = null;
                short groundTileCount = 0;
                if ((mapFlag & 0x20) != 0) {
                    groundTileCount = (mapFlag & 2) != 0 ? dis.readShort() : (short)dis.readByte();
                    imgGroundMap = new Image[groundTileCount];
                    int[] groundTileOffset = new int[groundTileCount + 1];
                    for (int i3 = 0; i3 < groundTileOffset.length; ++i3) {
                        groundTileOffset[i3] = dis.readInt();
                    }
                    int idxImgGroundIndex = 0;
                    for (i2 = 0; i2 < groundTileOffset.length; ++i2) {
                        if (i2 <= 0) continue;
                        imgData = new byte[groundTileOffset[i2] - groundTileOffset[i2 - 1]];
                        if (i2 - 1 == imgGroundIndex[idxImgGroundIndex]) {
                            dis.read(imgData);
                            Map.imgGroundMap[i2 - 1] = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                            idxImgGroundIndex = (short)(idxImgGroundIndex + 1);
                        } else {
                            dis.skip(imgData.length);
                        }
                        if (idxImgGroundIndex < imgGroundIndex.length) continue;
                        for (int j = i2 + 1; j < groundTileOffset.length; ++j) {
                            dis.skip(groundTileOffset[j] - groundTileOffset[j - 1]);
                        }
                        break;
                    }
                    groundTileOffset = null;
                }
                short buildTileCount = 0;
                if ((mapFlag & 0x40) != 0) {
                    buildTileCount = (mapFlag & 4) != 0 ? dis.readShort() : (short)dis.readByte();
                    imgBuildMap = new Image[buildTileCount];
                    int[] buildTileOffset = new int[buildTileCount + 1];
                    for (i2 = 0; i2 < buildTileOffset.length; ++i2) {
                        buildTileOffset[i2] = dis.readInt();
                    }
                    int idxImgBuildIndex = 0;
                    for (i = 0; i < buildTileOffset.length; ++i) {
                        if (i <= 0) continue;
                        imgData = new byte[buildTileOffset[i] - buildTileOffset[i - 1]];
                        if (i - 1 == imgBuildIndex[idxImgBuildIndex]) {
                            dis.read(imgData);
                            Map.imgBuildMap[i - 1] = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                            idxImgBuildIndex = (short)(idxImgBuildIndex + 1);
                        } else {
                            dis.skip(imgData.length);
                        }
                        if (idxImgBuildIndex < imgBuildIndex.length) continue;
                        for (int j = i + 1; j < buildTileOffset.length; ++j) {
                            dis.skip(buildTileOffset[j] - buildTileOffset[j - 1]);
                        }
                        break;
                    }
                    buildTileOffset = null;
                }
                short coverTileCount = 0;
                if ((mapFlag & 0x80) == 0) break block19;
                coverTileCount = (mapFlag & 8) != 0 ? dis.readShort() : (short)dis.readByte();
                imgCoverMap = new Image[coverTileCount];
                int[] coverTileOffset = new int[coverTileCount + 1];
                for (i = 0; i < coverTileOffset.length; ++i) {
                    coverTileOffset[i] = dis.readInt();
                }
                int idxImgCoverIndex = 0;
                for (int i4 = 0; i4 < coverTileOffset.length; ++i4) {
                    if (i4 <= 0) continue;
                    imgData = new byte[coverTileOffset[i4] - coverTileOffset[i4 - 1]];
                    if (i4 - 1 == imgCoverIndex[idxImgCoverIndex]) {
                        dis.read(imgData);
                        Map.imgCoverMap[i4 - 1] = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                        idxImgCoverIndex = (short)(idxImgCoverIndex + 1);
                    } else {
                        dis.skip(imgData.length);
                    }
                    if (idxImgCoverIndex < imgCoverIndex.length) continue;
                    for (int j = i4 + 1; j < coverTileOffset.length; ++j) {
                        dis.skip(coverTileOffset[j] - coverTileOffset[j - 1]);
                    }
                    break;
                }
                coverTileOffset = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadTileImageByPNG(DataInputStream dis) {
        block11: {
            try {
                short groundTileCount = 0;
                if ((mapFlag & 0x20) != 0) {
                    groundTileCount = (mapFlag & 2) != 0 ? dis.readShort() : (short)dis.readByte();
                    imgGroundMap = new Image[groundTileCount];
                    int idxImgGroundIndex = 0;
                    for (int i = 0; i < imgGroundMap.length; ++i) {
                        if (i == imgGroundIndex[idxImgGroundIndex]) {
                            Map.imgGroundMap[i] = Image.createImage((String)("/ground/" + i + ".png"));
                            idxImgGroundIndex = (short)(idxImgGroundIndex + 1);
                        }
                        if (idxImgGroundIndex >= imgGroundIndex.length) break;
                    }
                }
                short buildTileCount = 0;
                if ((mapFlag & 0x40) != 0) {
                    buildTileCount = (mapFlag & 4) != 0 ? dis.readShort() : (short)dis.readByte();
                    imgBuildMap = new Image[buildTileCount];
                    int idxImgBuildIndex = 0;
                    for (int i = 0; i < imgBuildMap.length; ++i) {
                        if (i == imgBuildIndex[idxImgBuildIndex]) {
                            Map.imgBuildMap[i] = Image.createImage((String)("/build/" + i + ".png"));
                            idxImgBuildIndex = (short)(idxImgBuildIndex + 1);
                        }
                        if (idxImgBuildIndex >= imgBuildIndex.length) break;
                    }
                }
                short coverTileCount = 0;
                if ((mapFlag & 0x80) == 0) break block11;
                coverTileCount = (mapFlag & 8) != 0 ? dis.readShort() : (short)dis.readByte();
                imgCoverMap = new Image[coverTileCount];
                int idxImgCoverIndex = 0;
                for (int i = 0; i < imgCoverMap.length; ++i) {
                    if (i == imgCoverIndex[idxImgCoverIndex]) {
                        Map.imgCoverMap[i] = Image.createImage((String)("/cover/" + i + ".png"));
                        idxImgCoverIndex = (short)(idxImgCoverIndex + 1);
                    }
                    if (idxImgCoverIndex < imgCoverIndex.length) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadIntegratedFarmat(DataInputStream dis) {
        try {
            int j;
            int i;
            mapDrawStyle = 1;
            System.out.println("integer image style");
            if ((mapFlag & 1) != 0) {
                widthByTile = dis.readShort();
                heightByTile = dis.readShort();
            } else {
                widthByTile = (short)(dis.readByte() & 0xFF);
                heightByTile = (short)(dis.readByte() & 0xFF);
            }
            width = (short)(widthByTile * cellWidth);
            height = (short)(heightByTile * cellHeight);
            System.out.println("widthByTile = " + widthByTile);
            System.out.println("heightByTile = " + heightByTile);
            int integratedImageNum = dis.readByte();
            System.out.println("integratedImageNum = " + integratedImageNum);
            short[] integratedImageElementData = new short[integratedImageNum * 7];
            imgIntegratedMap = new Image[integratedImageNum];
            imgIntegratedX = new short[integratedImageNum];
            imgIntegratedY = new short[integratedImageNum];
            imgIntegratedSrcX = new short[integratedImageNum];
            imgIntegratedSrcY = new short[integratedImageNum];
            imgIntegratedSrcWidth = new short[integratedImageNum];
            imgIntegratedSrcHeight = new short[integratedImageNum];
            imgIntegratedFlag = new byte[integratedImageNum];
            for (int i2 = 0; i2 < integratedImageElementData.length; ++i2) {
                integratedImageElementData[i2] = dis.readShort();
            }
            int[][] mapRes = new int[integratedImageNum][2];
            for (i = 0; i < integratedImageNum; ++i) {
                for (j = 0; j < 2; ++j) {
                    mapRes[i][j] = -1;
                }
            }
            i = 0;
            j = 0;
            while (i < integratedImageElementData.length) {
                int m;
                boolean needLoadImage = true;
                for (m = 0; m < integratedImageNum; ++m) {
                    if ((integratedImageElementData[i] & 0xFF) != mapRes[m][0]) continue;
                    Map.imgIntegratedMap[j] = imgIntegratedMap[mapRes[m][1]];
                    needLoadImage = false;
                    break;
                }
                if (needLoadImage) {
                    Map.imgIntegratedMap[j] = Image.createImage((String)("/map/" + (integratedImageElementData[i] & 0xFF) + ".png"));
                    for (m = 0; m < integratedImageNum; ++m) {
                        if (mapRes[m][0] != -1) continue;
                        mapRes[m][0] = integratedImageElementData[i] & 0xFF;
                        mapRes[m][1] = j;
                        break;
                    }
                }
                Map.imgIntegratedFlag[j] = (byte)((integratedImageElementData[i] & 0xFF00) >> 8);
                Map.imgIntegratedX[j] = integratedImageElementData[i + 1];
                Map.imgIntegratedY[j] = integratedImageElementData[i + 2];
                Map.imgIntegratedSrcX[j] = integratedImageElementData[i + 3];
                Map.imgIntegratedSrcY[j] = integratedImageElementData[i + 4];
                Map.imgIntegratedSrcWidth[j] = integratedImageElementData[i + 5];
                Map.imgIntegratedSrcHeight[j] = integratedImageElementData[i + 6];
                i += 7;
                ++j;
            }
            if ((mapFlag & 0x200) != 0) {
                phyData = new byte[widthByTile * heightByTile];
                dis.read(phyData);
            }
            Map.doFirstCoverIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initObstruct() {
        obstruct = new byte[widthByTile][heightByTile];
        if (phyData == null) {
            return;
        }
        Map.initObstruct(0, 0, widthByTile - 1, heightByTile - 1);
        System.out.println("initObstruct success");
    }

    private static void initObstruct(int si, int sj, int ei, int ej) {
        if (si >= ei || sj >= ej) {
            return;
        }
        block0: for (int i = si; i <= ei; ++i) {
            if (i < 0) continue;
            if (i >= widthByTile) break;
            for (int j = sj; j <= ej; ++j) {
                if (j < 0) continue;
                if (j >= heightByTile) continue block0;
                Map.obstruct[i][j] = phyData[i * heightByTile + j] == 0 ? 0 : -1;
            }
        }
    }

    private static void doFirstCoverIndex() {
        for (int i = 0; i < imgIntegratedFlag.length; i = (int)((byte)(i + 1))) {
            if ((imgIntegratedFlag[i] & 0x40) == 0) continue;
            firstCoverIndex = (byte)i;
            return;
        }
        firstCoverIndex = (byte)imgIntegratedFlag.length;
    }

    public static void paint(Graphics g, int topLeftX, int topLeftY) {
        Map.topLeftX = topLeftX;
        Map.topLeftY = topLeftY;
        startRow = topLeftY / cellHeight;
        startCol = topLeftX / cellWidth;
        endRow = startRow + screenHeightByTile;
        endCol = startCol + screenWidthByTile;
        offsetY = -(topLeftY % cellHeight);
        offsetX = -(topLeftX % cellWidth);
        switch (mapDrawStyle) {
            case 0: {
                Map.drawTileGroundBuildLevel(g);
                Map.drawOtherObject(g);
                Map.drawHeros(g);
                Map.drawTileCoverLevel(g);
                break;
            }
            case 1: {
                Map.drawIntegratedGroundBuildLevel(g);
                Map.drawHeroAndOtherObject(g);
                Map.drawIntegratedCoverLevel(g);
            }
        }
    }

    private static void drawTileGroundBuildLevel(Graphics g) {
        block0: for (int i = startRow; i < endRow; ++i) {
            if (i < 0) continue;
            if (i >= heightByTile) break;
            int rowPosIndex = i * widthByTile;
            for (int j = startCol; j < endCol; ++j) {
                if (j < 0) continue;
                if (j >= widthByTile) continue block0;
                short tempGroundIndex = groundData[rowPosIndex + j];
                short tempBuildIndex = buildData[rowPosIndex + j];
                int tileTopX = (j - startCol) * cellWidth + offsetX;
                int tileTopY = (i - startRow) * cellHeight + offsetY;
                if (transData[rowPosIndex + j] == 0) {
                    if (tempGroundIndex > -1) {
                        g.drawImage(imgGroundMap[tempGroundIndex], tileTopX, tileTopY, 0);
                    }
                    if (tempBuildIndex <= -1) continue;
                    g.drawImage(imgBuildMap[tempBuildIndex], tileTopX, tileTopY, 0);
                    continue;
                }
                if (tempGroundIndex > -1) {
                    if ((transData[rowPosIndex + j] & 0x10) != 0) {
                        g.drawRegion(imgGroundMap[tempGroundIndex], 0, 0, (int)cellWidth, (int)cellHeight, 2, tileTopX, tileTopY, 0);
                    } else if ((transData[rowPosIndex + j] & 0x20) != 0) {
                        g.drawRegion(imgGroundMap[tempGroundIndex], 0, 0, (int)cellWidth, (int)cellHeight, 1, tileTopX, tileTopY, 0);
                    } else {
                        g.drawImage(imgGroundMap[tempGroundIndex], tileTopX, tileTopY, 0);
                    }
                }
                if (tempBuildIndex <= -1) continue;
                if ((transData[rowPosIndex + j] & 1) != 0) {
                    g.drawRegion(imgBuildMap[tempBuildIndex], 0, 0, (int)cellWidth, (int)cellHeight, 2, tileTopX, tileTopY, 0);
                    continue;
                }
                if ((transData[rowPosIndex + j] & 2) != 0) {
                    g.drawRegion(imgBuildMap[tempBuildIndex], 0, 0, (int)cellWidth, (int)cellHeight, 1, tileTopX, tileTopY, 0);
                    continue;
                }
                g.drawImage(imgBuildMap[tempBuildIndex], tileTopX, tileTopY, 0);
            }
        }
    }

    private static void drawTileCoverLevel(Graphics g) {
        block0: for (int i = startRow; i < endRow; ++i) {
            if (i < 0) continue;
            if (i >= heightByTile) break;
            int rowPosIndex = i * widthByTile;
            for (int j = startCol; j < endCol; ++j) {
                if (j < 0) continue;
                if (j >= widthByTile) continue block0;
                short tempCoverIndex = coverData[rowPosIndex + j];
                int tileTopX = (j - startCol) * cellWidth + offsetX;
                int tileTopY = (i - startRow) * cellHeight + offsetY;
                if (transData[rowPosIndex + j] == 0) {
                    if (tempCoverIndex <= -1) continue;
                    g.drawImage(imgCoverMap[tempCoverIndex], tileTopX, tileTopY, 0);
                    continue;
                }
                if (tempCoverIndex <= -1) continue;
                if ((transData[rowPosIndex + j] & 4) != 0) {
                    g.drawRegion(imgCoverMap[tempCoverIndex], 0, 0, (int)cellWidth, (int)cellHeight, 2, tileTopX, tileTopY, 0);
                    continue;
                }
                if ((transData[rowPosIndex + j] & 8) != 0) {
                    g.drawRegion(imgCoverMap[tempCoverIndex], 0, 0, (int)cellWidth, (int)cellHeight, 1, tileTopX, tileTopY, 0);
                    continue;
                }
                g.drawImage(imgCoverMap[tempCoverIndex], tileTopX, tileTopY, 0);
            }
        }
    }

    private static void drawIntegratedGroundBuildLevel(Graphics g) {
        for (int i = 0; i < firstCoverIndex; ++i) {
            if ((imgIntegratedFlag[i] & 0x10) != 0) continue;
            if ((imgIntegratedFlag[i] & 0x20) != 0) {
                g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 2, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
                continue;
            }
            if ((imgIntegratedFlag[i] & 8) != 0) {
                g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 0, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
                continue;
            }
            g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 0, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
        }
    }

    private static void drawIntegratedCoverLevel(Graphics g) {
        for (int i = firstCoverIndex; i < imgIntegratedMap.length; ++i) {
            if ((imgIntegratedFlag[i] & 0x10) != 0) continue;
            if ((imgIntegratedFlag[i] & 0x20) != 0) {
                g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 2, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
                continue;
            }
            if ((imgIntegratedFlag[i] & 8) != 0) {
                g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 0, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
                continue;
            }
            g.drawRegion(imgIntegratedMap[i], (int)imgIntegratedSrcX[i], (int)imgIntegratedSrcY[i], (int)imgIntegratedSrcWidth[i], (int)imgIntegratedSrcHeight[i], 0, imgIntegratedX[i] - topLeftX, imgIntegratedY[i] - topLeftY, 0);
        }
    }

    private static void drawHeros(Graphics g) {
        XHero obj = null;
        for (int i = 0; i < GameEngine.heros.length; ++i) {
            if (GameEngine.heros[i] == null || !(obj = GameEngine.heros[i]).checkFlag(16)) continue;
            obj.paint(g, obj.baseInfo[8] - topLeftX, obj.baseInfo[9] - topLeftY, 1);
        }
    }

    private static void drawOtherObject(Graphics g) {
        XObject obj = null;
        for (int i = 0; i < GameEngine.actorInScreen.length && GameEngine.actorInScreen[i] != 0; ++i) {
            obj = GameEngine.objList[GameEngine.actorInScreen[i]];
            if (obj instanceof XSystemObject || !obj.checkFlag(16)) continue;
            obj.paint(g, obj.baseInfo[8] - topLeftX, obj.baseInfo[9] - topLeftY, 1);
        }
    }

    private static void drawHeroAndOtherObject(Graphics g) {
        int i;
        actorInScreenCount = 0;
        for (i = 0; i < GameEngine.actorInScreen.length && GameEngine.actorInScreen[i] != 0; ++i) {
            ++actorInScreenCount;
        }
        drawObjList = new int[actorInScreenCount + 4];
        for (i = 0; i < drawObjList.length; ++i) {
            Map.drawObjList[i] = i < drawObjList.length - 4 ? GameEngine.actorInScreen[i] : i - actorInScreenCount;
        }
        for (i = 0; i < drawObjList.length; ++i) {
            for (int j = i + 1; j < drawObjList.length; ++j) {
                short yj;
                short yi = drawObjList[i] >= 4 ? GameEngine.objList[Map.drawObjList[i]].baseInfo[9] : GameEngine.heros[Map.drawObjList[i]].baseInfo[9];
                if (yi <= (yj = drawObjList[j] >= 4 ? GameEngine.objList[Map.drawObjList[j]].baseInfo[9] : GameEngine.heros[Map.drawObjList[j]].baseInfo[9])) continue;
                int temp = drawObjList[j];
                Map.drawObjList[j] = drawObjList[i];
                Map.drawObjList[i] = temp;
            }
        }
        XObject obj = null;
        for (int i2 = 0; i2 < drawObjList.length; ++i2) {
            obj = drawObjList[i2] >= 4 ? GameEngine.objList[drawObjList[i2]] : GameEngine.heros[drawObjList[i2]];
            if (obj instanceof XSystemObject || obj == null || !obj.checkFlag(16)) continue;
            obj.paint(g, obj.baseInfo[8] - topLeftX, obj.baseInfo[9] - topLeftY, 1);
        }
    }

    public static void destroy() {
        switch (mapDrawStyle) {
            case 0: {
                int i;
                groundData = null;
                buildData = null;
                phyData = null;
                transData = null;
                coverData = null;
                imgGroundIndex = null;
                imgBuildIndex = null;
                imgCoverIndex = null;
                obstruct = null;
                if (imgGroundMap != null) {
                    for (i = 0; i < imgGroundMap.length; ++i) {
                        Map.imgGroundMap[i] = null;
                    }
                    imgGroundMap = null;
                }
                if (imgBuildMap != null) {
                    for (i = 0; i < imgBuildMap.length; ++i) {
                        Map.imgBuildMap[i] = null;
                    }
                    imgBuildMap = null;
                }
                if (imgCoverMap == null) break;
                for (i = 0; i < imgCoverMap.length; ++i) {
                    Map.imgCoverMap[i] = null;
                }
                imgCoverMap = null;
                break;
            }
            case 1: {
                imgIntegratedX = null;
                imgIntegratedY = null;
                imgIntegratedSrcX = null;
                imgIntegratedSrcY = null;
                imgIntegratedSrcWidth = null;
                imgIntegratedSrcHeight = null;
                imgIntegratedFlag = null;
                obstruct = null;
                phyData = null;
                if (imgIntegratedMap == null) break;
                for (int i = 0; i < imgIntegratedMap.length; ++i) {
                    Map.imgIntegratedMap[i] = null;
                }
                imgIntegratedMap = null;
            }
        }
        System.gc();
        GameEngine.pause(20L);
    }

    public static short setLayerDataByGrid(byte layerID, int gridX, int gridY, byte value) {
        int pos = gridY * widthByTile + gridX;
        Map.setLayer(layerID, value, pos);
        return (short)pos;
    }

    private static void setLayer(short layerID, short value, int pos) {
        switch (layerID) {
            case 0: {
                Map.groundData[pos] = value;
                break;
            }
            case 1: {
                Map.buildData[pos] = value;
                break;
            }
            case 2: {
                Map.phyData[pos] = (byte)value;
                break;
            }
            case 3: {
                Map.bulletData[pos] = value;
            }
        }
    }

    public static boolean isCollidedInMap(int dstX, int dstY, int direction, XObject obj) {
        short[] colBox = obj.getColBox();
        int index = dstY / cellHeight * widthByTile + dstX / cellWidth;
        if (index < 0 || index >= phyData.length) {
            return true;
        }
        return phyData[index] < 0;
    }

    public static boolean isCollidedByOtherSprites(int direction, XObject obj) {
        boolean isCollided = false;
        switch (direction) {
            case 2: {
                obj.baseInfo[9] = (short)(obj.baseInfo[9] - obj.property[23]);
                break;
            }
            case 3: {
                obj.baseInfo[9] = (short)(obj.baseInfo[9] + obj.property[23]);
                break;
            }
            case 0: {
                obj.baseInfo[8] = (short)(obj.baseInfo[8] - obj.property[23]);
                break;
            }
            case 1: {
                obj.baseInfo[8] = (short)(obj.baseInfo[8] + obj.property[23]);
            }
        }
        short[] heroRect = obj.getCollisionBox();
        for (int i = 0; i < GameEngine.actorInScreen.length && GameEngine.actorInScreen[i] != 0; ++i) {
            short[] npcRect;
            XObject otherSprite = GameEngine.objList[GameEngine.actorInScreen[i]];
            if (!otherSprite.checkFlag(8) || !otherSprite.checkFlag(16) || !Tools.isCollisionByRect(heroRect, npcRect = otherSprite.getCollisionBox())) continue;
            short actionID = otherSprite.baseInfo[7];
            switch (direction) {
                case 2: {
                    obj.baseInfo[9] = (short)(obj.baseInfo[9] + obj.property[23]);
                    break;
                }
                case 3: {
                    obj.baseInfo[9] = (short)(obj.baseInfo[9] - obj.property[23]);
                    break;
                }
                case 0: {
                    obj.baseInfo[8] = (short)(obj.baseInfo[8] + obj.property[23]);
                    break;
                }
                case 1: {
                    obj.baseInfo[8] = (short)(obj.baseInfo[8] - obj.property[23]);
                }
            }
            return true;
        }
        return isCollided;
    }

    static {
        preciousBoxFrameIndex = new byte[120];
    }
}

