/*
 * Decompiled with CFR 0.152.
 */
package com.unigame.util;

public class IAQueue {
    private static final int DEFAULT_INCREMENTAL = 50;
    private Node _head;
    private Node _tail;
    private int _inc;
    private int _size;

    public IAQueue(int n) {
        this.init(n);
    }

    public IAQueue() {
        this.init(50);
    }

    public void push(Object object) {
        if (this._tail == null) {
            this.attachNode();
        }
        if (this._tail.push >= this._inc) {
            this.attachNode();
        }
        this._tail.data[this._tail.push] = object;
        ++this._tail.push;
        ++this._size;
    }

    public Object pop() {
        if (this._head != null) {
            if (this._head.pop < this._head.push) {
                Object object = this._head.data[this._head.pop];
                ++this._head.pop;
                --this._size;
                if (this._head.pop >= this._head.push) {
                    if (this._head.pop >= this._inc) {
                        this.releaseNode();
                    } else {
                        this._head.pop = 0;
                        this._head.push = 0;
                    }
                }
                return object;
            }
            return null;
        }
        return null;
    }

    public Object peek() {
        if (this._head != null) {
            if (this._head.pop < this._head.push) {
                return this._head.data[this._head.pop];
            }
            return null;
        }
        return null;
    }

    public void clear() {
        while (this._head != null) {
            this.releaseNode();
        }
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    private void init(int n) {
        this._head = null;
        this._tail = null;
        this._inc = n;
        this._size = 0;
        this.attachNode();
    }

    private void attachNode() {
        Node node = new Node();
        node.data = new Object[this._inc];
        node.push = 0;
        node.pop = 0;
        node.next = null;
        if (this._tail == null) {
            this._head = node;
            this._tail = node;
        } else {
            this._tail.next = node;
            this._tail = node;
        }
    }

    private void releaseNode() {
        if (this._head != null) {
            this._head = this._head.next;
            if (this._head == null) {
                this._tail = null;
            }
        }
    }

    private class Node {
        public Object[] data;
        public int push;
        public int pop;
        public Node next;

        private Node() {
        }
    }
}

