/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.UniGame;
import com.unigame.VisualObject;
import logic.GameLogic;
import logic.PlayState;
import shell.Define;
import shell.Utility;

public class SheepButton
extends VisualObject
implements Define {
    private int type;
    private int cost;
    private long cd;
    private long timer;

    public SheepButton(int n, int n2) {
        this.type = n;
        switch (n) {
            case 0: {
                this.cost = 0;
                this.cd = 0L;
                break;
            }
            case 1: {
                this.cost = 3;
                this.cd = 3000L;
                break;
            }
            case 2: {
                this.cost = 9;
                this.cd = 5000L;
                break;
            }
            case 3: {
                this.cost = 6;
                this.cd = 10000L;
                break;
            }
            case 4: {
                this.cost = 6;
                this.cd = 8000L;
                break;
            }
            case 5: {
                this.cost = 18;
                this.cd = 30000L;
            }
        }
        this.x = 58 + n2 * 29;
        this.y = 291;
        this.timer = 0L;
    }

    public void onMessage(int n, int n2, int n3, int n4) {
        if (n2 == 2 && this.isAvailable()) {
            GameLogic.resource -= this.cost;
            this.timer = PlayState.currTime;
            UniGame.postStateMessage(this.getProperty(0), 7, this.type, 0);
        }
    }

    public void onRender(long l) {
        long l2;
        long l3;
        Utility.drawImage(68 + this.type, this.x, this.y);
        if (this.cd != 0L && this.timer != 0L && (l3 = (l2 = PlayState.currTime) - this.timer) < this.cd) {
            int n = (int)(26L * (this.cd - l3) / this.cd);
            int n2 = 26 - n;
            Utility.fillAlphaRect(this.x + 1, this.y + 1 + n2, 26, n, 0, 128);
        }
        if (this.cost > 0) {
            Utility.drawNumber(76, this.x + 3, this.y + 25 - 8, 8, 8, this.cost, 0);
        }
        if (GameLogic.resource < this.cost) {
            Utility.fillAlphaRect(this.x + 1, this.y + 1, 26, 26, 0, 150);
        }
    }

    private boolean isAvailable() {
        boolean bl = true;
        if (this.type == 0) {
            bl = false;
        }
        if (GameLogic.resource < this.cost) {
            bl = false;
        }
        long l = PlayState.currTime;
        long l2 = l - this.timer;
        if (this.timer != 0L && l2 < this.cd) {
            bl = false;
        }
        return bl;
    }
}

