/*
 * Decompiled with CFR 0.152.
 */
package com.unigame;

import com.unigame.GameObject;
import com.unigame.Msg;
import com.unigame.State;
import com.unigame.UniDefine;
import com.unigame.VisualObject;
import com.unigame.util.AStack;
import com.unigame.util.IAQueue;

public class UniGame
implements UniDefine {
    private static UniGame _ins;
    private AStack _states;
    private boolean _gameflag;
    private IAQueue _msgqueue;
    private int _msgcounter;

    public static boolean startUniGame(State state) {
        _ins = new UniGame();
        UniGame._ins._states = new AStack(8);
        UniGame._ins._gameflag = true;
        UniGame._ins._msgqueue = new IAQueue();
        UniGame.pushState(state);
        return true;
    }

    public static State peekState() {
        return (State)UniGame._ins._states.peek();
    }

    public static boolean pushState(State state) {
        if (UniGame.peekState() != null) {
            UniGame.peekState().onLeave();
        }
        UniGame._ins._msgqueue.clear();
        UniGame._ins._msgcounter = 0;
        boolean bl = UniGame._ins._states.push(state);
        if (bl) {
            state.onEnter();
        }
        return bl;
    }

    public static boolean popState() {
        if (UniGame.peekState() != null) {
            UniGame.peekState().onLeave();
            UniGame.peekState().onDestroy();
            UniGame._ins._states.pop();
            UniGame._ins._msgqueue.clear();
            UniGame._ins._msgcounter = 0;
            if (UniGame.peekState() != null) {
                UniGame.peekState().onEnter();
            }
            return true;
        }
        return false;
    }

    public static boolean changeState(State state) {
        boolean bl = false;
        if (UniGame.peekState() != null) {
            UniGame.peekState().onLeave();
            UniGame.peekState().onDestroy();
            UniGame._ins._states.pop();
            bl = true;
        } else {
            bl = false;
        }
        if (bl) {
            UniGame._ins._msgqueue.clear();
            UniGame._ins._msgcounter = 0;
            boolean bl2 = UniGame._ins._states.push(state);
            if (bl2) {
                state.onEnter();
            }
        }
        return bl;
    }

    public static void sendStateMessage(int n, int n2, int n3, int n4) {
        UniGame.peekState().onMessage(n, n2, n3, n4);
    }

    public static void postStateMessage(int n, int n2, int n3, int n4) {
        Msg msg = new Msg(-4, n, n2, n3, n4);
        UniGame._ins._msgqueue.push(msg);
    }

    public static void sendObjectMessage(int n, int n2, int n3, int n4, int n5) {
        GameObject gameObject = UniGame.peekState().getGameObject(n);
        if (gameObject != null) {
            gameObject.onMessage(n2, n3, n4, n5);
        }
    }

    public static void postObjectMessage(int n, int n2, int n3, int n4, int n5) {
        Msg msg = new Msg(n, n2, n3, n4, n5);
        UniGame._ins._msgqueue.push(msg);
    }

    public static int addGameObject(GameObject gameObject) {
        return UniGame.peekState().addGameObject(gameObject);
    }

    public static int addVisualObject(VisualObject visualObject, int n) {
        return UniGame.peekState().addVisualObject(visualObject, n);
    }

    public static void deleteGameObject(int n) {
        UniGame.peekState().deleteGameObject(n);
    }

    public static GameObject getGameObject(int n) {
        return UniGame.peekState().getGameObject(n);
    }

    public static void exitGame() {
        UniGame._ins._gameflag = false;
    }

    public static UniGame getInstance() {
        return _ins;
    }

    public boolean updateFrame(long l) {
        if (UniGame.peekState() != null) {
            this._msgcounter = this._msgqueue.size();
            while (this._msgcounter > 0) {
                Msg msg = (Msg)this._msgqueue.pop();
                if (msg == null) continue;
                if (msg.target == -4) {
                    UniGame.sendStateMessage(msg.sender, msg.msg, msg.lparam, msg.wparam);
                } else {
                    UniGame.sendObjectMessage(msg.target, msg.sender, msg.msg, msg.lparam, msg.wparam);
                }
                --this._msgcounter;
            }
            if (UniGame.peekState() != null) {
                UniGame.peekState().onFrame(l);
            }
            if (UniGame.peekState() != null) {
                UniGame.peekState().update(l);
            }
            if (UniGame.peekState() != null) {
                UniGame.peekState().render(l);
            }
        } else {
            this._gameflag = false;
        }
        return this._gameflag;
    }

    public void pauseGame() {
        if (this._states.peek() != null) {
            ((State)this._states.peek()).onPause();
        }
    }

    public void resumeGame() {
        if (this._states.peek() != null) {
            ((State)this._states.peek()).onResume();
        }
    }
}

