/*
 * Decompiled with CFR 0.152.
 */
package com.unigame.util;

import com.unigame.util.IAQueue;

public class RAList {
    private Object[] _list;
    private int _pointer;
    private int _size;
    private Node _head;
    private IAQueue _opts;
    private boolean _caching;
    private static final int OPT_INS = 0;
    private static final int OPT_DEL = 1;
    private static final int OPT_CLR = 2;

    public RAList(int n) {
        this._list = new Object[n];
        this._size = 0;
        this._pointer = 0;
        this._head = null;
        this._caching = false;
        this._opts = new IAQueue();
    }

    public int insert(Object object) {
        int n = -1;
        if (this._caching) {
            Operate operate = new Operate();
            operate.opt = 0;
            operate.data = object;
            if (this._pointer < this._list.length) {
                this._list[this._pointer] = null;
                n = this._pointer++;
            } else if (this._head != null) {
                this._list[this._head.id] = null;
                n = this._head.id;
                this._head = this._head.next;
            }
            operate.param = n;
            this._opts.push(operate);
        } else if (this._pointer < this._list.length) {
            this._list[this._pointer] = object;
            n = this._pointer++;
            ++this._size;
        } else if (this._head != null) {
            this._list[this._head.id] = object;
            n = this._head.id;
            ++this._size;
            this._head = this._head.next;
        }
        return n;
    }

    public void delete(int n) {
        if (this._caching) {
            Operate operate = new Operate();
            operate.opt = 1;
            operate.param = n;
            operate.data = null;
            this._opts.push(operate);
            if (this._list[n] != null) {
                Node node = new Node();
                node.id = n;
                node.next = this._head;
                this._head = node;
            }
        } else if (this._list[n] != null) {
            this._list[n] = null;
            Node node = new Node();
            node.id = n;
            node.next = this._head;
            this._head = node;
            --this._size;
        }
    }

    public Object get(int n) {
        if (n < 0) {
            return null;
        }
        return this._list[n];
    }

    public int size() {
        return this._size;
    }

    public int volume() {
        return this._list.length;
    }

    public void clear() {
        if (this._caching) {
            Operate operate = new Operate();
            operate.opt = 2;
            operate.param = 0;
            operate.data = null;
            this._opts.push(operate);
        } else {
            for (int i = 0; i < this._list.length; ++i) {
                this._list[i] = null;
            }
            this._size = 0;
            this._pointer = 0;
            this._head = null;
        }
    }

    public void cacheOperation() {
        this._caching = true;
    }

    public void flushOperation() {
        Operate operate = (Operate)this._opts.pop();
        while (operate != null) {
            switch (operate.opt) {
                case 0: {
                    this._list[operate.param] = operate.data;
                    ++this._size;
                    break;
                }
                case 1: {
                    this._list[operate.param] = null;
                    --this._size;
                    break;
                }
                case 2: {
                    for (int i = 0; i < this._list.length; ++i) {
                        this._list = null;
                    }
                    this._size = 0;
                    this._pointer = 0;
                    this._head = null;
                }
            }
            operate = (Operate)this._opts.pop();
        }
        this._caching = false;
    }

    private class Node {
        public int id;
        public Node next;

        private Node() {
        }
    }

    private class Operate {
        public int opt;
        public int param;
        public Object data;

        private Operate() {
        }
    }
}

