/*
 * Decompiled with CFR 0.152.
 */
package logic;

public class FrameTimer {
    private long _last;
    private long _time;
    private long _interval;
    private boolean _run;
    private boolean _paused;
    private long _activecount;

    public FrameTimer(long l) {
        this._interval = l;
        this._paused = false;
        this._run = false;
    }

    public void start() {
        if (!this._run) {
            this._time = 0L;
            this._last = System.currentTimeMillis();
            this._activecount = 0L;
            this._run = true;
        }
    }

    public void pause() {
        if (this._run && !this._paused) {
            this._paused = true;
            long l = System.currentTimeMillis();
            this._time += l - this._last;
            this._last = l;
        }
    }

    public void resume() {
        if (this._run && this._paused) {
            this._paused = false;
            this._last = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this._run) {
            this._run = false;
            this._paused = false;
        }
    }

    public int frame() {
        if (this._run) {
            if (!this._paused) {
                long l = System.currentTimeMillis();
                this._time += l - this._last;
                this._last = l;
            }
            int n = (int)((this._time - this._activecount * this._interval) / this._interval);
            this._activecount += (long)n;
            return n;
        }
        return 0;
    }

    public long getTime() {
        return this._time;
    }

    public void changeInterval(long l) {
        this.stop();
        this._interval = l;
    }
}

