/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.UniGame;
import com.unigame.VisualObject;
import javax.microedition.lcdui.Image;
import logic.GameLogic;
import logic.PlayState;
import logic.Role;
import logic.data.Pawn;
import shell.Define;
import shell.Utility;

public class Progress
extends VisualObject
implements Define {
    private int _progress;
    private int _totaltime;
    private int _time;
    private int _nexttime;
    private int _AUTO_barlength;
    private int _AUTO_pox;
    private int _AUTO_poy;

    public Progress() {
        Image image = Utility.getImage(54);
        Image image2 = Utility.getImage(55);
        this._AUTO_barlength = image.getWidth();
        this._AUTO_pox = image2.getWidth() / 2;
        this._AUTO_poy = image2.getHeight() / 2;
        this._progress = 0;
        this._totaltime = GameLogic.stage.StageTime;
        this._time = 0;
        this._nexttime = GameLogic.stage.getNextBatchTime();
    }

    public void onFrame(long l) {
        if (PlayState.paused) {
            return;
        }
        this._time = (int)((long)this._time + l);
        if (this._time / 1000 >= this._nexttime) {
            if (GameLogic.stage.isNextBatchClear()) {
                if (GameLogic.wolf_count <= 0) {
                    this.spawnMonster(GameLogic.stage.popBatch());
                    this._nexttime = GameLogic.stage.getNextBatchTime();
                } else {
                    this._time = (int)((long)this._time - l);
                }
            } else {
                this.spawnMonster(GameLogic.stage.popBatch());
                this._nexttime = GameLogic.stage.getNextBatchTime();
            }
        }
        this._progress = 1000 * this._time / (this._totaltime * 1000);
        if (this._progress >= 1000) {
            this._progress = 1000;
            if (GameLogic.wolf_count == 0) {
                UniGame.postStateMessage(-3, 6, 0, 0);
            }
        }
    }

    private void spawnMonster(int[] nArray) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            Role role = Pawn.createWolf(nArray[i]);
            int n = UniGame.addVisualObject(role, 1);
            GameLogic.regWolf(n);
        }
    }

    public void onRender(long l) {
        Utility.drawImage(54, 0, 2);
        Utility.drawImage(55, 0 - this._AUTO_pox + this._AUTO_barlength - this._progress * this._AUTO_barlength / 1000, 2 - this._AUTO_poy + 3);
    }
}

